PFont plotFont;
Library c;

PShape map;
int samplesx, samplesy, spacing;

PImage fill;
ArrayList<Contour2D> contours;
Legend k;
QuadTree_Node<Segment2D> cselect;
Contour2D highlight;

void setup() {
  	smooth();
  	size(1020, 536);
  	plotFont = createFont("Georgia-Bold", 11);
  	textFont(plotFont);
  	
    spacing = 4;
    samplesx = 185;
    samplesy = 129;
	
    // load map
    map = loadShape("roughUS.svg");
	map.disableStyle();
	
	// initialize
	fill = createImage(int(samplesx*spacing), int(samplesy*spacing), ARGB);
	contours = new ArrayList<Contour2D>();
	cselect = new QuadTree_Node<Segment2D>(200, 10, 200+samplesx*spacing, 10+samplesy*spacing, 15);
	highlight = null;
	k = new Legend(950,20,18,500);
	
	// controls
	c = new Library(10,50,90,20,2,7); 
	
	// load data
	loadData();
	
	DropTarget t = new DropTarget(10,10,90,20,2,1);
	t.linkBase(fill);
	t.linkContours(contours);
	t.linkLegend(k);
	t.linkQuadTree(cselect);
	
	c.linkTarget(t);
}

void draw(){
  	background(220);
	
	//handle interactions
	boolean interacting = c.interact(mouseX,mouseY);
	if (!interacting){ // get selection if exists
		Segment2D selection = cselect.select(mouseX, mouseY, 4);
		if (selection != null){
			highlight = selection.getSrcContour();
		}
		else highlight = null;
	}
	
		
	//draw map bg
	fill(255);
	noStroke();
	rect(200, 10, samplesx*spacing, samplesy*spacing, 4);
	
	//draw map
	strokeWeight(0.5);
	stroke(30,30,30,255);//stroke(85,46,27,255);
	fill(210);//fill(247,241,230);
	shape(map, 200+(39*spacing), 10+(35*spacing), 123*spacing, 75*spacing);
	
	// fill
	image(fill, 200, 10);
	
	// draw outline
	strokeWeight(0.5);
	stroke(30,30,30,255);//stroke(85,46,27,255);
	noFill();
	shape(map, 200+(39*spacing), 10+(35*spacing), 123*spacing, 75*spacing);	
	
	// contours
	//draw contours
	colorMode(HSB, 360, 100, 100, 100);
	stroke(0,0,10,100);
	strokeCap(SQUARE);
	drawContours(contours, color(0,0,0), 2.0);
	//drawContours(contours, 119, 27, 44, 80, 40, 100, color(119,40,21,100));
	strokeCap(ROUND);
	colorMode(RGB,255);
	
	// draw controls
	c.display();
	textSize(13);
	textAlign(LEFT, CENTER);
	fill(70);
	text(frameRate, 10, 210);
	textSize(10);
	k.display();
	
}

void loadData(){
	
	// TMP : increments of 5 degrees C
	ColorMapf tmp_5c = new ColorMapf();
	colorMode(HSB, 360, 100, 100, 100);
	tmp_5c.add(228.15, color(270, 100,  29) );
	tmp_5c.add(233.15, color(256,  88,  43) );
	tmp_5c.add(238.15, color(242,  77,  52) ); 
	tmp_5c.add(243.15, color(228,  66,  59) ); 
	tmp_5c.add(248.15, color(215,  55,  65) ); 
	tmp_5c.add(253.15, color(201,  43,  71) ); 
	tmp_5c.add(258.15, color(187,  32,  76) ); 
	tmp_5c.add(263.15, color(173,  21,  80) ); 
	tmp_5c.add(268.15, color(160,  10,  84) );
	tmp_5c.add(273.15, color(145,   0,  84) );
	tmp_5c.add(278.15, color(110,  10,  84) );
	tmp_5c.add(283.15, color( 96,  21,  80) );
	tmp_5c.add(288.15, color( 82,  32,  76) );
	tmp_5c.add(293.15, color( 68,  43,  71) );
	tmp_5c.add(298.15, color( 55,  55,  65) );
	tmp_5c.add(303.15, color( 41,  66,  59) );
	tmp_5c.add(308.15, color( 27,  77,  52) );
	tmp_5c.add(313.15, color( 13,  88,  43) );
	tmp_5c.add(318.15, color(  0, 100,  29) );
	colorMode(RGB,255);
	
	// TMP : increments of 3 degrees C
	ColorMapf tmp_3c = new ColorMapf();
	colorMode(HSB, 360, 100, 100, 100);
	tmp_3c.add(228.15, color(270, 100,  29));
	tmp_3c.add(231.15, color(262,  93,  38));
	tmp_3c.add(234.15, color(254,  87,  44));
	tmp_3c.add(237.15, color(246,  80,  50));
	tmp_3c.add(240.15, color(238,  74,  54));
	tmp_3c.add(243.15, color(230,  67,  58));
	tmp_3c.add(246.15, color(222,  61,  62));
	tmp_3c.add(249.15, color(215,  55,  65));
	tmp_3c.add(252.15, color(207,  48,  69));
	tmp_3c.add(255.15, color(199,  42,  71));
	tmp_3c.add(258.15, color(191,  35,  74));
	tmp_3c.add(261.15, color(183,  29,  77));
	tmp_3c.add(264.15, color(175,  22,  79));
	tmp_3c.add(267.15, color(167,  16,  82));
	tmp_3c.add(270.15, color(160,  10,  84));
	tmp_3c.add(273.15, color(160,   0,  84));
	tmp_3c.add(276.15, color(110,  10,  84));
	tmp_3c.add(279.15, color(102,  16,  82));
	tmp_3c.add(282.15, color( 94,  22,  79));
	tmp_3c.add(285.15, color( 86,  29,  77));
	tmp_3c.add(288.15, color( 78,  35,  74));
	tmp_3c.add(291.15, color( 70,  42,  71));
	tmp_3c.add(294.15, color( 62,  48,  69));
	tmp_3c.add(297.15, color( 55,  55,  65));
	tmp_3c.add(300.15, color( 47,  61,  62));
	tmp_3c.add(303.15, color( 39,  67,  58));
	tmp_3c.add(306.15, color( 31,  74,  54));
	tmp_3c.add(309.15, color( 23,  80,  50));
	tmp_3c.add(312.15, color( 15,  87,  44));
	tmp_3c.add(315.15, color(  7,  93,  38));
	tmp_3c.add(318.15, color(  0, 100,  29));
	colorMode(RGB,255);
	
	// RH : increments of 3 degrees C
	ColorMapf rh = new ColorMapf();
    rh.add(0, color(255, 255, 255, 0));
    rh.add(69, color(255, 255, 255, 0));
    rh.add(70, color(93, 180, 80, 255));
    rh.add(80, color(93, 180, 80, 255));
    rh.add(90, color(41, 98, 33, 255));
    rh.add(100, color(9, 49, 3, 255));
	
	
	Field f;
	Encoding encd;
	StatSelect entry;
	
	//mean 500mb TMP
	f = new Field("./datasets/tmp_500mb_mean.txt", samplesx, samplesy, new PVector(200, 10), samplesy*spacing, samplesx*spacing);
	encd = new Encoding(f);
	encd.useBilinear(true);
	encd.useInterpolation(false);
	encd.setColorMap(tmp_5c);
	encd.genIsovalues(273.15, 5);
	entry = new StatSelect(90,20,color(61,57,116),encd);
	c.add(entry);
	
	//mean 750mb TMP
	f = new Field("./datasets/tmp_750mb_mean.txt", samplesx, samplesy, new PVector(200, 10), samplesy*spacing, samplesx*spacing);
	encd = new Encoding(f);
	encd.useBilinear(true);
	encd.useInterpolation(false);
	encd.setColorMap(tmp_5c);
	encd.genIsovalues(273.15, 2);
	entry = new StatSelect(90,20,color(73,105,167),encd);
	c.add(entry);
	
	//mean 2m TMP
	f = new Field("./datasets/tmp_2m_mean.txt", samplesx, samplesy, new PVector(200, 10), samplesy*spacing, samplesx*spacing);
	encd = new Encoding(f);
	encd.useBilinear(true);
	encd.useInterpolation(false);
	encd.setColorMap(tmp_3c);
	encd.genIsovalues(273.15, 3);
	entry = new StatSelect(90,20,color(75,176,206),encd);
	c.add(entry);
	
	//mean 500mb RH
	f = new Field("./datasets/rh_500mb_mean.txt", samplesx, samplesy, new PVector(200, 10), samplesy*spacing, samplesx*spacing);
	encd = new Encoding(f);
	encd.useBilinear(true);
	encd.useInterpolation(false);
	encd.setColorMap(rh);
	encd.genIsovalues(10);
	entry = new StatSelect(90,20,color(30,98,17),encd);
	c.add(entry);
	
	//mean 750mb RH
	f = new Field("./datasets/rh_750mb_mean.txt", samplesx, samplesy, new PVector(200, 10), samplesy*spacing, samplesx*spacing);
	encd = new Encoding(f);
	encd.useBilinear(true);
	encd.useInterpolation(false);
	encd.setColorMap(rh);
	encd.genIsovalues(10);
	entry = new StatSelect(90,20,color(95,193,76),encd);
	c.add(entry);
	
}

void drawContours(ArrayList<Contour2D> contours, color select, float weight)
{
	noFill();
	strokeWeight(weight);
	
	int n = int(contours.size());
	boolean trigger = false;
	
	//draw all but selection
	Contour2D c;
	for (int i=0; i<n; i++){
		c = contours.get(i);
		if (c == highlight){
			trigger = true;
			continue;
		}
		c.drawContour();
	}
	
	//draw selection
	if ((highlight != null) && trigger){
		strokeWeight(weight+1);
		stroke(select);
		highlight.drawContour();
		
		String s = highlight.getID();
		fill(0,0,255,70);
		noStroke();
		rect(mouseX - (s.length()/2)*6, mouseY-17, s.length()*6, 12);
		fill(0);
		textAlign(CENTER,BOTTOM);
		textSize(10);
		text(s, mouseX, mouseY-5);
	}
}


void mousePressed(){
	c.clicked(mouseX,mouseY);
}

void mouseReleased() {
	c.released();
}
