class DropTarget extends Container {
	PImage layer0;//TODO layers to seperate subclass
	ArrayList<Contour2D> layer1;
	Legend legend;
	QuadTree_Node<Segment2D> qtree;
	
	DropTarget(float ix, float iy, float dx, float dy, int c, int r) {
		super(ix, iy, dx, dy, c, r);
		
		layer0 = null;
		layer1 = null;
		legend = null;
		qtree = null;
	}
	
	void linkBase(PImage img){
		layer0 = img;
	}
	
	void linkContours(ArrayList<Contour2D> contours){ 
		layer1 = contours;
	}
	
	void linkQuadTree(QuadTree_Node<Segment2D> q){
		qtree = q;
	}
	
	void linkLegend(Legend l){ 
		legend = l;
	}
	
	void remove(Selectable s){
		super.remove(s);
		updateRenderContext();	
	}
	
	void updateRenderContext(){
		int n = entries.size();
		switch(n){
			case 0:
				if (layer0 != null){
					//clear image
					layer0.loadPixels();
					int dim = layer0.width * layer0.height;
					for (int i=0; i < dim; i++){
						layer0.pixels[i] = color(0,0,0,0);
					}
					layer0.updatePixels();
					if (legend != null) legend.setColorMap(null);
				}
				break;
			case 1:
				//fill
				if (layer0 != null){
					Selectable s = entries.get(0);
					s.genFill(layer0);
					if (s instanceof StatSelect && legend != null){
						legend.setColorMap(((StatSelect) s).getColorMap());
					}
				}
				//blank countours
				if (layer1 != null) layer1.clear();
				if (qtree != null) qtree.clear();
				break;
			case 2:
			default:
				if (layer1 != null){
					layer1.clear();
					(entries.get(1)).genContours(layer1);
				}
				if (qtree != null){
					qtree.clear();
					for (Contour2D c: layer1){
						c.addAllSegmentsToQuadTree(qtree); 
					}
				}
				break;
		}
	}
		
}
