class Encoding {
	Field field;
	ColorMapf cmap;
	ArrayList<Float> isovalues;
	
	boolean bilinear;
	boolean interpolate;
	
	Encoding(Field f){
		field = f;
		//default to blank
		cmap = new ColorMapf();
		cmap.add(field.getMin(), color(0, 0, 0, 0));
		cmap.add(field.getMax(), color(0, 0, 0, 0));
		
		isovalues = new ArrayList<Float>();
		
		bilinear = true;
		interpolate = false;
	}
	
	void useBilinear(boolean b){
		bilinear = b;
	}
	
	void useInterpolation(boolean b){
		interpolate = b;
	}
	
	ColorMapf getColorMap(){
		return cmap;
	}
		
	void setColorMap(ColorMapf c){
		cmap = c;
	}
	
	void addIsovalue(float iso){
		isovalues.add(iso);
	}
	
	void addIsovalues(ArrayList<Float> list){
		isovalues.addAll(list);
	}
		
	void genIsovalues(float dv){
		float intercept = 0;
		float vmin, vmax;
		vmin = field.getMin();
		vmax = field.getMax();
		
		float iso = intercept + floor((vmin - intercept)/dv)*dv;
		while (iso < vmax){
			isovalues.add(iso);
			iso += dv;
		}
	}
	
	void genIsovalues(float intercept, float dv){
		float vmin, vmax;
		vmin = field.getMin();
		vmax = field.getMax();
		
		float iso = intercept + floor((vmin - intercept)/dv)*dv;
		while (iso < vmax){
			isovalues.add(iso);
			iso += dv;
		}
	}
	
	
	void genContours(ArrayList<Contour2D> contours){
		Contour2D c;
		for (Float iso: isovalues){
			  c = new Contour2D(2*field.dimy);
			  field.genIsocontour(iso, c);
			  c.setID(Float.toString(iso)); 
		   	  contours.add(c);
		}
	}
	
	void genFill(PImage img){
		if (bilinear){
			field.genFillBilinear(img, cmap, interpolate);
		}
		else{
			field.genFillNearestNeighbor(img, cmap, interpolate);
		}
	}
}