class Library extends Container {
	int k;
	ArrayList<DropTarget> targets;
	
	Library(float ix, float iy, float dx, float dy, int c, int r) {
		super(ix, iy, dx, dy, c, r);
		targets = new ArrayList<DropTarget>();
		k = 0;
	}
	
	void linkTarget(DropTarget t){
		targets.add(t);
	}
	
	void unlinkTarget(DropTarget t){
		targets.remove(t);
	}
	
	void add(Selectable s){ //TODO clean up index assignment
		if (s.home == null){
			s.setLibIndex(k++);
			s.setLibrary(this);
		}
		super.add(s);
	}
		
	void display() {
		super.display();
		for (DropTarget t: targets){
			t.display();
		}
		if (interacting != null) interacting.display();
	}
	
	boolean interact(int mx, int my){
		
		// get current interacting
		if (!(super.interact(mx, my))){ // if this has no interaction, test all targets for interaction
			for (DropTarget t: targets){
				if (t.interact(mx,my)){
					interacting = t.interacting;
					break;
				} 
			}
		}
		
		// handle movement between containers
		if (interacting != null && interacting.dragging){
			
			//remove if leaves current
			if (interacting.current != null){
				boolean inCurrent = interacting.current.isIntersectedAABB(interacting);
				if (!inCurrent) interacting.current.remove(interacting);
			}
			
			//add if possible
			if (interacting.current == null){
				if (this.isIntersectedAABB(interacting)) this.add(interacting);
				else{
					for (DropTarget t: targets){
						if(t.isIntersectedAABB(interacting)){
							t.add(interacting);
							break;
						}
					}
				}
			}
		}
		
		return (interacting != null);
	}
	
	boolean clicked(int mx, int my) {
		boolean click = super.clicked(mx,my);
		if (!click){
			for (DropTarget t: targets){
				click = click || t.clicked(mx,my);
				if (click) break;
			}
		}
		return click;
	}
	
	boolean released(){
		boolean r = super.released();
		for (DropTarget t: targets){
			r = r || t.released();	
		}
		return r;
	}
}
