class Selectable {
	boolean dragging = false;
	boolean rollover = false;
	
	float x,y,w,h; // entry position and size
	float restx, resty;
	int r,g,b; //color
	float offsetX, offsetY;// mouseclick offset
	
	Library home;
	Container current;
	int lib_idx; //library index
	
	
	Selectable(float ix, float iy, float iw, float ih, color rgb) {
	    x = ix;
		restx = ix;
	    y = iy;
		resty = iy;
	    w = iw;
	    h = ih;
	    offsetX = 0;
	    offsetY = 0;
		
		r = int(red(rgb)); 
		g = int(green(rgb));
		b = int(blue(rgb));
		
		home = null;
		current = null;
		lib_idx = -1;
	}
		
  	void display() {
   		//draw box for entry
		int a = dragging ? 150 : 255;
		fill(color(r,g,b,a));
		
		if (rollover) {
			strokeWeight(2);
			stroke(color(70));
		}
		else {
			noStroke();
		}
		rect(x,y,w,h);
   	}
	
	boolean interact(int mx, int my) {
	    if (mx > x && mx < x + w && my > y && my < y + h) {
	      rollover = true;
	    } 
		else {
	      rollover = false;
	    }
		
	    if (dragging) {
	      x = mx + offsetX;
	      y = my + offsetY;
	    }
		
		return rollover || dragging;
	}
	
	void setLibrary(Library l){ home = l;}
	void setCurrentContainer(Container c){ current = c;}
	void setLibIndex(int i){ lib_idx = i;}
	
	void setRestPos(float ix, float iy){
		restx = ix;
		resty = iy;
	}
	
	void moveToRest(){
		x = restx;
		y = resty;
	}
	
	boolean clicked(int mx, int my) {
		if (mx > x && mx < x + w && my > y && my < y + h) {
		    dragging = true;
			offsetX = x-mx;
			offsetY = y-my;
			return true;
		}
		return false;
	}
	
	boolean released(){
		if (dragging = false) return false;
		dragging = false;
		
		if(current == null){
			home.add(this);
		}
		
		if(current instanceof DropTarget){
			current.isIntersectedAABB(this);
			current.updateRenderContext();
			println("RELOAD!");
		}
		
		x = restx;
		y = resty;
		return true;
	}
	
	boolean intersectsAABB(float minx, float miny, float maxx, float maxy){
	    if (x+w <= minx || x >= maxx) return false;
	    if (y+h <= miny || y >= maxy) return false;
		return true;
	}
	
	void genFill(PImage img){
	}
	void genContours(ArrayList<Contour2D> contours){
	}
}
