/* @pjs preload="map2.png"; */

// --------------------- Sketch-wide variables ----------------------
PFont plotFont;

final Object lock = new Object();

final int highlight = 1; //TODO come up with better way to track state
final int dim = 2;
final int rest = 0;

final int per_bin = 25;

float buffer, spacing, controlbar;
int samplesx, samplesy;
float sx, sy;

String[] models = {"em", "nmm", "nmb"};
String[] perturbations = {"ctl", "n1", "n2", "n3", "p1", "p2", "p3"};
String[] fcstHrs = {"f00", "f03", "f06", "f09", "f12", "f15", "f18", "f21", "f24", "f27", "f30", "f33", "f36", "f39", "f42", "f45", "f48", "f51", "f54", "f57", "f60", "f63", "f66", "f69", "f72", "f75", "f78", "f81", "f84", "f87"};//{"f00", "f03", "f06", "f09", "f12", "f15", "f18", "f21"};

int fhr;

PShape map;

Slider timeSlider;
FwdButton bFwd;
BackButton bBack;

KeyEntry kTMP, kHGT, kTMP850;
ArrayList< ArrayList<Field> > tmp500mb, hgt500mb, tmp850mb;
ArrayList< Contour2D> tmp500mb_contours, hgt500mb_contours, tmp850mb_contours;
float maxTMP, minTMP, maxHGT, minHGT, maxTMP850, minTMP850;
float tmp_iso, hgt_iso, tmp850_iso;

ArrayList<BinaryField> hgt_band, hgt_envelope, hgt_median, hgt_o1, hgt_o2, hgt_o3; //hgt_mean
ArrayList<BinaryField> tmp_band, tmp_envelope, tmp_median, tmp_o1, tmp_o2, tmp_o3; //tmp_mean
ArrayList<BinaryField> tmp850_band, tmp850_envelope, tmp850_median, tmp850_o1, tmp850_o2, tmp850_o3; //tmp850_mean

QuadTree_Node<Segment2D> tmpQuadTree, hgtQuadTree, tmp850QuadTree;

Contour2D hContour, parent;
int n;

ArrayList<mText> tmp_mbrs, hgt_mbrs, tmp850_mbrs;

boolean cacheMeImFalling;

// ------------------------ Initialisation --------------------------

void setup()
{
  plotFont = createFont("Georgia-Bold", 12);
  textFont(plotFont);
  
  //window	
  buffer = 50; // defines white space buffer around plotted points in image
  spacing = 3;//4;
  samplesx = 185;//34;
  samplesy = 129;//18;
  controlbar = 200;
  sx = samplesx*spacing;
  sy = samplesy*spacing;
  
  size(int(sx + buffer + controlbar), int(2*sy + (1.5)*buffer), P2D);
  smooth();
  
  // load map
  map = loadShape("roughUS.svg");
  
  //time
  timeSlider = new Slider(width-(controlbar+(buffer/4)), width-(buffer/4), height-(buffer+(buffer/4)), 0, (fcstHrs.length - 1));
  timeSlider.setLabel("Forecast Hour");
  timeSlider.displaySliderValue(false);
  fhr = int(timeSlider.getValue());
  
  //legend
  float keyw = 125;
  float keyh = 24;
  float keyx = width-(controlbar)+(controlbar-keyw)/2.0-buffer/4.0;
  float keyy = buffer+(buffer/4);
  kHGT = new KeyEntry(keyx, keyy, keyw, keyh, color(136,136,187), "0˚C [700 mb]");
  kTMP = new KeyEntry(keyx, keyy+(keyh+1), keyw, keyh, color(136,187,136), ".1 in [APCP]");
  kTMP850 = new KeyEntry(keyx, keyy+2*(keyh+1), keyw, keyh, color(187,136,136), ".25 in [APCP]");
  
  bFwd = new FwdButton(width-(controlbar)-buffer/2.0+100, height-2*buffer,13);
  bFwd.setActive((fhr < fcstHrs.length -1));
  
  bBack = new BackButton(width-(controlbar)-buffer/2.0+75, height-2*buffer,13);
  bBack.setActive((fhr > 0));
  
  //num members
  n = models.length*perturbations.length;
  
  //data
  
  tmp_iso = 0.1*25.4 ;
  tmp850_iso = 0.25*25.4;
  hgt_iso = 273.15;
  
  
  tmp500mb = new ArrayList< ArrayList<Field> >();
  hgt500mb = new ArrayList< ArrayList<Field> >();
  // tmp850mb = new ArrayList< ArrayList<Field> >();
  tmp850mb = tmp500mb;
  
  hgt_band = new ArrayList<BinaryField>();
  hgt_envelope = new ArrayList<BinaryField>();
  hgt_median = new ArrayList<BinaryField>();
  //hgt_mean = new ArrayList<BinaryField>();
  hgt_o1 = new ArrayList<BinaryField>();
  hgt_o2 = new ArrayList<BinaryField>();
  hgt_o3 = new ArrayList<BinaryField>();
  
  tmp_band = new ArrayList<BinaryField>();
  tmp_envelope = new ArrayList<BinaryField>();
  tmp_median = new ArrayList<BinaryField>();
  //tmp_mean = new ArrayList<BinaryField>();
  tmp_o1 = new ArrayList<BinaryField>();
  tmp_o2 = new ArrayList<BinaryField>();
  tmp_o3 = new ArrayList<BinaryField>();
  
  tmp850_band = new ArrayList<BinaryField>();
  tmp850_envelope = new ArrayList<BinaryField>();
  tmp850_median = new ArrayList<BinaryField>();
  //tmp850_mean = new ArrayList<BinaryField>();
  tmp850_o1 = new ArrayList<BinaryField>();
  tmp850_o2 = new ArrayList<BinaryField>();
  tmp850_o3 = new ArrayList<BinaryField>();
  
  readData();//sets maxTMP, minTMP, maxHGT, minHGT
  
  print("generating contours...");
  tmp500mb_contours = new ArrayList< Contour2D >();
  hgt500mb_contours = new ArrayList< Contour2D >();
  tmp850mb_contours = new ArrayList< Contour2D >();
  tmpQuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, sx + buffer/2, sy + buffer/2, per_bin);
  hgtQuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, sx + buffer/2, sy + buffer/2, per_bin);
  tmp850QuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, sx + buffer/2, sy + buffer/2, per_bin);
  
  
  int segmentCount = 0;
  
  Contour2D c;
  for(Field f: tmp500mb.get(fhr)){
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(tmp_iso, c);
	  c.genPShape();
	  c.addAllSegmentsToQuadTree(tmpQuadTree);
	  tmp500mb_contours.add(c);
	  segmentCount += c.getMemberCount();
  }
  
  for(Field f: hgt500mb.get(fhr)){
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(hgt_iso, c);
	  c.genPShape();
	  c.addAllSegmentsToQuadTree(hgtQuadTree);
	  hgt500mb_contours.add(c);
	  segmentCount += c.getMemberCount();
  }
  
  for(Field f: tmp850mb.get(fhr)){
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(tmp850_iso, c);
	  c.genPShape();
	  c.addAllSegmentsToQuadTree(tmp850QuadTree);
	  tmp850mb_contours.add(c);
	  segmentCount += c.getMemberCount();
  }
  
  cacheMeImFalling = false;
  hContour = null;
  
  //member highlight
  tmp_mbrs = new ArrayList<mText>();
  mText m = new mText(0,0,"");
  float x = width-(controlbar)+10;
  for (int j=0; j < models.length; j++){
  	  for(int i=0; i < perturbations.length; i++){
  	  	  m = new mText(x,310+(14*i),models[j]+" "+perturbations[i]);
  	  	  m.setTextSize(11);
		  m.setColor(color(30,80,30));
  	  	  tmp_mbrs.add(m);
  	  }
  	  x += textWidth(m.text)+20;
  }
  
  hgt_mbrs = new ArrayList<mText>();
  m = new mText(0,0,"");
  x = width-(controlbar)+10;
  for (int j=0; j < models.length; j++){
  	  for(int i=0; i < perturbations.length; i++){
  	  	  m = new mText(x,180+(14*i),models[j]+" "+perturbations[i]);
  	  	  m.setTextSize(11);
		  m.setColor(color(55,20,70));
  	  	  hgt_mbrs.add(m);
  	  }
  	  x += textWidth(m.text)+20;
  }
  
  tmp850_mbrs = new ArrayList<mText>();
  m = new mText(0,0,"");
  x = width-(controlbar)+10;
  for (int j=0; j < models.length; j++){
  	  for(int i=0; i < perturbations.length; i++){
  	  	  m = new mText(x,440+(14*i),models[j]+" "+perturbations[i]);
  	  	  m.setTextSize(11);
		  m.setColor(color(70,20,20));
  	  	  tmp850_mbrs.add(m);
  	  }
  	  x += textWidth(m.text)+20;
  }
  
  println("segments: " + segmentCount);
}

// ------------------------ Processing draw ------------------------

void draw()
{        
    // background
    background(220);	
		
	/****** DISPLAY ******/
	
	//control bar
	timeSlider.display();
	kTMP.display();
	kHGT.display();
	kTMP850.display();
	
	fill(70);
	textAlign(LEFT, BOTTOM);
	textSize(13);
	text(".1 in", width-controlbar+5, 435);
	text(".25 in", width-controlbar+5, 305);
	text("0˚ C", width-controlbar+5, 175);
	
	for (int i=0; i < tmp850_mbrs.size(); i++){
		int idx = tmp850mb_contours.indexOf(parent);
		mText member = tmp850_mbrs.get(i);
		member.rollover = (idx == i);
		member.display();
	}
	
	for (int i=0; i < tmp_mbrs.size(); i++){
		int idx = tmp500mb_contours.indexOf(parent);
		mText member = tmp_mbrs.get(i);
		member.rollover = (idx == i);
		member.display();
	}
	
	for (int i=0; i < hgt_mbrs.size(); i++){
		int idx = hgt500mb_contours.indexOf(parent);
		mText member = hgt_mbrs.get(i);
		member.rollover = (idx == i);
		member.display();
	}
	
	
    bFwd.display();
    bBack.display();
    noStroke();
    fill(50);
    textAlign(CENTER);
    textSize(12);
    text(Integer.toString(Integer.parseInt(fcstHrs[fhr].substring(1))), width-(controlbar)-buffer/2.0+ 140, height - 2*buffer + 11);
      
    // fill(0);
    // textSize(12);
    // text("Forecast Hour", width-(controlbar)-buffer/2.0+115, height - 2*buffer + 30);
		
	//draw maps
	fill(234,250,255);
	noStroke();
	rect(buffer/2, buffer/2, sx, sy, 4);
	rect(buffer/2, buffer+sy, sx, sy, 4);
	shape(map, buffer/2 + (39*spacing), buffer/2 + (35*spacing), 123*spacing, 75*spacing);
	shape(map, buffer/2 + (39*spacing), buffer+sy + (35*spacing), 123*spacing, 75*spacing);
	
	//draw contours
	boolean hOR = kTMP.isHighlighted() || kHGT.isHighlighted() || kTMP850.isHighlighted() ;
	
	int s_1, s_2, b_1, b_2, a;
	if (hOR){
		if (kHGT.isHighlighted()){
			
			if (kTMP.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(tmp500mb_contours, 119, s_1, s_2, b_1, b_2, a, color(119,12,21,80));
				colorMode(RGB,255);
				renderCBP_TMP(fhr, dim);
			}
			
			if (kTMP850.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(tmp850mb_contours, 0, s_1, s_2, b_1, b_2, a, color(0,12,21,80));
				colorMode(RGB,255);
				renderCBP_TMP850(fhr, dim);
			}
			
			s_1 = 27;
			s_2 = 44;
			b_1 = 80;
			b_2 = 40;
			a = 100;
			
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(hgt500mb_contours, 239, s_1, s_2, b_1, b_2, a, color(239,40,21,100));
			colorMode(RGB,255);
			renderCBP_HGT(fhr, highlight);
		}
		else if (kTMP.isHighlighted()){
			
			if (kHGT.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(hgt500mb_contours, 239, s_1, s_2, b_1, b_2, a, color(239,12,21,80));
				colorMode(RGB,255);
				renderCBP_HGT(fhr, dim);
			}
			
			if (kTMP850.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(tmp850mb_contours, 0, s_1, s_2, b_1, b_2, a, color(0,12,21,80));
				colorMode(RGB,255);
				renderCBP_TMP850(fhr, dim);
			}
			
			s_1 = 27;
			s_2 = 44;
			b_1 = 80;
			b_2 = 40;
			a = 100;
		
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(tmp500mb_contours, 119, s_1, s_2, b_1, b_2, a, color(119,40,21,100));
			colorMode(RGB,255);
			renderCBP_TMP(fhr, highlight);
		}
		else if (kTMP850.isHighlighted()){
			
			if (kTMP.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(tmp500mb_contours, 119, s_1, s_2, b_1, b_2, a, color(119,12,21,80));
				colorMode(RGB,255);
				renderCBP_TMP(fhr, dim);
			}
			
			if (kHGT.isActive()){
				s_1 = 0;
				s_2 = 12;
				b_1 = 90;
				b_2 = 50;
				a = 70;
				
				colorMode(HSB, 360, 100, 100, 100);
				drawContours(hgt500mb_contours, 239, s_1, s_2, b_1, b_2, a, color(239,12,21,80));
				colorMode(RGB,255);
				renderCBP_HGT(fhr, dim);
			}
			
			s_1 = 27;
			s_2 = 44;
			b_1 = 80;
			b_2 = 40;
			a = 100;
			
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(tmp850mb_contours, 0, s_1, s_2, b_1, b_2, a, color(0,40,21,80));
			colorMode(RGB,255);
			renderCBP_TMP850(fhr, highlight);
		}
	}
	else{
		s_1 = 27;
		s_2 = 44;
		b_1 = 80;
		b_2 = 40;
		a = 80;
		
		if (kHGT.isActive()){
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(hgt500mb_contours, 239, s_1, s_2, b_1, b_2, a, color(239,40,21,100));
			colorMode(RGB,255);
			renderCBP_HGT(fhr, rest);
		}
		if (kTMP.isActive()){
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(tmp500mb_contours, 119, s_1, s_2, b_1, b_2, a, color(119,40,21,100));
			colorMode(RGB,255);
			renderCBP_TMP(fhr, rest);
		}
		if (kTMP850.isActive()){
			colorMode(HSB, 360, 100, 100, 100);
			drawContours(tmp850mb_contours, 0, s_1, s_2, b_1, b_2, a, color(0,40,21,80));
			colorMode(RGB,255);
			renderCBP_TMP850(fhr, rest);
			
		}
	}
	colorMode(RGB,255);
	
	//frame rate for testing
	textSize(13);
	textAlign(RIGHT, BOTTOM);
	fill(70);
	text(frameRate, width-3, height-3);
	textSize(10);
	
	//TODO speedup by not generating new threads every time
	//trigger cache for speedup at end of render; so thread spinup slowdown less noticable
	if (cacheMeImFalling){
		cacheContours();
		cacheMeImFalling = false;
	}
}

void mousePressed() {
	
	boolean interaction = false;
	interaction = interaction || kTMP.clicked(mouseX, mouseY);
	interaction = interaction || kHGT.clicked(mouseX, mouseY);
	interaction = interaction || kTMP850.clicked(mouseX, mouseY);
	
	if (timeSlider.clicked(mouseX,mouseY)){
	  interaction = true;
	  clearQuadTrees();
	}
    else if (bFwd.clicked(mouseX, mouseY)){
	  interaction = true;
	  fhr++;
	  
	  timeSlider.setVal(fhr);
  	  bFwd.setActive((fhr < fcstHrs.length -1));
  	  bBack.setActive((fhr > 0));
	  
    }
    else if (bBack.clicked(mouseX, mouseY)){
	  interaction = true;
	  fhr--;
	  
	  timeSlider.setVal(fhr);
  	  bFwd.setActive((fhr < fcstHrs.length -1));
  	  bBack.setActive((fhr > 0));
	  
    }
	
	if (!interaction){
		/*only reach if no other interaction is taking place*/
		if (hContour == null){
			hContour = parent;
		}
		else{
			hContour = null;
		}
	}
}

void mouseReleased() {
	if(timeSlider.released()){
		int curTime = int(timeSlider.getValue());
		if (fhr != curTime){ // if time has changed, re-contour
			fhr = curTime;
			
	    	bFwd.setActive((fhr < fcstHrs.length-1));
	    	bBack.setActive((fhr > 0));
		
			recontourAll();
		}
		cacheMeImFalling = true;
		// cacheContours();			
		spawnQuadTreeGen();
	}
    else if (bFwd.released() || bBack.released()){
		recontourAll();
		cacheMeImFalling = true;
		// cacheContours();
		clearQuadTrees();
		spawnQuadTreeGen();
	}
}

void selectContour(){
	parent = hContour;
	if (parent == null){ // get selection if exists
		Segment2D selection;
		
		if (kHGT.isActive()){ 
			selection = hgtQuadTree.select(mouseX, mouseY, 2.5);
			if (selection != null){
				parent = selection.getSrcContour();
			}
		}
		
		if (kTMP.isActive()){ 
			selection = tmpQuadTree.select(mouseX, mouseY, 2.5);
			if (selection != null){
				parent = selection.getSrcContour();
			}
		}
		
		if (kTMP850.isActive()){ 
			selection = tmp850QuadTree.select(mouseX, mouseY, 2.5);
			if (selection != null){
				parent = selection.getSrcContour();
			}
		}
	}
	
	if (parent == null){
		for (int i=0; i < tmp850_mbrs.size(); i++){
			if ((tmp850_mbrs.get(i)).interact(mouseX,mouseY)){
				parent = tmp850mb_contours.get(i);
				break;
			}
		}
	}
	
	if (parent == null){
		for (int i=0; i < tmp_mbrs.size(); i++){
			if ((tmp_mbrs.get(i)).interact(mouseX,mouseY)){
				parent = tmp500mb_contours.get(i);
				break;
			}
		}
	}
	
	if (parent == null){
		for (int i=0; i < hgt_mbrs.size(); i++){
			if ((hgt_mbrs.get(i)).interact(mouseX,mouseY)){
				parent = hgt500mb_contours.get(i);
				break;
			}
		}
	}
	
}


void mouseMoved(){
	timeSlider.interact(mouseX, mouseY);
	kTMP.interact(mouseX, mouseY);
	kHGT.interact(mouseX, mouseY);
	kTMP850.interact(mouseX, mouseY);
	
    bFwd.interact(mouseX, mouseY);
    bBack.interact(mouseX, mouseY);
	
	selectContour();
}


void mouseDragged(){
	timeSlider.interact(mouseX, mouseY);
	
	int curTime = int(timeSlider.getValue());
	
	if (timeSlider.isDragging() && (fhr != curTime)){ // if time has changed, re-contour
		fhr = curTime;
		
    	bFwd.setActive((fhr < fcstHrs.length-1));
    	bBack.setActive((fhr > 0));
		
		recontourAll();				
	}
}


// ------------------------- Render Calls -------------------------
// TODO -- Undo Hardcode allow for efficient classing and rendering
// TODO -- Do not recontour every draw!

void renderCBP_HGT(int fhr, int state){
	color c_o1, c_o2, c_o3, c_envl, c_bnd, c_mdn;//c_mn
	switch(state)
	{
		case highlight:
			c_o1 = color(255,0,0,255);
			c_o2 = color(210,50,50,255);
			c_o3 = color(170,70,70,255);
			c_mdn = color(170,0,70,255);
			//c_mn = color(230,230,0,255);
	
			c_envl = color(187,187,255,170);
			c_bnd = color(136,136,187,130);	
			break;
		case dim:
			c_o1 = color(210,150,150,255);
			c_o2 = color(190,130,130,255);
			c_o3 = color(170,120,120,255);
			c_mdn = color(170,100,100,255);
			//c_mn = color(230,230,0,130);
		
			c_envl = color(187,187,255,60);
			c_bnd = color(136,136,187,60);	
			break;
		case rest:
		default:
			c_o1 = color(255,0,0,230);
			c_o2 = color(210,50,50,230); //230,30,30,255
			c_o3 = color(170,70,70,230); //210,50,50,255
			c_mdn = color(170,0,70,230); //170,0,170,255
			//c_mn = color(230,230,0,230);
			
			c_envl = color(187,187,255,130);
			c_bnd = color(136,136,187,130);	
			break;
		
	}
	
	BinaryField f;
	
	// outliers
	noFill();
	strokeWeight(1.0);
	stroke(c_o1);
	f = hgt_o1.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o2);
	f = hgt_o2.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o3);
	f = hgt_o3.get(fhr);
	f.drawIsocontour(0.5);
	
	//band
	noStroke();
	fill(c_envl);
	f = hgt_envelope.get(fhr);
	f.drawFilledContour(0.5, false);
	
	fill(c_bnd);
	f = hgt_band.get(fhr);
	f.drawFilledContour(0.5, false);
		
	//centerings
	noFill();
	strokeWeight(2.0);
	stroke(c_mdn);//c_mn
	f = hgt_median.get(fhr);
	f.drawIsocontour(0.5);
	
	// stroke(c_mn);
	// f = hgt_mean.get(fhr);
	// f.drawIsocontour(0.5);
}

void renderCBP_TMP(int fhr, int state){
	color c_o1, c_o2, c_o3, c_envl, c_bnd, c_mdn;//c_mn
	switch(state)
	{
		case highlight:
			c_o1 = color(0,100,255,255);
			c_o2 = color(30,130,230,255);
			c_o3 = color(50,150,210,255);
			c_mdn = color(0,110,230,255); //110,20,110,255
			//c_mn = color(110,20,110,255);
		
			c_envl = color(187,255,187,170);
			c_bnd = color(136,187,136,130);	
			break;
		case dim:
			c_o1 = color(150,170,210,255);
			c_o2 = color(150,150,190,255);
			c_o3 = color(130,140,170,255);
			c_mdn = color(140,170,220,255); //110,20,110,255
			//c_mn = color(110,20,110,255);
		
			c_envl = color(187,255,187,60);
			c_bnd = color(136,187,136,60);	
			break;
		case rest:
		default:
			c_o1 = color(0,100,255,230);
			c_o2 = color(30,130,230,230);
			c_o3 = color(50,150,210,230);
			c_mdn = color(0,110,230,230); //110,20,110,255
			//c_mn = color(110,20,110,255);
			
			c_envl = color(187,255,187,130);
			c_bnd = color(136,187,136,130);	
			break;
		
	}
	
	BinaryField f;
	
	// outliers
	noFill();
	strokeWeight(1.0);
	stroke(c_o1);
	f = tmp_o1.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o2);
	f = tmp_o2.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o3);
	f = tmp_o3.get(fhr);
	f.drawIsocontour(0.5);
	
	//band
	noStroke();
	fill(c_envl);
	f = tmp_envelope.get(fhr);
	f.drawFilledContour(0.5, false);
	
	fill(c_bnd);
	f = tmp_band.get(fhr);
	f.drawFilledContour(0.5, false);
		
	//centerings
	noFill();
	strokeWeight(2.0);
	stroke(c_mdn);//c_mn
	f = tmp_median.get(fhr);
	f.drawIsocontour(0.5);
	
	// stroke(c_mn);
	// f = tmp_mean.get(fhr);
	// f.drawIsocontour(0.5);
}

void renderCBP_TMP850(int fhr, int state){
	color c_o1, c_o2, c_o3, c_envl, c_bnd, c_mdn;//c_mn
	switch(state)
	{
		case highlight:
			c_o1 = color(170,140,120,255);
			c_o2 = color(150,130,110,255);
			c_o3 = color(120,100,80,255);
			c_mdn = color(90,70,50,255);
			//c_mn = color(230,230,0,230);
	
			c_envl = color(255,187,187,170);
			c_bnd = color(187,136,136,130);		
			break;
		case dim:
			c_o1 = color(170,140,120,255);
			c_o2 = color(150,130,110,255);
			c_o3 = color(120,100,80,255);
			c_mdn = color(150,130,110,255);
			//c_mn = color(230,230,0,230);
		
			c_envl = color(255,187,187,60);
			c_bnd = color(187,136,136,60);		
			break;
		case rest:
		default:
			c_o1 = color(170,140,120,255);
			c_o2 = color(150,130,110,255);
			c_o3 = color(120,100,80,255);
			c_mdn = color(90,70,50,255);
			//c_mn = color(230,230,0,230);
			
			c_envl = color(255,187,187,130);
			c_bnd = color(187,136,136,130);	
			break;
	}
	
	BinaryField f;
	
	// outliers
	noFill();
	strokeWeight(1.0);
	stroke(c_o1);
	f = tmp850_o1.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o2);
	f = tmp850_o2.get(fhr);
	f.drawIsocontour(0.5);
	
	stroke(c_o3);
	f = tmp850_o3.get(fhr);
	f.drawIsocontour(0.5);
	
	//band
	noStroke();
	fill(c_envl);
	f = tmp850_envelope.get(fhr);
	f.drawFilledContour(0.5, false);
	
	fill(c_bnd);
	f = tmp850_band.get(fhr);
	f.drawFilledContour(0.5, false);
		
	//centerings
	noFill();
	strokeWeight(2.0);
	stroke(c_mdn);//c_mn
	f = tmp850_median.get(fhr);
	f.drawIsocontour(0.5);
	
	// stroke(c_mn);
	// f = tmp850_mean.get(fhr);
	// f.drawIsocontour(0.5);
}


// ---------------------------- Methods -----------------------------


// retreives 1D index for location (x,y) in an MxN array
int getIndex(int x, int y, int N)
{
   int idx = (y*N)+x;
   return idx;
}

void drawContours(ArrayList<Contour2D> contours, int h, int s_min, int s_max, int b_min, int b_max, int a, color select)
{
	noFill();
	strokeWeight(1);
	
	int n = int(contours.size());
	
	boolean containsParent = false;
	//draw all but selection
	Contour2D c;
	strokeWeight(1);
	for (int i=0; i<n; i++){
		int s = int(map(i, 0, n-1, s_min, s_max));
		int b = int(map(i, 0, n-1, b_min, b_max));
		stroke(h,s,b,a);
		c = contours.get(i);
		if (c == parent){
			containsParent = true;
			continue;
		}
		c.drawContour();
	}

	//draw selection
	if ((parent != null) && containsParent){
		strokeWeight(2);
		stroke(select);
		parent.drawContour();
	}
}


void recontour(ArrayList<Contour2D> contours, float iso ,ArrayList<Field> fields)//, QuadTree_Node<Segment2D> qTree)
{	

	int n = int(contours.size());
	Contour2D c;
	Field f;
	for(int i=0; i<n; i++){
		c = contours.get(i);
		f = fields.get(i);
		c.clearAll();
		f.genIsocontour(iso, c);
	}
}


// //works with total accumulations generate fields for any accumulation period
// ArrayList<Field>  accPeriod(ArrayList< ArrayList<Field> > acc, int hr, int p){
// 	int period = p
// 	// if (period%3 != 0){ // hr and p are in array index -- i.e. mod 3 = 0 implicit 
// 	// 	period -= period%3;
// 	// 	print("WARNING: in function accPeriod, period provided not a multiple of 3 -- next smallest multiple of 3 used instead");
// 	// }
// 	if (hr < p){
// 		return acc.get(0); //use zero case
// 	}
// 	
// 	ArrayList<Field> f0 = acc.get(hr-p)
// 	ArrayList<Field> f1 = acc.get(hr)
// 	int n = int(f1.size());
// 	
// 	ArrayList<Field> out = new ArrayList<Field>(n);
// 	for(int j=0; j<n; j++){
// 		Field f0member = f0.get(j);
// 		Field f1member = f0.get(j);
// 		
// 		int len = f1member.data.size();
// 		FloatList newdata = FloatList(len);
// 		float maxVal = 0; //for acc, min val always 0
// 		float minVal = 0;
// 		for(int i=0; i<len; i++){
// 			float val = f1member.data.get(i) - f0member.data.get(i);
// 	        maxVal = max(maxVal, val);
// 	        minVal = min(minVal, val);
// 			newdata.append(val)
// 		}
// 		out.append(new Field(newdata, maxVal, minVal, f1member.dimx, f1member.dimy, f1member.spacing))
// 	}
// }

void recontourAll(){
	recontour(tmp500mb_contours, tmp_iso, tmp500mb.get(fhr));//, tmpQuadTree);
	recontour(hgt500mb_contours, hgt_iso, hgt500mb.get(fhr));//, hgtQuadTree);
	recontour(tmp850mb_contours, tmp850_iso, tmp850mb.get(fhr));//, tmp850QuadTree);
}

// void cacheContours(){
// 	for(Contour2D c: tmp500mb_contours){
// 		c.genPShape();
// 	}
// 	for(Contour2D c: hgt500mb_contours){
// 		c.genPShape();
// 	}
// 	for(Contour2D c: tmp850mb_contours){
// 		c.genPShape();
// 	}
// }

void cacheContours(){
	
	class Cacher implements Runnable {
		 ArrayList<Contour2D> contours;
		  
		 Cacher(ArrayList<Contour2D> contour_list){ 
			 contours = contour_list;
		 }
 
		 public void run() {	 		 	 
			 for (Contour2D c : contours){
			 	 c.genPShape();
		 	 }
			 println("DEAD");
		 }
	}
	
	Thread damien = new Thread(new Cacher(tmp500mb_contours));
	damien.start();
	damien = new Thread(new Cacher(hgt500mb_contours));
	damien.start();
	damien = new Thread(new Cacher(tmp850mb_contours));
	damien.start();
	
}


void clearQuadTrees(){
	//TODO don't rely on garbage collection to solve threading issues
	//reset quad trees
	tmpQuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, samplesx*spacing + buffer/2, samplesy*spacing + buffer/2, per_bin);		
	hgtQuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, samplesx*spacing + buffer/2, samplesy*spacing + buffer/2, per_bin);		
	tmp850QuadTree = new QuadTree_Node<Segment2D>(buffer/2, buffer/2, samplesx*spacing + buffer/2, samplesy*spacing + buffer/2, per_bin);	
}

void spawnQuadTreeGen(){
	Thread damien = new Thread(new QuadTreeGen(tmpQuadTree, (ArrayList<Contour2D>)tmp500mb_contours));
	damien.start();
	damien = new Thread(new QuadTreeGen(hgtQuadTree, (ArrayList<Contour2D>)hgt500mb_contours));
	damien.start();
	damien = new Thread(new QuadTreeGen(tmp850QuadTree, (ArrayList<Contour2D>)tmp850mb_contours));
	damien.start();
}

void readData()
{
	
	print("loading 3hr APCP...\n");
	
	boolean first = true;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
		ArrayList<Field> members = new ArrayList<Field>(n);
		for (int j=0; j < models.length; j++){
			for (int i=0; i < perturbations.length; i++){
				String file = "surface_APCP_3hr/sref_" + models[j] + ".t15z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
				Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), sy, sx);
				if (first){
					maxTMP = f.getMax();
					minTMP = f.getMin();
					first = false;
				}
				else{
					maxTMP = max(maxTMP, f.getMax());
					minTMP = min(minTMP, f.getMin()); 
				}
				members.add(f);
			}
		}
		tmp500mb.add(members);
	}
	
	print("loading 700mb TMP...\n");
	
	first = true;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
		ArrayList<Field> members = new ArrayList<Field>(n);
		for (int j=0; j < models.length; j++){
			for (int i=0; i < perturbations.length; i++){
				String file = "700mb_TMP/sref_" + models[j] + ".t15z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
				Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), sy, sx);
				if (first){
					maxHGT = f.getMax();
					minHGT = f.getMin();
					first = false;
				}
				else{
					maxHGT = max(maxHGT, f.getMax());
					minHGT = min(minHGT, f.getMin()); 
				}
				members.add(f);
			}
		}
		hgt500mb.add(members);
	}
	
	// print("loading 850mb TMP...\n");
	// 
	// //TMP850
	// first = true;
	// for (int k = 0; k < fcstHrs.length; k++){
	// 	print("\t"+fcstHrs[k]+"\n");
	// 	ArrayList<Field> members = new ArrayList<Field>(n);
	// 	for (int j=0; j < models.length; j++){
	// 		for (int i=0; i < perturbations.length; i++){
	// 			String file = "850mb_TMP/sref_" + models[j] + ".t15z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
	// 			Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), sy, sx);
	// 			if (first){
	// 				maxTMP850 = f.getMax();
	// 				minTMP850 = f.getMin();
	// 				first = false;
	// 			}
	// 			else{
	// 				maxTMP850 = max(maxTMP850, f.getMax());
	// 				minTMP850 = min(minTMP850, f.getMin()); 
	// 			}
	// 			members.add(f);
	// 		}
	// 	}
	// 	tmp850mb.add(members);
	// }
	
	
	//CBP
	print("loading Contour Box Plots...\n");
	
	String file;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
				
		file = "700mb_TMP/cbp/band_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_band.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "700mb_TMP/cbp/envelop_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_envelope.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "700mb_TMP/cbp/median_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_median.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		//file = "700m_TMP/cbp/trimmedMean_gridRes_212_"+fcstHrs[k]+".csv";
		//hgt_mean.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "700mb_TMP/cbp/outlier_0_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_o1.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "700mb_TMP/cbp/outlier_1_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_o2.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "700mb_TMP/cbp/outlier_2_gridRes_212_"+fcstHrs[k]+".csv";
		hgt_o3.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		
		file = "surface_APCP_3hr/cbp2/band_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_band.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp2/envelop_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_envelope.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp2/median_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_median.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		//file = "surface_APCP_3hr/cbp/trimmedMean_gridRes_212_"+fcstHrs[k]+".csv";
		//tmp_mean.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp2/outlier_0_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_o1.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp2/outlier_1_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_o2.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp2/outlier_2_gridRes_212_"+fcstHrs[k]+".csv";
		tmp_o3.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		
		file = "surface_APCP_3hr/cbp/band_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_band.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp/envelop_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_envelope.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp/median_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_median.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		//file = surface_APCP_3hr/cbp2/trimmedMean_gridRes_212_"+fcstHrs[k]+".csv";
		//tmp850_mean.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp/outlier_0_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_o1.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp/outlier_1_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_o2.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
		file = "surface_APCP_3hr/cbp/outlier_2_gridRes_212_"+fcstHrs[k]+".csv";
		tmp850_o3.add(new BinaryField(file, samplesx, samplesy, new PVector(buffer/2, buffer+sy), sy, sx));
	}
	
}
