class KeyEntry {
	//boolean dragging = false;
	boolean rollover = false;
	boolean active = false;
	float x,y,w,h; // entry position and size
	color c; //color
	String label;
	float offsetX, offsetY;// mouseclick offset
	
	float tcornerX, tcornerY; 
	int tabSize = 16;
	
	
	KeyEntry(float ix, float iy, float iw, float ih, color clr, String l) {
	    x = ix;
	    y = iy;
	    w = iw;
	    h = ih;
	    offsetX = 0;
	    offsetY = 0;
		
		c = clr;
		label = l;
		
		tcornerY = y+((h-tabSize)/2.0);
		tcornerX = x+(tcornerY-y);
	  }
	
  	void display() {
   		//draw bounding box for entry (debugging)
		// noStroke();
		// fill(210);
		// rect(x,y,w,h);
		
		textSize(13);
		textAlign(LEFT, CENTER);
		if (rollover){
	        stroke(70);
	        strokeWeight(2);
			if (active) fill(c);
			else noFill();
			rect(tcornerX, tcornerY, tabSize, tabSize);
			
			fill(70);
			text(label, tcornerX+tabSize+(tcornerY-y), tcornerY+(tabSize/2.0));
		}
		else {
	        stroke(30);
	        strokeWeight(1);
			if (active) fill(c);
			else noFill();
			rect(tcornerX, tcornerY, tabSize, tabSize);
			
			fill(30);
			text(label, tcornerX+tabSize+(tcornerY-y), tcornerY+(tabSize/2.0));
		}

   	}
	
	boolean isHighlighted(){
		return (rollover && active);
	}
	
	boolean isActive(){
		return active;
	}
	
	void interact(int mx, int my) {
	    if (mx > x && mx < x + w && my > y && my < y + h) {
	      rollover = true;
	    } else {
	      rollover = false;
	    }
	}
	
	void clicked(int mx, int my) {
	    if (mx > x && mx < x + w && my > y && my < y + h) {
	      active = !active;
	    }
	}
	
}
