/* @pjs preload="map2.png"; */

// --------------------- Sketch-wide variables ----------------------
PFont plotFont;

float maxVal, minVal;
float buffer, spacing, controlbar;
int samplesx, samplesy;
Slider tmpSlider, hgtSlider, timeSlider;
String[] models = {"em", "nmm", "nmb"};
String[] perturbations = {"ctl", "n1", "n2", "n3", "p1", "p2", "p3"};
String[] fcstHrs = {"f00", "f03", "f06", "f09", "f12", "f15", "f18", "f21", "f24", "f27", "f30"};//, "f33", "f36", "f39", "f42", "f45", "f48", "f51", "f54", "f57", "f60", "f63", "f66", "f69", "f72", "f75", "f78", "f81", "f84", "f87"}; //{"f00", "f12", "f24", "f36", "f48", "f60", "f72", "f84"};
ArrayList<Field> tmp500mb;
ArrayList<Contour2D> tmp500mb_contours;

float maxRH, minRH;
ArrayList<Field> rh500mb;
ArrayList<Contour2D> rh500mb_contours;
Slider rhSlider;

float minHGT, maxHGT;
ArrayList<Field> hgt500mb;
ArrayList<Contour2D> hgt500mb_contours;

KeyEntry k_hgt, k_tmp, k_rh;
color c_hgt, c_tmp, c_rh;

float last_tmp, last_rh, last_hgt, last_fhr;
//PImage backgroundMap;        // OpenStreetMap.
//PVector tlCorner,brCorner;   // Corners of map in WebMercator coordinates.
//ArrayList<PVector>coords;    // Projected GPS coordinates.

PShape map;


// ------------------------ Initialisation --------------------------

void setup()
{
  plotFont = createFont("Georgia-Bold", 11);
  textFont(plotFont);

  // load map
  map = loadShape("roughUS.svg");
	
  buffer = 50; // defines white space buffer around plotted points in image
  spacing = 3;//5;
  samplesx = 185;//34;
  samplesy = 129;//18;
  controlbar = 200;
  size(int(samplesx*spacing + buffer + controlbar), int(samplesy*spacing + buffer), P2D);
  smooth();
  tmp500mb = new ArrayList<Field>();
  rh500mb = new ArrayList<Field>();
  hgt500mb = new ArrayList<Field>();
  readData();//sets maxVal, minVal, maxRH, minRH, minHGT, maxHGT
  float slider_length = controlbar;
  
  timeSlider = new Slider(width-(slider_length+(buffer/4)), width-(buffer/4), height-(buffer+(buffer/4)), 0, (fcstHrs.length - 1));
  timeSlider.setLabel("Forecast Hour");
  timeSlider.displaySliderValue(false);
  
  tmpSlider = new Slider(width-(slider_length+(buffer/4)), width-(buffer/4), height-2*(buffer+(buffer/4))-buffer, minVal, maxVal);
  tmpSlider.setVal(258.0);
  tmpSlider.setSigDigits(2);
  tmpSlider.setLabel("TMP");
  
  hgtSlider = new Slider(width-(slider_length+(buffer/4)), width-(buffer/4), height-2*(buffer+(buffer/4))-2*buffer, minHGT, maxHGT);
  hgtSlider.setVal(5580.0);
  hgtSlider.setSigDigits(2);
  hgtSlider.setLabel("HGT");
  
  rhSlider = new Slider(width-(slider_length+(buffer/4)), width-(buffer/4), height-2*(buffer+(buffer/4)), minRH, maxRH);
  rhSlider.setVal(80.0);
  rhSlider.setSigDigits(2);
  rhSlider.setLabel("RH");
  
  c_hgt = color(136,136,187);
  c_tmp = color(136,187,136);
  c_rh = color(187,136,136);
  
  float keyw = 125;
  float keyh = 24;
  float keyx = width-(controlbar)+(controlbar-keyw)/2.0-buffer/4.0;
  float keyy = buffer+(buffer/4);
  k_hgt = new KeyEntry(keyx, keyy, keyw, keyh, c_hgt, "HGT [500mb]");
  k_tmp = new KeyEntry(keyx, keyy+(keyh+1), keyw, keyh, c_tmp, "TMP [500mb]");
  k_rh = new KeyEntry(keyx, keyy+2*(keyh+1), keyw, keyh, c_rh, "RH [500mb]");
  
  // generate contours
  tmp500mb_contours = new ArrayList<Contour2D>();
  rh500mb_contours = new ArrayList<Contour2D>();
  hgt500mb_contours = new ArrayList<Contour2D>();
  
  int fhr = int(timeSlider.getValue());
  int n = models.length * perturbations.length;
  Contour2D c;
  Field f;
  
  float iso = tmpSlider.getValue();
  for (int i=0; i<n; i++){
      f = tmp500mb.get(fhr*n+i);
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(iso, c);
	  tmp500mb_contours.add(c);
  }
  last_tmp = iso;
  
  iso = rhSlider.getValue();
  for (int i=0; i<n; i++){
      f = rh500mb.get(fhr*n+i);
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(iso, c);
	  rh500mb_contours.add(c);
  }
  last_rh = iso;
  
  iso = hgtSlider.getValue();
  for (int i=0; i<n; i++){
      f = hgt500mb.get(fhr*n+i);
	  c = new Contour2D(2*f.dimy);
	  f.genIsocontour(iso, c);
	  hgt500mb_contours.add(c);
  }
  last_hgt = iso;
  
  last_fhr = fhr;
}

// ------------------------ Processing draw ------------------------

void draw()
{        
    // background
    background(220);
	
	//draw maps
	fill(234,250,255);
	noStroke();
	rect(buffer/2, buffer/2, samplesx*spacing, samplesy*spacing, 4);
	shape(map, buffer/2 + (39*spacing), buffer/2 + (35*spacing), 123*spacing, 75*spacing);
    
	//toggles
	k_hgt.interact(mouseX, mouseY);
	k_hgt.display();
	
	k_tmp.interact(mouseX, mouseY);
	k_tmp.display();
	
	k_rh.interact(mouseX, mouseY);
	k_rh.display();
	
    //sliders
	timeSlider.interact(mouseX, mouseY);
	timeSlider.display();
	
    tmpSlider.interact(mouseX, mouseY);
    tmpSlider.display();
	
    hgtSlider.interact(mouseX, mouseY);
    hgtSlider.display();
	
    rhSlider.interact(mouseX, mouseY);
    rhSlider.display();
	
	int n = models.length * perturbations.length;
	int fhr = int(timeSlider.getValue());
	
	//check if iso-values changed, recontour if necessary
	Contour2D c;
	Field f;
	float iso = tmpSlider.getValue();
	if (last_tmp != iso){
	    tmp500mb_contours.clear();
	    for (int i=0; i<n; i++){
	      f = tmp500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  tmp500mb_contours.add(c);
	    }
		last_tmp = iso;
	}
	
	iso = rhSlider.getValue();
	if (last_rh != iso){
	    rh500mb_contours.clear();
	    for (int i=0; i<n; i++){
	      f = rh500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  rh500mb_contours.add(c);
	    }
		last_rh = iso;
	}
	
	iso = hgtSlider.getValue();
	if (last_hgt != iso){
	    hgt500mb_contours.clear();
	    for (int i=0; i<n; i++){
	      f = hgt500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  hgt500mb_contours.add(c);
	    }
		last_hgt = iso;
	}
	
	
	if (last_fhr != fhr){
		
	    tmp500mb_contours.clear();
		rh500mb_contours.clear();
		hgt500mb_contours.clear();
		
		iso = tmpSlider.getValue();
	    for (int i=0; i<n; i++){
	      f = tmp500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  tmp500mb_contours.add(c);
	    }
		
		iso = rhSlider.getValue();
	    for (int i=0; i<n; i++){
	      f = rh500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  rh500mb_contours.add(c);
	    }
		
		iso = hgtSlider.getValue();
	    for (int i=0; i<n; i++){
	      f = hgt500mb.get(fhr*n+i);
	  	  c = new Contour2D(2*f.dimy);
	  	  f.genIsocontour(iso, c);
	  	  hgt500mb_contours.add(c);
	    }
		
		last_fhr = fhr;
	}
	
	//draw contours
	
	colorMode(HSB, 360, 100, 100, 100);
	noFill();
	strokeWeight(1);
	
	if (k_rh.isHighlighted()){	
		if (k_hgt.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 0, 12));
				int b = int(map(i, 0, n-1, 90, 50));
				stroke(239,s,b,70);
				c = hgt500mb_contours.get(i);
				c.drawContour();
			}
		}
	
		if (k_tmp.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 0, 12));
				int b = int(map(i, 0, n-1, 90, 50));
				stroke(119,s,b,70);
				c = tmp500mb_contours.get(i);
				c.drawContour();	
			}
		}
		
		for (int i=0; i<n; i++){
			int s = int(map(i, 0, n-1, 27, 44));
			int b = int(map(i, 0, n-1, 80, 40));
			stroke(0,s,b,100);
			c = rh500mb_contours.get(i);
			c.drawContour();
		}
	
	}
	else if (k_hgt.isHighlighted()){
		if (k_rh.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 0, 12));
				int b = int(map(i, 0, n-1, 90, 50));
				stroke(0,s,b,70);
				c = rh500mb_contours.get(i);
				c.drawContour();
			}
		}
		
		if (k_tmp.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 0, 12));
				int b = int(map(i, 0, n-1, 90, 50));
				stroke(119,s,b,70);
				c = tmp500mb_contours.get(i);
				c.drawContour();	
			}
		}
		
		for (int i=0; i<n; i++){
			int s = int(map(i, 0, n-1, 27, 44));
			int b = int(map(i, 0, n-1, 80, 40));
			stroke(239,s,b,100);
			c = hgt500mb_contours.get(i);
			c.drawContour();
		}
		
	}
	else if (k_tmp.isHighlighted()){
		if (k_rh.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 0, 12));
				int b = int(map(i, 0, n-1, 90, 50));
				stroke(0,s,b,70);
				c = rh500mb_contours.get(i);
				c.drawContour();
			}
		}
		
	    if (k_hgt.isActive()){
	   			for (int i=0; i<n; i++){
	   				int s = int(map(i, 0, n-1, 0, 12));
	   				int b = int(map(i, 0, n-1, 90, 50));
	   				stroke(239,s,b,70);
	   				c = hgt500mb_contours.get(i);
	   				c.drawContour();
	   			}
	   	}
		
		for (int i=0; i<n; i++){
			int s = int(map(i, 0, n-1, 27, 44));
			int b = int(map(i, 0, n-1, 80, 40));
			stroke(119,s,b,100);
			c = tmp500mb_contours.get(i);
			c.drawContour();	
		}
		
	}
	else{
		if (k_rh.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 27, 44));
				int b = int(map(i, 0, n-1, 80, 40));
				stroke(0,s,b,80);
				c = rh500mb_contours.get(i);
				c.drawContour();
			}
		}
	
		if (k_hgt.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 27, 44));
				int b = int(map(i, 0, n-1, 80, 40));
				stroke(239,s,b,80);
				c = hgt500mb_contours.get(i);
				c.drawContour();
			}
		}
	
		if (k_tmp.isActive()){
			for (int i=0; i<n; i++){
				int s = int(map(i, 0, n-1, 27, 44));
				int b = int(map(i, 0, n-1, 80, 40));
				stroke(119,s,b,80);
				c = tmp500mb_contours.get(i);
				c.drawContour();	
			}
		}
	}
	colorMode(RGB,255);

 println(frameRate);
}

void mousePressed() {
  k_hgt.clicked(mouseX, mouseY);
  k_tmp.clicked(mouseX, mouseY);
  k_rh.clicked(mouseX, mouseY);
  timeSlider.clicked(mouseX,mouseY);
  tmpSlider.clicked(mouseX,mouseY);
  hgtSlider.clicked(mouseX,mouseY);
  rhSlider.clicked(mouseX,mouseY);
}

void mouseReleased() {
  tmpSlider.released();
  hgtSlider.released();
  timeSlider.released();
  rhSlider.released();
}



// ---------------------------- Methods -----------------------------


// retreives 1D index for location (x,y) in an MxN array
int getIndex(int x, int y, int N)
{
   int idx = (y*N)+x;
   return idx;
}

void readData()
{
	
	print("loading TMP...\n");
	
	//TMP
	boolean first = true;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
		for (int j=0; j < models.length; j++){
			for (int i=0; i < perturbations.length; i++){
				String file = "./data/500mb_TMP/sref_" + models[j] + ".t09z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
				Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), samplesy*spacing, samplesx*spacing);
				if (first){
					maxVal = f.getMax();
					minVal = f.getMin();
					first = false;
				}
				else{
					maxVal = max(maxVal, f.getMax());
					minVal = min(minVal, f.getMin()); 
				}
				tmp500mb.add(f);
			}
		}
	}
	
	print("loading RH...\n");
	
	//RH
	first = true;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
		for (int j=0; j < models.length; j++){
			for (int i=0; i < perturbations.length; i++){
				String file = "./data/500mb_RH/sref_" + models[j] + ".t09z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
				Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), samplesy*spacing, samplesx*spacing);
				if (first){
					maxRH = f.getMax();
					minRH = f.getMin();
					first = false;
				}
				else{
					maxRH = max(maxRH, f.getMax());
					minRH = min(minRH, f.getMin()); 
				}
				rh500mb.add(f);
			}
		}
	}
	
	print("loading HGT...\n");
	
	//HGT
	first = true;
	for (int k = 0; k < fcstHrs.length; k++){
		print("\t"+fcstHrs[k]+"\n");
		for (int j=0; j < models.length; j++){
			for (int i=0; i < perturbations.length; i++){
				String file = "./data/500mb_HGT/sref_" + models[j] + ".t09z.pgrb212." + perturbations[i] + "." + fcstHrs[k] + ".txt";
				Field f = new Field(file, samplesx, samplesy, new PVector(buffer/2, buffer/2), samplesy*spacing, samplesx*spacing);
				if (first){
					maxHGT = f.getMax();
					minHGT = f.getMin();
					first = false;
				}
				else{
					maxHGT = max(maxHGT, f.getMax());
					minHGT = min(minHGT, f.getMin()); 
				}
				hgt500mb.add(f);
			}
		}
	}
	
	//f = new Field("em.t03z.212.TMP.500mb.txt", samplesx, samplesy, new PVector(buffer/2, buffer/2), samplesy*spacing, samplesx*spacing);
	//maxVal = f.getMax();
	//minVal = f.getMin();
}


/**********************************************************
/* WEB MERCATOR PROJECTION -- hacked from giCentre utils
/*********************************************************/

// Store the WebMercator coordinates of the corner of the map.
// The lat/long of the corners was provided by OpenStreetMap
// when exporting the map tile.
//tlCorner = proj.transformCoords(new PVector(-137.1,57.5));
//brCorner = proj.transformCoords(new PVector(-51.1,14.6));
//tlCorner = latLongToWebMercator(new PVector(-137.1,57.5));
//brCorner = latLongToWebMercator(new PVector(-51.1,14.6));

// Convert from WebMercator coordinates to screen coordinates.
// PVector geoToScreen(PVector geo)
// {
//   return new PVector(map(geo.x,tlCorner.x,brCorner.x,0,width),
//                      map(geo.y,tlCorner.y,brCorner.y,0,height),
//                      geo.z);
// }

// PVector latLongToWebMercator(PVector p)
// {
//     if ((p.x < -180) || (p.x > 180))
//     {
//             System.err.println("latLongToWebMercator: Longitude out of bounds: "+p.x);
//             return null;
//     }
//     if ((p.y < -88) || (p.y > 88))
//     {
//             System.err.println("latLongToWebMercator: Latitude out of bounds: "+p.y);
//             return null;
//     }
//     double R = 6378137;
//     double lamda0 = 0;
//     double DEG2RAD = PI/180;
//     double phi = p.y*DEG2RAD;
//     double lamda = p.x*DEG2RAD;
//     
//     double easting  = R*(lamda-lamda0);
//     double northing = R*log(tan((float)(QUARTER_PI + phi/2)));
//     
//     return new PVector((float)easting,(float)northing);
// }


