/*globals d3, console*/
d3.csv('data.csv', function (error, data) {
  if (error) {
    return;
  }
  var svg = d3.select('#Layer_1');

  var groupSize = d3.scale.linear()
    .domain([0, d3.max(data, function (d) {
      return parseInt(d.totalHours);
    })])
    .range([0,
            200
        ]);

  var spacing = {};
  var r = 40; // start with a little inner radius
  var padding = 10;

  data.forEach(function (d, i) {
    d.numPeople = parseInt(d.numPeople);
    d.totalHours = parseInt(d.totalHours);
    d.months = parseInt(d.months);
    var size = groupSize(d.totalHours);
    spacing[d.Group] = {
      low: r,
      high: r + size,
      size: size
    };
    r += size + padding;
  });

  var angleScale = d3.scale.linear()
    .domain([0, d3.max(data, function (d) {
      return d.months;
    })]).range([0, -1.5 * Math.PI]);

  var arcGenerator = d3.svg.arc()
    .innerRadius(function (d) {
      return spacing[d.Group].low;
    })
    .outerRadius(function (d) {
      return spacing[d.Group].high;
    })
    .startAngle(0)
    .endAngle(function (d) {
      return angleScale(d.months);
    });

  var colorScale = d3.scale.category10();

  var arcs = svg.selectAll('.arc').data(data);
  arcs.enter().append('path');
  arcs.exit().remove();
  arcs.attr('class', 'arc')
    .attr('d', arcGenerator)
    .attr('fill', function (d, i) {
      return colorScale(i);
    });
});
