/*
 * Decompiled with CFR 0.152.
 */
import blobDetection.Blob;
import blobDetection.BlobDetection;
import blobDetection.EdgeVertex;
import java.io.BufferedWriter;
import java.util.ArrayList;
import org.gicentre.utils.gui.TextInput;
import org.gicentre.utils.gui.TextPopup;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.data.StringList;
import processing.data.Table;
import processing.data.TableRow;

public class RCM_Training
extends PApplet {
    PFont myFont;
    TextInput input;
    Button submit;
    TextPopup popup;
    Table scheme;
    TableRow record;
    int record_number;
    String out_file;
    BufferedWriter writer;
    ArrayList<Delimeter> seg_positions;
    Delimeter current;
    PImage img;
    PImage map;
    PImage complex;
    PImage data;
    int t_last_click;
    int threshold = 300;
    float factor;
    int block;
    int color_block;
    int data_mode_index;
    int data_mode;
    int question;
    int option;
    int participant;
    String uuid;
    boolean finished;
    StringList cmap_image;
    String Q1 = "This study is examining how how individuals distinguish color categories in color maps commonly used for data visualization. A color-category is a continuous subset of the of the color map for which you consider colors within the subset more similar to one another than colors outside that subset. In the above image, for example, one color category might be the \u201cred\u201d or \u201creddish\u201d colors.\n\nIn the study, you will be provided images similar to the ones in this training session and asked to make judgements about color categories. You will then be asked to complete a survey asking about the reasoning behind your responses.";
    String Q2 = "In this study you will be required to type answers using the numeric keys on the keyboard. Please type the number twelve using the numeric keys, then either hit \"Enter\" or click \"Next\".";
    String Q3 = "You will also be asked to use a mouse to delineate the boundaries between color categories. Please click anywhere on the above image to create a boundary line.";
    String Q4 = "Boundaries can be highlighted by mousing over them and moved by clicking and dragging. Please familiarize yourself with these interaction mechanisms by adding more boundary lines and dragging them around.";
    String Q5 = "Boundary lines can be removed by double clicking them. Please remove at least one boundary now.";
    String Q6 = "There is a portion of the image that is never covered by the boundary lines (in this case the top half of the image). This allows you to use the end of the boundary line to see the exact color where you are placing the boundary. Note that boundary lines can still be selected in the uncovered portions of the image, however. Try selecting and dragging a boundary from the top half of the image.";
    String Q7 = "Here is a different data set. Practice placing, dragging and deleting boundary lines. When you are done, delete all the boundaries you placed, then click next.";
    String Q8 = "Here is a real-world data set. With a complex data set like this, the subset of the image never covered by the boundary line may be arbitrary. Create and drag a boundary line over the image to discover what subset of this data is never contoured. Delete the contour when you are done.";
    String Q9 = "\nYou should now be prepped for everything you will encounter in the study! Please inform the RA that you have completed the training.";
    boolean q_passed;
    boolean q_passed_alt;

    public void setup() {
        this.submit = new Button(this.width - 100, this.height - 40, "Next");
        this.myFont = this.createFont("Lucida Grande", 16.0f, true);
        this.input = new TextInput((PApplet)this, this.myFont, 16.0f);
        this.popup = new TextPopup((PApplet)this, 100, 100);
        this.finished = false;
        this.data = this.loadImage("brain.png");
        this.complex = this.loadImage("brain.png");
        this.data.loadPixels();
        this.complex.resize(this.width, 0);
        this.complex.loadPixels();
        this.factor = PApplet.parseFloat((int)this.width) / (float)this.data.width;
        this.img = this.createImage(this.width, this.width, 1);
        this.img.loadPixels();
        this.map = this.loadImage("rainbow_map.png");
        this.map.loadPixels();
        this.data_mode = 1;
        this.question = 6;
        this.updateDisplay();
        this.seg_positions = new ArrayList();
        this.current = null;
        this.t_last_click = this.millis();
        this.stroke(10);
        this.noFill();
        this.ellipseMode(2);
        this.q_passed = false;
    }

    public void next() {
        if (!this.submit.active) {
            return;
        }
        ++this.question;
        this.q_passed = false;
        if (this.question == 4) {
            this.submit.timedInactive(10000);
        } else if (this.question == 7) {
            this.nextDataSet();
            this.submit.timedInactive(10000);
        } else if (this.question == 8) {
            this.nextDataSet();
            this.submit.timedInactive(5000);
        } else if (this.question == 9) {
            this.finish();
        }
    }

    public void nextDataSet() {
        ++this.data_mode;
        this.updateDisplay();
        this.seg_positions.clear();
    }

    public void finish() {
        this.popup.clearText();
        this.popup.addText(this.Q9);
        this.popup.setIsActive(true);
        this.finished = true;
    }

    public void updateDisplay() {
        this.popup.clearText();
        this.popup.setIsActive(false);
        if (this.data_mode < 3) {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    float v = this.data_mode == 1 ? PApplet.parseFloat((int)x) / (float)this.img.width : RCM_Training.max((float)(1.0f - RCM_Training.min((float)RCM_Training.sqrt((float)(RCM_Training.sq((float)(2.0f * PApplet.parseFloat((int)x) / (float)this.img.width - 1.0f)) + RCM_Training.sq((float)(2.0f * PApplet.parseFloat((int)y) / (float)this.img.width - 1.0f)))), (float)1.0f)), (float)0.0f);
                    this.img.pixels[y * this.img.height + x] = this.map.pixels[RCM_Training.round((float)(v * 255.0f))];
                    ++x;
                }
                ++y;
            }
            this.img.updatePixels();
        } else if (this.complex.width != this.img.width) {
            this.popup.addText("Error with Complex Example: source image is wrong size.");
            this.popup.setIsActive(true);
        } else {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    int v = this.complex.pixels[y * this.img.height + x] >> 16 & 0xFF;
                    this.img.pixels[y * this.img.height + x] = this.map.pixels[v];
                    ++x;
                }
                ++y;
            }
            this.img.updatePixels();
        }
    }

    public void draw() {
        this.background(100);
        this.image(this.img, 0.0f, 0.0f);
        this.stroke(this.color_block == 1 ? this.color(255, 0, 0) : this.color(10));
        this.noFill();
        for (Delimeter p : this.seg_positions) {
            this.strokeWeight(p.interacting(this.mouseX, this.mouseY, this.img, this.data, this.factor) && this.mouseY < this.width ? 1.5f : 1.0f);
            p.draw(this.img, this.data, this.factor);
        }
        if (this.data_mode == 1) {
            int ix = 0;
            int iy = 0;
            int iw = this.img.width;
            int ih = this.img.height / 2;
            this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
        } else if (this.data_mode == 2) {
            int ix = 0;
            int iy = 0;
            int iw = this.img.width / 2;
            int ih = this.img.height;
            this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
        } else {
            int ix = 90;
            int iy = 237;
            int iw = this.img.width / 3;
            int ih = this.img.height / 3;
            this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
        }
        this.fill(255);
        this.textSize(13.0f);
        switch (this.question) {
            case 1: {
                this.text(this.Q1, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 2: {
                this.text(this.Q2, 50.0f, this.height - 200, this.width - 100, 170.0f);
                this.input.draw(50.0f, (float)(this.height - 125));
                break;
            }
            case 3: {
                this.text(this.Q3, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 4: {
                this.text(this.Q4, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 5: {
                this.text(this.Q5, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 6: {
                this.text(this.Q6, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 7: {
                this.text(this.Q7, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
            case 8: {
                this.text(this.Q8, 50.0f, this.height - 200, this.width - 100, 170.0f);
                break;
            }
        }
        boolean disabled = this.finished;
        disabled = disabled || this.question == 2 && PApplet.parseInt((String)this.input.getText()) != 12;
        disabled = disabled || this.question == 3 && this.seg_positions.size() <= 0;
        disabled = disabled || this.question == 4 && !this.q_passed && this.seg_positions.size() <= 1;
        disabled = disabled || this.question == 5 && !this.q_passed;
        disabled = disabled || this.question == 6 && !this.q_passed;
        disabled = disabled || (this.question == 7 || this.question == 8) && (this.seg_positions.size() != 0 || !this.q_passed);
        this.submit.active = !disabled;
        this.submit.interacting(this.mouseX, this.mouseY);
        this.submit.draw();
        this.popup.draw();
    }

    public void mousePressed() {
        int t_click = this.millis();
        if (!this.submit.clicked(this.mouseX, this.mouseY) && this.mouseY < this.width && this.question > 2) {
            for (Delimeter p : this.seg_positions) {
                if (!p.interacting(this.mouseX, this.mouseY, this.img, this.data, this.factor)) continue;
                this.current = p;
                boolean bl = !this.q_passed && !(this.question == 6 & this.mouseY < this.width / 2) ? false : (this.q_passed_alt = true);
            }
            if (this.current != null && t_click - this.t_last_click < this.threshold) {
                this.seg_positions.remove(this.current);
                this.current = null;
                if (this.question == 5) {
                    this.q_passed = true;
                }
            } else if (this.current == null) {
                this.current = new Delimeter(this.mouseX, this.mouseY, this.data_mode, this.img, this.data, this.factor);
                this.current.dragging = true;
                this.seg_positions.add(this.current);
                if (this.question == 7 || this.question == 8) {
                    this.q_passed = true;
                }
            } else {
                this.current.dragging = true;
                if (this.question == 4) {
                    this.q_passed = true;
                }
                if (this.question == 6) {
                    this.q_passed = this.q_passed_alt;
                }
            }
        }
        this.t_last_click = t_click;
    }

    public void keyPressed() {
        switch (this.key) {
            case '\n': 
            case '\r': {
                this.next();
                break;
            }
            case '\b': 
            case '\u007f': {
                if (this.question != 2) break;
                this.input.keyPressed();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.question != 2 || this.input.getText().length() >= 6) break;
                this.input.keyPressed();
                break;
            }
            case 'p': {
                RCM_Training.println((this.seg_positions.size() == 0 ? 1 : 0) != 0);
                RCM_Training.println((boolean)this.q_passed);
                RCM_Training.println((this.seg_positions.size() != 0 || !this.q_passed ? 1 : 0) != 0);
            }
        }
    }

    public void mouseReleased() {
        if (this.submit.released()) {
            this.next();
        } else if (this.current != null) {
            this.current.dragging = false;
            this.current = null;
        }
    }

    public void settings() {
        this.size(768, 988);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "RCM_Training"};
        if (passedArgs != null) {
            PApplet.main((String[])RCM_Training.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button {
        String text;
        float x;
        float y;
        int textsize;
        boolean rollover;
        boolean mouseDown;
        boolean active;
        boolean tInactive;
        int rest;
        int highlight;
        int pressed;
        int rest_bg;
        int highlight_bg;
        int pressed_bg;
        int startTimer;
        int timerLength;

        Button(float x0, float y0, String s) {
            this.text = s;
            this.x = x0;
            this.y = y0;
            this.textsize = 14;
            this.rollover = false;
            this.mouseDown = false;
            this.active = true;
            this.rest = RCM_Training.this.color(60);
            this.rest_bg = RCM_Training.this.color(240);
            this.highlight = RCM_Training.this.color(60);
            this.highlight_bg = RCM_Training.this.color(230);
            this.pressed = RCM_Training.this.color(240);
            this.pressed_bg = RCM_Training.this.color(180);
            this.startTimer = 0;
            this.timerLength = 0;
        }

        public void setTextSize(int s) {
            this.textsize = s;
        }

        public void setActive(boolean b) {
            this.active = b;
        }

        public void timedHighlight(int ms) {
            this.startTimer = RCM_Training.this.millis();
            this.timerLength = ms;
        }

        public void timedInactive(int ms) {
            this.tInactive = true;
            this.startTimer = RCM_Training.this.millis();
            this.timerLength = ms;
        }

        public void draw() {
            int elapsed = RCM_Training.this.millis() - this.startTimer;
            if (this.tInactive) {
                this.tInactive = elapsed < this.timerLength;
            }
            int alpha = 75;
            if (!this.active | this.tInactive) {
                RCM_Training.this.fill(this.rest_bg, alpha);
            } else if (this.mouseDown && this.rollover) {
                RCM_Training.this.fill(this.pressed_bg);
            } else if (this.rollover) {
                RCM_Training.this.fill(this.highlight_bg);
            } else if (elapsed < this.timerLength) {
                float f = PApplet.parseFloat((int)elapsed) / (float)this.timerLength;
                alpha = 155 + PApplet.parseInt((float)(100.0f * RCM_Training.abs((float)(f - 0.5f)) / 0.5f)) << 24;
                RCM_Training.this.fill(this.highlight_bg, alpha);
            } else {
                RCM_Training.this.fill(this.rest_bg);
            }
            RCM_Training.this.stroke(RCM_Training.this.color(255), alpha);
            RCM_Training.this.rect(this.x, this.y, RCM_Training.this.textWidth(this.text) + 20.0f, RCM_Training.this.textAscent() + RCM_Training.this.textDescent() + 10.0f, 8.0f);
            if (!this.active | this.tInactive) {
                RCM_Training.this.fill(this.rest, alpha);
            } else if (this.mouseDown && this.rollover) {
                RCM_Training.this.fill(this.pressed);
            } else if (this.rollover) {
                RCM_Training.this.fill(this.highlight);
            } else {
                RCM_Training.this.fill(this.rest);
            }
            RCM_Training.this.noStroke();
            RCM_Training.this.textAlign(37, 101);
            RCM_Training.this.textSize(this.textsize);
            RCM_Training.this.text(this.text, this.x + 10.0f, this.y + 5.0f);
        }

        public boolean intersected(float mx, float my) {
            RCM_Training.this.textSize(this.textsize);
            return mx > this.x && mx < this.x + RCM_Training.this.textWidth(this.text) + 20.0f && my > this.y && my < this.y + RCM_Training.this.textAscent() + RCM_Training.this.textDescent() + 12.0f;
        }

        public boolean interacting(int mx, int my) {
            this.rollover = this.active && this.intersected(mx, my);
            return this.rollover;
        }

        public boolean clicked(int mx, int my) {
            this.mouseDown = this.active && this.intersected(mx, my);
            return this.mouseDown;
        }

        public boolean released() {
            boolean tmp = this.mouseDown && this.rollover;
            this.mouseDown = false;
            return tmp;
        }
    }

    class Delimeter {
        int mode;
        float value;
        float epsilon = 3.0f;
        boolean dragging = false;
        BlobDetection detector;
        float factor;

        Delimeter(int mouse_x) {
            this.mode = 1;
            this.value = mouse_x;
            this.detector = null;
        }

        Delimeter(int mouse_x, int mouse_y, int m, PImage img, PImage data, float factor) {
            this.mode = m;
            if (this.mode == 3) {
                this.value = this.f_mode3(mouse_x, mouse_y, data, factor);
                this.detector = new BlobDetection(data.width, data.height);
                this.detector.setThreshold(this.value / 255.0f);
                this.detector.computeBlobs(data.pixels);
            } else {
                this.value = this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x);
            }
        }

        public boolean interacting(int mouse_x, int mouse_y, PImage img, PImage data, float factor) {
            if (this.dragging) {
                if (this.mode == 3) {
                    this.value = this.f_mode3(mouse_x, mouse_y, data, factor);
                    this.detector.setThreshold(this.value / 255.0f);
                    this.detector.computeBlobs(data.pixels);
                } else {
                    this.value = this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x);
                }
                return true;
            }
            float c_value = this.mode == 3 ? this.f_mode3(mouse_x, mouse_y, data, factor) : (this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x));
            return RCM_Training.abs((float)(this.value - c_value)) < this.epsilon + (float)(this.mode == 3 ? 20 : 0);
        }

        public float getNormalizedValue(PImage img) {
            if (this.mode == 3) {
                return this.value / 255.0f;
            }
            if (this.mode == 2) {
                return this.value / (float)(img.width / 2);
            }
            return this.value / (float)img.width;
        }

        public void draw(PImage img, PImage data, float factor) {
            if (this.mode == 3) {
                int n = 0;
                while (n < this.detector.getBlobNb()) {
                    Blob b = this.detector.getBlob(n);
                    if (b != null) {
                        int m = 0;
                        while (m < b.getEdgeNb()) {
                            EdgeVertex eA = b.getEdgeVertexA(m);
                            EdgeVertex eB = b.getEdgeVertexB(m);
                            if (eA != null && eB != null) {
                                RCM_Training.this.line(eA.x * (float)data.width * factor, eA.y * (float)data.height * factor, eB.x * (float)data.width * factor, eB.y * (float)data.height * factor);
                            }
                            ++m;
                        }
                    }
                    ++n;
                }
            } else if (this.mode == 2) {
                RCM_Training.this.ellipse((float)img.width / 2.0f, (float)img.height / 2.0f, this.value, this.value);
            } else {
                RCM_Training.this.line(this.value, 0.0f, this.value, img.height - 1);
            }
        }

        private float f_mode1(float x) {
            return x;
        }

        private float f_mode1(float x, float y, float w, float h) {
            return x;
        }

        private float f_mode2(float x, float y, float w, float h) {
            float half_height = h / 2.0f;
            return RCM_Training.min((float)RCM_Training.sqrt((float)(RCM_Training.sq((float)(w / 2.0f - x)) + RCM_Training.sq((float)(half_height - y)))), (float)half_height);
        }

        private float f_mode3(int x, int y, PImage data, float factor) {
            float tmp = (float)x / factor;
            int i0 = RCM_Training.floor((float)tmp);
            int i1 = RCM_Training.ceil((float)tmp);
            float ax = tmp - (float)i0;
            tmp = (float)y / factor;
            int j0 = RCM_Training.floor((float)tmp);
            int j1 = RCM_Training.ceil((float)tmp);
            float ay = tmp - (float)j0;
            float v00 = data.pixels[this.getIndex(RCM_Training.constrain((int)i0, (int)0, (int)(data.width - 1)), RCM_Training.constrain((int)j0, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v01 = data.pixels[this.getIndex(RCM_Training.constrain((int)i0, (int)0, (int)(data.width - 1)), RCM_Training.constrain((int)j1, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v10 = data.pixels[this.getIndex(RCM_Training.constrain((int)i1, (int)0, (int)(data.width - 1)), RCM_Training.constrain((int)j0, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v11 = data.pixels[this.getIndex(RCM_Training.constrain((int)i1, (int)0, (int)(data.width - 1)), RCM_Training.constrain((int)j1, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v0x = RCM_Training.lerp((float)v00, (float)v10, (float)ax);
            float v1x = RCM_Training.lerp((float)v01, (float)v11, (float)ax);
            float v = RCM_Training.lerp((float)v0x, (float)v1x, (float)ay);
            return v;
        }

        private int getIndex(int x, int y, int N) {
            int idx = y * N + x;
            return idx;
        }
    }
}

