/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.awt.Color;
import org.gicentre.utils.colour.ColourConverter;
import org.gicentre.utils.colour.ColourTable;
import processing.core.PVector;

public class CIELuv {
    private ColourConverter.WhitePoint wp;
    private static double[][] msc = new double[][]{{1.0, 0.0, 0.431}, {1.0, 0.0, 0.415}, {1.0, 0.0, 0.397}, {1.0, 0.0, 0.379}, {1.0, 0.0, 0.359}, {1.0, 0.0, 0.338}, {1.0, 0.0, 0.314}, {1.0, 0.0, 0.289}, {1.0, 0.0, 0.26}, {1.0, 0.0, 0.226}, {1.0, 0.0, 0.185}, {1.0, 0.0, 0.131}, {1.0, 0.0, 0.029}, {1.0, 0.108, 0.0}, {1.0, 0.169, 0.0}, {1.0, 0.213, 0.0}, {1.0, 0.248, 0.0}, {1.0, 0.278, 0.0}, {1.0, 0.303, 0.0}, {1.0, 0.327, 0.0}, {1.0, 0.348, 0.0}, {1.0, 0.368, 0.0}, {1.0, 0.386, 0.0}, {1.0, 0.403, 0.0}, {1.0, 0.419, 0.0}, {1.0, 0.434, 0.0}, {1.0, 0.449, 0.0}, {1.0, 0.462, 0.0}, {1.0, 0.475, 0.0}, {1.0, 0.489, 0.0}, {1.0, 0.501, 0.0}, {1.0, 0.513, 0.0}, {1.0, 0.523, 0.0}, {1.0, 0.535, 0.0}, {1.0, 0.546, 0.0}, {1.0, 0.556, 0.0}, {1.0, 0.566, 0.0}, {1.0, 0.576, 0.0}, {1.0, 0.586, 0.0}, {1.0, 0.596, 0.0}, {1.0, 0.605, 0.0}, {1.0, 0.614, 0.0}, {1.0, 0.624, 0.0}, {1.0, 0.633, 0.0}, {1.0, 0.641, 0.0}, {1.0, 0.65, 0.0}, {1.0, 0.659, 0.0}, {1.0, 0.667, 0.0}, {1.0, 0.675, 0.0}, {1.0, 0.683, 0.0}, {1.0, 0.691, 0.0}, {1.0, 0.699, 0.0}, {1.0, 0.708, 0.0}, {1.0, 0.716, 0.0}, {1.0, 0.724, 0.0}, {1.0, 0.732, 0.0}, {1.0, 0.739, 0.0}, {1.0, 0.747, 0.0}, {1.0, 0.755, 0.0}, {1.0, 0.763, 0.0}, {1.0, 0.771, 0.0}, {1.0, 0.779, 0.0}, {1.0, 0.787, 0.0}, {1.0, 0.795, 0.0}, {1.0, 0.803, 0.0}, {1.0, 0.811, 0.0}, {1.0, 0.819, 0.0}, {1.0, 0.827, 0.0}, {1.0, 0.835, 0.0}, {1.0, 0.843, 0.0}, {1.0, 0.852, 0.0}, {1.0, 0.86, 0.0}, {1.0, 0.868, 0.0}, {1.0, 0.877, 0.0}, {1.0, 0.885, 0.0}, {1.0, 0.894, 0.0}, {1.0, 0.903, 0.0}, {1.0, 0.913, 0.0}, {1.0, 0.922, 0.0}, {1.0, 0.931, 0.0}, {1.0, 0.94, 0.0}, {1.0, 0.95, 0.0}, {1.0, 0.96, 0.0}, {1.0, 0.969, 0.0}, {1.0, 0.98, 0.0}, {1.0, 0.99, 0.0}, {0.998, 1.0, 0.0}, {0.987, 1.0, 0.0}, {0.976, 1.0, 0.0}, {0.965, 1.0, 0.0}, {0.954, 1.0, 0.0}, {0.943, 1.0, 0.0}, {0.932, 1.0, 0.0}, {0.921, 1.0, 0.0}, {0.909, 1.0, 0.0}, {0.898, 1.0, 0.0}, {0.886, 1.0, 0.0}, {0.874, 1.0, 0.0}, {0.862, 1.0, 0.0}, {0.85, 1.0, 0.0}, {0.838, 1.0, 0.0}, {0.825, 1.0, 0.0}, {0.811, 1.0, 0.0}, {0.798, 1.0, 0.0}, {0.784, 1.0, 0.0}, {0.771, 1.0, 0.0}, {0.757, 1.0, 0.0}, {0.742, 1.0, 0.0}, {0.727, 1.0, 0.0}, {0.712, 1.0, 0.0}, {0.695, 1.0, 0.0}, {0.678, 1.0, 0.0}, {0.661, 1.0, 0.0}, {0.644, 1.0, 0.0}, {0.625, 1.0, 0.0}, {0.605, 1.0, 0.0}, {0.584, 1.0, 0.0}, {0.563, 1.0, 0.0}, {0.539, 1.0, 0.0}, {0.514, 1.0, 0.0}, {0.487, 1.0, 0.0}, {0.459, 1.0, 0.0}, {0.426, 1.0, 0.0}, {0.391, 1.0, 0.0}, {0.35, 1.0, 0.0}, {0.302, 1.0, 0.0}, {0.241, 1.0, 0.0}, {0.151, 1.0, 0.0}, {0.0, 1.0, 0.084}, {0.0, 1.0, 0.205}, {0.0, 1.0, 0.273}, {0.0, 1.0, 0.324}, {0.0, 1.0, 0.366}, {0.0, 1.0, 0.401}, {0.0, 1.0, 0.431}, {0.0, 1.0, 0.459}, {0.0, 1.0, 0.484}, {0.0, 1.0, 0.507}, {0.0, 1.0, 0.527}, {0.0, 1.0, 0.547}, {0.0, 1.0, 0.565}, {0.0, 1.0, 0.581}, {0.0, 1.0, 0.598}, {0.0, 1.0, 0.612}, {0.0, 1.0, 0.627}, {0.0, 1.0, 0.641}, {0.0, 1.0, 0.653}, {0.0, 1.0, 0.666}, {0.0, 1.0, 0.677}, {0.0, 1.0, 0.689}, {0.0, 1.0, 0.699}, {0.0, 1.0, 0.71}, {0.0, 1.0, 0.72}, {0.0, 1.0, 0.73}, {0.0, 1.0, 0.74}, {0.0, 1.0, 0.749}, {0.0, 1.0, 0.758}, {0.0, 1.0, 0.767}, {0.0, 1.0, 0.775}, {0.0, 1.0, 0.784}, {0.0, 1.0, 0.792}, {0.0, 1.0, 0.8}, {0.0, 1.0, 0.807}, {0.0, 1.0, 0.814}, {0.0, 1.0, 0.822}, {0.0, 1.0, 0.829}, {0.0, 1.0, 0.837}, {0.0, 1.0, 0.844}, {0.0, 1.0, 0.851}, {0.0, 1.0, 0.857}, {0.0, 1.0, 0.864}, {0.0, 1.0, 0.871}, {0.0, 1.0, 0.877}, {0.0, 1.0, 0.884}, {0.0, 1.0, 0.89}, {0.0, 1.0, 0.897}, {0.0, 1.0, 0.903}, {0.0, 1.0, 0.909}, {0.0, 1.0, 0.915}, {0.0, 1.0, 0.921}, {0.0, 1.0, 0.928}, {0.0, 1.0, 0.933}, {0.0, 1.0, 0.939}, {0.0, 1.0, 0.945}, {0.0, 1.0, 0.951}, {0.0, 1.0, 0.958}, {0.0, 1.0, 0.963}, {0.0, 1.0, 0.969}, {0.0, 1.0, 0.975}, {0.0, 1.0, 0.98}, {0.0, 1.0, 0.987}, {0.0, 1.0, 0.992}, {0.0, 1.0, 0.999}, {0.0, 0.994, 1.0}, {0.0, 0.989, 1.0}, {0.0, 0.984, 1.0}, {0.0, 0.977, 1.0}, {0.0, 0.971, 1.0}, {0.0, 0.966, 1.0}, {0.0, 0.961, 1.0}, {0.0, 0.955, 1.0}, {0.0, 0.948, 1.0}, {0.0, 0.943, 1.0}, {0.0, 0.938, 1.0}, {0.0, 0.932, 1.0}, {0.0, 0.927, 1.0}, {0.0, 0.921, 1.0}, {0.0, 0.916, 1.0}, {0.0, 0.909, 1.0}, {0.0, 0.904, 1.0}, {0.0, 0.898, 1.0}, {0.0, 0.893, 1.0}, {0.0, 0.888, 1.0}, {0.0, 0.882, 1.0}, {0.0, 0.875, 1.0}, {0.0, 0.87, 1.0}, {0.0, 0.865, 1.0}, {0.0, 0.858, 1.0}, {0.0, 0.852, 1.0}, {0.0, 0.847, 1.0}, {0.0, 0.84, 1.0}, {0.0, 0.835, 1.0}, {0.0, 0.828, 1.0}, {0.0, 0.822, 1.0}, {0.0, 0.816, 1.0}, {0.0, 0.809, 1.0}, {0.0, 0.803, 1.0}, {0.0, 0.796, 1.0}, {0.0, 0.789, 1.0}, {0.0, 0.782, 1.0}, {0.0, 0.776, 1.0}, {0.0, 0.769, 1.0}, {0.0, 0.762, 1.0}, {0.0, 0.754, 1.0}, {0.0, 0.746, 1.0}, {0.0, 0.739, 1.0}, {0.0, 0.731, 1.0}, {0.0, 0.723, 1.0}, {0.0, 0.714, 1.0}, {0.0, 0.705, 1.0}, {0.0, 0.697, 1.0}, {0.0, 0.687, 1.0}, {0.0, 0.678, 1.0}, {0.0, 0.668, 1.0}, {0.0, 0.658, 1.0}, {0.0, 0.648, 1.0}, {0.0, 0.637, 1.0}, {0.0, 0.625, 1.0}, {0.0, 0.613, 1.0}, {0.0, 0.601, 1.0}, {0.0, 0.588, 1.0}, {0.0, 0.574, 1.0}, {0.0, 0.559, 1.0}, {0.0, 0.543, 1.0}, {0.0, 0.527, 1.0}, {0.0, 0.509, 1.0}, {0.0, 0.49, 1.0}, {0.0, 0.47, 1.0}, {0.0, 0.448, 1.0}, {0.0, 0.423, 1.0}, {0.0, 0.397, 1.0}, {0.0, 0.366, 1.0}, {0.0, 0.33, 1.0}, {0.0, 0.288, 1.0}, {0.096, 0.257, 1.0}, {0.181, 0.243, 1.0}, {0.237, 0.229, 1.0}, {0.28, 0.213, 1.0}, {0.317, 0.196, 1.0}, {0.35, 0.178, 1.0}, {0.379, 0.157, 1.0}, {0.406, 0.132, 1.0}, {0.431, 0.101, 1.0}, {0.454, 0.058, 1.0}, {0.477, 0.007, 1.0}, {0.503, 0.007, 1.0}, {0.526, 0.006, 1.0}, {0.549, 0.005, 1.0}, {0.57, 0.003, 1.0}, {0.591, 0.002, 1.0}, {0.61, 0.003, 1.0}, {0.629, 0.0, 1.0}, {0.646, 0.0, 1.0}, {0.664, 0.0, 1.0}, {0.681, 0.0, 1.0}, {0.697, 0.0, 1.0}, {0.712, 0.0, 1.0}, {0.728, 0.0, 1.0}, {0.743, 0.0, 1.0}, {0.758, 0.0, 1.0}, {0.772, 0.0, 1.0}, {0.787, 0.0, 1.0}, {0.8, 0.0, 1.0}, {0.814, 0.0, 1.0}, {0.827, 0.0, 1.0}, {0.841, 0.0, 1.0}, {0.854, 0.0, 1.0}, {0.867, 0.0, 1.0}, {0.88, 0.0, 1.0}, {0.892, 0.0, 1.0}, {0.904, 0.0, 1.0}, {0.917, 0.0, 1.0}, {0.93, 0.0, 1.0}, {0.942, 0.0, 1.0}, {0.954, 0.0, 1.0}, {0.967, 0.0, 1.0}, {0.979, 0.0, 1.0}, {0.991, 0.0, 1.0}, {1.0, 0.0, 0.997}, {1.0, 0.0, 0.985}, {1.0, 0.0, 0.972}, {1.0, 0.0, 0.961}, {1.0, 0.0, 0.95}, {1.0, 0.0, 0.938}, {1.0, 0.0, 0.928}, {1.0, 0.0, 0.916}, {1.0, 0.0, 0.906}, {1.0, 0.0, 0.896}, {1.0, 0.0, 0.885}, {1.0, 0.0, 0.875}, {1.0, 0.0, 0.865}, {1.0, 0.0, 0.855}, {1.0, 0.0, 0.845}, {1.0, 0.0, 0.836}, {1.0, 0.0, 0.826}, {1.0, 0.0, 0.816}, {1.0, 0.0, 0.806}, {1.0, 0.0, 0.796}, {1.0, 0.0, 0.787}, {1.0, 0.0, 0.778}, {1.0, 0.0, 0.768}, {1.0, 0.0, 0.759}, {1.0, 0.0, 0.749}, {1.0, 0.0, 0.74}, {1.0, 0.0, 0.73}, {1.0, 0.0, 0.721}, {1.0, 0.0, 0.711}, {1.0, 0.0, 0.701}, {1.0, 0.0, 0.692}, {1.0, 0.0, 0.682}, {1.0, 0.0, 0.672}, {1.0, 0.0, 0.662}, {1.0, 0.0, 0.652}, {1.0, 0.0, 0.642}, {1.0, 0.0, 0.631}, {1.0, 0.0, 0.621}, {1.0, 0.0, 0.61}, {1.0, 0.0, 0.599}, {1.0, 0.0, 0.588}, {1.0, 0.0, 0.577}, {1.0, 0.0, 0.565}, {1.0, 0.0, 0.555}, {1.0, 0.0, 0.543}, {1.0, 0.0, 0.53}, {1.0, 0.0, 0.518}, {1.0, 0.0, 0.505}, {1.0, 0.0, 0.491}, {1.0, 0.0, 0.477}, {1.0, 0.0, 0.462}, {1.0, 0.0, 0.447}, {1.0, 0.0, 0.431}};

    public CIELuv() {
        this(ColourConverter.WhitePoint.D65);
    }

    CIELuv(ColourConverter.WhitePoint wp) {
        this.wp = wp;
    }

    public PVector getLuv(Color colour) {
        double[] Luv = ColourConverter.getLuv(colour, this.wp);
        return new PVector((float)Luv[1], (float)Luv[2], (float)Luv[0]);
    }

    public PVector getLCh(Color colour) {
        double[] Luv = ColourConverter.getLuv(colour, this.wp);
        double[] LCh = ColourConverter.LuvToLCh(Luv);
        return new PVector((float)LCh[1], (float)LCh[2], (float)LCh[0]);
    }

    public Color getColour(double L, double u, double v, boolean useNearest) {
        double[] rgb = ColourConverter.luvToRGB(L, u, v, this.wp);
        double[] Luv = new double[]{L, u, v};
        if (useNearest) {
            return this.findNearest(rgb, Luv);
        }
        if (rgb[0] < 0.0 || rgb[1] < 0.0 || rgb[2] < 0.0 || rgb[0] > 1.0 || rgb[1] > 1.0 || rgb[2] > 1.0) {
            return null;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }

    public Color getColourFromLCh(double L, double C, double h) {
        return this.getColourFromLCh(L, C, h, false);
    }

    public Color getColourFromLCh(double L, double C, double h, boolean findNearest) {
        if (L >= 100.0) {
            return Color.WHITE;
        }
        double[] Luv = ColourConverter.LChToLuv(new double[]{L, C, h});
        double[] rgb = ColourConverter.luvToRGB(Luv[0], Luv[1], Luv[2], this.wp);
        if (findNearest) {
            rgb[0] = Math.max(rgb[0], 0.0);
            rgb[1] = Math.max(rgb[1], 0.0);
            rgb[2] = Math.max(rgb[2], 0.0);
            rgb[0] = Math.min(rgb[0], 1.0);
            rgb[1] = Math.min(rgb[1], 1.0);
            rgb[2] = Math.min(rgb[2], 1.0);
        } else if (rgb[0] < 0.0 || rgb[1] < 0.0 || rgb[2] < 0.0 || rgb[0] > 1.0 || rgb[1] > 1.0 || rgb[2] > 1.0) {
            return null;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }

    public ColourTable getSequential(double hue, int numColours) {
        return this.getSequential(hue, 0.6, 0.75, numColours);
    }

    public ColourTable getSequential(double hue, double saturation, double brightness, int numColours) {
        return this.getSequential(hue, hue, saturation, brightness, numColours);
    }

    public ColourTable getSequential(double hue1, double hue2, double saturation, double brightness, int numColours) {
        double[] p2;
        boolean isContinuous = false;
        int validNumColours = numColours;
        if (validNumColours <= 0) {
            isContinuous = true;
            validNumColours = 12;
        }
        ColourTable cTable = new ColourTable();
        double c = Math.min(0.88, 0.34 + 0.06 * (double)validNumColours);
        double[] p0 = new double[]{0.0, 0.0, hue1};
        double[] rgbMSC = CIELuv.getMostSaturatedColour(hue1);
        double[] Luv = ColourConverter.getLuv(new Color((float)rgbMSC[0], (float)rgbMSC[1], (float)rgbMSC[2]), this.wp);
        double[] p1 = ColourConverter.LuvToLCh(Luv);
        if (Math.abs(hue1 - hue2) < 1.0) {
            p2 = new double[]{100.0, 0.0, hue1};
        } else {
            double w = 0.0;
            double pL = 50.0;
            double[] pb = ColourConverter.LuvToLCh(ColourConverter.getLuv(Color.yellow, this.wp));
            double[] pMid = ColourConverter.RGBToHSL(CIELuv.getMostSaturatedColour(hue2));
            pMid[0] = pMid[0] * 100.0;
            pMid[1] = pMid[1] * 100.0;
            pMid[2] = pMid[2] * 100.0;
            double[] pEnd = pL <= pMid[2] ? new double[]{0.0, 0.0, hue2} : new double[]{100.0, 0.0, hue2};
            double alpha = (pEnd[0] - pL) / (pEnd[0] + pMid[2]);
            double M = (180.0 + pb[2] - hue1) % 360.0 - 180.0;
            double sMax = alpha * (pMid[1] - pEnd[1]) + pEnd[1];
            p2 = new double[]{100.0 * (1.0 - w) + w * pb[0], Math.min(sMax, w * saturation * pb[1]), (hue2 + alpha * M) % 360.0};
        }
        double[] q0 = new double[]{p0[0] * (1.0 - saturation) + p1[0] * saturation, p0[1] * (1.0 - saturation) + p1[1] * saturation, p0[2] * (1.0 - saturation) + p1[2] * saturation};
        double[] q2 = new double[]{p2[0] * (1.0 - saturation) + p1[0] * saturation, p2[1] * (1.0 - saturation) + p1[1] * saturation, p2[2] * (1.0 - saturation) + p1[2] * saturation};
        double[] q1 = new double[]{0.5 * (q0[0] + q2[0]), 0.5 * (q0[1] + q2[1]), 0.5 * (q0[2] + q2[2])};
        int i = 0;
        while (i < validNumColours) {
            double t = (double)i / (double)(validNumColours - 1);
            double Lt = 125.0 - 125.0 * Math.pow(0.2, (1.0 - c) * brightness + t * c);
            double TLt = CIELuv.T(Lt, p0[0], p2[0], q0[0], q1[0], q2[0]);
            double[] colourLCh = TLt <= 0.5 ? CIELuv.B(p0, q0, q1, 2.0 * TLt) : CIELuv.B(q1, q2, p2, 2.0 * (TLt - 0.5));
            Color colour = this.getColourFromLCh(colourLCh[0], colourLCh[1], colourLCh[2], true);
            if (colour == null) {
                if (isContinuous) {
                    cTable.addContinuousColourRule((float)i / (float)(validNumColours - 1), 255, 255, 255);
                } else {
                    cTable.addDiscreteColourRule(i + 1, 255, 255, 255);
                }
            } else if (isContinuous) {
                cTable.addContinuousColourRule((float)i / (float)(validNumColours - 1), colour.getRed(), colour.getGreen(), colour.getBlue());
            } else {
                cTable.addDiscreteColourRule(i + 1, colour.getRed(), colour.getGreen(), colour.getBlue());
            }
            ++i;
        }
        return cTable;
    }

    public static double[] getMostSaturatedColour(double hue) {
        int hueIndex = (int)Math.round(hue % 360.0);
        return msc[hueIndex];
    }

    private Color findNearest(double[] rgb, double[] Luv) {
        if (rgb[0] < 0.0 || rgb[1] < 0.0 || rgb[2] < 0.0 || rgb[0] > 1.0 || rgb[1] > 1.0 || rgb[2] > 1.0) {
            double L = Luv[0];
            double u = Luv[1];
            double v = Luv[2];
            double theta = Math.atan2(u, v);
            double xInc = Math.sin(theta);
            double yInc = Math.cos(theta);
            double minDistSq = u * u + v * v;
            double mag = Math.sqrt(minDistSq) / 2.0;
            double u2 = u;
            double v2 = v;
            if (minDistSq > 1.0) {
                u2 -= xInc * mag;
            }
            if (minDistSq > 1.0) {
                v2 -= yInc * mag;
            }
            Color lastColour = null;
            boolean isOutside = true;
            while (Math.abs(mag) > 0.01) {
                Color newColour = this.getColour(L, u2, v2, false);
                if (newColour == null) {
                    mag = isOutside ? (mag /= 2.0) : (mag /= -2.0);
                    isOutside = true;
                } else {
                    double distSq = (u2 - u) * (u2 - u) + (v2 - v) * (v2 - v);
                    if (distSq < minDistSq) {
                        minDistSq = distSq;
                        lastColour = newColour;
                    }
                    mag = isOutside ? (mag /= -2.0) : (mag /= 2.0);
                    isOutside = false;
                }
                if (u2 * u2 > 1.0) {
                    u2 -= xInc * mag;
                }
                if (!(v2 * v2 > 1.0)) continue;
                v2 -= yInc * mag;
            }
            if (lastColour == null) {
                return this.getColour(L, 0.0, 0.0, false);
            }
            return lastColour;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }

    private static double[] B(double[] b0, double[] b1, double[] b2, double t) {
        return new double[]{(1.0 - t) * (1.0 - t) * b0[0] + 2.0 * (1.0 - t) * t * b1[0] + t * t * b2[0], (1.0 - t) * (1.0 - t) * b0[1] + 2.0 * (1.0 - t) * t * b1[1] + t * t * b2[1], (1.0 - t) * (1.0 - t) * b0[2] + 2.0 * (1.0 - t) * t * b1[2] + t * t * b2[2]};
    }

    private static double Binv(double b0, double b1, double b2, double v) {
        return (b0 - b1 + Math.sqrt(b1 * b1 - b0 * b2 + (b0 - 2.0 * b1 + b2) * v)) / (b0 - 2.0 * b1 + b2);
    }

    private static double T(double l, double p0L, double p2L, double q0L, double q1L, double q2L) {
        if (l <= q1L) {
            return 0.5 * CIELuv.Binv(p0L, q0L, q1L, l);
        }
        return 0.5 * CIELuv.Binv(q1L, q2L, p2L, l) + 0.5;
    }
}

