/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.gui;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PFont;

public class HelpScreen {
    private PApplet applet;
    private PFont font;
    private LinkedHashMap<String, String> helpEntries;
    private boolean isActive;
    private int numSpacers;
    private static final String SPACER = "spacer_key";
    private int backgroundColour;
    private int borderColour;
    private int textColour;
    private float headerTextSize = 0.0f;
    private float footerTextSize = 0.0f;
    private String headerText = null;
    private String footerText = null;
    private int outerPadding = 10;
    private float textSize;
    private int spaceBetweenEntries = 3;
    private int spaceBetweenLines = 1;
    private int spaceBetweenColon = 8;
    private int headerVerticalSpace;
    private int footerVerticalSpace;
    private int headerTextColour;
    private int footerTextColour;

    public HelpScreen(PApplet applet, PFont font) {
        this(applet, font, 12);
    }

    public HelpScreen(PApplet applet, PFont font, int textSize) {
        this.applet = applet;
        this.font = font;
        this.textSize = textSize;
        this.helpEntries = new LinkedHashMap();
        this.borderColour = new Color(100, 100, 100, 100).getRGB();
        this.backgroundColour = new Color(255, 248, 147, 200).getRGB();
        this.textColour = new Color(50, 50, 50).getRGB();
        this.footerTextColour = 100;
        this.isActive = false;
        this.numSpacers = 0;
    }

    public void putEntry(String action, String instruction) {
        this.helpEntries.put(action, instruction);
    }

    public void addSpacer() {
        ++this.numSpacers;
        this.helpEntries.put(SPACER + this.numSpacers, " ");
    }

    public void setHeader(String text, int verticalSpace, int textSize) {
        this.headerText = text;
        this.headerVerticalSpace = verticalSpace;
        this.headerTextSize = textSize;
    }

    public void setFooter(String text, int verticalSpace, int textSize) {
        this.footerText = text;
        this.footerVerticalSpace = verticalSpace;
        this.footerTextSize = textSize;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setHeaderTextColour(int colour) {
        this.headerTextColour = colour;
    }

    public void setFooterTextColour(int colour) {
        this.footerTextColour = colour;
    }

    public void setTextColour(int colour) {
        this.textColour = colour;
    }

    public void setBackgroundColour(int bgColour) {
        this.backgroundColour = bgColour;
    }

    public void setForegroundColour(int fgColour) {
        this.textColour = fgColour;
        this.borderColour = fgColour;
    }

    public void draw() {
        int i;
        String[] toks2;
        String[] toks1;
        int widthLeftColumn = 0;
        int widthRightColumn = 0;
        int height = 0;
        if (this.headerText != null) {
            height = (int)((float)height + (this.headerTextSize + (float)this.spaceBetweenLines + (float)this.headerVerticalSpace));
        }
        for (Map.Entry<String, String> entry : this.helpEntries.entrySet()) {
            this.applet.textFont(this.font);
            this.applet.textSize(this.textSize);
            toks1 = entry.getKey().split("\n");
            toks2 = entry.getValue().split("\n");
            float entryHeight = (float)PApplet.max((int)toks1.length, (int)toks2.length) * (this.textSize + (float)this.spaceBetweenLines);
            height = (int)((float)height + (entryHeight + (float)this.spaceBetweenEntries));
            if (entry.getKey().startsWith(SPACER)) continue;
            i = 0;
            while (i < toks1.length) {
                widthLeftColumn = (int)PApplet.max((float)widthLeftColumn, (float)this.applet.textWidth(toks1[i]));
                ++i;
            }
            i = 0;
            while (i < toks2.length) {
                widthRightColumn = (int)PApplet.max((float)widthRightColumn, (float)this.applet.textWidth(toks2[i]));
                ++i;
            }
        }
        if (this.footerText != null) {
            height += this.footerVerticalSpace;
        }
        int colonX = this.applet.width / 2 - (widthLeftColumn + widthRightColumn) / 2 + widthLeftColumn;
        int top = this.applet.height / 2 - height / 2 - this.outerPadding;
        int y = top + this.outerPadding;
        this.applet.fill(this.backgroundColour);
        this.applet.stroke(this.borderColour);
        this.applet.strokeWeight(0.8f);
        this.applet.rect((float)(this.applet.width / 2 - (widthLeftColumn + widthRightColumn) / 2 - 2 - this.spaceBetweenColon - this.outerPadding), (float)(y - this.outerPadding), (float)(widthLeftColumn + widthRightColumn + 2 * (this.outerPadding + this.spaceBetweenColon + 2)), (float)(height + 2 * this.outerPadding));
        this.applet.fill(this.textColour);
        if (this.headerText != null) {
            this.applet.textSize(this.headerTextSize);
            this.applet.textLeading(this.headerTextSize);
            this.applet.fill(this.headerTextColour);
            this.applet.textAlign(3, 101);
            this.applet.text(this.headerText, (float)(this.applet.width / 2 - (widthLeftColumn + widthRightColumn) / 2 - 2 - this.spaceBetweenColon), (float)y, (float)(widthLeftColumn + widthRightColumn + 2 * (this.spaceBetweenColon + 2)), PApplet.max((float)this.headerVerticalSpace, (float)(this.headerTextSize + this.headerTextSize / 2.0f)));
            y = (int)((float)y + (this.headerTextSize + (float)this.headerVerticalSpace));
            this.applet.textSize(this.textSize);
        }
        this.applet.fill(this.textColour);
        for (Map.Entry<String, String> entry : this.helpEntries.entrySet()) {
            if (!entry.getKey().startsWith(SPACER)) {
                toks1 = entry.getKey().split("\n");
                toks2 = entry.getValue().split("\n");
                i = 0;
                while (i < PApplet.max((int)toks1.length, (int)toks2.length)) {
                    if (toks1.length > i) {
                        this.applet.textAlign(39, 101);
                        this.applet.text(toks1[i], (float)(colonX - this.spaceBetweenColon), (float)y);
                    }
                    if (i == 0) {
                        this.applet.textAlign(3, 101);
                        this.applet.text(":", (float)colonX, (float)y);
                    }
                    if (toks2.length > i) {
                        this.applet.textAlign(37, 101);
                        this.applet.text(toks2[i], (float)(colonX + this.spaceBetweenColon), (float)y);
                    }
                    y = (int)((float)y + (this.textSize + (float)this.spaceBetweenLines));
                    ++i;
                }
            } else {
                y = (int)((float)y + this.textSize);
            }
            y += this.spaceBetweenEntries;
        }
        if (this.footerText != null) {
            this.applet.textSize(this.footerTextSize);
            this.applet.textLeading(this.footerTextSize);
            this.applet.fill(this.footerTextColour);
            this.applet.textAlign(39, 102);
            int heightOfFooterParagraphBox = (int)PApplet.max((float)this.footerVerticalSpace, (float)(this.footerTextSize + this.footerTextSize / 2.0f));
            this.applet.text(this.footerText, (float)(this.applet.width / 2 - (widthLeftColumn + widthRightColumn) / 2 - 2 - this.spaceBetweenColon), (float)(top + height + this.outerPadding - heightOfFooterParagraphBox), (float)(widthLeftColumn + widthRightColumn + 2 * (this.spaceBetweenColon + 2)), (float)heightOfFooterParagraphBox);
        }
    }
}

