/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.move;

public class Ease {
    private Ease() {
        throw new AssertionError((Object)"Cannot create instance of the Ease class.");
    }

    public static float sinIn(float t) {
        return Ease.sinIn(t, 1.0f);
    }

    public static float sinIn(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.sinOut(t, 1.0f);
        }
        return (float)(1.0 - Math.cos(t * 1.5707964f));
    }

    public static float sinOut(float t) {
        return Ease.sinOut(t, 1.0f);
    }

    public static float sinOut(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.sinIn(t, 1.0f);
        }
        return (float)Math.sin(t * 1.5707964f);
    }

    public static float sinBoth(float t) {
        return (float)(1.0 - Math.cos(t * (float)Math.PI)) / 2.0f;
    }

    public static float cubicIn(float t) {
        return Ease.cubicIn(t, 1.0f);
    }

    public static float cubicIn(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.cubicOut(t, 1.0f);
        }
        return t * t * t;
    }

    public static float cubicOut(float t) {
        return Ease.cubicOut(t, 1.0f);
    }

    public static float cubicOut(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.cubicIn(t, 1.0f);
        }
        float tPrime = 1.0f - t;
        return 1.0f - tPrime * tPrime * tPrime;
    }

    public static float cubicBoth(float t) {
        if ((double)t < 0.5) {
            float tPrime = t * 2.0f;
            return 0.5f * tPrime * tPrime * tPrime;
        }
        float tPrime = 2.0f - t * 2.0f;
        return 0.5f * (2.0f - tPrime * tPrime * tPrime);
    }

    public static float quarticIn(float t) {
        return Ease.quarticIn(t, 1.0f);
    }

    public static float quarticIn(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.quarticOut(t, 1.0f);
        }
        return t * t * t * t;
    }

    public static float quarticOut(float t) {
        return Ease.quarticOut(t, 1.0f);
    }

    public static float quarticOut(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.quarticIn(t, 1.0f);
        }
        float tPrime = 1.0f - t;
        return 1.0f - tPrime * tPrime * tPrime * tPrime;
    }

    public static float quarticBoth(float t) {
        if ((double)t < 0.5) {
            float tPrime = t * 2.0f;
            return 0.5f * tPrime * tPrime * tPrime * tPrime;
        }
        float tPrime = 2.0f - t * 2.0f;
        return 0.5f * (2.0f - tPrime * tPrime * tPrime * tPrime);
    }

    public static float quinticIn(float t) {
        return Ease.quinticIn(t, 1.0f);
    }

    public static float quinticIn(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.quinticOut(t, 1.0f);
        }
        return t * t * t * t * t;
    }

    public static float quinticOut(float t) {
        return Ease.quinticOut(t, 1.0f);
    }

    public static float quinticOut(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.quinticIn(t, 1.0f);
        }
        float tPrime = 1.0f - t;
        return 1.0f - tPrime * tPrime * tPrime * tPrime * tPrime;
    }

    public static float quinticBoth(float t) {
        if ((double)t < 0.5) {
            float tPrime = t * 2.0f;
            return 0.5f * tPrime * tPrime * tPrime * tPrime * tPrime;
        }
        float tPrime = 2.0f - t * 2.0f;
        return 0.5f * (2.0f - tPrime * tPrime * tPrime * tPrime * tPrime);
    }

    public static float bounceIn(float t) {
        return Ease.bounceIn(t, 1.0f);
    }

    public static float bounceIn(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.bounceOut(t);
        }
        float tPrime = 1.0f - t;
        if ((double)tPrime < 0.36364) {
            return 1.0f - 7.5625f * tPrime * tPrime;
        }
        if ((double)tPrime < 0.72727) {
            return 1.0f - (7.5625f * (tPrime -= 0.545454f) * tPrime + 0.75f);
        }
        if ((double)tPrime < 0.90909) {
            return 1.0f - (7.5625f * (tPrime -= 0.81818f) * tPrime + 0.9375f);
        }
        return 1.0f - (7.5625f * (tPrime -= 0.95455f) * tPrime + 0.984375f);
    }

    public static float bounceOut(float t) {
        return Ease.bounceOut(t, 1.0f);
    }

    public static float bounceOut(float t, float direction) {
        if (direction < 0.0f) {
            return Ease.bounceIn(t);
        }
        float tPrime = t;
        if ((double)tPrime < 0.36364) {
            return 7.5625f * tPrime * tPrime;
        }
        if ((double)tPrime < 0.72727) {
            return 7.5625f * (tPrime -= 0.545454f) * tPrime + 0.75f;
        }
        if ((double)tPrime < 0.90909) {
            return 7.5625f * (tPrime -= 0.81818f) * tPrime + 0.9375f;
        }
        return 7.5625f * (tPrime -= 0.95455f) * tPrime + 0.984375f;
    }

    public static float elasticIn(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 0.5f;
        }
        float p = 0.25f;
        float a = 1.05f;
        float s = 0.0501716f;
        return (float)Math.max(0.0, 0.5 + (double)a * Math.pow(2.0, -10.0f * t) * Math.sin((t - s) * ((float)Math.PI * 2) / p));
    }

    public static float elasticOut(float t) {
        if (t <= 0.0f) {
            return 0.5f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        float tPrime = 1.0f - t;
        float p = 0.25f;
        float a = 1.05f;
        float s = 0.0501717f;
        return (float)Math.min(1.0, 0.5 - (double)a * Math.pow(2.0, -10.0f * tPrime) * Math.sin((tPrime - s) * ((float)Math.PI * 2) / p));
    }
}

