/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.move;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import org.gicentre.utils.move.ZoomPan;
import org.gicentre.utils.move.ZoomPanListener;
import org.gicentre.utils.move.ZoomPanState;
import org.gicentre.utils.move.ZoomPanable;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import processing.event.MouseEvent;

public class ZoomPan30
implements ZoomPanable {
    private ZoomPanState zoomPanState;
    private PVector zoomStartPosition;
    private PVector oldPosition;
    private double zoomStep;
    private boolean isZooming;
    private boolean isPanning;
    private boolean isMouseCaptured;
    private boolean allowZoomButton;
    private boolean allowPanButton;
    private int mouseMask = 0;
    private Vector<ZoomPanListener> listeners;
    private int zoomMouseButton = 37;
    private Rectangle mouseBoundsMask = null;
    double minZoomScaleX = Double.MIN_VALUE;
    double maxZoomScaleX = Double.MAX_VALUE;
    double minZoomScaleY = Double.MIN_VALUE;
    double maxZoomScaleY = Double.MAX_VALUE;
    private ZoomPan.ZoomPanDirection zoomPanDirection = ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH;

    ZoomPan30(PApplet aContext) {
        this.zoomPanState = new ZoomPanState(aContext, null);
        if (aContext == null) {
            System.err.println("Warning: No applet context provided for ZoomPan.");
            return;
        }
        this.allowZoomButton = true;
        this.allowPanButton = true;
        this.listeners = new Vector();
        this.reset();
        aContext.registerMethod("mouseEvent", (Object)this);
    }

    ZoomPan30(PApplet sketchContext, PGraphics graphics) {
        this.zoomPanState = new ZoomPanState(sketchContext, graphics);
        if (sketchContext == null) {
            System.err.println("Warning: No applet context provided for ZoomPan.");
            return;
        }
        if (graphics == null) {
            System.err.println("Warning: No graphics context provided for ZoomPan.");
            return;
        }
        this.allowZoomButton = true;
        this.allowPanButton = true;
        this.listeners = new Vector();
        this.reset();
        sketchContext.registerMethod("mouseEvent", (Object)this);
    }

    public void transform() {
        this.zoomPanState.transform();
    }

    public void transform(PGraphics offScreenBuffer) {
        this.zoomPanState.transform(offScreenBuffer);
    }

    public void reset() {
        this.zoomPanState.trans = new AffineTransform();
        this.zoomPanState.iTrans = new AffineTransform();
        this.zoomPanState.zoomScaleX = 1.0;
        this.zoomPanState.zoomScaleY = 1.0;
        this.zoomPanState.panOffset = new PVector(0.0f, 0.0f);
        this.zoomStep = 1.05;
        this.isZooming = false;
        this.isPanning = false;
        this.isMouseCaptured = false;
        for (ZoomPanListener zoomPanListener : this.listeners) {
            zoomPanListener.panEnded();
            zoomPanListener.zoomEnded();
        }
    }

    public void addZoomPanListener(ZoomPanListener zoomPanListener) {
        this.listeners.add(zoomPanListener);
    }

    public boolean removeZoomPanListener(ZoomPanListener zoomPanListener) {
        return this.listeners.remove(zoomPanListener);
    }

    public void setMouseMask(int mouseMask) {
        if (mouseMask < 0) {
            this.mouseMask = -1;
            return;
        }
        switch (mouseMask) {
            case 17: {
                this.mouseMask = 17;
                break;
            }
            case 16: {
                this.mouseMask = 16;
                break;
            }
            case 18: {
                this.mouseMask = 18;
                break;
            }
            default: {
                this.mouseMask = 0;
            }
        }
    }

    public PVector getMouseCoord() {
        return this.getDispToCoord(new PVector((float)this.zoomPanState.aContext.mouseX, (float)this.zoomPanState.aContext.mouseY));
    }

    public double getZoomScale() {
        return this.zoomPanState.getZoomScale();
    }

    public double getZoomScaleX() {
        return this.zoomPanState.getZoomScaleX();
    }

    public double getZoomScaleY() {
        return this.zoomPanState.getZoomScaleY();
    }

    public void setZoomScale(double zoomScale) {
        this.setZoomScaleWithoutRecalculation(zoomScale, zoomScale);
        this.calcTransformation();
    }

    public void setZoomScale(double zoomScaleX, double zoomScaleY) {
        this.setZoomScaleWithoutRecalculation(zoomScaleX, zoomScaleY);
        this.calcTransformation();
    }

    public void setZoomScaleX(double zoomScaleX) {
        this.setZoomScaleWithoutRecalculation(zoomScaleX, this.zoomPanState.getZoomScaleY());
        this.calcTransformation();
    }

    public void setZoomScaleY(double zoomScaleY) {
        this.setZoomScaleWithoutRecalculation(this.zoomPanState.getZoomScaleX(), zoomScaleY);
        this.calcTransformation();
    }

    public void setZoomPanDirection(ZoomPan.ZoomPanDirection zoomPanDirection) {
        this.zoomPanDirection = zoomPanDirection;
    }

    public ZoomPan.ZoomPanDirection getZoomPanDirection() {
        return this.zoomPanDirection;
    }

    public PVector getPanOffset() {
        return this.zoomPanState.getPanOffset();
    }

    public void setPanOffset(float panX, float panY) {
        this.zoomPanState.panOffset.x = panX;
        this.zoomPanState.panOffset.y = panY;
        this.calcTransformation();
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    public boolean isPanning() {
        return this.isPanning;
    }

    public boolean isMouseCaptured() {
        return this.isMouseCaptured;
    }

    public void allowZoomButton(boolean allowZoom) {
        this.allowZoomButton = allowZoom;
    }

    public void allowPanButton(boolean allowPan) {
        this.allowPanButton = allowPan;
    }

    public void mouseEvent(MouseEvent e) {
        if (this.mouseMask == -1) {
            return;
        }
        if (e.getAction() == 2) {
            boolean isZoomEnded = false;
            boolean isPanEnded = false;
            if (this.isZooming) {
                this.isZooming = false;
                isZoomEnded = true;
            }
            if (this.isPanning) {
                this.isPanning = false;
                isPanEnded = true;
            }
            this.zoomStep = 1.05;
            this.isMouseCaptured = false;
            for (ZoomPanListener listener : this.listeners) {
                if (isZoomEnded) {
                    listener.zoomEnded();
                }
                if (!isPanEnded) continue;
                listener.panEnded();
            }
        }
        if (this.mouseMask < 0 || this.mouseMask == 16 && !e.isShiftDown() || this.mouseMask == 17 && !e.isControlDown() || this.mouseMask == 18 && !e.isAltDown()) {
            return;
        }
        if (e.getAction() == 1 && (this.mouseBoundsMask == null || this.mouseBoundsMask.contains(this.zoomPanState.aContext.mouseX, this.zoomPanState.aContext.mouseY))) {
            this.isMouseCaptured = true;
            this.zoomStartPosition = new PVector((float)e.getX(), (float)e.getY());
            this.oldPosition = new PVector((float)e.getX(), (float)e.getY());
        } else if (e.getAction() == 4) {
            if (this.zoomPanState.aContext == null || this.oldPosition == null) {
                return;
            }
            if (this.zoomPanState.aContext.mouseButton == this.zoomMouseButton && this.allowZoomButton && this.isMouseCaptured) {
                this.isZooming = true;
                if ((float)this.zoomPanState.aContext.mouseY < this.oldPosition.y) {
                    if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX * this.zoomStep, this.zoomPanState.zoomScaleY * this.zoomStep);
                    } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_HORIZONTAL_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX * this.zoomStep, this.zoomPanState.zoomScaleY);
                    } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_VERTICAL_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX, this.zoomPanState.zoomScaleY * this.zoomStep);
                    }
                } else if ((float)this.zoomPanState.aContext.mouseY > this.oldPosition.y) {
                    if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX / this.zoomStep, this.zoomPanState.zoomScaleY / this.zoomStep);
                    } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_HORIZONTAL_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX / this.zoomStep, this.zoomPanState.zoomScaleY);
                    } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_VERTICAL_PAN_BOTH) {
                        this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX, this.zoomPanState.zoomScaleY / this.zoomStep);
                    }
                }
                this.doZoom();
                this.zoomStep += 0.005;
            } else if (this.allowPanButton && this.isMouseCaptured) {
                this.isPanning = true;
                if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_HORIZONTAL_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_VERTICAL_PAN_BOTH) {
                    this.zoomPanState.panOffset.add(new PVector((float)e.getX() - this.oldPosition.x, (float)e.getY() - this.oldPosition.y));
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL) {
                    this.zoomPanState.panOffset.add(new PVector((float)e.getX() - this.oldPosition.x, 0.0f));
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL) {
                    this.zoomPanState.panOffset.add(new PVector(0.0f, (float)e.getY() - this.oldPosition.y));
                }
                this.calcTransformation();
            }
            this.oldPosition = new PVector((float)e.getX(), (float)e.getY());
        } else if (e.getCount() != 0) {
            this.isZooming = true;
            this.setZoomStartPosition(new PVector((float)e.getX(), (float)e.getY()));
            if (e.getCount() > 0) {
                if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX * this.zoomStep, this.zoomPanState.zoomScaleY * this.zoomStep);
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_HORIZONTAL_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX * this.zoomStep, this.zoomPanState.zoomScaleY);
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_VERTICAL_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX, this.zoomPanState.zoomScaleY * this.zoomStep);
                }
                this.doZoom();
            } else if (e.getCount() < 0) {
                if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX / this.zoomStep, this.zoomPanState.zoomScaleY / this.zoomStep);
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_HORIZONTAL_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX / this.zoomStep, this.zoomPanState.zoomScaleY);
                } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_VERTICAL_PAN_BOTH || this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL) {
                    this.setZoomScaleWithoutRecalculation(this.zoomPanState.zoomScaleX, this.zoomPanState.zoomScaleY / this.zoomStep);
                }
                this.doZoom();
            }
        }
    }

    public void setMinZoomScale(double minZoomScale) {
        this.minZoomScaleX = minZoomScale;
        this.minZoomScaleY = minZoomScale;
        if (this.zoomPanState.zoomScaleX < minZoomScale) {
            this.setZoomScaleX(minZoomScale);
        }
        if (this.zoomPanState.zoomScaleY < minZoomScale) {
            this.setZoomScaleY(minZoomScale);
        }
    }

    public void setMinZoomScaleX(double minZoomScaleX) {
        this.minZoomScaleX = minZoomScaleX;
        if (this.zoomPanState.zoomScaleX < minZoomScaleX) {
            this.setZoomScaleX(minZoomScaleX);
        }
    }

    public void setMinZoomScaleY(double minZoomScaleY) {
        this.minZoomScaleY = minZoomScaleY;
        if (this.zoomPanState.zoomScaleY < minZoomScaleY) {
            this.setZoomScaleY(minZoomScaleY);
        }
    }

    public void setMaxZoomScale(double maxZoomScale) {
        this.maxZoomScaleX = maxZoomScale;
        this.maxZoomScaleY = maxZoomScale;
        if (this.zoomPanState.zoomScaleX > maxZoomScale) {
            this.setZoomScaleX(maxZoomScale);
        }
        if (this.zoomPanState.zoomScaleY > maxZoomScale) {
            this.setZoomScaleY(maxZoomScale);
        }
    }

    public void setMaxZoomScaleX(double maxZoomScaleX) {
        this.maxZoomScaleX = maxZoomScaleX;
        if (this.zoomPanState.zoomScaleX > maxZoomScaleX) {
            this.setZoomScaleX(maxZoomScaleX);
        }
    }

    public void setMaxZoomScaleY(double maxZoomScaleY) {
        this.maxZoomScaleY = maxZoomScaleY;
        if (this.zoomPanState.zoomScaleY > maxZoomScaleY) {
            this.setZoomScale(maxZoomScaleY);
        }
    }

    public PVector getDispToCoord(PVector p) {
        return this.zoomPanState.getDispToCoord(p);
    }

    public PVector getCoordToDisp(PVector p) {
        return this.zoomPanState.getCoordToDisp(p);
    }

    public void setZoomMouseButton(int zoomMouseButton) {
        if (zoomMouseButton == 37 || zoomMouseButton == 39) {
            this.zoomMouseButton = zoomMouseButton;
        } else {
            System.err.println("setZoomMouseButton: Parameter must be LEFT, RIGHT or CENTER");
        }
    }

    @Deprecated
    public void text(String textToDisplay, float xPos, float yPos) {
        ZoomPan.text(this.zoomPanState.aContext, textToDisplay, xPos, yPos);
    }

    public ZoomPanState getZoomPanState() {
        return (ZoomPanState)this.zoomPanState.clone();
    }

    void doZoom() {
        PVector pCoord = this.getDispToCoord(new PVector(this.zoomStartPosition.x, this.zoomStartPosition.y));
        this.calcTransformation();
        PVector newZoomStartPosition = this.getCoordToDisp(pCoord);
        this.zoomPanState.panOffset.add(new PVector(this.zoomStartPosition.x - newZoomStartPosition.x, this.zoomStartPosition.y - newZoomStartPosition.y));
        this.calcTransformation();
    }

    int getMouseMask() {
        return this.mouseMask;
    }

    double getZoomStep() {
        return this.zoomStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setZoomScaleWithoutRecalculation(double zoomScaleX, double zoomScaleY) {
        ZoomPan30 zoomPan30 = this;
        synchronized (zoomPan30) {
            this.zoomPanState.zoomScaleX = zoomScaleX;
            this.zoomPanState.zoomScaleY = zoomScaleY;
            this.zoomPanState.zoomScaleX = Math.min(this.zoomPanState.zoomScaleX, this.maxZoomScaleX);
            this.zoomPanState.zoomScaleX = Math.max(this.zoomPanState.zoomScaleX, this.minZoomScaleX);
            this.zoomPanState.zoomScaleY = Math.min(this.zoomPanState.zoomScaleY, this.maxZoomScaleY);
            this.zoomPanState.zoomScaleY = Math.max(this.zoomPanState.zoomScaleY, this.minZoomScaleY);
        }
    }

    void setZoomStartPosition(PVector zoomStartPosition) {
        this.zoomStartPosition = zoomStartPosition;
    }

    private void calcTransformation() {
        double centreX = (double)this.zoomPanState.getGraphics().width * (1.0 - this.zoomPanState.zoomScaleX) / 2.0;
        double centreY = (double)this.zoomPanState.getGraphics().height * (1.0 - this.zoomPanState.zoomScaleY) / 2.0;
        this.zoomPanState.trans = new AffineTransform();
        this.zoomPanState.iTrans = new AffineTransform();
        if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_BOTH) {
            this.zoomPanState.trans.translate(centreX + (double)this.zoomPanState.panOffset.x, centreY + (double)this.zoomPanState.panOffset.y);
            this.zoomPanState.trans.scale(this.zoomPanState.zoomScaleX, this.zoomPanState.zoomScaleY);
            this.zoomPanState.iTrans.scale(1.0 / this.zoomPanState.zoomScaleX, 1.0 / this.zoomPanState.zoomScaleY);
            this.zoomPanState.iTrans.translate(-centreX - (double)this.zoomPanState.panOffset.x, -centreY - (double)this.zoomPanState.panOffset.y);
        } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_VERTICAL) {
            this.zoomPanState.trans.translate(0.0, centreY + (double)this.zoomPanState.panOffset.y);
            this.zoomPanState.trans.scale(1.0, this.zoomPanState.zoomScaleY);
            this.zoomPanState.iTrans.scale(1.0, 1.0 / this.zoomPanState.zoomScaleY);
            this.zoomPanState.iTrans.translate(0.0, -centreY - (double)this.zoomPanState.panOffset.y);
        } else if (this.zoomPanDirection == ZoomPan.ZoomPanDirection.ZOOM_PAN_HORIZONTAL) {
            this.zoomPanState.trans.translate(centreX + (double)this.zoomPanState.panOffset.x, 0.0);
            this.zoomPanState.trans.scale(this.zoomPanState.zoomScaleX, 1.0);
            this.zoomPanState.iTrans.scale(1.0 / this.zoomPanState.zoomScaleX, 1.0);
            this.zoomPanState.iTrans.translate(-centreX - (double)this.zoomPanState.panOffset.x, 0.0);
        }
    }
}

