/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.TwoBodyForce;
import org.gicentre.utils.network.traer.physics.Vector3D;

public class Attraction
extends TwoBodyForce {
    private float distanceMin;
    private float k;

    public Attraction(Particle oneEnd, Particle theOtherEnd, float k, float distanceMin) throws NullPointerException, IllegalArgumentException {
        super(oneEnd, theOtherEnd);
        this.setStrength(k);
        this.setMinimumDistance(distanceMin);
    }

    public final float getMinimumDistance() {
        return this.distanceMin;
    }

    public final Attraction setMinimumDistance(float d) throws IllegalArgumentException {
        if (d <= 0.0f) {
            throw new IllegalArgumentException("Argument d is " + d + "; cannot specify a minimum distance <=0.");
        }
        this.distanceMin = d;
        return this;
    }

    public final Attraction setStrength(float k) {
        this.k = k;
        return this;
    }

    public final float getStrength() {
        return this.k;
    }

    protected TwoBodyForce.ForcePair forcePair() {
        Vector3D fromTheOtherEndtoOneEnd = Vector3D.subtract(this.getOneEnd().position(), this.getTheOtherEnd().position()).floor(this.distanceMin);
        fromTheOtherEndtoOneEnd.length(-this.k * this.getOneEnd().mass() * this.getTheOtherEnd().mass() / fromTheOtherEndtoOneEnd.lengthSquared());
        return Attraction.equalAndOpposite(fromTheOtherEndtoOneEnd);
    }
}

