/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Integrator;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.Vector3D;

public class ModifiedEulerIntegrator
extends Integrator {
    public ModifiedEulerIntegrator(ParticleSystem s) {
        super(s);
    }

    public ModifiedEulerIntegrator step(float deltaT) {
        this.s.clearForces();
        this.s.applyForces();
        float halftt = 0.5f * deltaT * deltaT;
        for (Particle p : this.s.getParticles()) {
            if (!p.isFree()) continue;
            Vector3D a = p.getForce().multiplyBy(1.0f / p.mass());
            p.position().add(p.velocity().copy().multiplyBy(deltaT)).add(a.copy().multiplyBy(halftt));
            p.velocity().add(a.multiplyBy(deltaT));
        }
        return this;
    }
}

