/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import java.io.Serializable;
import processing.core.PVector;

public class Ellipsoid
implements Serializable {
    private int id;
    private double a;
    private double b;
    private double e2;
    private double n;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double DEG_TO_RAD = Math.PI / 180;
    public static final int UNDEFINED = -1;
    public static final int AIRY_1830 = 1;
    public static final int AUSTRALIAN_NATIONAL = 2;
    public static final int BESSEL_1841 = 3;
    public static final int BESSEL_1841_NAMIBIA = 4;
    public static final int CLARKE_1866 = 5;
    public static final int CLARKE_1880 = 6;
    public static final int EVEREST = 7;
    public static final int FISCHER_1960 = 8;
    public static final int FISCHER_1968 = 9;
    public static final int GRS_1967 = 10;
    public static final int GRS_1980 = 11;
    public static final int HELMERT_1906 = 12;
    public static final int HOUGH = 13;
    public static final int INTERNATIONAL = 14;
    public static final int KRASSOVSKY = 15;
    public static final int MODIFIED_AIRY = 16;
    public static final int MODIFIED_EVEREST = 17;
    public static final int MODIFIED_FISCHER_1960 = 18;
    public static final int SOUTH_AMERICAN = 19;
    public static final int WGS_60 = 20;
    public static final int WGS_66 = 21;
    public static final int WGS_72 = 22;
    public static final int WGS_84 = 23;
    public static final int SPHERE = 99;
    static final long serialVersionUID = -4698774124137349325L;

    public Ellipsoid(int id) {
        switch (id) {
            case 1: {
                this.store(id, 6377563.396, 0.0066705397616);
                break;
            }
            case 2: {
                this.store(id, 6378160.0, 0.006694542);
                break;
            }
            case 3: {
                this.store(id, 6377397.0, 0.006674372);
                break;
            }
            case 4: {
                this.store(id, 6377484.0, 0.006674372);
                break;
            }
            case 5: {
                this.store(id, 6378206.0, 0.006768658);
                break;
            }
            case 6: {
                this.store(id, 6378249.0, 0.006803511);
                break;
            }
            case 7: {
                this.store(id, 6377276.0, 0.006637847);
                break;
            }
            case 8: {
                this.store(id, 6378166.0, 0.006693422);
                break;
            }
            case 9: {
                this.store(id, 6378150.0, 0.006693422);
                break;
            }
            case 10: {
                this.store(id, 6378160.0, 0.006694605);
                break;
            }
            case 11: {
                this.store(id, 6378137.0, 0.00669438);
                break;
            }
            case 12: {
                this.store(id, 6378200.0, 0.006693422);
                break;
            }
            case 13: {
                this.store(id, 6378270.0, 0.00672267);
                break;
            }
            case 14: {
                this.store(id, 6378388.0, 0.00672267);
                break;
            }
            case 15: {
                this.store(id, 6378245.0, 0.006693422);
                break;
            }
            case 16: {
                this.store(id, 6377340.189, 0.00667054);
                break;
            }
            case 17: {
                this.store(id, 6377304.0, 0.006637847);
                break;
            }
            case 18: {
                this.store(id, 6378155.0, 0.006693422);
                break;
            }
            case 19: {
                this.store(id, 6378160.0, 0.006694542);
                break;
            }
            case 20: {
                this.store(id, 6378165.0, 0.006693422);
                break;
            }
            case 21: {
                this.store(id, 6378145.0, 0.006694542);
                break;
            }
            case 22: {
                this.store(id, 6378135.0, 0.006694318);
                break;
            }
            case 23: {
                this.store(id, 6378137.0, 0.00669438);
                break;
            }
            case 99: {
                this.store(id, 6378137.0, 0.0);
                break;
            }
            default: {
                this.store(-1, -1.0, -1.0);
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public double getEquatorialRadius() {
        return this.a;
    }

    public double getPolarRadius() {
        return this.b;
    }

    public double getSquaredEccentricity() {
        return this.e2;
    }

    public double getN() {
        return this.n;
    }

    public String getName() {
        return Ellipsoid.getName(this.id);
    }

    public PVector projectDatum(PVector p, int newDatum) {
        double lng = p.x;
        double lat = p.y;
        if (newDatum == this.id) {
            System.err.println("Warning: Already using " + Ellipsoid.getName(this.id) + ". No conversion necessary.");
            return new PVector((float)lng, (float)lat);
        }
        if (this.id == 23) {
            if (newDatum == 1) {
                return this.molodensky(lng, lat, -573.604, -1.1960023E-5, -375.0, 111.0, -431.0);
            }
            if (newDatum == 3) {
                return this.molodensky(lng, lat, 251.0, 1.4192702E-5, 86.0, 98.0, 119.0);
            }
            if (newDatum == 6) {
                return this.molodensky(lng, lat, 112.145, 5.4750714E-5, 168.0, 60.0, -320.0);
            }
            if (newDatum == 11) {
                return new PVector((float)lng, (float)lat);
            }
        }
        if (this.id == 1 && (newDatum == 23 || newDatum == 11)) {
            return this.molodensky(lng, lat, 573.604, 1.1960023E-5, 375.0, -111.0, 431.0);
        }
        if (this.id == 3 && (newDatum == 23 || newDatum == 11)) {
            return this.molodensky(lng, lat, -251.0, -1.4192702E-5, -86.0, -98.0, -119.0);
        }
        if (this.id == 6 && (newDatum == 23 || newDatum == 11)) {
            return this.molodensky(lng, lat, -112.145, -5.4750714E-5, -168.0, -60.0, 320.0);
        }
        System.err.println("Warning: Conversion from " + Ellipsoid.getName(this.id) + " to " + Ellipsoid.getName(newDatum) + " not supported.");
        return null;
    }

    public static String getName(int id) {
        switch (id) {
            case 1: {
                return new String("Airy 1830");
            }
            case 2: {
                return new String("Australian National");
            }
            case 3: {
                return new String("Bessel 1841");
            }
            case 4: {
                return new String("Bessel 1841 (Namibia)");
            }
            case 5: {
                return new String("Clarke 1866");
            }
            case 6: {
                return new String("Clarke 1880");
            }
            case 7: {
                return new String("Everest");
            }
            case 8: {
                return new String("Fischer 1960");
            }
            case 9: {
                return new String("Fischer 1968");
            }
            case 10: {
                return new String("GRS 1967");
            }
            case 11: {
                return new String("GRS 1980");
            }
            case 12: {
                return new String("Helmert 1906");
            }
            case 13: {
                return new String("Hough");
            }
            case 14: {
                return new String("International");
            }
            case 15: {
                return new String("Krassovsky");
            }
            case 16: {
                return new String("Modified Airy");
            }
            case 17: {
                return new String("Modified Everest");
            }
            case 18: {
                return new String("Modified Fischer 1960");
            }
            case 19: {
                return new String("South American");
            }
            case 20: {
                return new String("WGS 60");
            }
            case 21: {
                return new String("WGS 66");
            }
            case 22: {
                return new String("WGS 72");
            }
            case 23: {
                return new String("WGS 84");
            }
            case 99: {
                return new String("Sphere");
            }
        }
        return new String("Undefined");
    }

    private void store(int eid, double radius, double ee2) {
        this.id = eid;
        this.a = radius;
        this.e2 = ee2;
        this.b = Math.sqrt(this.a * this.a * (1.0 - this.e2));
        this.n = (this.a - this.b) / (this.a + this.b);
    }

    private PVector molodensky(double lng, double lat, double dA, double dF, double dX, double dY, double dZ) {
        double myA = this.a - dA;
        double myF = 0.0033528106647474805 - dF;
        double myES = 2.0 * myF - myF * myF;
        double myLat = lat * (Math.PI / 180);
        double myLng = lng * (Math.PI / 180);
        double sinLat = Math.sin(myLat);
        double sinLng = Math.sin(myLng);
        double cosLat = Math.cos(myLat);
        double cosLng = Math.cos(myLng);
        double rn = myA / Math.sqrt(1.0 - myES * sinLat * sinLat);
        double rm = myA * (1.0 - myES) / Math.pow(1.0 - myES * sinLat * sinLat, 1.5);
        double d1 = -dX * sinLat * cosLng - dY * sinLat * sinLng + dZ * cosLat;
        double d2 = dA * (rn * myES * sinLat * cosLat) / myA;
        double d3 = dF * (rm / (1.0 - myF) + rn * (1.0 - myF)) * sinLat * cosLat;
        double dLat = (d1 + d2 + d3) / rm;
        double dLng = (-dX * sinLng + dY * cosLng) / (rn * cosLat);
        return new PVector((float)((myLng + dLng) * 57.29577951308232), (float)((myLat + dLat) * 57.29577951308232));
    }
}

