/*
 * Decompiled with CFR 0.152.
 */
import blobDetection.Blob;
import blobDetection.BlobDetection;
import blobDetection.EdgeVertex;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.gicentre.utils.gui.TextInput;
import org.gicentre.utils.gui.TextPopup;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.data.StringList;
import processing.data.Table;
import processing.data.TableRow;

public class RCM_Pilot
extends PApplet {
    PFont myFont;
    TextInput input;
    Button submit;
    TextPopup popup;
    Table scheme;
    TableRow record;
    int record_number;
    String out_file;
    BufferedWriter writer;
    ArrayList<Delimeter> seg_positions;
    Delimeter current;
    PImage img;
    PImage map;
    PImage complex;
    PImage data;
    int t_last_click;
    int threshold = 300;
    float factor;
    int block;
    int color_block;
    int data_mode_index;
    int data_mode;
    int question;
    int option;
    int participant;
    String uuid;
    boolean finished;
    StringList cmap_image;
    String Q1 = "In the image above, how many distinct color categories do you see?\nPlease type your answer using the numeric keys.";
    String Q2 = "Your task is to delineate the distinct color categories that you see. To do this, click on the image to create a boundary between distinct color categories. You can move the boundary by clicking and dragging the boundary. To remove a boundary double-click on it. You may make as few or as many boundaries as you need to partition the color categories that you believe are distinct.";

    public void setup() {
        this.submit = new Button(this.width - 100, this.height - 40, "Next");
        this.myFont = this.createFont("Lucida Grande", 16.0f, true);
        this.input = new TextInput((PApplet)this, this.myFont, 16.0f);
        this.popup = new TextPopup((PApplet)this, 100, 100);
        this.scheme = this.loadTable("run_scheme.csv", "header");
        int count = this.scheme.getRowCount();
        this.finished = false;
        if (count > 0) {
            this.record_number = RCM_Pilot.round((float)(this.random(1.0f) * (float)(count - 1)));
            this.record = this.scheme.getRow(this.record_number);
            this.participant = this.record.getInt("Participant");
            this.uuid = this.record.getString("UUID");
            RCM_Pilot.println((int)this.participant);
            RCM_Pilot.println((String)this.uuid);
        } else {
            this.popup.addText("Error: No trials left to run on this machine.");
            this.popup.setIsActive(true);
            this.finished = true;
        }
        this.out_file = "test_records.csv";
        this.writer = this.initializeWriter(this.out_file);
        StringList images = new StringList();
        images.append("sinusoidal.png");
        images.append("brain.png");
        images.append("elevation.png");
        this.option = 2;
        this.data = this.loadImage(images.get(this.option));
        this.complex = this.loadImage(images.get(this.option));
        this.data.loadPixels();
        this.complex.resize(this.width, 0);
        this.complex.loadPixels();
        this.factor = PApplet.parseFloat((int)this.width) / (float)this.data.width;
        this.img = this.createImage(this.width, this.width, 1);
        this.img.loadPixels();
        this.cmap_image = new StringList();
        this.cmap_image.append("jet_map.png");
        this.cmap_image.append("gray_map.png");
        this.cmap_image.append("default_map.png");
        this.cmap_image.append("kindlmann_map.png");
        this.block = -1;
        this.color_block = 0;
        this.data_mode_index = 0;
        this.data_mode = 0;
        this.question = 0;
        if (count > 0) {
            this.next();
        }
        this.seg_positions = new ArrayList();
        this.current = null;
        this.t_last_click = this.millis();
        this.stroke(10);
        this.noFill();
        this.ellipseMode(2);
    }

    public void next() {
        if (!this.submit.active) {
            return;
        }
        if (this.block == -1) {
            this.nextBlock();
        } else if (++this.question > 2) {
            this.nextDataSet();
        }
    }

    public void nextBlock() {
        String current_cmap = null;
        switch (++this.block) {
            case 0: {
                current_cmap = "block_0 cmap";
                break;
            }
            case 1: {
                current_cmap = "block_1 cmap";
                break;
            }
            case 2: {
                current_cmap = "block_2 cmap";
                break;
            }
            case 3: {
                current_cmap = "block_3 cmap";
                break;
            }
            default: {
                this.finish();
            }
        }
        if (current_cmap != null && this.block < 4) {
            this.color_block = this.blockIndex(this.record.getString(current_cmap));
            this.map = this.loadImage(this.cmap_image.get(this.color_block));
            this.map.loadPixels();
            this.data_mode_index = -1;
            this.nextDataSet(false);
        }
    }

    public void nextDataSet() {
        this.nextDataSet(true);
    }

    public void nextDataSet(boolean write) {
        if (write) {
            this.writeRecord();
        }
        if (++this.data_mode_index > 2) {
            this.nextBlock();
        } else {
            String current;
            int[][] permutations = new int[][]{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 1}};
            switch (this.block) {
                default: {
                    current = "block_0 dPmt";
                    break;
                }
                case 1: {
                    current = "block_1 dPmt";
                    break;
                }
                case 2: {
                    current = "block_2 dPmt";
                    break;
                }
                case 3: {
                    current = "block_3 dPmt";
                }
            }
            this.data_mode = permutations[this.record.getInt(current) - 1][this.data_mode_index];
            this.updateDisplay();
            this.question = 1;
        }
    }

    public void finish() {
        this.scheme.removeRow(this.record_number);
        this.saveTable(this.scheme, "run_scheme.csv");
        this.popup.clearText();
        this.popup.addText("\nDO NOT CLOSE THIS WINDOW UNTIL YOU ARE TOLD IT IS OK TO DO SO.\n\nYour UID: " + this.uuid + "\n\nYou will need this UID to complete your exit survey");
        this.popup.setIsActive(true);
        this.finished = true;
    }

    public int blockIndex(String s) {
        int i;
        switch (s) {
            case "D": {
                i = 2;
                break;
            }
            case "J": {
                i = 0;
                break;
            }
            case "G": {
                i = 1;
                break;
            }
            case "M": {
                i = 3;
                break;
            }
            default: {
                i = -1;
            }
        }
        return i;
    }

    public void updateDisplay() {
        this.popup.clearText();
        this.popup.setIsActive(false);
        if (this.data_mode < 3) {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    float v = this.data_mode == 1 ? PApplet.parseFloat((int)x) / (float)this.img.width : RCM_Pilot.max((float)(1.0f - RCM_Pilot.min((float)RCM_Pilot.sqrt((float)(RCM_Pilot.sq((float)(2.0f * PApplet.parseFloat((int)x) / (float)this.img.width - 1.0f)) + RCM_Pilot.sq((float)(2.0f * PApplet.parseFloat((int)y) / (float)this.img.width - 1.0f)))), (float)1.0f)), (float)0.0f);
                    this.img.pixels[y * this.img.height + x] = this.map.pixels[RCM_Pilot.round((float)(v * 255.0f))];
                    ++x;
                }
                ++y;
            }
            this.img.updatePixels();
        } else if (this.complex.width != this.img.width) {
            this.popup.addText("Error with Complex Example: source image is wrong size.");
            this.popup.setIsActive(true);
        } else {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    int v = this.complex.pixels[y * this.img.height + x] >> 16 & 0xFF;
                    this.img.pixels[y * this.img.height + x] = this.map.pixels[v];
                    ++x;
                }
                ++y;
            }
            this.img.updatePixels();
        }
    }

    public void draw() {
        this.background(100);
        this.image(this.img, 0.0f, 0.0f);
        if (this.question == 2) {
            this.stroke(this.color_block == 1 ? this.color(255, 0, 0) : this.color(10));
            this.noFill();
            for (Delimeter p : this.seg_positions) {
                this.strokeWeight(p.interacting(this.mouseX, this.mouseY, this.img, this.data, this.factor) && this.mouseY < this.width ? 1.5f : 1.0f);
                p.draw(this.img, this.data, this.factor);
            }
            if (this.data_mode == 1) {
                int ix = 0;
                int iy = 0;
                int iw = this.img.width;
                int ih = this.img.height / 2;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
            } else if (this.data_mode == 2) {
                int ix = 0;
                int iy = 0;
                int iw = this.img.width / 2;
                int ih = this.img.height;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
            } else if (this.option == 0) {
                int ix = 0;
                int iy = 0;
                int iw = this.img.width;
                int ih = 1 * this.img.height / 8;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
                ix = 0;
                iy = 7 * this.img.height / 9;
                iw = this.img.width;
                ih = this.img.height - iy;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
            } else if (this.option == 1) {
                int ix = 0;
                int iy = 0;
                int iw = this.img.width / 2;
                int ih = this.img.height / 2;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
            } else if (this.option == 2) {
                int ix = this.img.width / 6;
                int iy = 0;
                int iw = 4 * this.img.width / 6;
                int ih = this.img.height / 3;
                this.copy(this.img, ix, iy, iw, ih, ix, iy, iw, ih);
            }
        }
        this.fill(255);
        this.textSize(13.0f);
        if (this.question == 1) {
            this.text(this.Q1, 50.0f, this.height - 130, this.width - 100, 40.0f);
            this.input.draw(50.0f, (float)(this.height - 75));
        } else if (this.question == 2) {
            this.text(this.Q2, 50.0f, this.height - 130, this.width - 100, 90.0f);
        }
        boolean disabled = this.finished;
        disabled |= this.question == 1 && this.input.getText().length() <= 0;
        this.submit.active = !(disabled |= this.question == 2 && PApplet.parseInt((String)this.input.getText()) > 1 && this.seg_positions.size() < 1);
        this.submit.interacting(this.mouseX, this.mouseY);
        this.submit.draw();
        this.popup.draw();
    }

    public void mousePressed() {
        int t_click = this.millis();
        if (!this.submit.clicked(this.mouseX, this.mouseY) && this.mouseY < this.width && this.question == 2) {
            for (Delimeter p : this.seg_positions) {
                if (!p.interacting(this.mouseX, this.mouseY, this.img, this.data, this.factor)) continue;
                this.current = p;
            }
            if (this.current != null && t_click - this.t_last_click < this.threshold) {
                this.seg_positions.remove(this.current);
                this.current = null;
            } else if (this.current == null) {
                this.current = new Delimeter(this.mouseX, this.mouseY, this.data_mode, this.img, this.data, this.factor);
                this.current.dragging = true;
                this.seg_positions.add(this.current);
            } else {
                this.current.dragging = true;
            }
        }
        this.t_last_click = t_click;
    }

    public void keyPressed() {
        switch (this.key) {
            case '\n': 
            case '\r': {
                this.next();
                break;
            }
            case '\b': 
            case '\u007f': {
                if (this.question != 1) break;
                this.input.keyPressed();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.question != 1 || this.input.getText().length() >= 6) break;
                this.input.keyPressed();
                break;
            }
            case 's': {
                this.img.save("screen" + RCM_Pilot.str((int)(this.block * 10 + this.data_mode)) + ".png");
            }
        }
    }

    public void mouseReleased() {
        if (this.submit.released()) {
            this.next();
        } else if (this.current != null) {
            this.current.dragging = false;
            this.current = null;
        }
    }

    public void stop() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                RCM_Pilot.println((String)"Error while closing the writer");
                e.printStackTrace();
            }
        }
    }

    public void writeRecord() {
        if (this.writer != null) {
            try {
                StringBuilder new_record = new StringBuilder();
                new_record.append(RCM_Pilot.str((int)this.participant));
                new_record.append(", ");
                new_record.append(this.uuid);
                new_record.append(", ");
                new_record.append(this.block);
                new_record.append(", ");
                switch (this.color_block) {
                    case 0: {
                        new_record.append("jet");
                        break;
                    }
                    case 1: {
                        new_record.append("gray");
                        break;
                    }
                    case 2: {
                        new_record.append("default");
                        break;
                    }
                    case 3: {
                        new_record.append("kindlmann");
                    }
                }
                new_record.append(", ");
                switch (this.data_mode) {
                    case 1: {
                        new_record.append("1D");
                        break;
                    }
                    case 2: {
                        new_record.append("2D");
                        break;
                    }
                    case 3: {
                        new_record.append("Complex");
                    }
                }
                new_record.append(", ");
                new_record.append(this.input.getText());
                new_record.append(", ");
                for (Delimeter p : this.seg_positions) {
                    new_record.append(RCM_Pilot.str((float)p.getNormalizedValue(this.img)));
                    new_record.append(", ");
                }
                this.writer.write(new_record.toString());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException e) {
                RCM_Pilot.println((String)"Error on Write");
                e.printStackTrace();
            }
        }
        this.input.setText("");
        this.seg_positions.clear();
    }

    public BufferedWriter initializeWriter(String file_name) {
        File f = new File(this.sketchPath(file_name));
        boolean init = !f.isFile();
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f, true));
            if (init) {
                out.write("participant, UUID, block, cmap, data, num_color_categories, delimeter_list");
                out.newLine();
                out.flush();
            }
        }
        catch (IOException e) {
            RCM_Pilot.println((String)"Error: Bad File Write");
            e.printStackTrace();
        }
        return out;
    }

    public void settings() {
        this.size(768, 918);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "RCM_Pilot"};
        if (passedArgs != null) {
            PApplet.main((String[])RCM_Pilot.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button {
        String text;
        float x;
        float y;
        int textsize;
        boolean rollover;
        boolean mouseDown;
        boolean active;
        int rest;
        int highlight;
        int pressed;
        int rest_bg;
        int highlight_bg;
        int pressed_bg;
        int startTimer;
        int timerLength;

        Button(float x0, float y0, String s) {
            this.text = s;
            this.x = x0;
            this.y = y0;
            this.textsize = 14;
            this.rollover = false;
            this.mouseDown = false;
            this.active = true;
            this.rest = RCM_Pilot.this.color(60);
            this.rest_bg = RCM_Pilot.this.color(240);
            this.highlight = RCM_Pilot.this.color(60);
            this.highlight_bg = RCM_Pilot.this.color(230);
            this.pressed = RCM_Pilot.this.color(240);
            this.pressed_bg = RCM_Pilot.this.color(180);
            this.startTimer = 0;
            this.timerLength = 0;
        }

        public void setTextSize(int s) {
            this.textsize = s;
        }

        public void setActive(boolean b) {
            this.active = b;
        }

        public void timedHighlight(int ms) {
            this.startTimer = RCM_Pilot.this.millis();
            this.timerLength = ms;
        }

        public void draw() {
            int elapsed = RCM_Pilot.this.millis() - this.startTimer;
            int alpha = 75;
            if (!this.active) {
                RCM_Pilot.this.fill(this.rest_bg, alpha);
            } else if (this.mouseDown && this.rollover) {
                RCM_Pilot.this.fill(this.pressed_bg);
            } else if (this.rollover) {
                RCM_Pilot.this.fill(this.highlight_bg);
            } else if (elapsed < this.timerLength) {
                float f = PApplet.parseFloat((int)elapsed) / (float)this.timerLength;
                alpha = 155 + PApplet.parseInt((float)(100.0f * RCM_Pilot.abs((float)(f - 0.5f)) / 0.5f)) << 24;
                RCM_Pilot.this.fill(this.highlight_bg, alpha);
            } else {
                RCM_Pilot.this.fill(this.rest_bg);
            }
            RCM_Pilot.this.stroke(RCM_Pilot.this.color(255), alpha);
            RCM_Pilot.this.rect(this.x, this.y, RCM_Pilot.this.textWidth(this.text) + 20.0f, RCM_Pilot.this.textAscent() + RCM_Pilot.this.textDescent() + 10.0f, 8.0f);
            if (!this.active) {
                RCM_Pilot.this.fill(this.rest, alpha);
            } else if (this.mouseDown && this.rollover) {
                RCM_Pilot.this.fill(this.pressed);
            } else if (this.rollover) {
                RCM_Pilot.this.fill(this.highlight);
            } else {
                RCM_Pilot.this.fill(this.rest);
            }
            RCM_Pilot.this.noStroke();
            RCM_Pilot.this.textAlign(37, 101);
            RCM_Pilot.this.textSize(this.textsize);
            RCM_Pilot.this.text(this.text, this.x + 10.0f, this.y + 5.0f);
        }

        public boolean intersected(float mx, float my) {
            RCM_Pilot.this.textSize(this.textsize);
            return mx > this.x && mx < this.x + RCM_Pilot.this.textWidth(this.text) + 20.0f && my > this.y && my < this.y + RCM_Pilot.this.textAscent() + RCM_Pilot.this.textDescent() + 12.0f;
        }

        public boolean interacting(int mx, int my) {
            this.rollover = this.active && this.intersected(mx, my);
            return this.rollover;
        }

        public boolean clicked(int mx, int my) {
            this.mouseDown = this.active && this.intersected(mx, my);
            return this.mouseDown;
        }

        public boolean released() {
            boolean tmp = this.mouseDown && this.rollover;
            this.mouseDown = false;
            return tmp;
        }
    }

    class Delimeter {
        int mode;
        float value;
        float epsilon = 3.0f;
        boolean dragging = false;
        BlobDetection detector;
        float factor;

        Delimeter(int mouse_x) {
            this.mode = 1;
            this.value = mouse_x;
            this.detector = null;
        }

        Delimeter(int mouse_x, int mouse_y, int m, PImage img, PImage data, float factor) {
            this.mode = m;
            if (this.mode == 3) {
                this.value = this.f_mode3(mouse_x, mouse_y, data, factor);
                this.detector = new BlobDetection(data.width, data.height);
                this.detector.setThreshold(this.value / 255.0f);
                this.detector.computeBlobs(data.pixels);
            } else {
                this.value = this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x);
            }
        }

        public boolean interacting(int mouse_x, int mouse_y, PImage img, PImage data, float factor) {
            if (this.dragging) {
                if (this.mode == 3) {
                    this.value = this.f_mode3(mouse_x, mouse_y, data, factor);
                    this.detector.setThreshold(this.value / 255.0f);
                    this.detector.computeBlobs(data.pixels);
                } else {
                    this.value = this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x);
                }
                return true;
            }
            float c_value = this.mode == 3 ? this.f_mode3(mouse_x, mouse_y, data, factor) : (this.mode == 2 ? this.f_mode2(mouse_x, mouse_y, img.width, img.height) : this.f_mode1(mouse_x));
            return RCM_Pilot.abs((float)(this.value - c_value)) < this.epsilon;
        }

        public float getNormalizedValue(PImage img) {
            if (this.mode == 3) {
                return this.value / 255.0f;
            }
            if (this.mode == 2) {
                return this.value / (float)(img.width / 2);
            }
            return this.value / (float)img.width;
        }

        public void draw(PImage img, PImage data, float factor) {
            if (this.mode == 3) {
                int n = 0;
                while (n < this.detector.getBlobNb()) {
                    Blob b = this.detector.getBlob(n);
                    if (b != null) {
                        int m = 0;
                        while (m < b.getEdgeNb()) {
                            EdgeVertex eA = b.getEdgeVertexA(m);
                            EdgeVertex eB = b.getEdgeVertexB(m);
                            if (eA != null && eB != null) {
                                RCM_Pilot.this.line(eA.x * (float)data.width * factor, eA.y * (float)data.height * factor, eB.x * (float)data.width * factor, eB.y * (float)data.height * factor);
                            }
                            ++m;
                        }
                    }
                    ++n;
                }
            } else if (this.mode == 2) {
                RCM_Pilot.this.ellipse((float)img.width / 2.0f, (float)img.height / 2.0f, this.value, this.value);
            } else {
                RCM_Pilot.this.line(this.value, 0.0f, this.value, img.height - 1);
            }
        }

        private float f_mode1(float x) {
            return x;
        }

        private float f_mode1(float x, float y, float w, float h) {
            return x;
        }

        private float f_mode2(float x, float y, float w, float h) {
            float half_height = h / 2.0f;
            return RCM_Pilot.min((float)RCM_Pilot.sqrt((float)(RCM_Pilot.sq((float)(w / 2.0f - x)) + RCM_Pilot.sq((float)(half_height - y)))), (float)half_height);
        }

        private float f_mode3(int x, int y, PImage data, float factor) {
            float tmp = (float)x / factor;
            int i0 = RCM_Pilot.floor((float)tmp);
            int i1 = RCM_Pilot.ceil((float)tmp);
            float ax = tmp - (float)i0;
            tmp = (float)y / factor;
            int j0 = RCM_Pilot.floor((float)tmp);
            int j1 = RCM_Pilot.ceil((float)tmp);
            float ay = tmp - (float)j0;
            float v00 = data.pixels[this.getIndex(RCM_Pilot.constrain((int)i0, (int)0, (int)(data.width - 1)), RCM_Pilot.constrain((int)j0, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v01 = data.pixels[this.getIndex(RCM_Pilot.constrain((int)i0, (int)0, (int)(data.width - 1)), RCM_Pilot.constrain((int)j1, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v10 = data.pixels[this.getIndex(RCM_Pilot.constrain((int)i1, (int)0, (int)(data.width - 1)), RCM_Pilot.constrain((int)j0, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v11 = data.pixels[this.getIndex(RCM_Pilot.constrain((int)i1, (int)0, (int)(data.width - 1)), RCM_Pilot.constrain((int)j1, (int)0, (int)(data.height - 1)), data.width)] >> 16 & 0xFF;
            float v0x = RCM_Pilot.lerp((float)v00, (float)v10, (float)ax);
            float v1x = RCM_Pilot.lerp((float)v01, (float)v11, (float)ax);
            float v = RCM_Pilot.lerp((float)v0x, (float)v1x, (float)ay);
            return v;
        }

        private int getIndex(int x, int y, int N) {
            int idx = y * N + x;
            return idx;
        }
    }
}

