/*
 * Decompiled with CFR 0.152.
 */
package blobDetection;

import blobDetection.BlobDetection;
import blobDetection.BlobTriangle;
import blobDetection.EdgeVertex;

public class Blob {
    public BlobDetection parent;
    public int id;
    public float x;
    public float y;
    public float w;
    public float h;
    public float xMin;
    public float xMax;
    public float yMin;
    public float yMax;
    public int xGridMin;
    public int yGridMin;
    public int xGridMax;
    public int yGridMax;
    public static int MAX_NBLINE = 4000;
    public int[] line;
    public int nbLine;
    public static int MAX_NBTRIANGLE = 500;
    public BlobTriangle[] triangle;
    public int nbTriangle;
    public boolean isFirstTrVisit;

    public Blob(BlobDetection parent) {
        this.parent = parent;
        this.line = new int[MAX_NBLINE];
        this.nbLine = 0;
    }

    public void allocateTriangles() {
        this.triangle = new BlobTriangle[MAX_NBTRIANGLE];
        int i = 0;
        while (i < MAX_NBTRIANGLE) {
            this.triangle[i] = new BlobTriangle();
            ++i;
        }
    }

    public EdgeVertex getEdgeVertexA(int iEdge) {
        if (iEdge * 2 < this.parent.nbLineToDraw * 2) {
            return this.parent.getEdgeVertex(this.line[iEdge * 2]);
        }
        return null;
    }

    public EdgeVertex getEdgeVertexB(int iEdge) {
        if (iEdge * 2 + 1 < this.parent.nbLineToDraw * 2) {
            return this.parent.getEdgeVertex(this.line[iEdge * 2 + 1]);
        }
        return null;
    }

    public int getEdgeNb() {
        return this.nbLine;
    }

    public int getTriangleNb() {
        return this.nbTriangle;
    }

    public BlobTriangle getTriangle(int iTriangle) {
        BlobTriangle bTri = null;
        if (iTriangle < this.nbTriangle) {
            bTri = this.triangle[iTriangle];
        }
        return bTri;
    }

    public EdgeVertex getTriangleVertexA(BlobTriangle bTri) {
        EdgeVertex evA = null;
        if (bTri != null) {
            evA = this.parent.edgeVrt[bTri.iA];
        }
        return evA;
    }

    public EdgeVertex getTriangleVertexB(BlobTriangle bTri) {
        EdgeVertex evB = null;
        if (bTri != null) {
            evB = this.parent.edgeVrt[bTri.iB];
        }
        return evB;
    }

    public EdgeVertex getTriangleVertexC(BlobTriangle bTri) {
        EdgeVertex evC = null;
        if (bTri != null) {
            evC = this.parent.edgeVrt[bTri.iC];
        }
        return evC;
    }

    public void update() {
        this.w = this.xMax - this.xMin;
        this.h = this.yMax - this.yMin;
        this.x = 0.5f * (this.xMax + this.xMin);
        this.y = 0.5f * (this.yMax + this.yMin);
        this.nbLine /= 2;
    }
}

