/*
 * Decompiled with CFR 0.152.
 */
package blobDetection;

import blobDetection.EdgeVertex;
import blobDetection.Metaballs2D;

public class EdgeDetection
extends Metaballs2D {
    public static final byte C_R = 1;
    public static final byte C_G = 2;
    public static final byte C_B = 4;
    public int imgWidth;
    public int imgHeight;
    public int[] pixels;
    public boolean posDiscrimination;
    protected float m_coeff = 765.0f;

    public EdgeDetection(int imgWidth, int imgHeight) {
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        super.init(imgWidth, imgHeight);
        this.posDiscrimination = false;
    }

    public void setPosDiscrimination(boolean is) {
        this.posDiscrimination = is;
    }

    public void setThreshold(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.setIsovalue(value * this.m_coeff);
    }

    public void setImage(int[] pixels) {
        this.pixels = pixels;
    }

    public void computeEdges(int[] pixels) {
        this.setImage(pixels);
        this.computeMesh();
    }

    public void computeIsovalue() {
        float coeff = 0.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        int y = 0;
        while (y < this.imgHeight) {
            int x = 0;
            while (x < this.imgWidth) {
                int offset = x + this.imgWidth * y;
                int pixel = this.pixels[offset];
                r = (pixel & 0xFF0000) >> 16;
                g = (pixel & 0xFF00) >> 8;
                b = pixel & 0xFF;
                this.gridValue[offset] = r + g + b;
                ++x;
            }
            ++y;
        }
    }

    protected int getSquareIndex(int x, int y) {
        int squareIndex = 0;
        int offy = this.resx * y;
        int offy1 = this.resx * (y + 1);
        if (!this.posDiscrimination) {
            if (this.gridValue[x + offy] < this.isovalue) {
                squareIndex |= 1;
            }
            if (this.gridValue[x + 1 + offy] < this.isovalue) {
                squareIndex |= 2;
            }
            if (this.gridValue[x + 1 + offy1] < this.isovalue) {
                squareIndex |= 4;
            }
            if (this.gridValue[x + offy1] < this.isovalue) {
                squareIndex |= 8;
            }
        } else {
            if (this.gridValue[x + offy] > this.isovalue) {
                squareIndex |= 1;
            }
            if (this.gridValue[x + 1 + offy] > this.isovalue) {
                squareIndex |= 2;
            }
            if (this.gridValue[x + 1 + offy1] > this.isovalue) {
                squareIndex |= 4;
            }
            if (this.gridValue[x + offy1] > this.isovalue) {
                squareIndex |= 8;
            }
        }
        return squareIndex;
    }

    public EdgeVertex getEdgeVertex(int index) {
        return this.edgeVrt[index];
    }
}

