/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.move;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class ZoomPanState
implements Cloneable {
    PApplet aContext;
    PGraphics pGraphics;
    AffineTransform trans;
    AffineTransform iTrans;
    double zoomScaleX;
    double zoomScaleY;
    PVector panOffset;

    ZoomPanState(PApplet aContext, PGraphics pGraphics) {
        this.aContext = aContext;
        this.pGraphics = pGraphics;
        this.zoomScaleX = 1.0;
        this.zoomScaleY = 1.0;
        this.panOffset = new PVector();
        this.trans = new AffineTransform();
        this.iTrans = new AffineTransform();
    }

    public PVector getDispToCoord(PVector p) {
        Point2D.Float pCoord = new Point2D.Float();
        Point2D.Float pDisp = new Point2D.Float(p.x, p.y);
        this.iTrans.transform(pDisp, pCoord);
        return new PVector(pCoord.x, pCoord.y);
    }

    public PVector getCoordToDisp(PVector p) {
        Point2D.Float pDisp = new Point2D.Float();
        Point2D.Float pCoord = new Point2D.Float(p.x, p.y);
        this.trans.transform(pCoord, pDisp);
        return new PVector(pDisp.x, pDisp.y);
    }

    public PVector getCoordToDisp(double x, double y) {
        Point2D.Double pDisp = new Point2D.Double();
        Point2D.Double pCoord = new Point2D.Double(x, y);
        this.trans.transform(pCoord, pDisp);
        return new PVector((float)pDisp.x, (float)pDisp.y);
    }

    public void transform() {
        this.getGraphics().translate((float)this.trans.getTranslateX(), (float)this.trans.getTranslateY());
        this.getGraphics().scale((float)this.trans.getScaleX(), (float)this.trans.getScaleY());
    }

    public void transform(PGraphics offScreenBuffer) {
        offScreenBuffer.translate((float)this.trans.getTranslateX(), (float)this.trans.getTranslateY());
        offScreenBuffer.scale((float)this.trans.getScaleX(), (float)this.trans.getScaleY());
    }

    public double getZoomScale() {
        return this.zoomScaleX;
    }

    public double getZoomScaleX() {
        return this.zoomScaleX;
    }

    public double getZoomScaleY() {
        return this.zoomScaleX;
    }

    public PVector getPanOffset() {
        return new PVector(this.panOffset.x, this.panOffset.y);
    }

    PGraphics getGraphics() {
        if (this.pGraphics == null) {
            return this.aContext.g;
        }
        return this.pGraphics;
    }

    public Object clone() {
        ZoomPanState zoomPanState = new ZoomPanState(this.aContext, this.pGraphics);
        zoomPanState.zoomScaleX = this.zoomScaleX;
        zoomPanState.zoomScaleY = this.zoomScaleY;
        zoomPanState.panOffset = this.panOffset;
        zoomPanState.trans = new AffineTransform(this.trans);
        zoomPanState.iTrans = new AffineTransform(this.iTrans);
        return zoomPanState;
    }
}

