/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gicentre.utils.move.ZoomPan;
import org.gicentre.utils.network.Edge;
import org.gicentre.utils.network.Node;
import org.gicentre.utils.network.traer.animation.Smoother3D;
import org.gicentre.utils.network.traer.physics.Attraction;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.Spring;
import org.gicentre.utils.network.traer.physics.Vector3D;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleViewer<N extends Node, E extends Edge> {
    private PApplet parent;
    private ParticleSystem physics;
    private Smoother3D centroid;
    private int width;
    private int height;
    private boolean isPaused;
    private HashMap<N, Particle> nodes;
    private HashMap<E, Spring> edges;
    private HashMap<N, Particle> stakes;
    private HashMap<Particle, Spring> tethers;
    private ZoomPan zoomer;
    private N selectedNode;
    public static final float EDGE_STRENGTH = 1.0f;
    public static final float SPRING_STRENGTH = 0.5f;
    public static final float DAMPING = 0.1f;

    public ParticleViewer(PApplet parent, int width, int height) {
        this.parent = parent;
        this.zoomer = new ZoomPan(parent);
        this.zoomer.setMouseMask(16);
        this.centroid = new Smoother3D(0.9f);
        this.physics = new ParticleSystem(0.0f, 0.75f);
        this.nodes = new HashMap();
        this.edges = new HashMap();
        this.stakes = new HashMap();
        this.tethers = new HashMap();
        this.width = width;
        this.height = height;
        this.isPaused = false;
        this.selectedNode = null;
    }

    public void draw() {
        this.parent.pushStyle();
        this.parent.pushMatrix();
        this.zoomer.transform();
        this.updateCentroid();
        this.centroid.tick();
        this.parent.translate((float)(this.width / 2), (float)(this.height / 2));
        this.parent.scale(this.centroid.getZ());
        this.parent.translate(-this.centroid.getX(), -this.centroid.getY());
        if (!this.isPaused) {
            this.updateParticles();
        }
        if (this.selectedNode != null) {
            Particle particle = this.nodes.get(this.selectedNode);
            particle.makeFixed();
            float mX = (this.zoomer.getMouseCoord().x - (float)(this.width / 2)) / this.centroid.getZ() + this.centroid.getX();
            float mY = (this.zoomer.getMouseCoord().y - (float)(this.height / 2)) / this.centroid.getZ() + this.centroid.getY();
            particle.position().set(mX, mY, 0.0f);
        }
        if (this.parent.g.strokeWeight > 0.0f) {
            this.parent.stroke(0, 180.0f);
            this.parent.noFill();
            for (Map.Entry<E, Spring> entry : this.edges.entrySet()) {
                Spring spring = entry.getValue();
                Vector3D p1 = spring.getOneEnd().position();
                Vector3D p2 = spring.getTheOtherEnd().position();
                ((Edge)entry.getKey()).draw(this.parent, p1.x(), p1.y(), p2.x(), p2.y());
            }
        }
        this.parent.noStroke();
        this.parent.fill(120.0f, 50.0f, 50.0f, 180.0f);
        for (Map.Entry<N, Particle> entry : this.nodes.entrySet()) {
            Vector3D pos = entry.getValue().position();
            ((Node)entry.getKey()).draw(this.parent, pos.x(), pos.y());
        }
        this.parent.popMatrix();
        this.parent.popStyle();
    }

    public void updateParticles() {
        this.physics.tick(0.3f);
    }

    public void setDrag(float drag) {
        this.physics.setDrag(drag);
    }

    public boolean addForce(N node1, N node2, float force) {
        return this.addForce(node1, node2, force, 0.1f);
    }

    public boolean addForce(N node1, N node2, float force, float minDistance) {
        Particle p1 = this.nodes.get(node1);
        if (p1 == null) {
            return false;
        }
        Particle p2 = this.nodes.get(node2);
        if (p2 == null) {
            return false;
        }
        int i = 0;
        while (i < this.physics.getNumAttractions()) {
            Attraction a = this.physics.getAttraction(i);
            if (a.getOneEnd() == p1 && a.getTheOtherEnd() == p2 || a.getOneEnd() == p2 && a.getTheOtherEnd() == p1) {
                this.physics.removeAttraction(a);
                break;
            }
            ++i;
        }
        this.physics.makeAttraction(p1, p2, force, minDistance);
        return false;
    }

    public boolean addSpring(N node1, N node2, float length) {
        return this.addSpring(node1, node2, length, 0.5f);
    }

    public boolean addSpring(N node1, N node2, float length, float strength) {
        Particle p1 = this.nodes.get(node1);
        if (p1 == null) {
            return false;
        }
        Particle p2 = this.nodes.get(node2);
        if (p2 == null) {
            return false;
        }
        int i = 0;
        while (i < this.physics.getNumSprings()) {
            Spring spring = this.physics.getSpring(i);
            if ((spring.getOneEnd() == p1 && spring.getTheOtherEnd() == p2 || spring.getOneEnd() == p2 && spring.getTheOtherEnd() == p1) && spring.strength() != 1.0f) {
                this.physics.removeSpring(spring);
                break;
            }
            ++i;
        }
        this.physics.makeSpring(p1, p2, strength, 0.1f, length);
        return false;
    }

    public boolean tether(N node, float strength) {
        Spring tether;
        Particle p1 = this.nodes.get(node);
        if (p1 == null) {
            return false;
        }
        Particle stake = this.stakes.get(node);
        if (stake == null) {
            stake = this.physics.makeParticle(1.0f, ((Node)node).getLocation().x, ((Node)node).getLocation().y, 0.0f);
            stake.makeFixed();
            this.stakes.put(node, stake);
        }
        if ((tether = this.tethers.get(stake)) == null) {
            tether = this.physics.makeSpring(stake, p1, strength, 0.1f, Float.MIN_VALUE);
            this.tethers.put(stake, tether);
        } else {
            tether.setStrength(strength);
        }
        return true;
    }

    public Particle getParticle(N node) {
        return this.nodes.get(node);
    }

    public N getSelectedNode() {
        return this.selectedNode;
    }

    public N getNearest(float x, float y) {
        return this.getNearest(x, y, -1.0f);
    }

    public N getNearest(float x, float y, float radius) {
        float mX = (x - (float)(this.width / 2)) / this.centroid.getZ() + this.centroid.getX();
        float mY = (y - (float)(this.height / 2)) / this.centroid.getZ() + this.centroid.getY();
        float nearestDSq = radius * radius;
        Node nearestNode = null;
        for (Map.Entry<N, Particle> row : this.nodes.entrySet()) {
            float py;
            Node node = (Node)row.getKey();
            Particle p = row.getValue();
            float px = p.position().x();
            float dSq = (px - mX) * (px - mX) + ((py = p.position().y()) - mY) * (py - mY);
            if (!(dSq < nearestDSq)) continue;
            nearestDSq = dSq;
            nearestNode = node;
        }
        return (N)nearestNode;
    }

    public void addNode(N node) {
        Particle p = this.physics.makeParticle(1.0f, ((Node)node).getLocation().x, ((Node)node).getLocation().y, 0.0f);
        this.nodes.put(node, p);
    }

    public boolean addEdge(E edge) {
        Particle p1 = this.nodes.get(((Edge)edge).getNode1());
        if (p1 == null) {
            System.err.println("Warning: Node1 not found when creating edge.");
            return false;
        }
        Particle p2 = this.nodes.get(((Edge)edge).getNode2());
        if (p2 == null) {
            System.err.println("Warning: Node2 not found when creating edge.");
            return false;
        }
        if (!this.edges.containsKey(edge)) {
            float x1 = p1.position().x();
            float y1 = p1.position().y();
            float x2 = p2.position().x();
            float y2 = p2.position().y();
            this.edges.put(edge, this.physics.makeSpring(p1, p2, 1.0f, 0.1f, (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2))));
        }
        return true;
    }

    public boolean addEdge(E edge, float distance) {
        Particle p1 = this.nodes.get(((Edge)edge).getNode1());
        if (p1 == null) {
            System.err.println("Warning: Node1 not found when creating edge.");
            return false;
        }
        Particle p2 = this.nodes.get(((Edge)edge).getNode2());
        if (p2 == null) {
            System.err.println("Warning: Node2 not found when creating edge.");
            return false;
        }
        if (!this.edges.containsKey(edge)) {
            this.edges.put(edge, this.physics.makeSpring(p1, p2, 1.0f, 0.1f, distance));
        }
        return true;
    }

    public void spaceNodes() {
        ArrayList<Particle> pList = new ArrayList<Particle>(this.nodes.values());
        int i = 0;
        while (i < pList.size()) {
            int j = 0;
            while (j < pList.size()) {
                if (i > j) {
                    Particle p1 = pList.get(i);
                    Particle p2 = pList.get(j);
                    for (Spring spring : this.edges.values()) {
                        if (spring.getOneEnd() == p1 && spring.getTheOtherEnd() == p2 || spring.getOneEnd() == p2 && spring.getTheOtherEnd() == p1) continue;
                        this.physics.makeAttraction(p1, p2, -1000.0f, 0.1f);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void selectNearestWithMouse() {
        if (!this.zoomer.isMouseCaptured()) {
            float mX = (this.zoomer.getMouseCoord().x - (float)(this.width / 2)) / this.centroid.getZ() + this.centroid.getX();
            float mY = (this.zoomer.getMouseCoord().y - (float)(this.height / 2)) / this.centroid.getZ() + this.centroid.getY();
            if (this.selectedNode == null) {
                float nearestDSq = Float.MAX_VALUE;
                for (Map.Entry<N, Particle> row : this.nodes.entrySet()) {
                    float py;
                    Node node = (Node)row.getKey();
                    Particle p = row.getValue();
                    float px = p.position().x();
                    float dSq = (px - mX) * (px - mX) + ((py = p.position().y()) - mY) * (py - mY);
                    if (!(dSq < nearestDSq)) continue;
                    nearestDSq = dSq;
                    this.selectedNode = node;
                }
            }
        }
    }

    public void dropSelected() {
        if (!this.zoomer.isMouseCaptured() && this.selectedNode != null) {
            this.nodes.get(this.selectedNode).makeFree();
            this.selectedNode = null;
        }
    }

    public void resetView() {
        this.zoomer.reset();
    }

    private void updateCentroid() {
        float xMax = Float.NEGATIVE_INFINITY;
        float xMin = Float.POSITIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.physics.getNumParticles()) {
            Particle p = this.physics.getParticle(i);
            xMax = Math.max(xMax, p.position().x());
            xMin = Math.min(xMin, p.position().x());
            yMin = Math.min(yMin, p.position().y());
            yMax = Math.max(yMax, p.position().y());
            ++i;
        }
        float xRange = xMax - xMin;
        float yRange = yMax - yMin;
        if (xRange == 0.0f && yRange == 0.0f) {
            xRange = Math.max(1.0f, xMax);
            yRange = Math.max(1.0f, yMax);
        }
        float zScale = (float)Math.min((double)this.height / ((double)yRange * 1.2), (double)this.width / ((double)xRange * 1.2));
        this.centroid.setTarget(xMin + 0.5f * xRange, yMin + 0.5f * yRange, zScale);
    }
}

