/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.animation;

import java.util.Vector;
import org.gicentre.utils.network.traer.animation.Smoother;
import org.gicentre.utils.network.traer.animation.Smoother2D;
import org.gicentre.utils.network.traer.animation.Smoother3D;
import org.gicentre.utils.network.traer.animation.Tickable;

public class Animator
implements Tickable {
    private Vector<Tickable> smoothers;
    private float smoothness;

    public Animator(float smoothness) {
        this.smoothness = smoothness;
        this.smoothers = new Vector();
    }

    public final Smoother makeSmoother() {
        Smoother s = new Smoother(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final Smoother2D make2DSmoother() {
        Smoother2D s = new Smoother2D(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final Smoother3D make3DSmoother() {
        Smoother3D s = new Smoother3D(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final void tick() {
        for (Tickable t : this.smoothers) {
            t.tick();
        }
    }

    public final void setSmoothness(float smoothness) {
        for (Tickable t : this.smoothers) {
            t.setSmoothness(smoothness);
        }
    }
}

