/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import java.util.Map;
import org.gicentre.utils.network.traer.physics.Function;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.RungeKuttaIntegrator;
import org.gicentre.utils.network.traer.physics.Vector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettlingRungeKuttaIntegrator
extends RungeKuttaIntegrator {
    public static final int DEFAULT_SETTLING_AGE = 50;
    private final int settlingAge;
    private final float epsilon = 1.0E-4f;

    public SettlingRungeKuttaIntegrator(ParticleSystem s, int settlingAge) {
        super(s);
        this.settlingAge = settlingAge;
    }

    public SettlingRungeKuttaIntegrator(ParticleSystem s) {
        this(s, 50);
    }

    @Override
    protected Function<Particle, ?> updater(Map<Particle, Vector3D> k1f, Map<Particle, Vector3D> k1v, Map<Particle, Vector3D> k2f, Map<Particle, Vector3D> k2v, Map<Particle, Vector3D> k3f, Map<Particle, Vector3D> k3v, Map<Particle, Vector3D> k4f, Map<Particle, Vector3D> k4v, Map<Particle, Vector3D> oPos, Map<Particle, Vector3D> oVel, float deltaT) {
        final Function<Particle, ?> superUpdater = super.updater(k1f, k1v, k2f, k2v, k3f, k3v, k4f, k4v, oPos, oVel, deltaT);
        return new Function<Particle, Object>(){

            @Override
            public Object apply(Particle from) {
                superUpdater.apply(from);
                from.age = from.velocity().length() < 1.0E-4f ? (from.age += 1.0f) : 0.0f;
                if (from.age > (float)SettlingRungeKuttaIntegrator.this.settlingAge) {
                    from.makeFixed();
                }
                return null;
            }
        };
    }
}

