/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class ObliqueMercator
implements MapProjection {
    private Ellipsoid ellipsoid;
    private boolean doInterpolation;
    private int direction;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_OVER_4 = 0.7853981633974483;
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    double fc;
    double lc;
    double ac;
    double gc;
    double singc;
    double cosgc;
    double kc;
    double FE;
    double FN;
    double uc;
    double vc;
    double e;
    double e2;
    double A;
    double B;
    double H;
    double l0;
    double g0;
    double sing0;
    double cosg0;

    public ObliqueMercator(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.doInterpolation = true;
        this.direction = 1;
        this.ellipsoid = new Ellipsoid(3);
        this.lc = 0.12984522414316146;
        this.fc = 0.8194740686761218;
        this.ac = 1.5707963267948966;
        this.gc = 1.5707963267948966;
        this.kc = 1.0;
        this.FE = -7419820.5907;
        this.FN = 1200000.0;
        double cosfc = Math.cos(this.fc);
        double sinfc = Math.sin(this.fc);
        this.singc = Math.sin(this.gc);
        this.cosgc = Math.cos(this.gc);
        this.e2 = ellipsoid.getSquaredEccentricity();
        this.e = Math.sqrt(this.e2);
        double a = ellipsoid.getEquatorialRadius();
        this.B = Math.sqrt(1.0 + this.e2 * cosfc * cosfc * cosfc * cosfc / (1.0 - this.e2));
        this.A = a * this.B * this.kc * Math.sqrt(1.0 - this.e2) / (1.0 - this.e2 * sinfc * sinfc);
        double t0 = Math.tan(0.7853981633974483 - this.fc / 2.0) / Math.pow((1.0 - this.e * sinfc) / (1.0 + this.e * sinfc), this.e / 2.0);
        double D = this.B * Math.sqrt(1.0 - this.e2) / (cosfc * Math.sqrt(1.0 - this.e2 * sinfc * sinfc));
        double DSq = D * D;
        if (DSq < 1.0) {
            DSq = 1.0;
        }
        double F = D + Math.sqrt(DSq - 1.0);
        if (this.fc < 0.0) {
            F *= -1.0;
        }
        this.H = F * Math.pow(t0, this.B);
        double G = (F - 1.0 / F) / 2.0;
        this.sing0 = Math.sin(this.ac) / D;
        this.g0 = Math.asin(this.sing0);
        this.cosg0 = Math.cos(this.g0);
        this.l0 = this.ac == 1.5707963267948966 ? this.lc - 1.5707963267948966 / this.B : this.lc - Math.asin(G * Math.tan(this.g0)) / this.B;
        this.vc = 0.0;
        if (this.ac == 1.5707963267948966) {
            this.uc = this.A * (this.lc - this.l0);
        } else {
            this.uc = this.A / this.B * Math.atan(Math.sqrt(DSq - 1.0) / Math.cos(this.ac));
            if (this.fc < 0.0) {
                this.uc *= -1.0;
            }
        }
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToObliqueMercator(p);
        }
        return this.obliqueMercatorToLatLong(p);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 1) {
            return this.obliqueMercatorToLatLong(p);
        }
        return this.latLongToObliqueMercator(p);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to Oblique Mercator transformation.";
        }
        return "Oblique Mercator to lat/long transformation.";
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public PVector latLongToObliqueMercator(PVector p) {
        double lngRad = (double)p.x * (Math.PI / 180);
        double latRad = (double)p.y * (Math.PI / 180);
        double t = Math.tan(0.7853981633974483 - latRad / 2.0) / Math.pow((1.0 - this.e * Math.sin(latRad)) / (1.0 + this.e * Math.sin(latRad)), this.e / 2.0);
        double Q = this.H / Math.pow(t, this.B);
        double S = (Q - 1.0 / Q) / 2.0;
        double T = (Q + 1.0 / Q) / 2.0;
        double V = Math.sin(this.B * (lngRad - this.l0));
        double U = (-V * Math.cos(this.g0) + S * this.sing0) / T;
        double v = this.A * Math.log((1.0 - U) / (1.0 + U)) / (2.0 * this.B);
        double u = this.A * Math.atan2(S * this.cosg0 + V * this.sing0, Math.cos(this.B * (lngRad - this.l0))) / this.B;
        double E = v * this.cosgc + u * this.singc + this.FE;
        double N = u * this.cosgc - v * this.singc + this.FN;
        return new PVector((float)E, (float)N);
    }

    public PVector obliqueMercatorToLatLong(PVector p) {
        double easting = p.x;
        double northing = p.y;
        double vPrime = (easting - this.FE) * this.cosgc - (northing - this.FN) * this.singc;
        double uPrime = (northing - this.FN) * this.cosgc + (easting - this.FE) * this.singc;
        double QPrime = Math.pow(Math.E, -this.B * vPrime / this.A);
        double SPrime = (QPrime - 1.0 / QPrime) / 2.0;
        double TPrime = (QPrime + 1.0 / QPrime) / 2.0;
        double VPrime = Math.sin(this.B * uPrime / this.A);
        double UPrime = (VPrime * this.cosg0 + SPrime * this.sing0) / TPrime;
        double tPrime = Math.pow(this.H / Math.sqrt((1.0 + UPrime) / (1.0 - UPrime)), 1.0 / this.B);
        double c = 1.5707963267948966 - 2.0 * Math.atan(tPrime);
        double lat = c + Math.sin(2.0 * c) * (this.e2 / 2.0 + 5.0 * this.e2 * this.e2 / 24.0 + this.e2 * this.e2 * this.e2 / 12.0 + 13.0 * this.e2 * this.e2 * this.e2 * this.e2 / 360.0) + Math.sin(4.0 * c) * (7.0 * this.e2 * this.e2 / 48.0 + 29.0 * this.e2 * this.e2 * this.e2 / 240.0 + 811.0 * this.e2 * this.e2 * this.e2 * this.e2 / 11520.0) + Math.sin(6.0 * c) * (7.0 * this.e2 * this.e2 * this.e2 / 120.0 + 81.0 * this.e2 * this.e2 * this.e2 * this.e2 / 1120.0) + Math.sin(8.0 * c) * (4279.0 * this.e2 * this.e2 * this.e2 * this.e2 / 161280.0);
        double lng = this.l0 - Math.atan((SPrime * this.cosg0 - VPrime * this.sing0) / Math.cos(this.B * uPrime / this.A)) / this.B;
        return new PVector((float)(lng * 57.29577951308232), (float)(lat * 57.29577951308232));
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }
}

