/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.geom;

import java.util.ArrayList;
import processing.core.PVector;

public class Ellipse {
    private double cx;
    private double cy;
    private double a;
    private double b;
    private double cosTheta;
    private double sinTheta;
    private PVector f1;
    private PVector f2;
    private static final double EPSILON = 1.0E-5;
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    public Ellipse(double cx, double cy, double eWidth, double eHeight) {
        this(cx, cy, eWidth, eHeight, 0.0);
    }

    public Ellipse(double cx, double cy, double eWidth, double eHeight, double theta) {
        this.cx = cx;
        this.cy = cy;
        this.a = Math.max(eWidth / 2.0, eHeight / 2.0);
        this.b = Math.min(eWidth / 2.0, eHeight / 2.0);
        if (eHeight > eWidth) {
            this.cosTheta = Math.cos(theta + 1.5707963267948966);
            this.sinTheta = Math.sin(theta + 1.5707963267948966);
        } else {
            this.cosTheta = Math.cos(theta);
            this.sinTheta = Math.sin(theta);
        }
        this.f1 = new PVector((float)(cx - Math.sqrt(this.a * this.a - this.b * this.b) * this.cosTheta), (float)(cy - Math.sqrt(this.a * this.a - this.b * this.b) * this.sinTheta));
        this.f2 = new PVector((float)(cx + Math.sqrt(this.a * this.a - this.b * this.b) * this.cosTheta), (float)(cy + Math.sqrt(this.a * this.a - this.b * this.b) * this.sinTheta));
    }

    public PVector getPosition(double lamda) {
        double eta = this.getEta(lamda);
        double cosNeta = Math.cos(eta);
        double sinNeta = Math.sin(eta);
        return new PVector((float)(this.cx + this.a * this.cosTheta * cosNeta - this.b * this.sinTheta * sinNeta), (float)(this.cy + this.a * this.sinTheta * cosNeta + this.b * this.cosTheta * sinNeta));
    }

    public PVector[] getBezier(double startAngle, double endAngle) {
        if (startAngle == endAngle) {
            PVector p = this.getPosition(startAngle);
            return new PVector[]{p, p, p, p};
        }
        double eta1 = this.getEta(startAngle);
        double eta2 = this.getEta(endAngle);
        PVector p1 = this.getPosition(startAngle);
        PVector p2 = this.getPosition(endAngle);
        double tanSq = Math.tan((eta2 - eta1) / 2.0);
        tanSq *= tanSq;
        double alpha = Math.sin(eta2 - eta1) * ((Math.sqrt(4.0 + 3.0 * tanSq) - 1.0) / 3.0);
        PVector q1 = this.getEDash(startAngle);
        PVector q2 = this.getEDash(endAngle);
        q1.x = (float)((double)p1.x + alpha * (double)q1.x);
        q1.y = (float)((double)p1.y + alpha * (double)q1.y);
        q2.x = (float)((double)p2.x - alpha * (double)q2.x);
        q2.y = (float)((double)p2.y - alpha * (double)q2.y);
        return new PVector[]{p1, q1, q2, p2};
    }

    public PVector[] getBezierVertices(double startAngle, double endAngle) {
        double arcAngle = Ellipse.clockwiseAngleBetween(startAngle, endAngle);
        ArrayList<PVector> vertices = new ArrayList<PVector>();
        vertices.add(this.getPosition(startAngle));
        if (arcAngle > 1.0E-5) {
            double a1 = startAngle;
            double angleProg = 0.0;
            while (angleProg < arcAngle - 1.0E-5) {
                double a2;
                double angleInc = 1.5707963267948966 - (a1 % (Math.PI * 2) + Math.PI * 2) % 1.5707963267948966;
                if (angleInc < 1.0E-5) {
                    angleInc = 1.5707963267948966;
                }
                if (angleProg + angleInc >= arcAngle) {
                    a2 = endAngle;
                    angleProg = arcAngle;
                } else {
                    angleProg += angleInc;
                    a2 = a1 + angleInc;
                }
                PVector[] arc = this.getBezier(a1, a2);
                vertices.add(arc[1]);
                vertices.add(arc[2]);
                vertices.add(arc[3]);
                a1 = a2;
            }
        }
        PVector[] aVertices = new PVector[vertices.size()];
        int i = 0;
        while (i < vertices.size()) {
            aVertices[i] = (PVector)vertices.get(i);
            ++i;
        }
        return aVertices;
    }

    public static double clockwiseAngleBetween(double startAngle, double endAngle) {
        PVector v1 = PVector.fromAngle((float)((float)startAngle));
        PVector v2 = PVector.fromAngle((float)((float)endAngle));
        PVector cp = v1.cross(v2);
        if (cp.z < 0.0f) {
            return Math.PI * 2 - (double)PVector.angleBetween((PVector)v1, (PVector)v2);
        }
        return PVector.angleBetween((PVector)v1, (PVector)v2);
    }

    public PVector getCentre() {
        return new PVector((float)this.cx, (float)this.cy);
    }

    public double getMajor() {
        return this.a;
    }

    public double getMinor() {
        return this.b;
    }

    public PVector getFocus1() {
        return this.f1;
    }

    public PVector getFocus2() {
        return this.f2;
    }

    private double getEta(double lambda) {
        return Math.atan2(Math.sin(lambda) / this.b, Math.cos(lambda) / this.a);
    }

    private PVector getEDash(double lambda) {
        double eta = this.getEta(lambda);
        double cosEta = Math.cos(eta);
        double sinEta = Math.sin(eta);
        return new PVector((float)(-this.a * this.cosTheta * sinEta - this.b * this.sinTheta * cosEta), (float)(-this.a * this.sinTheta * sinEta + this.b * this.cosTheta * cosEta));
    }
}

