/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Function;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.Vector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gravity
extends Function<Particle, Particle> {
    private Vector3D gravity;
    public static final float DEFAULT_GRAVITY = 0.0f;

    public Gravity() {
        this(0.0f);
    }

    public Gravity(float grav) {
        this(0.0f, grav, 0.0f);
    }

    public Gravity(float gx, float gy, float gz) {
        this.gravity = Vector3D.of(gx, gy, gz);
    }

    public Gravity(Vector3D grav3d) {
        this.gravity = grav3d.copy();
    }

    public Gravity setGravity(float grav) {
        return this.setGravity(0.0f, grav, 0.0f);
    }

    public Gravity setGravity(float gx, float gy, float gz) {
        this.gravity.set(gx, gy, gz);
        return this;
    }

    public Gravity setGravity(Vector3D grav3d) {
        this.gravity.set(grav3d);
        return this;
    }

    @Override
    public Particle apply(Particle p) {
        p.getForce().add(this.gravity);
        return p;
    }
}

