/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.TargetedForce;
import org.gicentre.utils.network.traer.physics.Vector3D;

public abstract class TwoBodyForce
extends TargetedForce {
    private Particle oneEnd;
    private Particle theOtherEnd;

    protected TwoBodyForce(Particle oneEnd, Particle theOtherEnd) throws NullPointerException {
        TwoBodyForce.thrower(oneEnd, theOtherEnd);
        this.directSetOneEnd(oneEnd);
        this.directSetTheOtherEnd(theOtherEnd);
    }

    public final Particle getOneEnd() {
        return this.oneEnd;
    }

    public final Particle getTheOtherEnd() {
        return this.theOtherEnd;
    }

    public TwoBodyForce apply() {
        if (this.isOn() && (this.oneEnd.isFree() || this.theOtherEnd.isFree())) {
            ForcePair fp = this.forcePair();
            if (this.oneEnd.isFree()) {
                this.oneEnd.addForce(fp.forceOnOneEnd());
            }
            if (this.theOtherEnd.isFree()) {
                this.theOtherEnd.addForce(fp.forceOnTheOtherEnd());
            }
        }
        return this;
    }

    public TwoBodyForce turnOff() {
        return this.turnOn(false);
    }

    public TwoBodyForce turnOn() {
        return this.turnOn(true);
    }

    public TwoBodyForce turnOn(boolean isOn) {
        super.turnOn(isOn);
        return this;
    }

    protected TwoBodyForce setOneEnd(Particle p) throws NullPointerException {
        return p != null ? this.directSetOneEnd(p) : TwoBodyForce.thrower("Argument p is null.");
    }

    protected TwoBodyForce setTheOtherEnd(Particle p) throws NullPointerException {
        return p != null ? this.directSetTheOtherEnd(p) : TwoBodyForce.thrower("Argument p is null.");
    }

    protected static ForcePair specifyBoth(Vector3D forceOnOneEnd, Vector3D forceOnTheOtherEnd) throws NullPointerException {
        ForcePair.thrower(forceOnOneEnd, forceOnTheOtherEnd);
        return new ForcePair(forceOnOneEnd, forceOnTheOtherEnd);
    }

    protected static ForcePair equalAndOpposite(Vector3D forceOnOneEnd) throws NullPointerException {
        if (forceOnOneEnd == null) {
            ForcePair.thrower("Argument forceOnOneEnd == null.");
        }
        return new ForcePair(forceOnOneEnd);
    }

    protected abstract ForcePair forcePair();

    private TwoBodyForce directSetOneEnd(Particle p) {
        this.oneEnd = p;
        return this;
    }

    private TwoBodyForce directSetTheOtherEnd(Particle p) {
        this.theOtherEnd = p;
        return this;
    }

    private static boolean thrower(Particle oneEnd, Particle theOtherEnd) {
        if (oneEnd == null || theOtherEnd == null) {
            if (oneEnd == null && theOtherEnd == null) {
                throw new NullPointerException("Both end Particles are null.");
            }
            if (oneEnd == null) {
                throw new NullPointerException("The oneEnd Particle is null.");
            }
            throw new NullPointerException("The theOtherEnd Particle is null.");
        }
        return true;
    }

    private static TwoBodyForce thrower(String message) {
        throw new NullPointerException(message);
    }

    protected static class ForcePair {
        private Vector3D forceOnOneEnd;
        private Vector3D forceOnTheOtherEnd;
        private final boolean equalAndOpposite;

        private ForcePair(Vector3D forceOnOneEnd, Vector3D forceOnTheOtherEnd) {
            this.forceOnOneEnd = forceOnOneEnd;
            this.forceOnTheOtherEnd = forceOnTheOtherEnd;
            this.equalAndOpposite = false;
        }

        private ForcePair(Vector3D forceOnOneEnd) {
            this.forceOnOneEnd = forceOnOneEnd;
            this.equalAndOpposite = true;
        }

        protected Vector3D forceOnOneEnd() {
            return this.forceOnOneEnd;
        }

        protected Vector3D forceOnTheOtherEnd() {
            return this.equalAndOpposite ? this.forceOnOneEnd.copy().multiplyBy(-1.0f) : this.forceOnTheOtherEnd;
        }

        protected ForcePair updateEqualAndOpposite(Vector3D forceOnOneEnd) throws NullPointerException, IllegalStateException {
            if (!this.equalAndOpposite) {
                throw new IllegalStateException("This ForcePair was not setup as an equal and opposite force pair.");
            }
            if (forceOnOneEnd == null) {
                return ForcePair.thrower("The forceOnOneEnd Vector3D is null.");
            }
            this.forceOnOneEnd = forceOnOneEnd;
            return this;
        }

        protected ForcePair updateBoth(Vector3D forceOnOneEnd, Vector3D forceOnTheOtherEnd) throws NullPointerException {
            ForcePair.thrower(forceOnOneEnd, forceOnTheOtherEnd);
            this.forceOnOneEnd = forceOnOneEnd;
            this.forceOnTheOtherEnd = forceOnTheOtherEnd;
            return this;
        }

        private static void thrower(Vector3D forceOnOneEnd, Vector3D forceOnTheOtherEnd) throws NullPointerException {
            if (forceOnOneEnd == null || forceOnTheOtherEnd == null) {
                if (forceOnOneEnd == null && forceOnTheOtherEnd == null) {
                    throw new NullPointerException("Both Vector3D forces are null.");
                }
                if (forceOnOneEnd == null) {
                    throw new NullPointerException("The forceOnOneEnd Vector3D is null.");
                }
                throw new NullPointerException("The forceOnTheOtherEnd Vector3D is null.");
            }
        }

        private static ForcePair thrower(String message) {
            throw new NullPointerException(message);
        }
    }
}

