/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.geom.Locatable;
import processing.core.PVector;

public class Vector3D
implements Locatable {
    private float x;
    private float y;
    private float z;
    private PVector location;

    public Vector3D() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3D(PVector location) {
        this.x = location.x;
        this.y = location.y;
        this.z = location.z;
        this.location = new PVector(this.x, this.y, this.z);
    }

    public Vector3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.location = new PVector(x, y, z);
    }

    public Vector3D(Vector3D p) throws NullPointerException {
        if (p != null) {
            this.location = new PVector();
            this.set(p.x, p.y, p.z);
        } else {
            Vector3D.thrower("Argument Vector3D p cannot be null in constructor Vector3D(p).");
        }
    }

    public static final Vector3D of(float x, float y, float z) {
        return new Vector3D(x, y, z);
    }

    public static final Vector3D of() {
        return new Vector3D(0.0f, 0.0f, 0.0f);
    }

    public static final Vector3D copy(Vector3D from) {
        return new Vector3D(from);
    }

    public final Vector3D copy() {
        return Vector3D.copy(this);
    }

    public static final Vector3D thrower(String message) throws NullPointerException {
        throw new NullPointerException(message);
    }

    public final Vector3D subtract(float x, float y, float z) {
        return this.set(this.x - x, this.y - y, this.z - z);
    }

    public final Vector3D subtract(Vector3D p) throws NullPointerException {
        return p != null ? Vector3D.subtract(this, p, this) : Vector3D.thrower("Argument Vector3D p cannot be null in subtract(p).");
    }

    public static final Vector3D subtract(Vector3D v1, Vector3D v2) throws NullPointerException {
        return Vector3D.subtract(v1, v2, null);
    }

    public static final Vector3D subtract(Vector3D v1, Vector3D v2, Vector3D target) throws NullPointerException {
        return v1 != null && v2 != null ? (target == null ? new Vector3D(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z) : target.set(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z)) : (v1 == null && v2 == null ? Vector3D.thrower("Both Vector3D v1 and v2 are null in subtract(v1,v2,target).") : (v1 == null ? Vector3D.thrower("Vector3D v1 is null in subtract(v1,v2,target).") : Vector3D.thrower("Vector3D v2 is null in subtract(v1,v2,target).")));
    }

    public final Vector3D add(float x, float y, float z) {
        return this.set(this.x + x, this.y + y, this.z + z);
    }

    public final Vector3D add(Vector3D p) throws NullPointerException {
        return p != null ? Vector3D.add(this, p, this) : Vector3D.thrower("Argument p in add(p) is null.");
    }

    public static Vector3D add(Vector3D v1, Vector3D v2) throws NullPointerException {
        return Vector3D.add(v1, v2, null);
    }

    public static Vector3D add(Vector3D v1, Vector3D v2, Vector3D target) throws NullPointerException {
        return v1 != null && v2 != null ? (target == null ? new Vector3D(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z) : target.set(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z)) : (v1 == null && v2 == null ? Vector3D.thrower("Both Vector3D v1 and v2 are null in add(v1,v2,target).") : (v1 == null ? Vector3D.thrower("Vector3D v1 is null in add(v1,v2,target).") : Vector3D.thrower("Vector3D v2 is null in add(v1,v2,target).")));
    }

    public final float x() {
        return this.x;
    }

    public final float y() {
        return this.y;
    }

    public final float z() {
        return this.z;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public PVector getLocation() {
        return this.location;
    }

    public final Vector3D setX(float x) {
        this.x = x;
        this.location.x = x;
        return this;
    }

    public final Vector3D setY(float y) {
        this.y = y;
        this.location.y = y;
        return this;
    }

    public final Vector3D setZ(float z) {
        this.z = z;
        this.location.z = z;
        return this;
    }

    public final Vector3D set(float x, float y, float z) {
        return this.setX(x).setY(y).setZ(z);
    }

    public final Vector3D set(Vector3D p) throws NullPointerException {
        return p != null ? this.set(p.x, p.y, p.z) : Vector3D.thrower("Argument p is null in set(p).");
    }

    public final Vector3D multiplyBy(float f) {
        return this.set(this.x * f, this.y * f, this.z * f);
    }

    public static final Vector3D multiplyBy(Vector3D v, float f) throws NullPointerException {
        return v != null ? Vector3D.multiplyBy(v, f, null) : Vector3D.thrower("Argument v is null in multiplyBy(v) call.");
    }

    public static final Vector3D multiplyBy(Vector3D v, float f, Vector3D target) throws NullPointerException {
        if (v == null) {
            Vector3D.thrower("Argument v is null in multiplyBy(v,f,target) call.");
        }
        return target == null ? Vector3D.of(v.x * f, v.y * f, v.z * f) : target.set(v.x * f, v.y * f, v.z * f);
    }

    public final Vector3D limit(float f) {
        return this.length() > f ? this.length(f) : this;
    }

    public final Vector3D floor(float f) {
        return f > 0.0f && this.length() < f ? this.length(f) : this;
    }

    public final Vector3D normalize() throws ArithmeticException {
        return this.multiplyBy(1.0f / this.length());
    }

    public final float distanceTo(Vector3D v) throws NullPointerException {
        Vector3D.thrower(v, "Argument v is null in distanceTo(p) call.");
        return Vector3D.subtract(this, v).length();
    }

    public final float distanceSquaredTo(Vector3D v) throws NullPointerException {
        Vector3D.thrower(v, "Argument v is null in distanceSquaredTo(p) call.");
        return Vector3D.subtract(this, v).lengthSquared();
    }

    public final float distanceTo(float x, float y, float z) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final Vector3D projectOnto(Vector3D p) {
        return this.set(p.copy().length(p.dot(this) / p.length()));
    }

    public final float dot(Vector3D p) throws NullPointerException {
        Vector3D.thrower(p, "Argument p is null in dot(p) call.");
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public final Vector3D length(float f) {
        float len = this.length();
        if (len == 0.0f) {
            return this.multiplyBy(0.0f);
        }
        return this.multiplyBy(f / this.length());
    }

    public final float lengthSquared() {
        return this.dot(this);
    }

    public final void clear() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.location.x = 0.0f;
        this.location.y = 0.0f;
        this.location.z = 0.0f;
    }

    public final String toString() {
        return new String("(" + this.x + ", " + this.y + ", " + this.z + ")");
    }

    public final Vector3D cross(Vector3D v) throws NullPointerException {
        return v == null ? Vector3D.thrower("Argument v is null in cross(Vector3D).") : new Vector3D(this.y * v.z - this.z * v.y, this.x * v.z - this.z * v.x, this.x * v.y - this.y * v.x);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public boolean equals(Object other) {
        return other instanceof Vector3D ? this.equals((Vector3D)other) : false;
    }

    public int hashCode() {
        int result = Float.floatToIntBits(this.x);
        result = 1000003 * result + Float.floatToIntBits(this.y);
        result = 1000003 * result + Float.floatToIntBits(this.z);
        return result;
    }

    protected boolean equals(Vector3D other) {
        return this == other ? true : this.x == other.x && this.y == other.y && this.z == other.z;
    }

    private static boolean thrower(Vector3D v, String message) {
        if (v == null) {
            Vector3D.thrower(message);
        }
        return true;
    }
}

