/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class AlbersEqualAreaConic
implements MapProjection {
    private Ellipsoid ellipsoid;
    private boolean doInterpolation;
    private int direction;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double TWO_PI = Math.PI * 2;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double DBLLONG = 4.61168601E18;
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    private double phi1;
    private double phi2;
    private double lngCentre;
    private double latCentre;
    private double falseEast;
    private double falseNorth;
    private double sinRho;
    private double cosRho;
    private double eccentricity;
    private double con;
    private double c;
    private double ns0;
    private double rh;
    private double ms1;
    private double ms2;
    private double qs0;
    private double qs1;
    private double qs2;

    public AlbersEqualAreaConic(Ellipsoid ellipsoid, double lat1, double lat2) {
        this(ellipsoid, lat1, lat2, 0.0, 0.0, 0.0, 0.0);
    }

    public AlbersEqualAreaConic(Ellipsoid ellipsoid, double lat1, double lat2, double lon0, double lat0, double falseEast, double falseNorth) {
        this.ellipsoid = ellipsoid;
        this.doInterpolation = true;
        this.direction = 1;
        this.phi1 = lat1 * (Math.PI / 180);
        this.phi2 = lat2 * (Math.PI / 180);
        this.lngCentre = lon0 * (Math.PI / 180);
        this.latCentre = lat0 * (Math.PI / 180);
        this.falseEast = falseEast;
        this.falseNorth = falseNorth;
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-10) {
            System.err.println("Standard parallels must be separate (currently set at " + lat1 + " and " + lat2 + ")");
            return;
        }
        this.eccentricity = Math.sqrt(ellipsoid.getSquaredEccentricity());
        this.sinRho = Math.sin(this.phi1);
        this.cosRho = Math.cos(this.phi1);
        this.con = this.sinRho;
        this.ms1 = this.msfnz(this.sinRho, this.cosRho);
        this.qs1 = this.qsfnz(this.sinRho);
        this.sinRho = Math.sin(this.phi2);
        this.cosRho = Math.cos(this.phi2);
        this.ms2 = this.msfnz(this.sinRho, this.cosRho);
        this.qs2 = this.qsfnz(this.sinRho);
        this.sinRho = Math.sin(this.latCentre);
        this.cosRho = Math.cos(this.latCentre);
        this.qs0 = this.qsfnz(this.sinRho);
        this.ns0 = Math.abs(this.phi1 - this.phi2) > 1.0E-10 ? (this.ms1 * this.ms1 - this.ms2 * this.ms2) / (this.qs2 - this.qs1) : this.con;
        this.c = this.ms1 * this.ms1 + this.ns0 * this.qs1;
        this.rh = ellipsoid.getEquatorialRadius() * Math.sqrt(this.c - this.ns0 * this.qs0) / this.ns0;
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToAlbers(p);
        }
        return this.AlbersToLatLong(p);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 1) {
            return this.AlbersToLatLong(p);
        }
        return this.latLongToAlbers(p);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to Albers conic equal area transformation.";
        }
        return "Albers conic equal area to lat/long transformation.";
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public PVector latLongToAlbers(PVector p) {
        double phi = (double)p.y * (Math.PI / 180);
        double lambda = (double)p.x * (Math.PI / 180);
        double qs = this.qsfnz(Math.sin(phi));
        double rh1 = this.ellipsoid.getEquatorialRadius() * Math.sqrt(this.c - this.ns0 * qs) / this.ns0;
        double theta = this.ns0 * AlbersEqualAreaConic.adjustLong(lambda - this.lngCentre);
        return new PVector((float)(rh1 * Math.sin(theta) + this.falseEast), (float)(this.rh - rh1 * Math.cos(theta) + this.falseNorth));
    }

    public PVector AlbersToLatLong(PVector p) {
        double phi;
        double con1;
        double rh1;
        double easting = p.x;
        double northing = p.y;
        easting -= this.falseEast;
        northing = (float)(this.rh - northing + this.falseNorth);
        if (this.ns0 >= 0.0) {
            rh1 = Math.sqrt(easting * easting + northing * northing);
            con1 = 1.0;
        } else {
            rh1 = -Math.sqrt(easting * easting + northing * northing);
            con1 = -1.0;
        }
        double theta = 0.0;
        if (rh1 != 0.0) {
            theta = Math.atan2(con1 * easting, con1 * northing);
        }
        con1 = rh1 * this.ns0 / this.ellipsoid.getEquatorialRadius();
        double qs = (this.c - con1 * con1) / this.ns0;
        if (this.eccentricity >= 1.0E-10) {
            con1 = 1.0 - 0.5 * (1.0 - this.ellipsoid.getSquaredEccentricity()) * Math.log((1.0 - this.eccentricity) / (1.0 + this.eccentricity)) / this.eccentricity;
            if (Math.abs(Math.abs(con1) - Math.abs(qs)) > 1.0E-10) {
                phi = this.phi1z(qs);
                if (phi == Double.NaN) {
                    System.err.println("Problem calculating inverse Albers projection");
                    return null;
                }
            } else {
                phi = qs >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            }
        } else {
            phi = this.phi1z(qs);
            if (phi == Double.NaN) {
                System.err.println("Problem calculating inverse Albers projection");
                return null;
            }
        }
        double lambda = AlbersEqualAreaConic.adjustLong(theta / this.ns0 + this.lngCentre);
        return new PVector((float)(lambda * 57.29577951308232), (float)(phi * 57.29577951308232));
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    private double msfnz(double sinPhi, double cosPhi) {
        double con1 = this.eccentricity * sinPhi;
        return cosPhi / Math.sqrt(1.0 - con1 * con1);
    }

    private double qsfnz(double sinPhi) {
        if (this.eccentricity > 1.0E-7) {
            double con1 = this.eccentricity * sinPhi;
            return (1.0 - this.eccentricity * this.eccentricity) * (sinPhi / (1.0 - con1 * con1) - 0.5 / this.eccentricity * Math.log((1.0 - con1) / (1.0 + con1)));
        }
        return 2.0 * sinPhi;
    }

    private static double adjustLong(double origLng) {
        long count = 0L;
        double lng = origLng;
        while (!(Math.abs(lng) <= Math.PI)) {
            lng = (long)Math.abs(lng / Math.PI) < 2L ? (lng -= lng < 0.0 ? -1.0 : Math.PI * 2) : ((long)Math.abs(lng / (Math.PI * 2)) < Long.MAX_VALUE ? (lng -= (double)((long)(lng / (Math.PI * 2))) * (Math.PI * 2)) : ((long)Math.abs(lng / 5.795215566461698E19) < Long.MAX_VALUE ? (lng -= (double)((long)(lng / 5.795215566461698E19)) * 5.795215566461698E19) : ((long)Math.abs(lng / 2.897607777935765E19) < Long.MAX_VALUE ? (lng -= (double)((long)(lng / 2.897607777935765E19)) * 2.897607777935765E19) : (lng -= lng < 0.0 ? -1.0 : Math.PI * 2))));
            if (++count <= 4L) continue;
        }
        return lng;
    }

    private double phi1z(double qs) {
        double eccntSq = this.ellipsoid.getSquaredEccentricity();
        double phi = AlbersEqualAreaConic.asinz(0.5 * qs);
        if (this.eccentricity < 1.0E-10) {
            return phi;
        }
        eccntSq = this.eccentricity * this.eccentricity;
        int i = 1;
        while (i <= 25) {
            double sinpi = Math.sin(phi);
            double cospi = Math.cos(phi);
            double con1 = this.eccentricity * sinpi;
            double com = 1.0 - con1 * con1;
            double dphi = 0.5 * com * com / cospi * (qs / (1.0 - eccntSq) - sinpi / com + 0.5 / this.eccentricity * Math.log((1.0 - con1) / (1.0 + con1)));
            phi += dphi;
            if (Math.abs(dphi) <= 1.0E-7) {
                return phi;
            }
            ++i;
        }
        System.err.println("Convergence error when calculating inverse Albers projection");
        return Double.NaN;
    }

    private static double asinz(double origCon) {
        double con1 = origCon;
        if (Math.abs(con1) > 1.0) {
            con1 = con1 > 1.0 ? 1.0 : -1.0;
        }
        return Math.asin(con1);
    }
}

