/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class Swiss
implements MapProjection {
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private double latOrigin;
    private double lngOrigin;
    private double falseEasting;
    private double falseNorthing;
    private double a;
    private double e2;
    private double e;
    private double c;
    private double equivLatOrgPrime;
    private double K;
    private double R;
    private int direction;
    private Ellipsoid wgs84;
    private Ellipsoid bessel1841;
    private boolean doInterpolation;

    public Swiss() {
        this(1);
    }

    public Swiss(int direction) {
        this.direction = direction;
        this.wgs84 = new Ellipsoid(23);
        this.bessel1841 = new Ellipsoid(3);
        this.latOrigin = 0.819474068753692;
        this.lngOrigin = 0.12984522408498383;
        this.falseEasting = 600000.0;
        this.falseNorthing = 200000.0;
        this.a = this.bessel1841.getEquatorialRadius();
        this.e2 = this.bessel1841.getSquaredEccentricity();
        this.e = Math.sqrt(this.e2);
        this.c = Math.sqrt(1.0 + this.e2 * Math.pow(Math.cos(this.latOrigin), 4.0) / (1.0 - this.e2));
        this.equivLatOrgPrime = Math.asin(Math.sin(this.latOrigin) / this.c);
        this.K = Math.log(Math.tan(0.7853981633974483 + this.equivLatOrgPrime / 2.0)) - this.c * (Math.log(Math.tan(0.7853981633974483 + this.latOrigin / 2.0)) - this.e / 2.0 * Math.log((1.0 + this.e * Math.sin(this.latOrigin)) / (1.0 - this.e * Math.sin(this.latOrigin))));
        this.R = this.a * Math.sqrt(1.0 - this.e2) / (1.0 - this.e2 * Math.sin(this.latOrigin) * Math.sin(this.latOrigin));
    }

    public PVector latLongToSwiss(PVector p) {
        double phi = (double)p.y * (Math.PI / 180);
        double lamda = (double)p.x * (Math.PI / 180);
        double lngPrime = this.c * (lamda - this.lngOrigin);
        double w = this.c * (Math.log(Math.tan(0.7853981633974483 + phi / 2.0)) - this.e / 2.0 * Math.log((1.0 + this.e * Math.sin(phi)) / (1.0 - this.e * Math.sin(phi)))) + this.K;
        double latPrime = 2.0 * (Math.atan(Math.exp(w)) - 0.7853981633974483);
        double sinLatDoublePrime = Math.cos(this.equivLatOrgPrime) * Math.sin(latPrime) - Math.sin(this.equivLatOrgPrime) * Math.cos(latPrime) * Math.cos(lngPrime);
        double latDoublePrime = Math.asin(sinLatDoublePrime);
        double sinLngDoublePrime = Math.cos(latPrime) * Math.sin(lngPrime) / Math.cos(latDoublePrime);
        double lngDoublePrime = Math.asin(sinLngDoublePrime);
        float northing = (float)(this.R * Math.log(Math.tan(0.7853981633974483 + latDoublePrime / 2.0)) + this.falseNorthing);
        float easting = (float)(this.R * lngDoublePrime + this.falseEasting);
        return new PVector(easting, northing);
    }

    public PVector swissToLatLong(PVector p) {
        double easting = p.x;
        double northing = p.y;
        double latDoublePrime = 2.0 * (Math.atan(Math.exp((northing - this.falseNorthing) / this.R)) - 0.7853981633974483);
        double lngDoublePrime = (easting - this.falseEasting) / this.R;
        double sinLatPrime = Math.cos(this.equivLatOrgPrime) * Math.sin(latDoublePrime) + Math.sin(this.equivLatOrgPrime) * Math.cos(latDoublePrime) * Math.cos(lngDoublePrime);
        double latPrime = Math.asin(sinLatPrime);
        double sinLngPrime = Math.cos(latDoublePrime) * Math.sin(lngDoublePrime) / Math.cos(latPrime);
        double lngPrime = Math.asin(sinLngPrime);
        float lng = (float)((lngPrime / this.c + this.lngOrigin) * 57.29577951308232);
        float lat = (float)(this.newtonRaphson(latPrime) * 57.29577951308232);
        return new PVector(lng, lat);
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToSwiss(this.wgs84.projectDatum(p, 3));
        }
        return this.bessel1841.projectDatum(this.swissToLatLong(p), 23);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 2) {
            return this.latLongToSwiss(this.wgs84.projectDatum(p, 3));
        }
        return this.bessel1841.projectDatum(this.swissToLatLong(p), 23);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to Swiss National Grid transformation.";
        }
        return "Swiss National Grid to lat/long transformation.";
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public Ellipsoid getEllipsoid() {
        return this.bessel1841;
    }

    private double newtonRaphson(double initEstimate) {
        double corr;
        double estimate = initEstimate;
        double tol = 1.0E-5;
        double C = (this.K - Math.log(Math.tan(0.7853981633974483 + initEstimate / 2.0))) / this.c;
        do {
            corr = this.corrRatio(estimate, C);
            estimate -= corr;
        } while (Math.abs(corr) > tol);
        return estimate;
    }

    private double corrRatio(double lat, double C) {
        double corr = (C + Math.log(Math.tan(0.7853981633974483 + lat / 2.0)) - this.e / 2.0 * Math.log((1.0 + this.e * Math.sin(lat)) / (1.0 - this.e * Math.sin(lat)))) * ((1.0 - this.e2 * Math.sin(lat) * Math.sin(lat)) * Math.cos(lat) / (1.0 - this.e2));
        return corr;
    }
}

