/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.stat;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.gicentre.utils.gui.Drawable;
import processing.core.PApplet;
import processing.core.PGraphics;

public abstract class AbstractChart {
    protected PApplet parent;
    protected PGraphics graphics;
    protected Drawable renderer;
    protected float[][] data;
    protected float[][] tics;
    protected float[][] logTics;
    protected boolean transposeAxes;
    protected DecimalFormat[] axisFormatter;
    protected int axisColour;
    protected int axisValuesColour;
    protected int axisLabelColour;
    protected boolean showEdge;
    protected boolean drawDecorations;
    private float minBorder;
    private float borderL;
    private float borderR;
    private float borderT;
    private float borderB;
    private float minBorderL;
    private float minBorderR;
    private float minBorderT;
    private float minBorderB;
    private boolean[] isLogScale;
    private float[] min;
    private float[] max;
    private float[] minLog;
    private float[] maxLog;
    private boolean[] forceMin;
    private boolean[] forceMax;
    private boolean[] showAxis;
    private Side[] axisPositions;
    private static final int MAX_DIMENSIONS = 20;

    protected AbstractChart(PApplet parent) {
        this.parent = parent;
        this.graphics = parent.g;
        this.renderer = new RendererGraphics(this.graphics);
        this.data = new float[20][];
        this.tics = new float[20][];
        this.logTics = new float[20][];
        this.min = new float[20];
        this.max = new float[20];
        this.minLog = new float[20];
        this.maxLog = new float[20];
        this.isLogScale = new boolean[20];
        this.forceMin = new boolean[20];
        this.forceMax = new boolean[20];
        this.showAxis = new boolean[20];
        this.axisPositions = new Side[20];
        this.axisFormatter = new DecimalFormat[20];
        this.showEdge = false;
        this.drawDecorations = true;
        this.axisColour = parent.color(120);
        this.axisLabelColour = parent.color(120);
        this.axisValuesColour = parent.color(120);
        this.transposeAxes = false;
        this.borderL = this.minBorder = 1.0f;
        this.borderR = this.minBorder;
        this.borderT = this.minBorder;
        this.borderB = this.minBorder;
        this.minBorderL = this.minBorder;
        this.minBorderR = this.minBorder;
        this.minBorderT = this.minBorder;
        this.minBorderB = this.minBorder;
        int i = 0;
        while (i < 20) {
            this.forceMin[i] = false;
            this.forceMax[i] = false;
            this.showAxis[i] = false;
            this.isLogScale[i] = false;
            this.axisPositions[i] = Side.NO_SIDE;
            this.axisFormatter[i] = new DecimalFormat("###,###,###.######");
            ++i;
        }
    }

    protected abstract void draw(float var1, float var2, float var3, float var4);

    public void setGraphics(PGraphics graphics) {
        this.graphics = graphics;
        this.renderer = new RendererGraphics(graphics);
    }

    public void setRenderer(Drawable renderer) {
        this.renderer = renderer;
    }

    public void setDecorations(boolean drawDecorations) {
        this.drawDecorations = drawDecorations;
    }

    public void setAxisColour(int colour) {
        this.axisColour = colour;
    }

    public void setAxisLabelColour(int colour) {
        this.axisLabelColour = colour;
    }

    public void setAxisValuesColour(int colour) {
        this.axisValuesColour = colour;
    }

    public void setShowEdge(boolean showEdge) {
        this.showEdge = showEdge;
    }

    protected void setData(int dimension, float[] data) {
        if (dimension >= 20) {
            System.err.println("Warning: Cannot set data for dimension " + dimension + ": permissable range 0-" + 19);
            return;
        }
        if (data == null) {
            this.setData(dimension, new float[0]);
            return;
        }
        this.data[dimension] = data;
        this.updateChart(dimension);
    }

    protected float[] getData(int dimension) {
        if (dimension >= 20) {
            System.err.println("Warning: Cannot get data for dimension " + dimension + ": permissable range 0-" + 19);
            return null;
        }
        return this.data[dimension];
    }

    protected void setRange(int dimension, float min, float max) {
        if (Float.isNaN(min)) {
            this.forceMin[dimension] = false;
        } else {
            this.forceMin[dimension] = true;
            this.min[dimension] = min;
        }
        if (Float.isNaN(max)) {
            this.forceMax[dimension] = false;
        } else {
            this.forceMax[dimension] = true;
            this.max[dimension] = max;
        }
        this.updateChart(dimension);
    }

    protected void setMin(int dimension, float min) {
        if (Float.isNaN(min)) {
            this.forceMin[dimension] = false;
        } else {
            this.forceMin[dimension] = true;
            this.min[dimension] = min;
        }
        this.updateChart(dimension);
    }

    protected float getMin(int dimension) {
        return this.min[dimension];
    }

    protected float getMax(int dimension) {
        return this.max[dimension];
    }

    protected float getMinLog(int dimension) {
        return this.minLog[dimension];
    }

    protected float getMaxLog(int dimension) {
        return this.maxLog[dimension];
    }

    protected void setMax(int dimension, float max) {
        if (Float.isNaN(max)) {
            this.forceMax[dimension] = false;
        } else {
            this.forceMax[dimension] = true;
            this.max[dimension] = max;
        }
        this.updateChart(dimension);
    }

    protected void setMinBorder(float border) {
        this.minBorder = border;
    }

    protected void setMinBorder(float border, Side side) {
        switch (side) {
            case TOP: {
                this.minBorderT = Math.max(this.minBorder, border);
                break;
            }
            case BOTTOM: {
                this.minBorderB = Math.max(this.minBorder, border);
                break;
            }
            case LEFT: {
                this.minBorderL = Math.max(this.minBorder, border);
                break;
            }
            case RIGHT: {
                this.minBorderR = Math.max(this.minBorder, border);
            }
        }
    }

    protected void setBorder(float border, Side side) {
        switch (side) {
            case TOP: {
                this.borderT = border;
                this.minBorderT = border;
                break;
            }
            case BOTTOM: {
                this.borderB = border;
                this.minBorderB = border;
                break;
            }
            case LEFT: {
                this.borderL = border;
                this.minBorderL = border;
                break;
            }
            case RIGHT: {
                this.borderR = border;
                this.minBorderR = border;
            }
        }
    }

    protected float getMinBorder() {
        return this.minBorder;
    }

    protected float getBorder(Side side) {
        switch (side) {
            case TOP: {
                return Math.max(this.minBorderT, this.borderT);
            }
            case BOTTOM: {
                return Math.max(this.minBorderB, this.borderB);
            }
            case LEFT: {
                return Math.max(this.minBorderL, this.borderL);
            }
            case RIGHT: {
                return Math.max(this.minBorderR, this.borderR);
            }
        }
        return 0.0f;
    }

    protected void showAxis(int dimension, boolean isVisible, Side side) {
        if (this.showAxis[dimension] != isVisible) {
            if (this.data[dimension] == null) {
                this.setData(dimension, new float[0]);
            }
            this.showAxis[dimension] = isVisible;
            this.axisPositions[dimension] = isVisible ? side : Side.NO_SIDE;
            if (side == Side.TOP) {
                this.borderT = this.minBorder;
                this.minBorderT = this.minBorder;
                if (isVisible) {
                    this.borderT = Math.max(this.borderT, this.graphics.textAscent() + this.graphics.textDescent());
                }
            } else if (side == Side.BOTTOM) {
                this.borderB = this.minBorder;
                this.minBorderB = this.minBorder;
                if (isVisible) {
                    this.borderB = Math.max(this.borderB, this.graphics.textAscent() + this.graphics.textDescent());
                }
            } else if (side == Side.LEFT) {
                this.borderL = this.minBorder;
                this.minBorderL = this.minBorder;
                if (isVisible && this.tics != null) {
                    float[] fArray = this.tics[dimension];
                    int n = fArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        float tic = fArray[n2];
                        this.borderL = Math.max(this.borderL, this.graphics.textWidth(this.axisFormatter[dimension].format(tic)));
                        ++n2;
                    }
                }
            } else if (side == Side.RIGHT) {
                this.borderR = this.minBorder;
                this.minBorderR = this.minBorder;
                if (isVisible && this.tics != null) {
                    float[] fArray = this.tics[dimension];
                    int n = fArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        float tic = fArray[n3];
                        this.borderR = Math.max(this.borderR, this.graphics.textWidth(this.axisFormatter[dimension].format(tic)));
                        ++n3;
                    }
                }
            }
            this.updateChart(dimension);
        }
    }

    protected boolean getShowAxis(int dimension) {
        if (dimension >= 20) {
            return false;
        }
        return this.showAxis[dimension];
    }

    protected boolean getIsLogScale(int dimension) {
        if (dimension >= 20) {
            return false;
        }
        return this.isLogScale[dimension];
    }

    protected void setIsLogScale(int dimension, boolean isLog) {
        if (dimension >= 20) {
            return;
        }
        this.isLogScale[dimension] = isLog;
    }

    protected void setFormat(int dimension, String format) {
        block2: {
            block3: {
                this.axisFormatter[dimension] = new DecimalFormat(format);
                if (!this.showAxis[dimension]) break block2;
                if (this.axisPositions[dimension] != Side.LEFT) break block3;
                this.borderL = this.minBorderL;
                float[] fArray = this.tics[dimension];
                int n = fArray.length;
                int n2 = 0;
                while (n2 < n) {
                    float tic = fArray[n2];
                    this.borderL = Math.max(this.borderL, this.graphics.textWidth(this.axisFormatter[dimension].format(tic)));
                    ++n2;
                }
                break block2;
            }
            if (this.axisPositions[dimension] != Side.RIGHT) break block2;
            this.borderR = this.minBorderR;
            float[] fArray = this.tics[dimension];
            int n = fArray.length;
            int n3 = 0;
            while (n3 < n) {
                float tic = fArray[n3];
                this.borderR = Math.max(this.borderR, this.graphics.textWidth(this.axisFormatter[dimension].format(tic)));
                ++n3;
            }
        }
    }

    protected static float convertToLog(double dataItem, double minLogValue, double maxLogValue) {
        if (dataItem <= 0.0) {
            return 0.0f;
        }
        return (float)((Math.log10(dataItem) - minLogValue) / (maxLogValue - minLogValue));
    }

    protected static float convertFromLog(double logValue, double minLogValue, double maxLogValue) {
        if (logValue < 0.0 || logValue > 1.0) {
            return 0.0f;
        }
        double unscaledLog = logValue * (maxLogValue - minLogValue) + minLogValue;
        return (float)Math.pow(10.0, unscaledLog);
    }

    private void updateChart(int dimension) {
        if (this.data[dimension] == null) {
            this.data[dimension] = new float[0];
        }
        if (this.data[dimension].length == 0) {
            if (this.min[dimension] == this.max[dimension]) {
                this.min[dimension] = Math.min(0.0f, this.min[dimension]);
                this.max[dimension] = Math.max(1.0f, this.max[dimension]);
            }
            this.tics[dimension] = AbstractChart.getTics(this.min[dimension], this.max[dimension]);
        }
        if (this.data[dimension] != null && this.data[dimension].length > 0) {
            float dataItem;
            int n;
            int n2;
            float[] fArray;
            if (!this.forceMin[dimension]) {
                this.min[dimension] = Float.MAX_VALUE;
                this.minLog[dimension] = Float.MAX_VALUE;
                fArray = this.data[dimension];
                n2 = fArray.length;
                n = 0;
                while (n < n2) {
                    dataItem = fArray[n];
                    this.min[dimension] = Math.min(this.min[dimension], dataItem);
                    ++n;
                }
            } else {
                this.minLog[dimension] = (float)Math.log10(Math.max(Math.min(0.001, (double)this.max[dimension] / 1000.0), (double)this.min[dimension]));
            }
            if (!this.forceMax[dimension]) {
                this.max[dimension] = -3.4028235E38f;
                this.maxLog[dimension] = -3.4028235E38f;
                fArray = this.data[dimension];
                n2 = fArray.length;
                n = 0;
                while (n < n2) {
                    dataItem = fArray[n];
                    this.max[dimension] = Math.max(this.max[dimension], dataItem);
                    ++n;
                }
            } else {
                this.maxLog[dimension] = (float)Math.log10(this.max[dimension]);
            }
            this.tics[dimension] = AbstractChart.getTics(this.min[dimension], this.max[dimension]);
            this.logTics[dimension] = AbstractChart.getLogTics(Math.pow(10.0, this.minLog[dimension]), this.max[dimension]);
            if (this.showAxis[dimension]) {
                float tic;
                fArray = this.tics[dimension];
                n2 = fArray.length;
                n = 0;
                while (n < n2) {
                    tic = fArray[n];
                    if (!this.forceMax[dimension]) {
                        this.max[dimension] = Math.max(this.max[dimension], tic);
                    }
                    if (!this.forceMin[dimension]) {
                        this.min[dimension] = Math.min(this.min[dimension], tic);
                    }
                    ++n;
                }
                fArray = this.logTics[dimension];
                n2 = fArray.length;
                n = 0;
                while (n < n2) {
                    tic = fArray[n];
                    if (!this.forceMax[dimension]) {
                        this.maxLog[dimension] = Math.max(this.maxLog[dimension], tic);
                    }
                    if (!this.forceMin[dimension]) {
                        this.minLog[dimension] = Math.min(this.minLog[dimension], tic);
                    }
                    ++n;
                }
            }
        }
    }

    private static float[] getTics(double minValue, double maxValue) {
        float minTic;
        double maxVal;
        double minVal = Math.min(minValue, maxValue);
        if (minVal == (maxVal = Math.max(minValue, maxValue))) {
            minVal -= 0.5;
            maxVal += 0.5;
        }
        float spacing = AbstractChart.findSpacing(minVal, maxVal);
        float tic = minTic = (float)Math.floor(minVal / (double)spacing) * spacing;
        int numTics = 0;
        while ((double)tic < maxVal) {
            tic = minTic + (float)numTics * spacing;
            ++numTics;
        }
        float[] tics = new float[numTics];
        int i = 0;
        while (i < numTics) {
            tics[i] = minTic + (float)i * spacing;
            ++i;
        }
        return tics;
    }

    private static float[] getLogTics(double minVal, double maxVal) {
        int minDecade = (int)Math.round(Math.log10(minVal) - 0.5);
        int maxDecade = (int)Math.round(Math.log10(maxVal) + 0.5);
        double maxLog = Math.log10(maxVal);
        int range = maxDecade - minDecade;
        float[] mult = range < 3 ? new float[]{1.0f, 2.0f, 5.0f} : (range < 5 ? new float[]{1.0f, 5.0f} : new float[]{1.0f});
        ArrayList<Double> tics = new ArrayList<Double>();
        int i = 0;
        while (i <= range) {
            int m = 0;
            while (m < mult.length) {
                double tic = Math.log10(Math.pow(10.0, minDecade + i) * (double)mult[m]);
                if (tic <= maxLog) {
                    tics.add(new Double(tic));
                }
                ++m;
            }
            ++i;
        }
        float[] ticArray = new float[tics.size()];
        int i2 = 0;
        while (i2 < ticArray.length) {
            ticArray[i2] = ((Double)tics.get(i2)).floatValue();
            ++i2;
        }
        return ticArray;
    }

    private static float findSpacing(double minVal, double maxVal) {
        double r = maxVal - minVal;
        double newMaxVal = maxVal;
        if (r <= 0.0) {
            newMaxVal = minVal + 1.0;
        }
        int n = (int)Math.floor(Math.log10(r));
        int minInterval = 4;
        int maxInterval = 7;
        double[] mu = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0};
        int i = 0;
        while (i < mu.length) {
            int interval = (int)Math.round(r / (mu[i] * Math.pow(10.0, n))) + 1;
            if (interval >= minInterval && interval <= maxInterval) {
                return (float)(mu[i] * Math.pow(10.0, n));
            }
            ++i;
        }
        return (float)(newMaxVal - minVal);
    }

    private class RendererGraphics
    implements Drawable {
        private PGraphics gr;

        public RendererGraphics(PGraphics graphics) {
            this.gr = graphics;
        }

        public void point(float x, float y) {
            this.gr.point(x, y);
        }

        public void line(float x1, float y1, float x2, float y2) {
            this.gr.line(x1, y1, x2, y2);
        }

        public void rect(float x, float y, float w, float h) {
            this.gr.rect(x, y, w, h);
        }

        public void ellipse(float x, float y, float w, float h) {
            this.gr.ellipse(x, y, w, h);
        }

        public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.gr.triangle(x1, y1, x2, y2, x3, y3);
        }

        public void shape(float[] xCoords, float[] yCoords) {
            this.gr.beginShape();
            int i = 0;
            while (i < xCoords.length) {
                this.gr.vertex(xCoords[i], yCoords[i]);
                ++i;
            }
            this.gr.endShape(2);
        }

        public void polyLine(float[] xCoords, float[] yCoords) {
            this.gr.pushStyle();
            this.gr.noFill();
            this.gr.beginShape();
            int i = 0;
            while (i < xCoords.length) {
                this.gr.vertex(xCoords[i], yCoords[i]);
                ++i;
            }
            this.gr.endShape();
            this.gr.popStyle();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Side {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        NO_SIDE;

    }
}

