/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.stat;

import org.gicentre.utils.colour.ColourTable;
import org.gicentre.utils.stat.AbstractChart;
import processing.core.PApplet;
import processing.core.PVector;

public class BarChart
extends AbstractChart {
    private int barColour = this.graphics.color(180);
    private float barGap = 1.0f;
    private float barPad = 0.0f;
    private boolean reverseCats = false;
    private ColourTable cTable = null;
    private String[] catLabels = null;
    private boolean showLabels = false;
    private String categoryLabel = null;
    private String valueLabel = null;
    private Float catAxisPosition;
    private float top = 0.0f;
    private float left = 0.0f;
    private float bottom = 0.0f;
    private float right = 0.0f;

    public BarChart(PApplet parent) {
        super(parent);
    }

    public void setData(float[] values) {
        this.setData(1, values);
        float[] categories = new float[values.length];
        int i = 0;
        while (i < categories.length) {
            categories[i] = i + 1;
            ++i;
        }
        this.setData(0, categories);
    }

    public float[] getData() {
        return this.getData(1);
    }

    public void draw(float xOrigin, float yOrigin, float width, float height) {
        int index;
        if (this.data[1] == null || this.data[1].length == 0) {
            return;
        }
        int strokeColour = this.graphics.strokeColor;
        this.graphics.pushStyle();
        this.graphics.rectMode(0);
        float extraLeftBorder = 2.0f;
        float extraRightBorder = 2.0f;
        float extraTopBorder = 2.0f;
        float extraBottomBorder = 2.0f;
        if (this.getShowAxis(0) || this.transposeAxes && this.getShowAxis(1)) {
            int axis = this.transposeAxes ? 1 : 0;
            String lastLabel = this.catLabels != null && !this.transposeAxes ? this.catLabels[this.catLabels.length - 1] : this.axisFormatter[axis].format(this.tics[axis][this.tics[axis].length - 1]);
            extraRightBorder += this.graphics.textWidth(lastLabel) / 2.0f;
        }
        if (this.getShowAxis(1) || this.transposeAxes && this.getShowAxis(0)) {
            extraTopBorder += this.graphics.textAscent() / 2.0f + 2.0f;
        }
        if (this.valueLabel != null && this.getShowAxis(1) || this.transposeAxes && this.categoryLabel != null && this.getShowAxis(0)) {
            extraLeftBorder += this.graphics.textAscent() + this.graphics.textDescent();
        }
        if (this.categoryLabel != null && this.getShowAxis(0) || this.transposeAxes && this.valueLabel != null && this.getShowAxis(1)) {
            extraBottomBorder += this.graphics.textAscent() + this.graphics.textDescent();
        }
        this.left = xOrigin + this.getBorder(AbstractChart.Side.LEFT) + extraLeftBorder;
        this.right = xOrigin + width - (this.getBorder(AbstractChart.Side.RIGHT) + extraRightBorder);
        this.bottom = yOrigin + height - (this.getBorder(AbstractChart.Side.BOTTOM) + extraBottomBorder);
        this.top = yOrigin + this.getBorder(AbstractChart.Side.TOP) + extraTopBorder;
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        float axisValue = this.catAxisPosition == null ? this.getMin(1) : this.catAxisPosition.floatValue();
        float barWidth = this.transposeAxes ? (vRange - (float)(this.data[0].length - 1) * this.barGap - (float)this.data[0].length * this.barPad) / (float)this.data[0].length : (hRange - (float)(this.data[0].length - 1) * this.barGap - (float)this.data[0].length * this.barPad) / (float)this.data[0].length;
        if (this.showEdge) {
            this.graphics.stroke(strokeColour);
        } else {
            this.graphics.noStroke();
        }
        if (this.cTable == null) {
            this.graphics.fill(this.barColour);
        }
        int i = 0;
        while (i < this.data[0].length) {
            if (this.cTable != null) {
                this.graphics.fill(this.cTable.findColour(this.data[2][i]));
            }
            index = this.reverseCats ? this.data[0].length - 1 - i : i;
            float dataValue = Math.max(Math.min(this.data[1][index], this.getMax(1)), this.getMin(1));
            if (this.transposeAxes) {
                if (this.getIsLogScale(1)) {
                    this.renderer.rect(this.left, this.top + (float)i * (barWidth + this.barGap + this.barPad) + this.barPad / 2.0f, hRange * BarChart.convertToLog(dataValue, this.getMinLog(1), this.getMaxLog(1)), barWidth);
                } else {
                    this.renderer.rect(this.left + hRange * (axisValue - this.getMin(1)) / (this.getMax(1) - this.getMin(1)), this.top + (float)i * (barWidth + this.barGap + this.barPad) + this.barPad / 2.0f, hRange * (dataValue - axisValue) / (this.getMax(1) - this.getMin(1)), barWidth);
                }
            } else if (this.getIsLogScale(1)) {
                this.renderer.rect(this.left + (float)i * (barWidth + this.barGap + this.barPad) + this.barPad / 2.0f, this.bottom, barWidth, -vRange * BarChart.convertToLog(dataValue, this.getMinLog(1), this.getMaxLog(1)));
            } else {
                this.renderer.rect(this.left + (float)i * (barWidth + this.barGap + this.barPad) + this.barPad / 2.0f, this.bottom - vRange * (axisValue - this.getMin(1)) / (this.getMax(1) - this.getMin(1)), barWidth, -vRange * (dataValue - axisValue) / (this.getMax(1) - this.getMin(1)));
            }
            ++i;
        }
        if (this.drawDecorations) {
            if (this.getShowAxis(1)) {
                int n;
                float[] fArray;
                this.graphics.strokeWeight(0.5f);
                this.graphics.stroke(this.axisColour);
                if (this.transposeAxes) {
                    this.renderer.line(this.left, this.bottom, this.right, this.bottom);
                } else {
                    this.renderer.line(this.left, this.bottom, this.left, this.top);
                }
                this.graphics.fill(this.axisValuesColour);
                if (this.getIsLogScale(1)) {
                    fArray = this.logTics[1];
                    n = fArray.length;
                    index = 0;
                    while (index < n) {
                        float logTic = fArray[index];
                        float tic = (float)Math.pow(10.0, logTic);
                        if (tic <= this.getMax(1)) {
                            if (this.transposeAxes) {
                                this.graphics.textAlign(3, 101);
                                this.graphics.text(this.axisFormatter[1].format(tic), this.left + hRange * (logTic - this.getMinLog(1)) / (this.getMaxLog(1) - this.getMinLog(1)), this.bottom + 2.0f);
                            } else {
                                this.graphics.textAlign(39, 3);
                                this.graphics.text(this.axisFormatter[1].format(tic), this.left - 2.0f, this.top + vRange * (this.getMaxLog(1) - logTic) / (this.getMaxLog(1) - this.getMinLog(1)));
                            }
                        }
                        ++index;
                    }
                } else {
                    fArray = this.tics[1];
                    n = fArray.length;
                    index = 0;
                    while (index < n) {
                        float tic = fArray[index];
                        if (tic <= this.getMax(1)) {
                            if (this.transposeAxes) {
                                this.graphics.textAlign(3, 101);
                                this.graphics.text(this.axisFormatter[1].format(tic), this.left + hRange * (tic - this.getMin(1)) / (this.getMax(1) - this.getMin(1)), this.bottom + 2.0f);
                            } else {
                                this.graphics.textAlign(39, 3);
                                this.graphics.text(this.axisFormatter[1].format(tic), this.left - 2.0f, this.top + vRange * (this.getMax(1) - tic) / (this.getMax(1) - this.getMin(1)));
                            }
                        }
                        ++index;
                    }
                }
                if (this.valueLabel != null) {
                    this.graphics.fill(this.axisLabelColour);
                    if (this.transposeAxes) {
                        this.graphics.textAlign(3, 101);
                        this.graphics.text(this.valueLabel, (this.left + this.right) / 2.0f, this.bottom + this.getBorder(AbstractChart.Side.BOTTOM) + 2.0f);
                    } else {
                        this.graphics.textAlign(3, 102);
                        this.graphics.pushMatrix();
                        this.graphics.translate(this.left - (this.getBorder(AbstractChart.Side.LEFT) + 1.0f), (this.top + this.bottom) / 2.0f);
                        this.graphics.rotate(-1.5707964f);
                        this.graphics.text(this.valueLabel, 0.0f, 0.0f);
                        this.graphics.popMatrix();
                    }
                }
            }
            if (this.getShowAxis(0)) {
                this.graphics.strokeWeight(0.5f);
                this.graphics.stroke(this.axisColour);
                this.graphics.fill(this.axisValuesColour);
                i = 0;
                while (i < this.data[0].length) {
                    if (this.transposeAxes) {
                        this.graphics.textAlign(39, 3);
                        int n = index = this.reverseCats ? this.data[0].length - 1 - i : i;
                        if (!this.showLabels) {
                            this.graphics.text(this.axisFormatter[0].format(this.data[0][index]), this.left - 2.0f, this.top + barWidth / 2.0f + (float)i * (barWidth + this.barGap + this.barPad));
                        } else {
                            this.graphics.text(this.catLabels[index], this.left - 2.0f, this.top + barWidth / 2.0f + (float)i * (barWidth + this.barGap + this.barPad));
                        }
                    } else {
                        this.graphics.textAlign(3, 101);
                        int n = index = this.reverseCats ? this.data[0].length - 1 - i : i;
                        if (!this.showLabels) {
                            this.graphics.text(this.axisFormatter[0].format(this.data[0][index]), this.left + barWidth / 2.0f + (float)i * (barWidth + this.barGap + this.barPad), this.bottom + 2.0f);
                        } else {
                            this.graphics.text(this.catLabels[index], this.left + barWidth / 2.0f + (float)i * (barWidth + this.barGap + this.barPad), this.bottom + 2.0f);
                        }
                    }
                    ++i;
                }
                if (this.categoryLabel != null) {
                    this.graphics.fill(this.axisLabelColour);
                    if (this.transposeAxes) {
                        this.graphics.textAlign(3, 102);
                        this.graphics.pushMatrix();
                        this.graphics.translate(this.left - (this.getBorder(AbstractChart.Side.LEFT) + 1.0f), (this.top + this.bottom) / 2.0f);
                        this.graphics.rotate(-1.5707964f);
                        this.graphics.text(this.categoryLabel, 0.0f, 0.0f);
                        this.graphics.popMatrix();
                    } else {
                        this.graphics.textAlign(3, 101);
                        this.graphics.text(this.categoryLabel, (this.left + this.right) / 2.0f, this.bottom + this.getBorder(AbstractChart.Side.BOTTOM) + 2.0f);
                    }
                }
            }
        }
        this.graphics.popStyle();
    }

    public PVector getDataToScreen(PVector dataPoint) {
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        if (vRange <= 0.0f || hRange <= 0.0f) {
            return null;
        }
        float x = dataPoint.x / (float)(this.data[0].length - 1);
        float y = this.getIsLogScale(1) ? BarChart.convertToLog(dataPoint.y, this.getMinLog(1), this.getMaxLog(1)) : (dataPoint.y - this.getMin(1)) / (this.getMax(1) - this.getMin(1));
        if (this.transposeAxes) {
            float barWidth = (vRange - (float)(this.data[0].length - 1) * this.barGap - (float)this.data[0].length * this.barPad) / (float)this.data[0].length;
            return new PVector(this.left + hRange * y, this.bottom - barWidth / 2.0f - this.barPad / 2.0f - (vRange - barWidth - this.barPad) * x);
        }
        float barWidth = (hRange - (float)(this.data[0].length - 1) * this.barGap - (float)this.data[0].length * this.barPad) / (float)this.data[0].length;
        return new PVector(this.left + this.barPad / 2.0f + barWidth / 2.0f + (hRange - barWidth - this.barPad) * x, this.bottom - vRange * y);
    }

    public PVector getScreenToData(PVector screenPoint) {
        float x;
        float y;
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        if (vRange <= 0.0f || hRange <= 0.0f) {
            return null;
        }
        if (screenPoint.x < this.left || screenPoint.x >= this.right || screenPoint.y <= this.top || screenPoint.y > this.bottom) {
            return null;
        }
        if (this.transposeAxes) {
            y = (screenPoint.x - this.left) / hRange;
            x = (this.bottom - screenPoint.y) / vRange;
        } else {
            x = (screenPoint.x - this.left) / hRange;
            y = (this.bottom - screenPoint.y) / vRange;
        }
        x = (int)(x * (float)this.data[0].length);
        y = this.getIsLogScale(1) ? BarChart.convertFromLog(y, this.getMinLog(1), this.getMaxLog(1)) : y * (this.getMax(1) - this.getMin(1)) + this.getMin(1);
        return new PVector(x, y);
    }

    public int getNumBars() {
        return this.data[0].length;
    }

    public void setLogValues(boolean isLog) {
        this.setIsLogScale(1, isLog);
    }

    public void setMinValue(float minVal) {
        this.setMin(1, minVal);
    }

    public float getMinValue() {
        return this.getMin(1);
    }

    public float getMaxValue() {
        return this.getMax(1);
    }

    public void setMaxValue(float maxVal) {
        this.setMax(1, maxVal);
    }

    public void setCategoryAxisAt(float value) {
        this.catAxisPosition = new Float(value);
        if (value < this.getMin(1)) {
            this.setMinValue(value);
        } else if (value > this.getMax(1)) {
            this.setMaxValue(value);
        }
    }

    public void setBarLabels(String[] labels) {
        if (labels == null) {
            this.showLabels = false;
            if (this.getShowAxis(0)) {
                this.setMinBorder(0.0f, this.transposeAxes ? AbstractChart.Side.LEFT : AbstractChart.Side.BOTTOM);
                this.showAxis(0, true, this.transposeAxes ? AbstractChart.Side.LEFT : AbstractChart.Side.BOTTOM);
            }
            return;
        }
        if (labels.length != this.data[0].length) {
            System.err.println("Warning: Number of labels (" + labels.length + ") does not match number of bars (" + this.data[0].length + ").");
            return;
        }
        this.catLabels = labels;
        this.showLabels = true;
        float border = this.getMinBorder();
        if (this.transposeAxes) {
            String[] stringArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                border = Math.max(border, this.graphics.textWidth(label));
                ++n2;
            }
            this.setMinBorder(border + 2.0f, AbstractChart.Side.LEFT);
        }
    }

    public void showValueAxis(boolean showAxis) {
        super.showAxis(1, showAxis, this.transposeAxes ? AbstractChart.Side.BOTTOM : AbstractChart.Side.LEFT);
    }

    public void showCategoryAxis(boolean showAxis) {
        super.showAxis(0, showAxis, this.transposeAxes ? AbstractChart.Side.LEFT : AbstractChart.Side.BOTTOM);
        if (showAxis && this.showLabels) {
            this.setBarLabels(this.catLabels);
        }
    }

    public void transposeAxes(boolean transpose) {
        this.transposeAxes = transpose;
        this.updateLayout();
    }

    public void updateLayout() {
        boolean showCategoryAxis = this.getShowAxis(0);
        boolean showValueAxis = this.getShowAxis(1);
        this.showCategoryAxis(!showCategoryAxis);
        this.showValueAxis(!showValueAxis);
        this.showCategoryAxis(showCategoryAxis);
        this.showValueAxis(showValueAxis);
    }

    public void setBarGap(float gap) {
        this.barGap = gap;
    }

    public void setBarPadding(float padding) {
        this.barPad = padding;
    }

    public void setReverseCategories(boolean reverse) {
        this.reverseCats = reverse;
    }

    public void setValueFormat(String format) {
        this.setFormat(1, format);
    }

    public void setCategoryFormat(String format) {
        this.setFormat(0, format);
    }

    public void setCategoryAxisLabel(String label) {
        this.categoryLabel = label;
    }

    public void setValueAxisLabel(String label) {
        this.valueLabel = label;
    }

    public void setBarColour(int colour) {
        this.barColour = colour;
        this.cTable = null;
        this.data[2] = null;
    }

    public void setBarColour(float[] colourData, ColourTable cTable) {
        if (colourData.length != this.data[1].length) {
            System.err.println("Warning: Number of items in bar colour data (" + colourData.length + ") does not match number of bars (" + this.data[1].length + ").");
            return;
        }
        this.cTable = cTable;
        this.setData(2, colourData);
    }
}

