/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.stat;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import org.gicentre.utils.colour.ColourTable;
import org.gicentre.utils.move.Ease;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikertChart {
    private LikertChart chart2;
    private float[] frequencies;
    private float[] targetFrequencies;
    private float maxHeight;
    private float minHeight;
    private float numDontKnow;
    private float numMissing;
    private float numNA;
    private float targetMaxHeight;
    private float targetMinHeight;
    private float targetNumDontKnow;
    private float targetNumMissing;
    private float targetNumNA;
    private float currentMean;
    private float currentConsensus;
    private String title;
    private String longTitle;
    private int midBar;
    private int numBars;
    private ColourTable cTable;
    private int secondaryColour;
    private int textColour;
    private float secondaryLineWidth;
    private float widthScale;
    private float heightScale;
    private boolean showTitle;
    private boolean showSecondary;
    private boolean animateToBars;
    private boolean animateFromBars;
    private boolean scaleByPrimary;
    private Rectangle2D lastBounds;
    private int highlightBar;
    private float mean;
    private float consensus;
    private float targetMean;
    private float targetConsensus;
    private float order;
    private float interp;
    private float animSpeed;
    private float textSize;
    private float textPadding;
    private static final double LOG2 = Math.log(2.0);

    public LikertChart(float[] frequencies) {
        this(frequencies, 0.0f, 0.0f, 0.0f, null);
    }

    public LikertChart(float[] frequencies, float maxHeight, float minHeight) {
        this(frequencies, 0.0f, 0.0f, 0.0f, null);
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
    }

    public LikertChart(float[] frequencies, float numDontKnow, float numNA, float numMissing, String title) {
        this(frequencies, numDontKnow, numNA, numMissing, title, null);
    }

    public LikertChart(float[] frequencies, float numDontKnow, float numNA, float numMissing, String title, String longTitle) {
        this.frequencies = frequencies;
        this.numDontKnow = numDontKnow;
        this.numNA = numNA;
        this.numMissing = numMissing;
        this.title = title;
        this.longTitle = longTitle;
        this.showTitle = false;
        this.widthScale = 0.5f;
        this.heightScale = 1.0f;
        this.animateToBars = false;
        this.animateFromBars = false;
        this.scaleByPrimary = true;
        this.showSecondary = true;
        this.order = 0.0f;
        this.interp = 1.0f;
        this.animSpeed = 0.04f;
        this.textSize = -1.0f;
        this.textPadding = 0.0f;
        this.numBars = frequencies.length;
        this.midBar = (this.numBars - 1) / 2;
        this.cTable = ColourTable.getPresetColourTable(219, -1.0f, 1.0f);
        this.secondaryColour = new Color(100, 0, 30, 150).getRGB();
        this.secondaryLineWidth = 2.0f;
        this.textColour = new Color(150, 150, 150).getRGB();
        this.highlightBar = -1;
        this.maxHeight = -3.4028235E38f;
        this.minHeight = 0.0f;
        int i = 0;
        while (i < this.numBars) {
            if (this.maxHeight < frequencies[i]) {
                this.maxHeight = frequencies[i];
            }
            if (this.minHeight > frequencies[i]) {
                this.minHeight = frequencies[i];
            }
            ++i;
        }
        if (this.numBars % 2 == 1) {
            this.maxHeight = Math.max(this.maxHeight, frequencies[(this.numBars - 1) / 2] + numDontKnow + numNA + numMissing);
        }
        this.mean = 0.0f;
        this.consensus = 0.0f;
        if (this.minHeight >= 0.0f) {
            float total = 0.0f;
            int dx = this.numBars - 1;
            int i2 = 0;
            while (i2 < this.numBars) {
                total += frequencies[i2];
                this.mean += frequencies[i2] * (float)(i2 + 1);
                ++i2;
            }
            this.mean /= total;
            i2 = 0;
            while (i2 < this.numBars) {
                this.consensus = (float)((double)this.consensus + (double)(frequencies[i2] / total) * Math.log(1.0f - Math.abs((float)(i2 + 1) - this.mean) / (float)dx) / LOG2);
                ++i2;
            }
            this.consensus += 1.0f;
        }
    }

    public void draw(PApplet parent, Rectangle2D bounds) {
        this.draw(parent, bounds, null);
    }

    public void draw(PApplet parent, Rectangle2D bounds, PFont font) {
        float barGap;
        float currentMinHeight;
        float currentMaxHeight;
        this.lastBounds = bounds;
        parent.pushStyle();
        parent.strokeWeight(0.2f);
        parent.ellipseMode(3);
        float padding = (float)bounds.getWidth() / 20.0f;
        float barSpace = (float)(bounds.getWidth() - (double)(2.0f * padding)) / (float)this.numBars;
        float originX = (float)bounds.getX() + padding;
        float easedHeightScale = 0.0f;
        float yScale = 0.0f;
        if (this.scaleByPrimary || this.chart2 == null) {
            currentMaxHeight = this.maxHeight;
            currentMinHeight = this.minHeight;
        } else {
            currentMaxHeight = this.chart2.maxHeight;
            currentMinHeight = this.chart2.minHeight;
        }
        float currentNumDontKnow = this.numDontKnow;
        float currentNumDontKnow2 = 0.0f;
        float[] currentFrequencies = new float[this.numBars];
        float[] currentFrequencies2 = null;
        System.arraycopy(this.frequencies, 0, currentFrequencies, 0, this.numBars);
        this.currentMean = this.mean;
        this.currentConsensus = this.consensus;
        if (this.chart2 != null) {
            currentNumDontKnow2 = this.chart2.numDontKnow;
            currentFrequencies2 = new float[this.chart2.numBars];
            System.arraycopy(this.chart2.frequencies, 0, currentFrequencies2, 0, this.chart2.numBars);
            this.interp = Math.min(this.interp, this.chart2.interp);
            this.chart2.currentMean = this.chart2.mean;
            this.chart2.currentConsensus = this.chart2.consensus;
        }
        if (this.interp < 1.0f) {
            int i;
            float toSourceScale;
            this.interp += this.animSpeed;
            if (this.chart2 != null) {
                this.chart2.interp = this.interp;
            }
            if (this.targetFrequencies != null) {
                toSourceScale = (this.maxHeight - this.minHeight) / (this.targetMaxHeight - this.targetMinHeight);
                currentNumDontKnow = PApplet.lerp((float)this.numDontKnow, (float)(toSourceScale * this.targetNumDontKnow), (float)this.interp);
                i = 0;
                while (i < this.numBars) {
                    currentFrequencies[i] = PApplet.lerp((float)currentFrequencies[i], (float)(toSourceScale * this.targetFrequencies[i]), (float)this.interp);
                    ++i;
                }
                this.currentMean = PApplet.lerp((float)this.mean, (float)this.targetMean, (float)this.interp);
                this.currentConsensus = PApplet.lerp((float)this.consensus, (float)this.targetConsensus, (float)this.interp);
            }
            if (this.chart2 != null && currentFrequencies2 != null) {
                if (this.chart2.targetFrequencies == null) {
                    toSourceScale = this.scaleByPrimary ? (currentMaxHeight - currentMinHeight) / (this.targetMaxHeight - this.targetMinHeight) : (currentMaxHeight - currentMinHeight) / (this.chart2.maxHeight - this.chart2.minHeight);
                    currentNumDontKnow2 = PApplet.lerp((float)this.chart2.numDontKnow, (float)(toSourceScale * this.chart2.numDontKnow), (float)this.interp);
                    i = 0;
                    while (i < this.numBars) {
                        currentFrequencies2[i] = PApplet.lerp((float)currentFrequencies2[i], (float)(toSourceScale * currentFrequencies2[i]), (float)this.interp);
                        ++i;
                    }
                } else {
                    toSourceScale = this.scaleByPrimary ? 1.0f : (currentMaxHeight - currentMinHeight) / (this.chart2.targetMaxHeight - this.chart2.targetMinHeight);
                    currentNumDontKnow2 = PApplet.lerp((float)this.chart2.numDontKnow, (float)(toSourceScale * this.chart2.targetNumDontKnow), (float)this.interp);
                    i = 0;
                    while (i < this.chart2.numBars) {
                        currentFrequencies2[i] = PApplet.lerp((float)currentFrequencies2[i], (float)(toSourceScale * this.chart2.targetFrequencies[i]), (float)this.interp);
                        ++i;
                    }
                    this.chart2.currentMean = PApplet.lerp((float)this.chart2.mean, (float)this.chart2.targetMean, (float)this.interp);
                    this.chart2.currentConsensus = PApplet.lerp((float)this.chart2.consensus, (float)this.chart2.targetConsensus, (float)this.interp);
                }
            }
            if (this.interp >= 1.0f) {
                if (this.targetFrequencies != null) {
                    this.interp = 1.0f;
                    this.maxHeight = this.targetMaxHeight;
                    this.minHeight = this.targetMinHeight;
                    this.numDontKnow = this.targetNumDontKnow;
                    this.numMissing = this.targetNumMissing;
                    this.numNA = this.targetNumNA;
                    System.arraycopy(this.targetFrequencies, 0, this.frequencies, 0, this.numBars);
                    this.mean = this.targetMean;
                    this.consensus = this.targetConsensus;
                    this.resetTarget();
                }
                if (this.chart2 != null && this.chart2.targetFrequencies != null) {
                    this.chart2.interp = 1.0f;
                    this.chart2.maxHeight = this.chart2.targetMaxHeight;
                    this.chart2.minHeight = this.chart2.targetMinHeight;
                    this.chart2.numDontKnow = this.chart2.targetNumDontKnow;
                    this.chart2.numMissing = this.chart2.targetNumMissing;
                    this.chart2.numNA = this.chart2.targetNumNA;
                    System.arraycopy(this.chart2.targetFrequencies, 0, this.chart2.frequencies, 0, this.chart2.numBars);
                    this.chart2.mean = this.chart2.targetMean;
                    this.chart2.consensus = this.chart2.targetConsensus;
                    this.chart2.resetTarget();
                }
            }
        }
        float negScale = (float)(bounds.getHeight() - (double)(2.0f * padding)) / (currentMaxHeight - currentMinHeight);
        float originY = (float)(bounds.getY() + bounds.getHeight() + (double)(currentMinHeight * negScale) - (double)padding);
        if (this.animateToBars) {
            this.heightScale += this.animSpeed;
            if (this.heightScale >= 1.0f) {
                this.heightScale = 1.0f;
                this.animateToBars = false;
            }
        } else if (this.animateFromBars) {
            this.heightScale -= this.animSpeed;
            if (this.heightScale <= 0.0f) {
                this.heightScale = 0.0f;
                this.animateFromBars = false;
            }
        }
        float ticHeight = 10.0f;
        if (this.heightScale > 0.0f) {
            float barTop;
            parent.noStroke();
            easedHeightScale = Ease.sinBoth(this.heightScale);
            ticHeight *= 1.0f - easedHeightScale;
            yScale = (float)(bounds.getHeight() - (double)(2.0f * padding)) * easedHeightScale / (currentMaxHeight - currentMinHeight);
            barGap = barSpace * (1.0f - this.widthScale);
            float x = originX - 0.5f * barGap;
            float spaceScaling1 = barSpace * (float)this.numBars / (barSpace * (float)this.numBars - barGap);
            int bar = 0;
            while (bar < this.numBars) {
                int colour = this.cTable.findColour(((float)bar - (float)(this.numBars - 1) / 2.0f) / (float)(this.numBars - 1));
                parent.fill(colour);
                if (bar == this.highlightBar) {
                    parent.stroke(this.secondaryColour);
                    parent.strokeWeight(2.0f);
                } else {
                    parent.stroke(colour);
                    parent.strokeWeight(0.2f);
                }
                float barTop2 = originY - currentFrequencies[bar] * yScale;
                if ((double)barTop2 < bounds.getY() + (double)padding - 1.0) {
                    float barLeft = x + barGap * 0.5f;
                    float barRight = barLeft + (barSpace - barGap) * spaceScaling1;
                    parent.beginShape();
                    parent.vertex(barLeft, originY);
                    parent.vertex(barLeft, (float)bounds.getY() + padding);
                    parent.vertex((barLeft + barRight) / 2.0f, (float)bounds.getY());
                    parent.vertex(barRight, (float)bounds.getY() + padding);
                    parent.vertex(barRight, originY);
                    parent.endShape(2);
                } else {
                    parent.rect(x + barGap * 0.5f, originY - currentFrequencies[bar] * yScale, (barSpace - barGap) * spaceScaling1, currentFrequencies[bar] * yScale);
                }
                x += barSpace * spaceScaling1;
                ++bar;
            }
            if (this.numBars % 2 == 1 && (double)(barTop = originY - (currentFrequencies[this.midBar] + currentNumDontKnow) * yScale) >= bounds.getY() + (double)padding) {
                if (this.midBar == this.highlightBar) {
                    parent.stroke(this.secondaryColour);
                    parent.strokeWeight(2.0f);
                } else {
                    parent.stroke(0);
                    parent.strokeWeight(0.2f);
                }
                parent.noFill();
                parent.rect(originX + barSpace * (float)this.midBar + 0.5f * barGap, originY - (currentFrequencies[this.midBar] + currentNumDontKnow) * yScale, barSpace - barGap, (currentFrequencies[this.midBar] + currentNumDontKnow) * yScale);
            }
            if (this.chart2 != null && this.showSecondary && currentFrequencies2 != null) {
                float barTop3;
                parent.fill(this.secondaryColour);
                parent.noStroke();
                float secondaryPadding = 5.0f;
                x = originX - 0.5f * barGap;
                float barSpace2 = (float)(bounds.getWidth() - (double)(2.0f * padding)) / (float)this.chart2.numBars;
                float spaceScaling2 = barSpace2 * (float)this.chart2.numBars / (barSpace2 * (float)this.chart2.numBars - barGap);
                int bar2 = 0;
                while (bar2 < this.chart2.numBars) {
                    float barTop4 = originY - currentFrequencies2[bar2] * yScale;
                    if ((double)barTop4 < bounds.getY() + (double)padding - 1.0) {
                        float barLeft = x + barGap * 0.5f + secondaryPadding;
                        float barRight = barLeft + (barSpace2 - barGap) * spaceScaling2 - 2.0f * secondaryPadding;
                        parent.beginShape();
                        parent.vertex(barLeft, originY);
                        parent.vertex(barLeft, (float)bounds.getY() + padding);
                        parent.vertex((barLeft + barRight) / 2.0f, (float)bounds.getY());
                        parent.vertex(barRight, (float)bounds.getY() + padding);
                        parent.vertex(barRight, originY);
                        parent.endShape(2);
                    } else {
                        parent.rect(x + barGap * 0.5f + secondaryPadding, barTop4, (barSpace2 - barGap) * spaceScaling2 - 2.0f * secondaryPadding, currentFrequencies2[bar2] * yScale);
                    }
                    x += barSpace * spaceScaling2;
                    ++bar2;
                }
                if (this.chart2.numBars % 2 == 1 && (double)(barTop3 = originY - currentFrequencies2[this.chart2.midBar] * yScale) >= bounds.getY() + (double)padding) {
                    parent.stroke(this.secondaryColour);
                    parent.noFill();
                    parent.rect(originX + barSpace2 * (float)this.chart2.midBar + 0.5f * barGap + secondaryPadding, originY - (currentFrequencies2[this.chart2.midBar] + currentNumDontKnow2) * yScale, barSpace2 - barGap - 2.0f * secondaryPadding, (currentFrequencies2[this.chart2.midBar] + currentNumDontKnow2) * yScale);
                }
            }
            parent.stroke(0);
            parent.strokeWeight(0.2f);
            float midpointX = originX + barSpace * (float)this.numBars / 2.0f;
            float axisHeight = easedHeightScale * currentMaxHeight * yScale;
            parent.line(midpointX, originY, midpointX, originY - axisHeight);
            axisHeight = easedHeightScale * currentMinHeight * yScale;
            parent.line(midpointX, originY, midpointX, originY - axisHeight);
        }
        if (this.heightScale < 1.0f) {
            parent.stroke(0);
            float midpointX = originX + barSpace * (float)this.numBars / 2.0f;
            float rightPointX = originX + (float)this.numBars * barSpace;
            parent.line(midpointX, originY - ticHeight, midpointX, originY + ticHeight);
            parent.line(originX, originY - ticHeight / 5.0f, originX, originY + ticHeight / 5.0f);
            parent.line(rightPointX, originY - ticHeight / 5.0f, rightPointX, originY + ticHeight / 5.0f);
        }
        parent.line(originX, originY, (float)((double)originX + bounds.getWidth() - (double)(2.0f * padding)), originY);
        if (currentMinHeight >= 0.0f) {
            parent.strokeWeight(3.0f);
            parent.stroke(150);
            parent.fill(this.cTable.findColour((this.currentMean - 1.0f - (float)(this.numBars - 1) / 2.0f) / (float)(this.numBars - 1)));
            barGap = barSpace * (1.0f - this.widthScale);
            float spaceScaling = barSpace * (float)this.numBars / (barSpace * (float)this.numBars - barGap);
            float meanX = originX - spaceScaling * (0.5f * barGap - barSpace * (this.currentMean - 0.5f));
            float dissentWidth = (float)((double)(1.0f - this.currentConsensus) * (bounds.getWidth() - (double)(2.0f * padding)) / 2.0);
            float meanSize = (float)bounds.getWidth() / 15.0f;
            parent.line(meanX - dissentWidth, originY, meanX + dissentWidth, originY);
            parent.ellipse(meanX, originY, meanSize, meanSize);
        }
        if (this.chart2 != null && this.showSecondary && this.chart2.minHeight >= 0.0f) {
            parent.strokeWeight(this.secondaryLineWidth);
            parent.stroke(this.secondaryColour);
            parent.fill(parent.color(255, 100));
            float barSpace2 = (float)(bounds.getWidth() - (double)(2.0f * padding)) / (float)this.chart2.numBars;
            float barGap2 = barSpace2 * (1.0f - this.widthScale);
            float spaceScaling = barSpace2 * (float)this.chart2.numBars / (barSpace2 * (float)this.chart2.numBars - barGap2);
            float meanX = originX - spaceScaling * (0.5f * barGap2 - barSpace2 * (this.chart2.currentMean - 0.5f));
            float dissentWidth = (float)((double)(1.0f - this.chart2.currentConsensus) * (bounds.getWidth() - (double)(2.0f * padding)) / 2.0);
            float meanSize = (float)bounds.getWidth() / 30.0f;
            parent.ellipse(meanX, originY, meanSize, meanSize);
            parent.line(meanX - dissentWidth, originY, meanX + dissentWidth, originY);
        }
        if (this.showTitle && font != null) {
            parent.fill(this.textColour);
            float textHeight = this.textSize;
            if (textHeight < 0.0f) {
                textHeight = (float)Math.max(6.0, Math.min(bounds.getHeight() / 5.0, bounds.getWidth() / 20.0));
            }
            parent.textFont(font, textHeight);
            String displayedTitle = this.title.trim();
            float textWidth = parent.textWidth(displayedTitle);
            if ((double)textWidth > bounds.getWidth() - (double)padding) {
                float ellipsisWidth = parent.textWidth("...");
                while ((double)textWidth > bounds.getWidth() - (double)padding - (double)ellipsisWidth) {
                    displayedTitle = displayedTitle.substring(0, displayedTitle.length() - 2);
                    textWidth = parent.textWidth(displayedTitle);
                }
                displayedTitle = String.valueOf(displayedTitle) + "...";
            }
            parent.text(displayedTitle, originX, originY - textHeight / 2.0f - easedHeightScale * (currentMaxHeight * yScale - textHeight / 2.0f) - this.textPadding);
        }
        parent.popStyle();
    }

    public void setColourTable(ColourTable cTable) {
        this.cTable = cTable;
    }

    public void setWidthScale(float widthScale) {
        this.widthScale = widthScale;
    }

    public void setShowBars(boolean showBars) {
        this.heightScale = showBars ? 1.0f : 0.0f;
        this.animateToBars = false;
        this.animateFromBars = false;
    }

    public void setSecondaryChart(LikertChart secondaryChart) {
        this.chart2 = secondaryChart;
    }

    public void setSecondaryDisplay(boolean showSecondary) {
        this.showSecondary = showSecondary;
    }

    public void setSecondaryColour(int colour) {
        this.secondaryColour = colour;
    }

    public void setSecondaryLineWidth(float width) {
        this.secondaryLineWidth = width;
    }

    public int getSecondaryColour() {
        return this.secondaryColour;
    }

    public void setTextColour(int colour) {
        this.textColour = colour;
    }

    public int getTextColour() {
        return this.textColour;
    }

    public void setHighlightBar(int barIndex) {
        this.highlightBar = barIndex;
    }

    public int getHighlightBar() {
        return this.highlightBar;
    }

    public int getBarAt(float xCoord, float yCoord) {
        float currentMinHeight;
        float currentMaxHeight;
        if (this.heightScale <= 0.0f) {
            return -1;
        }
        if (this.lastBounds == null) {
            return -1;
        }
        if (!this.lastBounds.contains(xCoord, yCoord)) {
            return -1;
        }
        if (this.scaleByPrimary || this.chart2 == null) {
            currentMaxHeight = this.maxHeight;
            currentMinHeight = this.minHeight;
        } else {
            currentMaxHeight = this.chart2.maxHeight;
            currentMinHeight = this.chart2.minHeight;
        }
        float padding = (float)this.lastBounds.getWidth() / 20.0f;
        float yScale = (float)(this.lastBounds.getHeight() - (double)(2.0f * padding)) / (currentMaxHeight - currentMinHeight);
        float originY = (float)(this.lastBounds.getY() + this.lastBounds.getHeight() + (double)(currentMinHeight * yScale) - (double)padding);
        if ((double)yCoord <= this.lastBounds.getY() + (double)padding || yCoord > originY) {
            return -1;
        }
        float barSpace = (float)(this.lastBounds.getWidth() - (double)(2.0f * padding)) / (float)this.numBars;
        float barGap = barSpace * (1.0f - this.widthScale);
        float originX = (float)this.lastBounds.getX() + padding;
        float x = originX - 0.5f * barGap;
        float spaceScaling = barSpace * (float)this.numBars / (barSpace * (float)this.numBars - barGap);
        int bar = 0;
        while (bar < this.numBars) {
            float barTop = originY - this.frequencies[bar] * yScale;
            float barLeft = x + barGap * 0.5f;
            float barRight = barLeft + (barSpace - barGap) * spaceScaling;
            if (xCoord >= barLeft && xCoord <= barRight && yCoord >= barTop) {
                return bar;
            }
            x += barSpace * spaceScaling;
            ++bar;
        }
        return -1;
    }

    public void animateToBars() {
        this.animateToBars = true;
        this.animateFromBars = false;
    }

    public void animateFromBars() {
        this.animateFromBars = true;
        this.animateToBars = false;
    }

    public void animateToNewValues(float[] newFrequencies, float newNumDontKnow, float newNumNA, float newNumMissing) {
        this.resetTarget();
        this.targetFrequencies = newFrequencies;
        this.interp = 0.0f;
        int i = 0;
        while (i < this.numBars) {
            if (this.targetMaxHeight < newFrequencies[i]) {
                this.targetMaxHeight = newFrequencies[i];
            }
            if (this.targetMinHeight > newFrequencies[i]) {
                this.targetMinHeight = newFrequencies[i];
            }
            ++i;
        }
        if (this.numBars % 2 == 1) {
            this.targetMaxHeight = Math.max(this.targetMaxHeight, newFrequencies[(this.numBars - 1) / 2] + newNumDontKnow + newNumNA + newNumMissing);
        }
        if (this.targetMinHeight >= 0.0f) {
            float total = 0.0f;
            int dx = this.numBars - 1;
            int i2 = 0;
            while (i2 < this.numBars) {
                total += newFrequencies[i2];
                this.targetMean += newFrequencies[i2] * (float)(i2 + 1);
                ++i2;
            }
            this.targetMean /= total;
            i2 = 0;
            while (i2 < this.numBars) {
                this.targetConsensus = (float)((double)this.targetConsensus + (double)(newFrequencies[i2] / total) * Math.log(1.0f - Math.abs((float)(i2 + 1) - this.targetMean) / (float)dx) / LOG2);
                ++i2;
            }
            this.targetConsensus += 1.0f;
        }
    }

    public float getWidthScale() {
        return this.widthScale;
    }

    public float[] getFrequencies() {
        return this.frequencies;
    }

    public LikertChart getSecondaryData() {
        return this.chart2;
    }

    public void setScaleToPrimary(boolean usePrimary) {
        this.scaleByPrimary = usePrimary;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLongTitle() {
        return this.longTitle;
    }

    public float getMean() {
        return this.mean;
    }

    public float getConsensus() {
        return this.consensus;
    }

    public void setOrder(float order) {
        this.order = order;
    }

    public void setAnimationSpeed(float numFrames) {
        this.animSpeed = numFrames <= 0.0f ? 1.0f : 1.0f / numFrames;
    }

    public float getAnimationSpeed() {
        return 1.0f / this.animSpeed;
    }

    public void setTextSize(float size) {
        this.textSize = size;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextPadding(float padding) {
        this.textPadding = padding;
    }

    public float getTextPadding() {
        return this.textPadding;
    }

    public float getOrder() {
        return this.order;
    }

    private void resetTarget() {
        this.targetFrequencies = null;
        this.targetNumDontKnow = this.numDontKnow;
        this.targetNumNA = this.numNA;
        this.targetNumMissing = this.numMissing;
        this.targetMaxHeight = -3.4028235E38f;
        this.targetMinHeight = 0.0f;
        this.targetMean = 0.0f;
        this.targetConsensus = 0.0f;
    }

    public static Comparator<LikertChart> getCustomComparator() {
        return new CustomComparator();
    }

    public static Comparator<LikertChart> getMeanComparator() {
        return new MeanComparator();
    }

    public static Comparator<LikertChart> getConsensusComparator() {
        return new ConsensusComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsensusComparator
    implements Comparator<LikertChart> {
        @Override
        public int compare(LikertChart chart1, LikertChart chart2) {
            if (chart1.getConsensus() > chart2.getConsensus()) {
                return -1;
            }
            if (chart1.getConsensus() < chart2.getConsensus()) {
                return 1;
            }
            if (chart1.getMean() < chart2.getMean()) {
                return -1;
            }
            if (chart1.getMean() > chart2.getMean()) {
                return 1;
            }
            if (chart1.getOrder() < chart2.getOrder()) {
                return -1;
            }
            if (chart1.getOrder() > chart2.getOrder()) {
                return 1;
            }
            if (chart1.hashCode() < chart2.hashCode()) {
                return -1;
            }
            if (chart1.hashCode() > chart2.hashCode()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomComparator
    implements Comparator<LikertChart> {
        @Override
        public int compare(LikertChart chart1, LikertChart chart2) {
            if (chart1.getOrder() < chart2.getOrder()) {
                return -1;
            }
            if (chart1.getOrder() > chart2.getOrder()) {
                return 1;
            }
            if (chart1.hashCode() < chart2.hashCode()) {
                return -1;
            }
            if (chart1.hashCode() > chart2.hashCode()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MeanComparator
    implements Comparator<LikertChart> {
        @Override
        public int compare(LikertChart chart1, LikertChart chart2) {
            if (chart1.getMean() > chart2.getMean()) {
                return -1;
            }
            if (chart1.getMean() < chart2.getMean()) {
                return 1;
            }
            if (chart1.getOrder() < chart2.getOrder()) {
                return -1;
            }
            if (chart1.getOrder() > chart2.getOrder()) {
                return 1;
            }
            if (chart1.hashCode() < chart2.hashCode()) {
                return -1;
            }
            if (chart1.hashCode() > chart2.hashCode()) {
                return 1;
            }
            return 0;
        }
    }
}

