/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.stat;

import java.util.List;
import org.gicentre.utils.colour.ColourTable;
import org.gicentre.utils.stat.AbstractChart;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYChart
extends AbstractChart {
    private int pointColour;
    private int lineColour;
    private float pointSize;
    private float lineWidth;
    private ColourTable cTable;
    private float maxPointSize;
    private Float xAxisPosition;
    private Float yAxisPosition;
    private String xLabel;
    private String yLabel;
    private float top;
    private float left;
    private float bottom;
    private float right;
    private float leftSpace;
    private float rightSpace;
    private float topSpace;
    private float bottomSpace;

    public XYChart(PApplet parent) {
        super(parent);
        this.pointColour = this.graphics.color(120);
        this.lineColour = this.graphics.color(120);
        this.pointSize = 4.0f;
        this.lineWidth = 0.0f;
        this.maxPointSize = 0.0f;
        this.cTable = null;
        this.xAxisPosition = null;
        this.yAxisPosition = null;
        this.xLabel = null;
        this.yLabel = null;
        this.top = 0.0f;
        this.bottom = 0.0f;
        this.left = 0.0f;
        this.right = 0.0f;
        this.calcDataSpacing();
    }

    public void setData(float[] xValues, float[] yValues) {
        if (xValues.length != yValues.length) {
            System.err.println("Warning: Number of x and y coordinates given to XYChart.setData() do not match (" + xValues.length + " and " + yValues.length + ").");
            return;
        }
        this.setData(0, xValues);
        this.setData(1, yValues);
    }

    public void setData(List<PVector> data) {
        float[] xVals = new float[data.size()];
        float[] yVals = new float[data.size()];
        int i = 0;
        while (i < data.size()) {
            PVector dataPair = data.get(i);
            xVals[i] = dataPair.x;
            yVals[i] = dataPair.y;
            ++i;
        }
        this.setData(0, xVals);
        this.setData(1, yVals);
    }

    @Override
    public void draw(float xOrigin, float yOrigin, float width, float height) {
        if (this.data[0] == null || this.data[1] == null) {
            return;
        }
        int strokeColour = this.graphics.strokeColor;
        this.graphics.pushStyle();
        this.calcDataSpacing();
        this.left = xOrigin + this.leftSpace;
        this.right = xOrigin + width - this.rightSpace;
        this.bottom = yOrigin + height - this.bottomSpace;
        this.top = yOrigin + this.topSpace;
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        if (this.lineWidth > 0.0f) {
            this.graphics.noFill();
            this.graphics.stroke(this.lineColour);
            this.graphics.strokeWeight(this.lineWidth);
            float prevX = 0.0f;
            float prevY = 0.0f;
            int i = 0;
            while (i < this.data[0].length) {
                float xValue = Math.max(Math.min(this.data[0][i], this.getMax(0)), this.getMin(0));
                float yValue = Math.max(Math.min(this.data[1][i], this.getMax(1)), this.getMin(1));
                float x = this.getIsLogScale(0) ? XYChart.convertToLog(xValue, this.getMinLog(0), this.getMaxLog(0)) : (xValue - this.getMin(0)) / (this.getMax(0) - this.getMin(0));
                float y = this.getIsLogScale(1) ? XYChart.convertToLog(yValue, this.getMinLog(1), this.getMaxLog(1)) : (yValue - this.getMin(1)) / (this.getMax(1) - this.getMin(1));
                if (this.transposeAxes) {
                    if (i > 0) {
                        this.renderer.line(prevX, prevY, this.left + hRange * y, this.bottom - vRange * x);
                    }
                    prevX = this.left + hRange * y;
                    prevY = this.bottom - vRange * x;
                } else {
                    if (i > 0) {
                        this.renderer.line(prevX, prevY, this.left + hRange * x, this.bottom - vRange * y);
                    }
                    prevX = this.left + hRange * x;
                    prevY = this.bottom - vRange * y;
                }
                ++i;
            }
        }
        if (this.pointSize > 0.0f || this.maxPointSize > 0.0f) {
            if (this.cTable == null) {
                this.graphics.fill(this.pointColour);
            }
            if (this.showEdge) {
                this.graphics.stroke(strokeColour);
            } else {
                this.graphics.noStroke();
            }
            int i = 0;
            while (i < this.data[0].length) {
                if (this.cTable != null) {
                    this.graphics.fill(this.cTable.findColour(this.data[2][i]));
                }
                float xValue = Math.max(Math.min(this.data[0][i], this.getMax(0)), this.getMin(0));
                float yValue = Math.max(Math.min(this.data[1][i], this.getMax(1)), this.getMin(1));
                float x = this.getIsLogScale(0) ? XYChart.convertToLog(xValue, this.getMinLog(0), this.getMaxLog(0)) : (xValue - this.getMin(0)) / (this.getMax(0) - this.getMin(0));
                float y = this.getIsLogScale(1) ? XYChart.convertToLog(yValue, this.getMinLog(1), this.getMaxLog(1)) : (yValue - this.getMin(1)) / (this.getMax(1) - this.getMin(1));
                if (this.maxPointSize > 0.0f) {
                    float radius = (float)((double)this.maxPointSize * Math.sqrt(this.data[3][i] / this.getMax(3)));
                    if (this.transposeAxes) {
                        this.renderer.ellipse(this.left + hRange * y, this.bottom - vRange * x, radius, radius);
                    } else {
                        this.renderer.ellipse(this.left + hRange * x, this.bottom - vRange * y, radius, radius);
                    }
                } else if (this.transposeAxes) {
                    this.renderer.ellipse(this.left + hRange * y, this.bottom - vRange * x, this.pointSize, this.pointSize);
                } else {
                    this.renderer.ellipse(this.left + hRange * x, this.bottom - vRange * y, this.pointSize, this.pointSize);
                }
                ++i;
            }
        }
        if (this.drawDecorations) {
            float ticOffset;
            float tic;
            float axisPosition;
            int firstTic;
            float textHeight = this.graphics.textAscent();
            boolean showSingleOriginValue = false;
            if (this.getShowAxis(0) && this.getShowAxis(1) && this.axisFormatter[0].format(this.tics[0][0]).equals(this.axisFormatter[1].format(this.tics[1][0]))) {
                showSingleOriginValue = true;
            }
            int n = firstTic = showSingleOriginValue ? 1 : 0;
            if (this.getShowAxis(0)) {
                int i;
                this.graphics.strokeWeight(0.5f);
                this.graphics.stroke(this.axisColour);
                if (this.transposeAxes) {
                    axisPosition = this.left;
                    if (this.xAxisPosition != null) {
                        axisPosition = this.getIsLogScale(0) ? (float)((double)this.left + (double)hRange * (Math.log10(this.xAxisPosition.doubleValue()) - (double)this.getMinLog(1)) / (double)(this.getMaxLog(1) - this.getMinLog(1))) : (float)((double)this.left + (double)hRange * (this.xAxisPosition.doubleValue() - (double)this.getMin(1)) / (double)(this.getMax(1) - this.getMin(1)));
                    }
                    this.renderer.line(axisPosition, this.bottom, axisPosition, this.top);
                } else {
                    axisPosition = this.bottom;
                    if (this.xAxisPosition != null) {
                        axisPosition = this.getIsLogScale(0) ? (float)((double)this.top + (double)vRange * ((double)this.getMaxLog(1) - Math.log10(this.xAxisPosition.doubleValue())) / (double)(this.getMaxLog(1) - this.getMinLog(1))) : (float)((double)this.top + (double)vRange * ((double)this.getMax(1) - this.xAxisPosition.doubleValue()) / (double)(this.getMax(1) - this.getMin(1)));
                    }
                    this.renderer.line(this.left, axisPosition, this.right, axisPosition);
                }
                this.graphics.fill(this.axisValuesColour);
                if (this.getIsLogScale(0)) {
                    i = firstTic;
                    while (i < this.logTics[0].length) {
                        float logTic = this.logTics[0][i];
                        float tic2 = (float)Math.pow(10.0, logTic);
                        if (tic2 >= this.getMin(0) && tic2 <= this.getMax(0)) {
                            float ticOffset2;
                            if (this.transposeAxes) {
                                ticOffset2 = vRange * (this.getMaxLog(0) - logTic) / (this.getMaxLog(0) - this.getMinLog(0));
                                if (ticOffset2 >= 0.0f) {
                                    this.graphics.textAlign(39, 3);
                                    this.graphics.text(this.axisFormatter[0].format(tic2), axisPosition - 2.0f, this.top + ticOffset2);
                                }
                            } else {
                                ticOffset2 = hRange * (logTic - this.getMinLog(0)) / (this.getMaxLog(0) - this.getMinLog(0));
                                if (ticOffset2 >= 0.0f) {
                                    this.graphics.textAlign(3, 101);
                                    this.graphics.text(this.axisFormatter[0].format(tic2), this.left + ticOffset2, axisPosition + 2.0f);
                                }
                            }
                        }
                        ++i;
                    }
                } else {
                    i = firstTic;
                    while (i < this.tics[0].length) {
                        tic = this.tics[0][i];
                        if (tic >= this.getMin(0) && tic <= this.getMax(0)) {
                            if (this.transposeAxes) {
                                ticOffset = vRange * (this.getMax(0) - tic) / (this.getMax(0) - this.getMin(0));
                                if (ticOffset >= 0.0f) {
                                    this.graphics.textAlign(39, 3);
                                    this.graphics.text(this.axisFormatter[0].format(tic), axisPosition - 2.0f, this.top + ticOffset);
                                }
                            } else {
                                ticOffset = hRange * (tic - this.getMin(0)) / (this.getMax(0) - this.getMin(0));
                                if (ticOffset >= 0.0f) {
                                    this.graphics.textAlign(3, 101);
                                    this.graphics.text(this.axisFormatter[0].format(tic), this.left + ticOffset, axisPosition + 2.0f);
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (this.xLabel != null) {
                    this.graphics.fill(this.axisLabelColour);
                    if (this.transposeAxes) {
                        this.graphics.textAlign(3, 102);
                        this.graphics.pushMatrix();
                        this.graphics.translate(axisPosition - (this.getBorder(AbstractChart.Side.LEFT) + 1.0f), (this.top + this.bottom) / 2.0f);
                        this.graphics.rotate(-1.5707964f);
                        this.graphics.text(this.xLabel, 0.0f, 0.0f);
                        this.graphics.popMatrix();
                    } else {
                        this.graphics.textAlign(3, 101);
                        this.graphics.text(this.xLabel, (this.left + this.right) / 2.0f, axisPosition + this.getBorder(AbstractChart.Side.BOTTOM) + 2.0f);
                    }
                }
            }
            if (this.getShowAxis(1)) {
                this.graphics.strokeWeight(0.5f);
                this.graphics.stroke(this.axisColour);
                if (this.transposeAxes) {
                    axisPosition = this.bottom;
                    if (this.yAxisPosition != null) {
                        axisPosition = this.getIsLogScale(1) ? (float)((double)this.top + (double)vRange * ((double)this.getMaxLog(0) - Math.log10(this.yAxisPosition.doubleValue())) / (double)(this.getMaxLog(0) - this.getMinLog(0))) : (float)((double)this.top + (double)vRange * ((double)this.getMax(0) - this.yAxisPosition.doubleValue()) / (double)(this.getMax(0) - this.getMin(0)));
                    }
                    this.renderer.line(this.left, axisPosition, this.right, axisPosition);
                } else {
                    axisPosition = this.left;
                    if (this.yAxisPosition != null) {
                        axisPosition = this.getIsLogScale(1) ? (float)((double)this.left + (double)hRange * (Math.log10(this.yAxisPosition.doubleValue()) - (double)this.getMinLog(0)) / (double)(this.getMaxLog(0) - this.getMinLog(0))) : (float)((double)this.left + (double)hRange * (this.yAxisPosition.doubleValue() - (double)this.getMin(0)) / (double)(this.getMax(0) - this.getMin(0)));
                    }
                    this.renderer.line(axisPosition, this.bottom, axisPosition, this.top);
                }
                this.graphics.fill(this.axisValuesColour);
                int i = firstTic;
                while (i < this.tics[1].length) {
                    tic = this.tics[1][i];
                    if (tic >= this.getMin(1) && tic <= this.getMax(1)) {
                        if (this.transposeAxes) {
                            ticOffset = hRange * (tic - this.getMin(1)) / (this.getMax(1) - this.getMin(1));
                            if (ticOffset >= 0.0f) {
                                this.graphics.textAlign(3, 101);
                                this.graphics.text(this.axisFormatter[1].format(tic), this.left + ticOffset, axisPosition + textHeight / 2.0f - 2.0f);
                            }
                        } else {
                            ticOffset = vRange * (this.getMax(1) - tic) / (this.getMax(1) - this.getMin(1));
                            if (ticOffset >= 0.0f) {
                                this.graphics.textAlign(39, 3);
                                this.graphics.text(this.axisFormatter[1].format(tic), axisPosition - 2.0f, this.top + ticOffset);
                            }
                        }
                    }
                    ++i;
                }
                if (this.yLabel != null) {
                    this.graphics.fill(this.axisLabelColour);
                    if (this.transposeAxes) {
                        this.graphics.textAlign(3, 101);
                        this.graphics.text(this.yLabel, (this.left + this.right) / 2.0f, axisPosition + this.getBorder(AbstractChart.Side.BOTTOM) + 2.0f);
                    } else {
                        this.graphics.textAlign(3, 102);
                        this.graphics.pushMatrix();
                        this.graphics.translate(axisPosition - (this.getBorder(AbstractChart.Side.LEFT) + 1.0f), (this.top + this.bottom) / 2.0f);
                        this.graphics.rotate(-1.5707964f);
                        this.graphics.text(this.yLabel, 0.0f, 0.0f);
                        this.graphics.popMatrix();
                    }
                }
            }
            if (showSingleOriginValue) {
                this.graphics.fill(this.axisValuesColour);
                this.graphics.textAlign(39, 101);
                this.graphics.text(this.axisFormatter[1].format(this.tics[0][0]), this.left - 2.0f, this.bottom + textHeight / 2.0f);
            }
        }
        this.graphics.popStyle();
    }

    public PVector getDataToScreen(PVector dataPoint) {
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        if (vRange <= 0.0f || hRange <= 0.0f) {
            return null;
        }
        float x = this.getIsLogScale(0) ? XYChart.convertToLog(dataPoint.x, this.getMinLog(0), this.getMaxLog(0)) : (dataPoint.x - this.getMin(0)) / (this.getMax(0) - this.getMin(0));
        float y = this.getIsLogScale(1) ? XYChart.convertToLog(dataPoint.y, this.getMinLog(1), this.getMaxLog(1)) : (dataPoint.y - this.getMin(1)) / (this.getMax(1) - this.getMin(1));
        if (this.transposeAxes) {
            return new PVector(this.left + hRange * y, this.bottom - vRange * x);
        }
        return new PVector(this.left + hRange * x, this.bottom - vRange * y);
    }

    public PVector getScreenToData(PVector screenPoint) {
        float x;
        float y;
        float hRange = this.right - this.left;
        float vRange = this.bottom - this.top;
        if (vRange <= 0.0f || hRange <= 0.0f) {
            return null;
        }
        if (screenPoint.x < this.left || screenPoint.x > this.right || screenPoint.y < this.top || screenPoint.y > this.bottom) {
            return null;
        }
        if (this.transposeAxes) {
            y = (screenPoint.x - this.left) / hRange;
            x = (this.bottom - screenPoint.y) / vRange;
        } else {
            x = (screenPoint.x - this.left) / hRange;
            y = (this.bottom - screenPoint.y) / vRange;
        }
        x = this.getIsLogScale(0) ? XYChart.convertFromLog(x, this.getMinLog(0), this.getMaxLog(0)) : x * (this.getMax(0) - this.getMin(0)) + this.getMin(0);
        y = this.getIsLogScale(1) ? XYChart.convertFromLog(y, this.getMinLog(1), this.getMaxLog(1)) : y * (this.getMax(1) - this.getMin(1)) + this.getMin(1);
        return new PVector(x, y);
    }

    public void setPointColour(int colour) {
        this.pointColour = colour;
        this.cTable = null;
        this.data[2] = null;
    }

    public void setPointColour(float[] colourData, ColourTable cTable) {
        if (colourData.length != this.data[0].length) {
            System.err.println("Warning: Number of items in point colour data (" + colourData.length + ") does not match number of x,y pairs (" + this.data[0].length + ").");
            return;
        }
        this.cTable = cTable;
        this.setData(2, colourData);
    }

    public void setLineColour(int colour) {
        this.lineColour = colour;
    }

    public void setPointSize(float size) {
        this.pointSize = size;
        this.data[3] = null;
        this.maxPointSize = 0.0f;
    }

    public void setPointSize(float[] sizeData, float maxSize) {
        if (sizeData.length != this.data[0].length) {
            System.err.println("Warning: Number of items in point size data (" + sizeData.length + ") does not match number of x,y pairs (" + this.data[0].length + ").");
            return;
        }
        this.maxPointSize = maxSize;
        this.setData(3, sizeData);
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public void showXAxis(boolean showAxis) {
        this.showAxis(0, showAxis, this.transposeAxes ? AbstractChart.Side.LEFT : AbstractChart.Side.BOTTOM);
    }

    public void showYAxis(boolean showAxis) {
        this.showAxis(1, showAxis, this.transposeAxes ? AbstractChart.Side.BOTTOM : AbstractChart.Side.LEFT);
    }

    public void setMinX(float minX) {
        this.setMin(0, minX);
    }

    public void setMinY(float minY) {
        this.setMin(1, minY);
    }

    public void setMaxX(float maxX) {
        this.setMax(0, maxX);
    }

    public void setMaxY(float maxY) {
        this.setMax(1, maxY);
    }

    public float[] getXData() {
        return this.getData(0);
    }

    public float[] getYData() {
        return this.getData(1);
    }

    public float getMinX() {
        return this.getMin(0);
    }

    public float getMaxX() {
        return this.getMax(0);
    }

    public float getMinY() {
        return this.getMin(1);
    }

    public float getMaxY() {
        return this.getMax(1);
    }

    public float getLeftSpacing() {
        return this.leftSpace;
    }

    public float getRightSpacing() {
        return this.rightSpace;
    }

    public float getBottomSpacing() {
        return this.bottomSpace;
    }

    public float getTopSpacing() {
        return this.topSpace;
    }

    public void setXAxisLabel(String label) {
        this.xLabel = label;
    }

    public void setYAxisLabel(String label) {
        this.yLabel = label;
    }

    public void setXAxisAt(float yValue) {
        this.xAxisPosition = new Float(yValue);
        if (yValue < this.getMin(1)) {
            this.setMinY(yValue);
        } else if (yValue > this.getMax(1)) {
            this.setMaxY(yValue);
        }
    }

    public void setYAxisAt(float xValue) {
        this.yAxisPosition = new Float(xValue);
        if (xValue < this.getMin(0)) {
            this.setMinX(xValue);
        } else if (xValue > this.getMax(0)) {
            this.setMaxX(xValue);
        }
    }

    public void setXFormat(String format) {
        this.setFormat(0, format);
    }

    public void setYFormat(String format) {
        this.setFormat(1, format);
    }

    public void setLogX(boolean isLog) {
        this.setIsLogScale(0, isLog);
    }

    public void setLogY(boolean isLog) {
        this.setIsLogScale(1, isLog);
    }

    public void transposeAxes(boolean transpose) {
        this.transposeAxes = transpose;
        this.updateLayout();
    }

    public void updateLayout() {
        boolean showXAxis = this.getShowAxis(0);
        boolean showYAxis = this.getShowAxis(1);
        this.showXAxis(!showXAxis);
        this.showYAxis(!showYAxis);
        this.showXAxis(showXAxis);
        this.showYAxis(showYAxis);
    }

    public void calcDataSpacing() {
        float extraLeftBorder = 2.0f;
        float extraRightBorder = 2.0f;
        float extraTopBorder = 2.0f;
        float extraBottomBorder = 2.0f;
        if (this.getShowAxis(0) || this.transposeAxes && this.getShowAxis(1)) {
            int axis = this.transposeAxes ? 1 : 0;
            String lastLabel = this.axisFormatter[axis].format(this.tics[axis][this.tics[axis].length - 1]);
            extraRightBorder += this.graphics.textWidth(lastLabel) / 2.0f;
        }
        if (this.getShowAxis(1) || this.transposeAxes && this.getShowAxis(0)) {
            extraTopBorder += this.graphics.textAscent() / 2.0f + 2.0f;
        }
        if (this.yLabel != null && this.getShowAxis(1) || this.transposeAxes && this.xLabel != null && this.getShowAxis(0)) {
            extraLeftBorder += this.graphics.textAscent() + this.graphics.textDescent();
        }
        if (this.xLabel != null && this.getShowAxis(0) || this.transposeAxes && this.yLabel != null && this.getShowAxis(1)) {
            extraBottomBorder += this.graphics.textAscent() + this.graphics.textDescent();
        }
        this.leftSpace = this.getBorder(AbstractChart.Side.LEFT) + extraLeftBorder;
        this.rightSpace = this.getBorder(AbstractChart.Side.RIGHT) + extraRightBorder;
        this.bottomSpace = this.getBorder(AbstractChart.Side.BOTTOM) + extraBottomBorder;
        this.topSpace = this.getBorder(AbstractChart.Side.TOP) + extraTopBorder;
    }
}

