/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils;

import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;

public class FrameTimer {
    private long thisTime;
    private long lastTime;
    private int lastFrameCount;
    private int frameCounter;
    private int reportRateInFrames;
    private float reportRateInSeconds;
    private DecimalFormat rounder;
    private long elapsedTime;
    private String formattedFPS;
    private float fps;
    private boolean displayResult;

    public FrameTimer() {
        this(50);
    }

    public FrameTimer(int reportRateInFrames) {
        this.reportRateInFrames = reportRateInFrames;
        this.reportRateInSeconds = -1.0f;
        this.rounder = new DecimalFormat("#,##0.0");
        this.lastTime = this.thisTime = System.currentTimeMillis();
        this.frameCounter = 0;
        this.lastFrameCount = -1;
        this.elapsedTime = 0L;
        this.formattedFPS = "";
        this.fps = 0.0f;
        this.displayResult = false;
    }

    public FrameTimer(float delay, float reportRateInSeconds) {
        this.reportRateInSeconds = reportRateInSeconds;
        this.reportRateInFrames = -1;
        this.rounder = new DecimalFormat("#,##0.0");
        this.lastTime = this.thisTime = System.currentTimeMillis();
        this.frameCounter = 0;
        this.lastFrameCount = -1;
        this.elapsedTime = 0L;
        this.formattedFPS = "";
        this.fps = 0.0f;
        this.displayResult = false;
        Timer timedCounter = new Timer();
        timedCounter.schedule((TimerTask)new TimedFrameCounter(), Math.round(delay * 1000.0f), (long)Math.round(reportRateInSeconds * 1000.0f));
    }

    public void displayFrameRate() {
        if (this.reportRateInFrames > 0 && this.reportRateInSeconds < 0.0f) {
            ++this.frameCounter;
            if (this.frameCounter % this.reportRateInFrames == 0) {
                this.lastTime = this.thisTime;
                this.thisTime = System.currentTimeMillis();
                this.fps = (float)this.reportRateInFrames * 1000.0f / (float)(1L + this.thisTime - this.lastTime);
                System.out.println(String.valueOf(this.rounder.format(this.fps)) + " frames per second.");
            }
        } else {
            this.displayResult = true;
        }
    }

    public String getFrameRateAsText() {
        if (this.reportRateInFrames > 0 && this.reportRateInSeconds < 0.0f) {
            ++this.frameCounter;
            if (this.frameCounter % this.reportRateInFrames == 0) {
                this.lastTime = this.thisTime;
                this.thisTime = System.currentTimeMillis();
                this.fps = (float)this.reportRateInFrames * 1000.0f / (float)(1L + this.thisTime - this.lastTime);
                this.formattedFPS = new String(this.rounder.format(this.fps));
            }
        }
        return this.formattedFPS;
    }

    public float getFrameRate() {
        if (this.reportRateInFrames > 0 && this.reportRateInSeconds < 0.0f) {
            ++this.frameCounter;
            if (this.frameCounter % this.reportRateInFrames == 0) {
                this.lastTime = this.thisTime;
                this.thisTime = System.currentTimeMillis();
                this.fps = (float)this.reportRateInFrames * 1000.0f / (float)(1L + this.thisTime - this.lastTime);
            }
        }
        return this.fps;
    }

    public void update() {
        if (this.reportRateInFrames < 0 && this.reportRateInSeconds > 0.0f) {
            ++this.frameCounter;
        }
    }

    public void startTimer() {
        this.elapsedTime = System.currentTimeMillis();
    }

    public float getElapsedTime() {
        if (this.elapsedTime == 0L) {
            return 0.0f;
        }
        return (float)(System.currentTimeMillis() - this.elapsedTime) / 1000.0f;
    }

    class TimedFrameCounter
    extends TimerTask {
        TimedFrameCounter() {
        }

        public void run() {
            FrameTimer.this.lastTime = FrameTimer.this.thisTime;
            FrameTimer.this.thisTime = System.currentTimeMillis();
            FrameTimer.this.fps = 1000.0f * (float)(FrameTimer.this.frameCounter - FrameTimer.this.lastFrameCount) / (float)(1L + FrameTimer.this.thisTime - FrameTimer.this.lastTime);
            FrameTimer.this.formattedFPS = FrameTimer.this.rounder.format(FrameTimer.this.fps);
            FrameTimer.this.lastFrameCount = FrameTimer.this.frameCounter;
            if (FrameTimer.this.displayResult) {
                System.out.println(String.valueOf(FrameTimer.this.formattedFPS) + " frames per second.");
                FrameTimer.this.displayResult = false;
            }
        }
    }
}

