/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.geom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.gicentre.utils.geom.Locatable;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashGrid<E extends Locatable>
implements Set<E> {
    private int numRows;
    private int numCols;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private HashMap<Integer, Collection<E>> hashMap;
    private Set<E> set;
    private float radius;

    public HashGrid(float maxX, float maxY, float radius) {
        this(0.0f, 0.0f, maxX, maxY, radius);
    }

    public HashGrid(float minX, float minY, float maxX, float maxY, float radius) {
        if (maxX - minX <= 0.0f) {
            throw new IllegalArgumentException("Minimum x value must be smaller than maximum x value when creating a HashGrid.");
        }
        if (maxY - minY <= 0.0f) {
            throw new IllegalArgumentException("Minimum y value must be smaller than maximum x value when creating a HashGrid.");
        }
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.radius = radius > 0.0f ? radius : (maxX - minX) / 10.0f;
        this.numCols = (int)((maxX - minX) / (radius * 2.0f));
        this.numRows = (int)((maxY - minY) / (radius * 2.0f));
        this.hashMap = new HashMap();
        this.set = new LinkedHashSet();
    }

    public Set<E> get(PVector location) {
        int coordHash = this.getCoordHash(location);
        Collection<E> origCollection = this.hashMap.get(coordHash);
        HashSet<Locatable> newCollection = new HashSet<Locatable>();
        if (origCollection == null) {
            return newCollection;
        }
        double maxDistSq = this.radius * this.radius;
        for (Locatable obj : origCollection) {
            double distSq = (location.x - obj.getLocation().x) * (location.x - obj.getLocation().x) + (location.y - obj.getLocation().y) * (location.y - obj.getLocation().y);
            if (!(distSq <= maxDistSq)) continue;
            newCollection.add(obj);
        }
        return newCollection;
    }

    public boolean contains(E obj, PVector location) {
        return this.get(location).contains(obj);
    }

    public Set<E> getAll() {
        return this.set;
    }

    public void updateAll() {
        this.updateAll(0.0f);
    }

    public void updateAll(float newRadius) {
        if (newRadius > 0.0f) {
            this.radius = newRadius;
            this.numCols = (int)((this.maxX - this.minX) / (this.radius * 2.0f));
            this.numRows = (int)((this.maxY - this.minY) / (this.radius * 2.0f));
        }
        float halfGridX = (this.maxX - this.minX) / (float)(this.numCols * 2);
        float halfGridY = (this.maxY - this.minY) / (float)(this.numRows * 2);
        this.hashMap.clear();
        for (Locatable obj : this.set) {
            this.addToGrid(obj, obj.getLocation());
            this.addToGrid(obj, new PVector(obj.getLocation().x - halfGridX, obj.getLocation().y - halfGridY));
            this.addToGrid(obj, new PVector(obj.getLocation().x, obj.getLocation().y - halfGridY));
            this.addToGrid(obj, new PVector(obj.getLocation().x + halfGridX, obj.getLocation().y - halfGridY));
            this.addToGrid(obj, new PVector(obj.getLocation().x - halfGridX, obj.getLocation().y));
            this.addToGrid(obj, new PVector(obj.getLocation().x + halfGridX, obj.getLocation().y));
            this.addToGrid(obj, new PVector(obj.getLocation().x - halfGridX, obj.getLocation().y + halfGridY));
            this.addToGrid(obj, new PVector(obj.getLocation().x, obj.getLocation().y + halfGridY));
            this.addToGrid(obj, new PVector(obj.getLocation().x + halfGridX, obj.getLocation().y + halfGridY));
        }
    }

    public void update(E obj) {
        this.remove(obj);
        this.add(obj);
    }

    @Override
    public boolean add(E obj) {
        return this.add(obj, (Locatable)obj);
    }

    public boolean add(E obj, Locatable loc) {
        boolean isItemAdded = this.addToGrid(obj, loc.getLocation());
        float halfGridX = (this.maxX - this.minX) / (float)(this.numCols * 2);
        float halfGridY = (this.maxY - this.minY) / (float)(this.numRows * 2);
        this.addToGrid(obj, new PVector(loc.getLocation().x - halfGridX, loc.getLocation().y - halfGridY));
        this.addToGrid(obj, new PVector(loc.getLocation().x, loc.getLocation().y - halfGridY));
        this.addToGrid(obj, new PVector(loc.getLocation().x + halfGridX, loc.getLocation().y - halfGridY));
        this.addToGrid(obj, new PVector(loc.getLocation().x - halfGridX, loc.getLocation().y));
        this.addToGrid(obj, new PVector(loc.getLocation().x + halfGridX, loc.getLocation().y));
        this.addToGrid(obj, new PVector(loc.getLocation().x - halfGridX, loc.getLocation().y + halfGridY));
        this.addToGrid(obj, new PVector(loc.getLocation().x, loc.getLocation().y + halfGridY));
        this.addToGrid(obj, new PVector(loc.getLocation().x + halfGridX, loc.getLocation().y + halfGridY));
        if (isItemAdded) {
            this.set.add(obj);
        }
        return isItemAdded;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean hasChanged = false;
        for (Locatable obj : collection) {
            if (!this.add((E)obj)) continue;
            hasChanged = true;
        }
        return hasChanged;
    }

    @Override
    public void clear() {
        this.hashMap.clear();
        this.set.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this.set.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HashGrid) {
            return this.set.equals(((HashGrid)obj).getAll());
        }
        if (obj instanceof Set) {
            return this.set.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean remove(Object obj) {
        boolean isChanged = this.set.remove(obj);
        if (!isChanged) {
            return false;
        }
        Vector<Integer> hashesToRemove = new Vector<Integer>();
        for (Integer hashVal : this.hashMap.keySet()) {
            Collection<E> collection = this.hashMap.get(hashVal);
            if (!collection.remove(obj) || collection.size() != 0) continue;
            hashesToRemove.add(hashVal);
        }
        for (Integer hashVal : hashesToRemove) {
            this.hashMap.remove(hashVal);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean isChanged = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot perform a retainsAll() operation on a hash grid.");
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    private boolean addToGrid(E obj, PVector location) {
        if (location.x < 0.0f || location.y < 0.0f || location.x > this.maxX || location.y > this.maxY) {
            return false;
        }
        int coordHash = this.getCoordHash(location);
        Collection<E> objects = this.hashMap.get(coordHash);
        if (objects == null) {
            objects = new HashSet();
        }
        objects.add(obj);
        this.hashMap.put(coordHash, objects);
        return true;
    }

    private int getCoordHash(PVector location) {
        int col = (int)(location.x * (float)this.numCols / (this.maxX + 1.0f));
        int row = (int)(location.y * (float)this.numRows / (this.maxY + 1.0f));
        return row * this.numCols + col;
    }

    public PVector getGridCoord(PVector location) {
        int col = (int)(location.x * (float)this.numCols / (this.maxX + 1.0f));
        int row = (int)(location.y * (float)this.numRows / (this.maxY + 1.0f));
        return new PVector((float)col, (float)row);
    }
}

