/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.gui;

import java.awt.Dimension;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;

public class TextPopup {
    private PApplet sketch;
    private boolean isActive;
    private int xBorder;
    private int yBorder;
    private int xMargin;
    private int yMargin;
    private PFont font;
    float textSize;
    private int fgColour;
    private int bgColour;
    private ArrayList<TextLine> textLines;

    public TextPopup(PApplet sketch) {
        this(sketch, 30, 30);
    }

    public TextPopup(PApplet sketch, int xBorder, int yBorder) {
        this(sketch, sketch.createFont("Sans serif", 12.0f), xBorder, yBorder);
    }

    public TextPopup(PApplet sketch, PFont font, int xBorder, int yBorder) {
        this.sketch = sketch;
        this.font = font;
        this.xBorder = xBorder;
        this.yBorder = yBorder;
        this.fgColour = sketch.color(50);
        this.bgColour = sketch.color(255, 255, 250, 240);
        this.textLines = new ArrayList();
        this.textSize = 12.0f;
        this.xMargin = 4;
        this.yMargin = 4;
        this.isActive = false;
    }

    public void draw() {
        if (!this.isActive) {
            return;
        }
        this.sketch.pushStyle();
        this.sketch.textAlign(37, 101);
        this.sketch.fill(this.bgColour);
        this.sketch.stroke(this.fgColour);
        this.sketch.strokeWeight(0.3f);
        this.sketch.rect((float)this.xBorder, (float)this.yBorder, (float)(this.sketch.width - 2 * this.xBorder), (float)(this.sketch.height - 2 * this.yBorder));
        this.sketch.textFont(this.font);
        float yPos = this.yBorder + this.yMargin;
        this.sketch.fill(this.fgColour);
        for (TextLine line : this.textLines) {
            if (line.getTextSize() <= 0.0f) {
                this.sketch.textSize(this.textSize);
            } else {
                this.sketch.textSize(line.getTextSize());
            }
            this.sketch.text(line.getText(), (float)(this.xBorder + this.xMargin), yPos, (float)(this.sketch.width - 2 * (this.xBorder + this.xMargin)), (float)(this.sketch.height - 2 * (this.yBorder + this.yMargin)));
            yPos += this.sketch.textAscent() + this.sketch.textDescent();
        }
        this.sketch.popStyle();
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setBackgroundColour(int bgColour) {
        this.bgColour = bgColour;
    }

    public void setForegroundColour(int fgColour) {
        this.fgColour = fgColour;
    }

    public void setExternalMargin(int xMargin, int yMargin) {
        this.xBorder = xMargin < 0 ? 0 : (xMargin >= this.sketch.width / 2 ? this.sketch.width / 2 : xMargin);
        this.yBorder = yMargin < 0 ? 0 : (yMargin >= this.sketch.height / 2 ? this.sketch.height / 2 : yMargin);
    }

    public Dimension getExternalMargin() {
        return new Dimension(this.xBorder, this.yBorder);
    }

    public void setInternalMargin(int xMargin, int yMargin) {
        this.xMargin = xMargin < 0 ? 0 : (xMargin >= (this.sketch.width - 2 * this.xBorder) / 2 ? (this.sketch.width - 2 * this.xBorder) / 2 : xMargin);
        this.yMargin = yMargin < 0 ? 0 : (yMargin >= (this.sketch.height - 2 * this.yBorder) / 2 ? (this.sketch.height - 2 * this.yBorder) / 2 : yMargin);
    }

    public Dimension getInternalMargin() {
        return new Dimension(this.xMargin, this.yMargin);
    }

    public void addText(String textLine) {
        this.addText(textLine, -1.0f);
    }

    public void addText(String textLine, float lineTextSize) {
        String[] lines;
        String[] stringArray = lines = PApplet.split((String)textLine, (char)'\n');
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.textLines.add(new TextLine(line, lineTextSize));
            ++n2;
        }
    }

    public void setText(String text) {
        this.setText(text, -1.0f);
    }

    public void setText(String text, float textSize) {
        this.textLines.clear();
        this.addText(text, textSize);
    }

    public void clearText() {
        this.textLines.clear();
    }

    private class TextLine {
        private String text;
        private float lineSize;

        public TextLine(String text, float textSize) {
            this.text = text;
            this.lineSize = textSize;
        }

        public String getText() {
            return this.text;
        }

        public float getTextSize() {
            if (this.lineSize < 0.0f) {
                return TextPopup.this.textSize;
            }
            return this.lineSize;
        }
    }
}

