/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.gui;

import java.awt.Color;
import java.util.ArrayList;
import org.gicentre.utils.spatial.Direction;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;
import processing.event.MouseEvent;

public class Tooltip {
    private PApplet parent;
    private PFont font;
    private ArrayList<String> lines;
    private String originalText;
    private float width;
    private float displayWidth;
    private float maxHeight;
    private float textRowHeight;
    private float textSize;
    private static final int BORDER = 3;
    private float closeSize;
    private float pointerSize;
    private float x;
    private float y;
    private float borderWidth;
    private int backgroundColour;
    private int textColour;
    private int borderColour;
    private float xOffset;
    private float yOffset;
    private float textTopOffset;
    private float textBottomOffset;
    private float textLeftOffset;
    private float textRightOffset;
    private Direction anchor;
    private boolean showPointer;
    private boolean isCurved;
    private boolean showClose;
    private boolean isActive;
    private boolean isFixedWidth;
    private PVector[] boundary;

    public Tooltip(PApplet parent, PFont font, float textSize, float width) {
        this.parent = parent;
        this.font = font;
        this.textSize = textSize;
        this.width = width;
        this.displayWidth = width;
        this.maxHeight = 0.0f;
        this.textRowHeight = 0.0f;
        this.borderWidth = 0.2f;
        this.textTopOffset = 0.0f;
        this.textBottomOffset = 0.0f;
        this.textLeftOffset = 0.0f;
        this.textRightOffset = 0.0f;
        this.pointerSize = 15.0f;
        this.closeSize = 17.0f;
        this.borderColour = new Color(100, 100, 100, 100).getRGB();
        this.backgroundColour = new Color(255, 248, 147, 200).getRGB();
        this.textColour = new Color(50, 50, 50).getRGB();
        this.showPointer = false;
        this.isCurved = false;
        this.showClose = false;
        this.isActive = true;
        this.isFixedWidth = true;
        this.setAnchor(Direction.WEST);
        parent.curveTightness(0.7f);
    }

    public void draw(float ttX, float ttY) {
        if (!this.isActive) {
            return;
        }
        this.x = ttX;
        this.y = ttY;
        if (this.lines == null || this.lines.size() == 0) {
            return;
        }
        this.parent.pushStyle();
        this.parent.fill(this.backgroundColour);
        this.parent.stroke(this.borderColour);
        this.parent.strokeWeight(this.borderWidth);
        if (this.showPointer) {
            int n;
            PVector[] pVectorArray;
            this.parent.beginShape();
            if (this.isCurved) {
                pVectorArray = this.boundary;
                n = this.boundary.length;
                int n2 = 0;
                while (n2 < n) {
                    PVector coord = pVectorArray[n2];
                    this.parent.curveVertex(this.x + coord.x, this.y + coord.y);
                    ++n2;
                }
                int i = 0;
                while (i < 3) {
                    PVector coord = this.boundary[i];
                    this.parent.curveVertex(this.x + coord.x, this.y + coord.y);
                    ++i;
                }
            } else {
                pVectorArray = this.boundary;
                n = this.boundary.length;
                int coord = 0;
                while (coord < n) {
                    PVector coord2 = pVectorArray[coord];
                    this.parent.vertex(this.x + coord2.x, this.y + coord2.y);
                    ++coord;
                }
            }
            this.parent.endShape(2);
        } else if (this.isCurved) {
            this.parent.beginShape();
            this.parent.curveVertex(this.x + this.xOffset, this.y + this.yOffset);
            this.parent.curveVertex(this.x + this.xOffset + this.displayWidth, this.y + this.yOffset);
            this.parent.curveVertex(this.x + this.xOffset + this.displayWidth, this.y + this.yOffset + this.maxHeight);
            this.parent.curveVertex(this.x + this.xOffset, this.y + this.yOffset + this.maxHeight);
            this.parent.curveVertex(this.x + this.xOffset, this.y + this.yOffset);
            this.parent.curveVertex(this.x + this.xOffset + this.displayWidth, this.y + this.yOffset);
            this.parent.curveVertex(this.x + this.xOffset + this.displayWidth, this.y + this.yOffset + this.maxHeight);
            this.parent.endShape(2);
        } else {
            this.parent.rect(this.x + this.xOffset, this.y + this.yOffset, this.displayWidth, this.maxHeight);
        }
        this.parent.textFont(this.font);
        this.parent.textAlign(37, 101);
        float yPos = this.y + this.yOffset + 3.0f + this.textTopOffset - this.textBottomOffset;
        this.parent.textSize(this.textSize);
        this.parent.fill(this.textColour);
        int i = 0;
        while (i < this.lines.size()) {
            String line = this.lines.get(i);
            this.parent.text(line, this.x + this.xOffset + 3.0f + this.textLeftOffset, yPos);
            yPos += this.textRowHeight;
            ++i;
        }
        if (this.showClose) {
            this.parent.strokeWeight(1.0f);
            this.parent.noFill();
            float cornerX = this.x + this.xOffset + this.displayWidth - this.closeSize - 3.0f - this.textRightOffset;
            float cornerY = this.y + this.yOffset + 3.0f + this.textTopOffset - this.textBottomOffset;
            this.parent.rect(cornerX, cornerY, this.closeSize, this.closeSize);
            this.parent.line(cornerX + 3.0f, cornerY + 3.0f, cornerX + this.closeSize - 3.0f, cornerY + this.closeSize - 3.0f);
            this.parent.line(cornerX + this.closeSize - 3.0f, cornerY + 3.0f, cornerX + 3.0f, cornerY + this.closeSize - 3.0f);
        }
        this.parent.popStyle();
    }

    public void setText(String text) {
        this.originalText = text;
        this.updateLayout();
    }

    public void setBorderColour(int borderColour) {
        this.borderColour = borderColour;
    }

    public void setTextColour(int textColour) {
        this.textColour = textColour;
    }

    public void setBackgroundColour(int backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public void setIsCurved(boolean curve) {
        this.isCurved = curve;
    }

    public void setPointerSize(float size) {
        this.pointerSize = size;
        this.updateLayout();
    }

    public void setAnchor(Direction anchorPosition) {
        this.anchor = anchorPosition;
        this.updateLayout();
    }

    public void showPointer(boolean show) {
        this.showPointer = show;
        this.updateLayout();
    }

    public void showCloseIcon(boolean show) {
        if (this.showClose && this.isActive && !show) {
            this.parent.unregisterMethod("mouseEvent", (Object)this);
        }
        this.showClose = show;
        if (this.showClose) {
            this.parent.registerMethod("mouseEvent", (Object)this);
        }
        this.updateLayout();
    }

    public void setIsActive(boolean isActive) {
        if (this.showClose && this.isActive && !isActive) {
            this.parent.unregisterMethod("mouseEvent", (Object)this);
        }
        this.isActive = isActive;
        if (isActive && this.showClose) {
            this.parent.registerMethod("mouseEvent", (Object)this);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsFixedWidth(boolean isFixedWidth) {
        if (isFixedWidth != this.isFixedWidth) {
            this.isFixedWidth = isFixedWidth;
            this.updateLayout();
        }
    }

    public boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    public float getWidth() {
        return this.displayWidth;
    }

    public float getHeight() {
        return this.maxHeight;
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getAction() == 1 && this.showClose) {
            float cornerX = this.x + this.xOffset + this.displayWidth - this.closeSize - 3.0f - this.textRightOffset;
            float cornerY = this.y + this.yOffset + 3.0f + this.textTopOffset - this.textBottomOffset;
            if ((float)e.getX() >= cornerX && (float)e.getY() >= cornerY && (float)e.getX() <= cornerX + this.closeSize && (float)e.getY() <= cornerY + this.closeSize) {
                this.isActive = false;
            }
        }
    }

    private void updateLayout() {
        this.textLeftOffset = 0.0f;
        this.textRightOffset = 0.0f;
        this.textTopOffset = 0.0f;
        this.textBottomOffset = 0.0f;
        if (this.showPointer) {
            if (this.anchor == Direction.NORTH || this.anchor == Direction.NORTH_WEST || this.anchor == Direction.NORTH_EAST) {
                this.textTopOffset = this.pointerSize;
            }
            if (this.anchor == Direction.SOUTH || this.anchor == Direction.SOUTH_WEST || this.anchor == Direction.SOUTH_EAST) {
                this.textBottomOffset = this.pointerSize;
            }
            if (this.anchor == Direction.WEST || this.anchor == Direction.NORTH_WEST || this.anchor == Direction.SOUTH_WEST) {
                this.textLeftOffset = this.pointerSize;
            }
            if (this.anchor == Direction.EAST || this.anchor == Direction.NORTH_EAST || this.anchor == Direction.SOUTH_EAST) {
                this.textRightOffset = this.pointerSize;
            }
            if (this.textTopOffset + this.textBottomOffset + this.textLeftOffset + this.textRightOffset > this.pointerSize) {
                this.textTopOffset /= 2.0f;
                this.textBottomOffset /= 2.0f;
                this.textLeftOffset /= 2.0f;
                this.textRightOffset /= 2.0f;
            }
        }
        if (this.originalText != null) {
            this.updateText();
        }
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        if (this.anchor == Direction.NORTH || this.anchor == Direction.CENTRE || this.anchor == Direction.SOUTH) {
            this.xOffset = -this.displayWidth / 2.0f;
        } else if (this.anchor == Direction.NORTH_EAST || this.anchor == Direction.EAST || this.anchor == Direction.SOUTH_EAST) {
            this.xOffset = -this.displayWidth;
        }
        if (this.anchor == Direction.WEST || this.anchor == Direction.CENTRE || this.anchor == Direction.EAST) {
            this.yOffset = -this.maxHeight / 2.0f;
        } else if (this.anchor == Direction.SOUTH_WEST || this.anchor == Direction.SOUTH || this.anchor == Direction.SOUTH_EAST) {
            this.yOffset = -this.maxHeight;
        }
        if (this.anchor == Direction.NORTH) {
            this.boundary = new PVector[7];
            this.boundary[0] = new PVector(this.xOffset + this.displayWidth / 2.0f, this.yOffset);
            this.boundary[1] = new PVector(this.xOffset + this.displayWidth / 2.0f + this.pointerSize, this.yOffset + this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.pointerSize);
            this.boundary[3] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight + this.pointerSize);
            this.boundary[4] = new PVector(this.xOffset, this.yOffset + this.maxHeight + this.pointerSize);
            this.boundary[5] = new PVector(this.xOffset, this.yOffset + this.pointerSize);
            this.boundary[6] = new PVector(this.xOffset + this.displayWidth / 2.0f - this.pointerSize, this.yOffset + this.pointerSize);
        } else if (this.anchor == Direction.NORTH_EAST) {
            this.boundary = new PVector[6];
            this.boundary[0] = new PVector(this.xOffset + this.displayWidth, this.yOffset);
            this.boundary[1] = new PVector(this.xOffset + this.displayWidth - this.pointerSize / 2.0f, this.yOffset + this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset + this.displayWidth - this.pointerSize / 2.0f, this.yOffset + this.maxHeight + this.pointerSize / 2.0f);
            this.boundary[3] = new PVector(this.xOffset, this.yOffset + this.maxHeight + this.pointerSize / 2.0f);
            this.boundary[4] = new PVector(this.xOffset, this.yOffset + this.pointerSize / 2.0f);
            this.boundary[5] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset + this.pointerSize / 2.0f);
        } else if (this.anchor == Direction.EAST) {
            this.boundary = new PVector[7];
            this.boundary[0] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight / 2.0f);
            this.boundary[1] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset + this.maxHeight / 2.0f + this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset + this.maxHeight);
            this.boundary[3] = new PVector(this.xOffset, this.yOffset + this.maxHeight);
            this.boundary[4] = new PVector(this.xOffset, this.yOffset);
            this.boundary[5] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset);
            this.boundary[6] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset + this.maxHeight / 2.0f - this.pointerSize);
        } else if (this.anchor == Direction.SOUTH_EAST) {
            this.boundary = new PVector[6];
            this.boundary[0] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight);
            this.boundary[1] = new PVector(this.xOffset + this.displayWidth - this.pointerSize, this.yOffset + this.maxHeight - this.pointerSize / 2.0f);
            this.boundary[2] = new PVector(this.xOffset, this.yOffset + this.maxHeight - this.pointerSize / 2.0f);
            this.boundary[3] = new PVector(this.xOffset, this.yOffset - this.pointerSize / 2.0f);
            this.boundary[4] = new PVector(this.xOffset + this.displayWidth - this.pointerSize / 2.0f, this.yOffset - this.pointerSize / 2.0f);
            this.boundary[5] = new PVector(this.xOffset + this.displayWidth - this.pointerSize / 2.0f, this.yOffset + this.maxHeight - this.pointerSize);
        } else if (this.anchor == Direction.SOUTH) {
            this.boundary = new PVector[7];
            this.boundary[0] = new PVector(this.xOffset + this.displayWidth / 2.0f, this.yOffset + this.maxHeight);
            this.boundary[1] = new PVector(this.xOffset + this.displayWidth / 2.0f - this.pointerSize, this.yOffset + this.maxHeight - this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset, this.yOffset + this.maxHeight - this.pointerSize);
            this.boundary[3] = new PVector(this.xOffset, this.yOffset - this.pointerSize);
            this.boundary[4] = new PVector(this.xOffset + this.displayWidth, this.yOffset - this.pointerSize);
            this.boundary[5] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight - this.pointerSize);
            this.boundary[6] = new PVector(this.xOffset + this.displayWidth / 2.0f + this.pointerSize, this.yOffset + this.maxHeight - this.pointerSize);
        } else if (this.anchor == Direction.SOUTH_WEST) {
            this.boundary = new PVector[6];
            this.boundary[0] = new PVector(this.xOffset, this.yOffset + this.maxHeight);
            this.boundary[1] = new PVector(this.xOffset + this.pointerSize / 2.0f, this.yOffset + this.maxHeight - this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset + this.pointerSize / 2.0f, this.yOffset - this.pointerSize / 2.0f);
            this.boundary[3] = new PVector(this.xOffset + this.displayWidth, this.yOffset - this.pointerSize / 2.0f);
            this.boundary[4] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight - this.pointerSize / 2.0f);
            this.boundary[5] = new PVector(this.xOffset + this.pointerSize, this.yOffset + this.maxHeight - this.pointerSize / 2.0f);
        } else if (this.anchor == Direction.WEST) {
            this.boundary = new PVector[7];
            this.boundary[0] = new PVector(this.xOffset, this.yOffset + this.maxHeight / 2.0f);
            this.boundary[1] = new PVector(this.xOffset + this.pointerSize, this.yOffset + this.maxHeight / 2.0f - this.pointerSize);
            this.boundary[2] = new PVector(this.xOffset + this.pointerSize, this.yOffset);
            this.boundary[3] = new PVector(this.xOffset + this.displayWidth, this.yOffset);
            this.boundary[4] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight);
            this.boundary[5] = new PVector(this.xOffset + this.pointerSize, this.yOffset + this.maxHeight);
            this.boundary[6] = new PVector(this.xOffset + this.pointerSize, this.yOffset + this.maxHeight / 2.0f + this.pointerSize);
        } else if (this.anchor == Direction.NORTH_WEST) {
            this.boundary = new PVector[6];
            this.boundary[0] = new PVector(this.xOffset, this.yOffset);
            this.boundary[1] = new PVector(this.xOffset + this.pointerSize, this.yOffset + this.pointerSize / 2.0f);
            this.boundary[2] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.pointerSize / 2.0f);
            this.boundary[3] = new PVector(this.xOffset + this.displayWidth, this.yOffset + this.maxHeight + this.pointerSize / 2.0f);
            this.boundary[4] = new PVector(this.xOffset + this.pointerSize / 2.0f, this.yOffset + this.maxHeight + this.pointerSize / 2.0f);
            this.boundary[5] = new PVector(this.xOffset + this.pointerSize / 2.0f, this.yOffset + this.pointerSize);
        }
    }

    private void updateText() {
        this.parent.pushStyle();
        this.parent.textFont(this.font, this.textSize);
        this.textRowHeight = this.parent.textAscent() + this.parent.textDescent();
        this.lines = new ArrayList();
        String[] textLines = this.originalText.split("\\r?\\n");
        float xPos = 3.0f;
        StringBuffer textLine = new StringBuffer();
        float spaceWidth = this.parent.textWidth(" ");
        this.maxHeight = 6.0f;
        String[] stringArray = textLines;
        int n = textLines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] tokens;
            String line = stringArray[n2];
            float maxTextWidth = this.width - 3.0f - this.textLeftOffset - this.textRightOffset;
            this.maxHeight += this.textRowHeight;
            String[] stringArray2 = tokens = line.split("\\s");
            int n3 = tokens.length;
            int n4 = 0;
            while (n4 < n3) {
                String token = stringArray2[n4];
                float tokenWidth = this.parent.textWidth(token.trim());
                float textWidth = maxTextWidth;
                if (this.showClose && this.maxHeight - 3.0f - this.textRowHeight < this.closeSize + 3.0f) {
                    textWidth = maxTextWidth - this.closeSize;
                }
                if (xPos + tokenWidth <= textWidth) {
                    textLine.append(token);
                    textLine.append(" ");
                    xPos += tokenWidth + spaceWidth;
                } else {
                    this.lines.add(textLine.toString());
                    this.maxHeight += this.textRowHeight;
                    textLine = new StringBuffer(token);
                    textLine.append(" ");
                    xPos = 3.0f + tokenWidth + spaceWidth;
                }
                ++n4;
            }
            this.lines.add(textLine.toString());
            textLine = new StringBuffer();
            xPos = 3.0f;
            ++n2;
        }
        this.parent.popStyle();
        this.displayWidth = !this.isFixedWidth && this.lines.size() == 1 ? this.parent.textWidth(this.lines.get(0)) + 3.0f - this.textLeftOffset - this.textRightOffset : this.width;
    }
}

