/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Integrator;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.Vector3D;

public class ForwardEulerIntegrator
extends Integrator {
    public ForwardEulerIntegrator(ParticleSystem s) {
        super(s);
    }

    public ForwardEulerIntegrator step(float deltaT) {
        this.s.clearForces();
        this.s.applyForces();
        for (Particle p : this.s.getParticles()) {
            if (!p.isFree()) continue;
            p.position().add(Vector3D.multiplyBy(p.velocity(), deltaT));
            p.velocity().add(p.getForce().multiplyBy(deltaT / p.mass()));
        }
        return this;
    }
}

