/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import java.util.HashMap;
import java.util.Map;
import org.gicentre.utils.network.traer.physics.Function;
import org.gicentre.utils.network.traer.physics.Integrator;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.Vector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RungeKuttaIntegrator
extends Integrator {
    private Map<Particle, Vector3D> originalPositions;
    private Map<Particle, Vector3D> originalVelocities;
    private Map<Particle, Vector3D> k1Forces;
    private Map<Particle, Vector3D> k1Velocities;
    private Map<Particle, Vector3D> k2Forces;
    private Map<Particle, Vector3D> k2Velocities;
    private Map<Particle, Vector3D> k3Forces;
    private Map<Particle, Vector3D> k3Velocities;
    private Map<Particle, Vector3D> k4Forces;
    private Map<Particle, Vector3D> k4Velocities;

    public RungeKuttaIntegrator(ParticleSystem s) {
        super(s);
    }

    protected static final Function<Particle, ?> kFunctor(final Map<Particle, Vector3D> kForces, final Map<Particle, Vector3D> kVelocities) {
        return new Function<Particle, Object>(){

            @Override
            public Object apply(Particle p) {
                kForces.put(p, p.getForce().copy());
                kVelocities.put(p, p.velocity().copy());
                p.clearForce();
                return null;
            }
        };
    }

    protected static final Function<Particle, ?> kApplier(final Map<Particle, Vector3D> kForces, final Map<Particle, Vector3D> kVelocities, final Map<Particle, Vector3D> originalPositions, final Map<Particle, Vector3D> originalVelocities, final float deltaT) {
        return new Function<Particle, Object>(){

            @Override
            public Object apply(Particle p) {
                p.position().set((Vector3D)kVelocities.get(p)).multiplyBy(0.5f * deltaT).add((Vector3D)originalPositions.get(p));
                p.velocity().set((Vector3D)kForces.get(p)).multiplyBy(0.5f * deltaT / p.mass()).add((Vector3D)originalVelocities.get(p));
                p.clearForce();
                return null;
            }
        };
    }

    protected Function<Particle, ?> updater(final Map<Particle, Vector3D> k1f, final Map<Particle, Vector3D> k1v, final Map<Particle, Vector3D> k2f, final Map<Particle, Vector3D> k2v, final Map<Particle, Vector3D> k3f, final Map<Particle, Vector3D> k3v, final Map<Particle, Vector3D> k4f, final Map<Particle, Vector3D> k4v, final Map<Particle, Vector3D> oPos, final Map<Particle, Vector3D> oVel, final float deltaT) {
        return new Function<Particle, Object>(){

            @Override
            public Object apply(Particle from) {
                from.age += deltaT;
                Vector3D originalPosition = (Vector3D)oPos.get(from);
                Vector3D k1Velocity = ((Vector3D)k1v.get(from)).multiplyBy(deltaT / 6.0f);
                Vector3D k2Velocity = ((Vector3D)k2v.get(from)).multiplyBy(deltaT / 3.0f);
                Vector3D k3Velocity = ((Vector3D)k3v.get(from)).multiplyBy(deltaT / 3.0f);
                Vector3D k4Velocity = ((Vector3D)k4v.get(from)).multiplyBy(deltaT / 6.0f);
                from.position().set(originalPosition).add(k1Velocity).add(k2Velocity).add(k3Velocity).add(k4Velocity);
                Vector3D originalVelocity = (Vector3D)oVel.get(from);
                Vector3D k1Force = ((Vector3D)k1f.get(from)).multiplyBy(deltaT / (6.0f * from.mass()));
                Vector3D k2Force = ((Vector3D)k2f.get(from)).multiplyBy(deltaT / (3.0f * from.mass()));
                Vector3D k3Force = ((Vector3D)k3f.get(from)).multiplyBy(deltaT / (3.0f * from.mass()));
                Vector3D k4Force = ((Vector3D)k4f.get(from)).multiplyBy(deltaT / (6.0f * from.mass()));
                from.velocity().set(originalVelocity).add(k1Force).add(k2Force).add(k3Force).add(k4Force);
                return null;
            }
        };
    }

    protected final void allocateParticles() {
        this.originalPositions = new HashMap<Particle, Vector3D>();
        this.originalVelocities = new HashMap<Particle, Vector3D>();
        for (Particle p : this.s.getParticles()) {
            if (!p.isFree()) continue;
            this.originalPositions.put(p, p.position().copy());
            this.originalVelocities.put(p, p.velocity().copy());
            p.clearForce();
        }
    }

    @Override
    public RungeKuttaIntegrator step(float deltaT) {
        this.allocateParticles();
        this.s.applyForces();
        this.k1Forces = new HashMap<Particle, Vector3D>();
        this.k1Velocities = new HashMap<Particle, Vector3D>();
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kFunctor(this.k1Forces, this.k1Velocities));
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kApplier(this.k1Forces, this.k1Velocities, this.originalPositions, this.originalVelocities, deltaT));
        this.s.applyForces();
        this.k2Forces = new HashMap<Particle, Vector3D>();
        this.k2Velocities = new HashMap<Particle, Vector3D>();
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kFunctor(this.k2Forces, this.k2Velocities));
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kApplier(this.k2Forces, this.k2Velocities, this.originalPositions, this.originalVelocities, deltaT));
        this.s.applyForces();
        this.k3Forces = new HashMap<Particle, Vector3D>();
        this.k3Velocities = new HashMap<Particle, Vector3D>();
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kFunctor(this.k3Forces, this.k3Velocities));
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kApplier(this.k3Forces, this.k3Velocities, this.originalPositions, this.originalVelocities, deltaT * 2.0f));
        this.s.applyForces();
        this.k4Forces = new HashMap<Particle, Vector3D>();
        this.k4Velocities = new HashMap<Particle, Vector3D>();
        Function.functor(this.originalPositions.keySet(), RungeKuttaIntegrator.kFunctor(this.k4Forces, this.k4Velocities));
        Function.functor(this.originalPositions.keySet(), this.updater(this.k1Forces, this.k1Velocities, this.k2Forces, this.k2Velocities, this.k3Forces, this.k3Velocities, this.k4Forces, this.k4Velocities, this.originalPositions, this.originalVelocities, deltaT));
        return this;
    }
}

