/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.TwoBodyForce;
import org.gicentre.utils.network.traer.physics.Vector3D;

public class Spring
extends TwoBodyForce {
    private float l;
    private float ks;
    private float d;

    public Spring(Particle oneEnd, Particle theOtherEnd, float ks, float d, float l) throws NullPointerException, IllegalArgumentException {
        super(oneEnd, theOtherEnd);
        this.setStrength(ks);
        this.setDamping(d);
        this.setRestLength(l);
    }

    public final float currentLength() {
        return this.getOneEnd().position().distanceTo(this.getTheOtherEnd().position());
    }

    public final float restLength() {
        return this.l;
    }

    public final Spring setRestLength(float l) throws IllegalArgumentException {
        if (l < 0.0f) {
            throw new IllegalArgumentException("Rest length l is negative; spring ideal length must be positive.");
        }
        this.l = Math.max(Float.MIN_VALUE, l);
        return this;
    }

    public final float strength() {
        return this.ks;
    }

    public final Spring setStrength(float ks) throws IllegalArgumentException {
        if (ks < 0.0f) {
            throw new IllegalArgumentException("Spring strength ks is negative; spring strength must be positive.");
        }
        this.ks = Math.max(Float.MIN_VALUE, ks);
        return this;
    }

    public final float damping() {
        return this.d;
    }

    public final Spring setDamping(float d) throws IllegalArgumentException {
        if (d < 0.0f) {
            throw new IllegalArgumentException("Spring damping is < 0; damping constant must be positive.");
        }
        this.d = d;
        return this;
    }

    public TwoBodyForce.ForcePair forcePair() {
        Vector3D springForce = Vector3D.subtract(this.getOneEnd().position(), this.getTheOtherEnd().position());
        springForce.length(-(springForce.length() - this.l)).multiplyBy(this.ks);
        Vector3D dampingForce = Vector3D.subtract(this.getOneEnd().velocity(), this.getTheOtherEnd().velocity()).projectOnto(springForce).multiplyBy(-this.d);
        springForce.add(dampingForce);
        return Spring.equalAndOpposite(springForce);
    }
}

