/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Postcode {
    private String pcArea;
    private String pcDistrict;
    private String pcSector;
    private String pcUnit;
    private boolean isValid;
    private String errorMessage;
    private int pos;
    private int endPos;
    private static final Pattern NON_ALPHA_NUM = Pattern.compile("[^0-9A-Z ]");

    public Postcode(String postcode) {
        this.isValid = this.validate(postcode);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getArea() {
        if (this.isValid) {
            return this.pcArea;
        }
        return null;
    }

    public String getAreaCode() {
        return this.getArea();
    }

    public String getDistrict() {
        if (this.isValid) {
            return String.valueOf(this.pcArea) + this.pcDistrict;
        }
        return null;
    }

    public String getDistrictCode() {
        if (this.isValid) {
            return this.pcDistrict;
        }
        return null;
    }

    public String getSector() {
        if (this.isValid) {
            return String.valueOf(this.pcArea) + this.pcDistrict + " " + this.pcSector;
        }
        return null;
    }

    public String getSectorCode() {
        if (this.isValid) {
            return this.pcSector;
        }
        return null;
    }

    public String getUnit() {
        if (this.isValid) {
            if (this.pcSector.length() > 0) {
                return String.valueOf(this.pcArea) + this.pcDistrict + " " + this.pcSector + this.pcUnit;
            }
            return String.valueOf(this.pcArea) + this.pcDistrict;
        }
        return null;
    }

    public String getUnit7() {
        if (this.isValid) {
            if (this.pcSector.length() > 0) {
                int numSpaces = 7 - (this.pcArea.length() + this.pcDistrict.length() + this.pcSector.length() + this.pcUnit.length());
                String spaces = "       ";
                return String.valueOf(this.pcArea) + this.pcDistrict + spaces.substring(0, numSpaces) + this.pcSector + this.pcUnit;
            }
            return String.valueOf(this.pcArea) + this.pcDistrict;
        }
        return null;
    }

    public String getUnitCode() {
        if (this.isValid) {
            return this.pcUnit;
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public String toString() {
        if (this.isValid) {
            return this.getUnit();
        }
        return "";
    }

    private boolean validate(String postcode) {
        char finalChar;
        char nextChar;
        this.errorMessage = "";
        this.pcDistrict = "";
        this.pcSector = "";
        this.pcUnit = "";
        this.pos = 0;
        if (postcode == null) {
            this.errorMessage = "No postcode provided.";
            return false;
        }
        String pcUpperCase = postcode.trim().toUpperCase();
        if (pcUpperCase.length() == 0) {
            this.errorMessage = "Empty postcode text provided.";
            return false;
        }
        pcUpperCase = pcUpperCase.replaceAll("\\s+", " ");
        String pcNoSpaces = pcUpperCase.replaceAll(" ", "");
        this.endPos = pcUpperCase.length() - 1;
        Matcher matcher = NON_ALPHA_NUM.matcher(pcUpperCase);
        if (matcher.find()) {
            this.errorMessage = "Postcode contains unknown character '" + pcUpperCase.substring(matcher.start(), matcher.start() + 1) + "'.";
            return false;
        }
        if (pcNoSpaces.length() > 7) {
            this.errorMessage = "Postcode contains too many characters.";
            return false;
        }
        if (pcNoSpaces.length() >= 5) {
            char unit2 = this.getLastCharacter(pcUpperCase);
            char unit1 = this.getLastCharacter(pcUpperCase);
            if (Postcode.isLetter(unit1) && Postcode.isLetter(unit2)) {
                this.pcUnit = String.valueOf(Character.toString(unit1)) + Character.toString(unit2);
                char sector = this.getLastCharacter(pcUpperCase);
                if (!Postcode.isNumber(sector)) {
                    this.errorMessage = "Postcode sector appears to be a letter '" + sector + "'.";
                    return false;
                }
                this.pcSector = Character.toString(sector);
                pcUpperCase = pcUpperCase.substring(0, this.endPos + 1).trim();
            }
        }
        if (!Postcode.isLetter(nextChar = this.getNextCharacter(pcUpperCase))) {
            this.errorMessage = "Postcode area does not start with a letter.";
            return false;
        }
        this.pcArea = Character.toString(nextChar);
        nextChar = this.getNextCharacter(pcUpperCase);
        if (nextChar == '\u0000') {
            return true;
        }
        if (Postcode.isLetter(nextChar)) {
            this.pcArea = String.valueOf(this.pcArea) + Character.toString(nextChar);
        } else if (Postcode.isNumber(nextChar)) {
            this.pcDistrict = Character.toString(nextChar);
        }
        if (this.pcDistrict.length() > 0 && pcUpperCase.length() > 3 && pcUpperCase.charAt(this.pos) == ' ' && this.pcSector.length() == 0) {
            nextChar = this.getNextCharacter(pcUpperCase);
            finalChar = this.getNextCharacter(pcUpperCase);
            if (finalChar == '\u0000' && Postcode.isNumber(nextChar)) {
                this.pcSector = Character.toString(nextChar);
                return true;
            }
            if (!Postcode.isNumber(nextChar)) {
                this.errorMessage = "Last part of postcode district or postcode sector contains unexpected letter '" + nextChar + "'.";
                return false;
            }
            this.pcDistrict = String.valueOf(this.pcDistrict) + Character.toString(nextChar);
            if (Postcode.isNumber(finalChar)) {
                this.pcSector = Character.toString(finalChar);
                finalChar = this.getNextCharacter(pcUpperCase);
                if (finalChar != '\u0000') {
                    this.errorMessage = "Postcode unit contains only one character '" + finalChar + "'.";
                    return false;
                }
                return true;
            }
        }
        if ((nextChar = this.getNextCharacter(pcUpperCase)) == '\u0000') {
            return true;
        }
        if (Postcode.isLetter(nextChar) && this.pcDistrict.length() == 0) {
            this.errorMessage = "Postcode district should start with a number but starts with unexpected character '" + nextChar + "'.";
            return false;
        }
        this.pcDistrict = String.valueOf(this.pcDistrict) + Character.toString(nextChar);
        if (pcUpperCase.length() > 4 && pcUpperCase.charAt(this.pos) == ' ' && this.pcSector.length() == 0) {
            nextChar = this.getNextCharacter(pcUpperCase);
            finalChar = this.getNextCharacter(pcUpperCase);
            if (finalChar == '\u0000') {
                if (Postcode.isNumber(nextChar)) {
                    this.pcSector = Character.toString(nextChar);
                    finalChar = this.getNextCharacter(pcUpperCase);
                    if (finalChar != '\u0000') {
                        this.errorMessage = "Postcode unit contains only one character '" + finalChar + "'.";
                        return false;
                    }
                    return true;
                }
                this.errorMessage = "Postcode sector contains unexpected letter '" + nextChar + "'.";
                return false;
            }
            this.pcDistrict = String.valueOf(this.pcDistrict) + Character.toString(nextChar);
            if (Postcode.isNumber(finalChar)) {
                this.pcSector = Character.toString(finalChar);
                finalChar = this.getNextCharacter(pcUpperCase);
                if (finalChar != '\u0000') {
                    this.errorMessage = "Postcode unit contains only one character '" + finalChar + "'.";
                    return false;
                }
                return true;
            }
            this.errorMessage = "Postcode sector contains unexpected letter '" + finalChar + "'.";
            return false;
        }
        nextChar = this.getNextCharacter(pcUpperCase);
        if (nextChar == '\u0000') {
            return true;
        }
        if (this.pcDistrict.length() == 2) {
            if (Postcode.isNumber(nextChar)) {
                this.pcSector = Character.toString(nextChar);
                return true;
            }
            this.errorMessage = "Postcode sector contains unexpected letter '" + nextChar + "'.";
            return false;
        }
        this.pcDistrict = String.valueOf(this.pcDistrict) + Character.toString(nextChar);
        nextChar = this.getNextCharacter(pcUpperCase);
        if (nextChar != '\u0000') {
            if (Postcode.isNumber(nextChar)) {
                this.pcSector = Character.toString(nextChar);
                finalChar = this.getNextCharacter(pcUpperCase);
                if (finalChar != '\u0000') {
                    this.errorMessage = "Postcode unit contains only one character '" + finalChar + "'.";
                    return false;
                }
                return true;
            }
            this.errorMessage = "Postcode sector contains unexpected letter '" + nextChar + "'.";
            return false;
        }
        return true;
    }

    private char getNextCharacter(String text) {
        if (this.pos >= text.length()) {
            return '\u0000';
        }
        if (text.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return text.charAt(this.pos++);
    }

    private char getLastCharacter(String text) {
        if (this.endPos < 0) {
            return '\u0000';
        }
        if (text.charAt(this.endPos) == ' ') {
            --this.endPos;
        }
        return text.charAt(this.endPos--);
    }

    private static boolean isLetter(char character) {
        return character >= 'A' && character <= 'Z';
    }

    private static boolean isNumber(char character) {
        return character >= '0' && character <= '9';
    }
}

