/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class UTM
implements MapProjection {
    private Ellipsoid ellipsoid;
    private int zoneNumber;
    private char zoneLetter;
    private boolean doInterpolation;
    private int direction;
    private static final float RAD2DEG = 57.29578f;
    private static final float DEG2RAD = 0.0174533f;
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;

    public UTM(Ellipsoid ellipsoid, int zoneNumber, char zoneLetter) {
        this.ellipsoid = ellipsoid;
        this.doInterpolation = true;
        this.setZone(zoneNumber, zoneLetter);
        this.direction = 2;
    }

    public UTM(Ellipsoid ellipsoid, float lat, float lng) {
        this.ellipsoid = ellipsoid;
        this.doInterpolation = true;
        this.setZone(lat, lng);
        this.direction = 1;
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToUTM(p);
        }
        return this.UTMToLatLong(p);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 1) {
            return this.UTMToLatLong(p);
        }
        return this.latLongToUTM(p);
    }

    public String getDescription() {
        return new String("UTM zone " + this.getZone() + " lat/long transformation.");
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public PVector latLongToUTM(PVector p) {
        double lngOrigin = (this.zoneNumber - 1) * 6 - 180 + 3;
        double latOrigin = 0.0;
        double xOffset = 500000.0;
        double yOffset = 0.0;
        if (p.y < 0.0f) {
            yOffset = 1.0E7;
        }
        return this.latLongToUTM(p, lngOrigin, latOrigin, xOffset, yOffset, 0.9996);
    }

    public PVector latLongToUTM(PVector p, double lngOrigin, double latOrigin, double xOffset, double yOffset, double scaleFactor) {
        double a = this.ellipsoid.getEquatorialRadius();
        double b = this.ellipsoid.getPolarRadius();
        double e2 = this.ellipsoid.getSquaredEccentricity();
        double n = this.ellipsoid.getN();
        double n2 = n * n;
        double n3 = n2 * n;
        double lngTemp = (double)p.x - lngOrigin + 180.0 - (double)((int)(((double)p.x - lngOrigin + 180.0) / 360.0) * 360) - 180.0;
        double phi = p.y * 0.0174533f;
        double phi0 = latOrigin * (double)0.0174533f;
        double lambda = lngTemp * (double)0.0174533f;
        double lambda2 = lambda * lambda;
        double lambda3 = lambda2 * lambda;
        double sinPhi = Math.sin(phi);
        double sin2Phi = sinPhi * sinPhi;
        double cosPhi = Math.cos(phi);
        double cos3Phi = cosPhi * cosPhi * cosPhi;
        double cos5Phi = cos3Phi * cosPhi * cosPhi;
        double tanPhi = Math.tan(phi);
        double tan2Phi = tanPhi * tanPhi;
        double tan4Phi = tan2Phi * tan2Phi;
        double v = a * scaleFactor / Math.sqrt(1.0 - e2 * sin2Phi);
        double rho = a * scaleFactor * (1.0 - e2) / Math.pow(1.0 - e2 * sin2Phi, 1.5);
        double neta2 = v / rho - 1.0;
        double M = b * scaleFactor * ((1.0 + n + 1.25 * n2 + 1.25 * n3) * (phi - phi0) - (3.0 * n + 3.0 * n2 + 2.625 * n3) * Math.sin(phi - phi0) * Math.cos(phi + phi0) + (1.875 * n2 + 1.875 * n3) * Math.sin(2.0 * (phi - phi0)) * Math.cos(2.0 * (phi + phi0)) - 1.4583333333333333 * n3 * Math.sin(3.0 * (phi - phi0)) * Math.cos(3.0 * (phi + phi0)));
        double I = M + yOffset;
        double II = v / 2.0 * sinPhi * cosPhi;
        double III = v / 24.0 * sinPhi * cos3Phi * (5.0 - tan2Phi + 9.0 * neta2);
        double IIIA = v / 720.0 * sinPhi * cos5Phi * (61.0 - 58.0 * tan2Phi + tan4Phi);
        double IV = v * cosPhi;
        double V = v / 6.0 * cos3Phi * (v / rho - tan2Phi);
        double VI = v / 120.0 * cos5Phi * (5.0 - 18.0 * tan2Phi + tan4Phi + 14.0 * neta2 - 58.0 * tan2Phi * neta2);
        return new PVector((float)(xOffset + IV * lambda + V * lambda3 + VI * lambda2 * lambda3), (float)(I + II * lambda2 + III * lambda2 * lambda2 + IIIA * lambda3 * lambda3));
    }

    public PVector UTMToLatLong(PVector p) {
        double lngOrigin = (this.zoneNumber - 1) * 6 - 180 + 3;
        double latOrigin = 0.0;
        double xOffset = 500000.0;
        double yOffset = 0.0;
        if (this.zoneLetter - 78 < 0) {
            yOffset = 1.0E7;
        }
        return this.UTMToLatLong(p, lngOrigin, latOrigin, xOffset, yOffset, 0.9996);
    }

    public PVector UTMToLatLong(PVector p, double lngOrigin, double latOrigin, double xOffset, double yOffset, double scaleFactor) {
        double a = this.ellipsoid.getEquatorialRadius();
        double b = this.ellipsoid.getPolarRadius();
        double e2 = this.ellipsoid.getSquaredEccentricity();
        double n = this.ellipsoid.getN();
        double n2 = n * n;
        double n3 = n2 * n;
        double phi0 = latOrigin * (double)0.0174533f;
        double phi = ((double)p.y - yOffset) / (a * scaleFactor) + phi0;
        double M = b * scaleFactor * ((1.0 + n + 1.25 * n2 + 1.25 * n3) * (phi - phi0) - (3.0 * n + 3.0 * n2 + 2.625 * n3) * Math.sin(phi - phi0) * Math.cos(phi + phi0) + (1.875 * n2 + 1.875 * n3) * Math.sin(2.0 * (phi - phi0)) * Math.cos(2.0 * (phi + phi0)) - 1.4583333333333333 * n3 * Math.sin(3.0 * (phi - phi0)) * Math.cos(3.0 * (phi + phi0)));
        while (Math.abs((double)p.y - yOffset - M) >= 0.01) {
            phi = ((double)p.y - yOffset - M) / (a * scaleFactor) + phi;
            M = b * scaleFactor * ((1.0 + n + 1.25 * n2 + 1.25 * n3) * (phi - phi0) - (3.0 * n + 3.0 * n2 + 2.625 * n3) * Math.sin(phi - phi0) * Math.cos(phi + phi0) + (1.875 * n2 + 1.875 * n3) * Math.sin(2.0 * (phi - phi0)) * Math.cos(2.0 * (phi + phi0)) - 1.4583333333333333 * n3 * Math.sin(3.0 * (phi - phi0)) * Math.cos(3.0 * (phi + phi0)));
        }
        double sinPhi = Math.sin(phi);
        double secPhi = 1.0 / Math.cos(phi);
        double sin2Phi = sinPhi * sinPhi;
        double tanPhi = Math.tan(phi);
        double tan2Phi = tanPhi * tanPhi;
        double tan4Phi = tan2Phi * tan2Phi;
        double tan6Phi = tan4Phi * tan2Phi;
        double v = a * scaleFactor / Math.sqrt(1.0 - e2 * sin2Phi);
        double v2 = v * v;
        double v3 = v2 * v;
        double v5 = v3 * v2;
        double v7 = v5 * v2;
        double rho = a * scaleFactor * (1.0 - e2) / Math.pow(1.0 - e2 * sin2Phi, 1.5);
        double neta2 = v / rho - 1.0;
        double VII = tanPhi / (2.0 * rho * v);
        double VIII = tanPhi / (24.0 * rho * v3) * (5.0 + 3.0 * tan2Phi + neta2 - 9.0 * tan2Phi * neta2);
        double IX = tanPhi / (720.0 * rho * v5) * (61.0 + 90.0 * tan2Phi + 45.0 * tan4Phi);
        double X = secPhi / v;
        double XI = secPhi / (6.0 * v3) * (v / rho + 2.0 * tan2Phi);
        double XII = secPhi / (120.0 * v5) * (5.0 + 28.0 * tan2Phi + 24.0 * tan4Phi);
        double XIIA = secPhi / (5040.0 * v7) * (61.0 + 662.0 * tan2Phi + 1320.0 * tan4Phi + 720.0 * tan6Phi);
        double E = (double)p.x - xOffset;
        double E2 = E * E;
        double E3 = E2 * E;
        double E4 = E3 * E;
        double E5 = E4 * E;
        double E6 = E5 * E;
        double E7 = E6 * E;
        return new PVector((float)(lngOrigin + (double)57.29578f * (X * E - XI * E3 + XII * E5 - XIIA * E7)), (float)((double)57.29578f * (phi - VII * E2 + VIII * E4 - IX * E6)));
    }

    public void setZone(float lat, float lng) {
        double longTemp = lng + 180.0f - (float)((int)((lng + 180.0f) / 360.0f) * 360) - 180.0f;
        this.zoneNumber = (int)((longTemp + 180.0) / 6.0) + 1;
        if (lat >= 56.0f && lat < 64.0f && longTemp >= 3.0 && longTemp < 12.0) {
            this.zoneNumber = 32;
        }
        if (lat >= 72.0f && lat < 84.0f) {
            if (longTemp >= 0.0 && longTemp < 9.0) {
                this.zoneNumber = 31;
            } else if (longTemp >= 9.0 && longTemp < 21.0) {
                this.zoneNumber = 33;
            } else if (longTemp >= 21.0 && longTemp < 33.0) {
                this.zoneNumber = 35;
            } else if (longTemp >= 33.0 && longTemp < 42.0) {
                this.zoneNumber = 37;
            }
        }
        this.zoneLetter = 84.0f >= lat && lat >= 72.0f ? (char)88 : (72.0f > lat && lat >= 64.0f ? (char)87 : (64.0f > lat && lat >= 56.0f ? (char)86 : (56.0f > lat && lat >= 48.0f ? (char)85 : (48.0f > lat && lat >= 40.0f ? (char)84 : (40.0f > lat && lat >= 32.0f ? (char)83 : (32.0f > lat && lat >= 24.0f ? (char)82 : (24.0f > lat && lat >= 16.0f ? (char)81 : (16.0f > lat && lat >= 8.0f ? (char)80 : (8.0f > lat && lat >= 0.0f ? (char)78 : (0.0f > lat && lat >= -8.0f ? (char)77 : (-8.0f > lat && lat >= -16.0f ? (char)76 : (-16.0f > lat && lat >= -24.0f ? (char)75 : (-24.0f > lat && lat >= -32.0f ? (char)74 : (-32.0f > lat && lat >= -40.0f ? (char)72 : (-40.0f > lat && lat >= -48.0f ? (char)71 : (-48.0f > lat && lat >= -56.0f ? (char)70 : (-56.0f > lat && lat >= -64.0f ? (char)69 : (-64.0f > lat && lat >= -72.0f ? (char)68 : (-72.0f > lat && lat >= -80.0f ? (char)67 : (char)90)))))))))))))))))));
    }

    public void setZone(int zoneNumber, char zoneLetter) {
        this.zoneNumber = zoneNumber;
        this.zoneLetter = zoneLetter;
    }

    public int getZoneNumber() {
        return this.zoneNumber;
    }

    public char getZoneLetter() {
        return this.zoneLetter;
    }

    public String getZone() {
        return String.valueOf(new String(Integer.toString(this.zoneNumber))) + Character.toString(this.zoneLetter);
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }
}

