/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.text;

import java.util.ArrayList;
import java.util.List;
import org.gicentre.utils.text.WrappedToken;
import processing.core.PApplet;
import processing.core.PGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordWrapper {
    public static List<String> wordWrap(String text, int width, PApplet sketch) {
        return WordWrapper.wordWrap(text, width, sketch.g);
    }

    public static List<String> wordWrap(String textToWrap, int width, PGraphics pGraphics) {
        String text = String.valueOf(textToWrap) + '\n';
        ArrayList<String> wrappedLines = new ArrayList<String>();
        int idxInOriginalString = 0;
        int lengthOriginalString = text.length();
        StringBuffer currentLine = new StringBuffer();
        StringBuffer currentWord = new StringBuffer();
        float cumWCurLine = 0.0f;
        while (idxInOriginalString < lengthOriginalString) {
            char ch = text.charAt(idxInOriginalString);
            boolean wrapIfNeeded = false;
            boolean forceNewLine = false;
            if (ch == '\t') {
                ch = ' ';
            } else if (ch == '\n') {
                wrapIfNeeded = true;
                forceNewLine = true;
            } else if (ch != ' ') {
                currentWord.append(ch);
            }
            if (ch == ' ' || ch == '-') {
                wrapIfNeeded = true;
            }
            if (wrapIfNeeded) {
                float w = pGraphics.textWidth(currentWord.toString());
                if (currentLine.length() > 0 && cumWCurLine + w > (float)width) {
                    wrappedLines.add(currentLine.toString().trim());
                    currentLine = new StringBuffer();
                    cumWCurLine = 0.0f;
                }
                currentLine.append(currentWord);
                cumWCurLine += w;
                currentWord = new StringBuffer();
            }
            if (ch == ' ') {
                currentLine.append(ch);
                cumWCurLine += pGraphics.textWidth(' ');
            }
            if (forceNewLine) {
                currentLine.append(currentWord);
                currentWord = new StringBuffer();
                wrappedLines.add(currentLine.toString());
                currentLine = new StringBuffer();
                cumWCurLine = 0.0f;
            }
            ++idxInOriginalString;
        }
        return wrappedLines;
    }

    public static List<WrappedToken> wordWrapAndTokenise(String text, float x, float y, float width, PApplet sketch) {
        return WordWrapper.wordWrapAndTokenise(text, x, y, width, sketch.g);
    }

    public static List<WrappedToken> wordWrapAndTokenise(String textToTokenize, float x, float y, float width, PGraphics pGraphics) {
        float maxX = x + width;
        String text = String.valueOf(textToTokenize) + '\n';
        ArrayList<WrappedToken> wrappedTokens = new ArrayList<WrappedToken>();
        int idxInOriginalString = 0;
        int lengthOriginalString = text.length();
        StringBuffer currentLine = new StringBuffer();
        StringBuffer currentWord = new StringBuffer();
        float curX = x;
        float curY = y;
        float cumWCurToken = 0.0f;
        String curStringID = "";
        String nextStringID = "";
        while (idxInOriginalString < lengthOriginalString) {
            WrappedToken wrappedToken;
            float w;
            char ch = text.charAt(idxInOriginalString);
            boolean wrapIfNeeded = false;
            boolean forceNewLine = false;
            if (ch == '{') {
                nextStringID = "";
                ch = text.charAt(++idxInOriginalString);
                while (ch != '}' && idxInOriginalString < lengthOriginalString) {
                    nextStringID = String.valueOf(nextStringID) + ch;
                    if (++idxInOriginalString >= lengthOriginalString) continue;
                    ch = text.charAt(idxInOriginalString);
                }
                if (++idxInOriginalString < lengthOriginalString) {
                    ch = text.charAt(idxInOriginalString);
                }
                if (curX + cumWCurToken + (w = pGraphics.textWidth(currentWord.toString())) > maxX) {
                    wrappedToken = new WrappedToken();
                    wrappedToken.id = curStringID;
                    wrappedToken.text = currentLine.toString();
                    wrappedToken.x = curX;
                    wrappedToken.y = curY;
                    wrappedToken.bounds.x = (int)curX;
                    wrappedToken.bounds.y = (int)curY;
                    wrappedToken.bounds.width = (int)pGraphics.textWidth(currentLine.toString());
                    wrappedToken.bounds.height = (int)pGraphics.textLeading;
                    wrappedTokens.add(wrappedToken);
                    curX = x;
                    curY += pGraphics.textLeading;
                    cumWCurToken = 0.0f;
                    currentLine = new StringBuffer();
                }
                cumWCurToken += pGraphics.textWidth(currentWord.toString());
                currentLine.append(currentWord);
                if (currentLine.length() > 0) {
                    wrappedToken = new WrappedToken();
                    wrappedToken.id = curStringID;
                    wrappedToken.text = currentLine.toString();
                    wrappedToken.x = curX;
                    wrappedToken.y = curY;
                    wrappedToken.bounds.x = (int)curX;
                    wrappedToken.bounds.y = (int)curY;
                    wrappedToken.bounds.width = (int)pGraphics.textWidth(currentLine.toString());
                    wrappedToken.bounds.height = (int)pGraphics.textLeading;
                    wrappedTokens.add(wrappedToken);
                }
                curStringID = nextStringID;
                nextStringID = "";
                curX += cumWCurToken;
                cumWCurToken = 0.0f;
                currentLine = new StringBuffer();
                currentWord = new StringBuffer();
            }
            if (ch == '\t') {
                ch = ' ';
            }
            if (ch == '\n') {
                wrapIfNeeded = true;
                forceNewLine = true;
            } else if (ch != ' ') {
                currentWord.append(ch);
            }
            if (ch == ' ' || ch == '-') {
                wrapIfNeeded = true;
            }
            if (wrapIfNeeded) {
                w = pGraphics.textWidth(currentWord.toString());
                if (curX + cumWCurToken + w > maxX) {
                    wrappedToken = new WrappedToken();
                    wrappedToken.id = curStringID;
                    if (currentLine.length() > 0 && currentLine.charAt(currentLine.length() - 1) == ' ') {
                        currentLine.deleteCharAt(currentLine.length() - 1);
                    }
                    wrappedToken.text = currentLine.toString();
                    wrappedToken.x = curX;
                    wrappedToken.y = curY;
                    wrappedToken.bounds.x = (int)curX;
                    wrappedToken.bounds.y = (int)curY;
                    wrappedToken.bounds.width = (int)pGraphics.textWidth(currentLine.toString());
                    wrappedToken.bounds.height = (int)pGraphics.textLeading;
                    wrappedTokens.add(wrappedToken);
                    curX = x;
                    curY += pGraphics.textLeading;
                    cumWCurToken = 0.0f;
                    currentLine = new StringBuffer();
                }
                currentLine.append(currentWord);
                cumWCurToken += w;
                currentWord = new StringBuffer();
            }
            if (ch == ' ') {
                currentLine.append(ch);
                cumWCurToken += pGraphics.textWidth(' ');
            }
            if (forceNewLine) {
                currentLine.append(currentWord);
                currentWord = new StringBuffer();
                WrappedToken wrappedToken2 = new WrappedToken();
                wrappedToken2.id = curStringID;
                wrappedToken2.text = currentLine.toString();
                wrappedToken2.x = curX;
                wrappedToken2.y = curY;
                wrappedToken2.bounds.x = (int)curX;
                wrappedToken2.bounds.y = (int)curY;
                wrappedToken2.bounds.width = (int)pGraphics.textWidth(currentLine.toString());
                wrappedToken2.bounds.height = (int)pGraphics.textLeading;
                wrappedTokens.add(wrappedToken2);
                curX = x;
                curY += pGraphics.textLeading;
                cumWCurToken = 0.0f;
                currentLine = new StringBuffer();
            }
            ++idxInOriginalString;
        }
        pGraphics.textFont.getSize();
        if (!(wrappedTokens.isEmpty() || pGraphics.textAlign != 3 && pGraphics.textAlign != 39)) {
            float lineY = wrappedTokens.get((int)0).y;
            ArrayList<WrappedToken> wrappedTokensOnSameLine = new ArrayList<WrappedToken>();
            for (WrappedToken wrappedToken : wrappedTokens) {
                if (lineY != wrappedToken.y) {
                    WordWrapper.correctForAlignment(wrappedTokensOnSameLine, maxX, pGraphics);
                    wrappedTokensOnSameLine.clear();
                }
                wrappedTokensOnSameLine.add(wrappedToken);
                lineY = wrappedToken.y;
            }
            WordWrapper.correctForAlignment(wrappedTokensOnSameLine, maxX, pGraphics);
        }
        return wrappedTokens;
    }

    private static void correctForAlignment(List<WrappedToken> wrappedTokensOnSameLine, float maxX, PGraphics pGraphics) {
        float wordOffset;
        float lineW = 0.0f;
        for (WrappedToken wrappedToken2 : wrappedTokensOnSameLine) {
            lineW += (float)wrappedToken2.bounds.width;
        }
        if (pGraphics.textAlign == 3) {
            float lineOffset = (maxX - lineW) / 2.0f;
            for (WrappedToken wrappedToken2 : wrappedTokensOnSameLine) {
                wordOffset = (float)wrappedToken2.bounds.width / 2.0f;
                wrappedToken2.x += lineOffset + wordOffset;
                wrappedToken2.bounds.x = (int)(wrappedToken2.x - wordOffset);
            }
        } else if (pGraphics.textAlign == 39) {
            float lineOffset = maxX - lineW;
            for (WrappedToken wrappedToken2 : wrappedTokensOnSameLine) {
                wordOffset = pGraphics.textWidth(wrappedToken2.text);
                wrappedToken2.x += lineOffset + wordOffset;
                wrappedToken2.bounds.x = (int)(wrappedToken2.x - wordOffset);
            }
        }
        if (pGraphics.textAlignY == 3) {
            for (WrappedToken wrappedToken2 : wrappedTokensOnSameLine) {
                wrappedToken2.bounds.y = (int)((float)wrappedToken2.bounds.y - (pGraphics.textLeading / 2.0f - pGraphics.textDescent()));
            }
        }
    }
}

