/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.awt.Color;
import org.gicentre.utils.colour.ColourConverter;
import processing.core.PVector;

public class CIELab {
    private ColourConverter.WhitePoint wp;

    public CIELab() {
        this(ColourConverter.WhitePoint.D65);
    }

    public CIELab(ColourConverter.WhitePoint wp) {
        this.wp = wp;
    }

    public PVector getLab(Color colour) {
        double[] lab = ColourConverter.getLab(colour, this.wp);
        return new PVector((float)lab[1], (float)lab[2], (float)lab[0]);
    }

    public Color getColour(double L, double a, double b, boolean useNearest) {
        double[] rgb = ColourConverter.labToRGB(L, a, b, this.wp);
        double[] Lab = new double[]{L, a, b};
        if (useNearest) {
            return this.findNearest(rgb, Lab);
        }
        if (rgb[0] < 0.0 || rgb[1] < 0.0 || rgb[2] < 0.0 || rgb[0] > 1.0 || rgb[1] > 1.0 || rgb[2] > 1.0) {
            return null;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }

    private Color findNearest(double[] rgb, double[] Lab) {
        if (rgb[0] < 0.0 || rgb[1] < 0.0 || rgb[2] < 0.0 || rgb[0] > 1.0 || rgb[1] > 1.0 || rgb[2] > 1.0) {
            double L = Lab[0];
            double a = Lab[1];
            double b = Lab[2];
            double theta = Math.atan2(a, b);
            double xInc = Math.sin(theta);
            double yInc = Math.cos(theta);
            double minDistSq = a * a + b * b;
            double mag = Math.sqrt(minDistSq) / 2.0;
            double a2 = a;
            double b2 = b;
            if (minDistSq > 1.0) {
                a2 -= xInc * mag;
            }
            if (minDistSq > 1.0) {
                b2 -= yInc * mag;
            }
            Color lastColour = null;
            boolean isOutside = true;
            while (Math.abs(mag) > 0.01) {
                Color newColour = this.getColour(L, a2, b2, false);
                if (newColour == null) {
                    mag = isOutside ? (mag /= 2.0) : (mag /= -2.0);
                    isOutside = true;
                } else {
                    double distSq = (a2 - a) * (a2 - a) + (b2 - b) * (b2 - b);
                    if (distSq < minDistSq) {
                        minDistSq = distSq;
                        lastColour = newColour;
                    }
                    mag = isOutside ? (mag /= -2.0) : (mag /= 2.0);
                    isOutside = false;
                }
                if (a2 * a2 > 1.0) {
                    a2 -= xInc * mag;
                }
                if (!(b2 * b2 > 1.0)) continue;
                b2 -= yInc * mag;
            }
            if (lastColour == null) {
                return this.getColour(L, 0.0, 0.0, false);
            }
            return lastColour;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }
}

