/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import org.gicentre.utils.colour.ColourTable;
import org.gicentre.utils.colour.PickerListener;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class ColourPicker {
    private PApplet sketch;
    private boolean isActive;
    private int xBorder;
    private int yBorder;
    private Vector<PickerListener> pickerListeners;
    private HashMap<Rectangle2D.Float, ColourTable> swatches;
    private ColourTable[] coloursCont;
    private ColourTable[] coloursDiv;
    private ColourTable[] coloursCat;
    private int imgWidth;
    private int imgHeight;
    private float barWidth;
    private float bottom;
    private PImage img;
    private int lastColour;
    private ColourTable lastColourTable;
    private boolean isDragged;

    public ColourPicker(PApplet sketch) {
        this(sketch, 30, 30);
    }

    public ColourPicker(PApplet sketch, int xBorder, int yBorder) {
        this.sketch = sketch;
        this.xBorder = xBorder;
        this.yBorder = yBorder;
        this.isActive = false;
        this.pickerListeners = new Vector();
        this.lastColour = Integer.MAX_VALUE;
        this.lastColourTable = null;
        this.isDragged = false;
        this.coloursCont = new ColourTable[18];
        this.coloursCont[0] = ColourTable.getPresetColourTable(201, 0.0f, 1.0f);
        this.coloursCont[1] = ColourTable.getPresetColourTable(202, 0.0f, 1.0f);
        this.coloursCont[2] = ColourTable.getPresetColourTable(203, 0.0f, 1.0f);
        this.coloursCont[3] = ColourTable.getPresetColourTable(204, 0.0f, 1.0f);
        this.coloursCont[4] = ColourTable.getPresetColourTable(205, 0.0f, 1.0f);
        this.coloursCont[5] = ColourTable.getPresetColourTable(206, 0.0f, 1.0f);
        this.coloursCont[6] = ColourTable.getPresetColourTable(207, 0.0f, 1.0f);
        this.coloursCont[7] = ColourTable.getPresetColourTable(208, 0.0f, 1.0f);
        this.coloursCont[8] = ColourTable.getPresetColourTable(209, 0.0f, 1.0f);
        this.coloursCont[9] = ColourTable.getPresetColourTable(210, 0.0f, 1.0f);
        this.coloursCont[10] = ColourTable.getPresetColourTable(211, 0.0f, 1.0f);
        this.coloursCont[11] = ColourTable.getPresetColourTable(212, 0.0f, 1.0f);
        this.coloursCont[12] = ColourTable.getPresetColourTable(213, 0.0f, 1.0f);
        this.coloursCont[13] = ColourTable.getPresetColourTable(214, 0.0f, 1.0f);
        this.coloursCont[14] = ColourTable.getPresetColourTable(215, 0.0f, 1.0f);
        this.coloursCont[15] = ColourTable.getPresetColourTable(216, 0.0f, 1.0f);
        this.coloursCont[16] = ColourTable.getPresetColourTable(217, 0.0f, 1.0f);
        this.coloursCont[17] = ColourTable.getPresetColourTable(218, 0.0f, 1.0f);
        this.coloursDiv = new ColourTable[9];
        this.coloursDiv[0] = ColourTable.getPresetColourTable(219, 0.0f, 1.0f);
        this.coloursDiv[1] = ColourTable.getPresetColourTable(220, 0.0f, 1.0f);
        this.coloursDiv[2] = ColourTable.getPresetColourTable(221, 0.0f, 1.0f);
        this.coloursDiv[3] = ColourTable.getPresetColourTable(222, 0.0f, 1.0f);
        this.coloursDiv[4] = ColourTable.getPresetColourTable(223, 0.0f, 1.0f);
        this.coloursDiv[5] = ColourTable.getPresetColourTable(224, 0.0f, 1.0f);
        this.coloursDiv[6] = ColourTable.getPresetColourTable(225, 0.0f, 1.0f);
        this.coloursDiv[7] = ColourTable.getPresetColourTable(226, 0.0f, 1.0f);
        this.coloursDiv[8] = ColourTable.getPresetColourTable(227, 0.0f, 1.0f);
        this.coloursCat = new ColourTable[8];
        this.coloursCat[0] = ColourTable.getPresetColourTable(236);
        this.coloursCat[1] = ColourTable.getPresetColourTable(242);
        this.coloursCat[2] = ColourTable.getPresetColourTable(252);
        this.coloursCat[3] = ColourTable.getPresetColourTable(259);
        this.coloursCat[4] = ColourTable.getPresetColourTable(265);
        this.coloursCat[5] = ColourTable.getPresetColourTable(271);
        this.coloursCat[6] = ColourTable.getPresetColourTable(281);
        this.coloursCat[7] = ColourTable.getPresetColourTable(287);
        this.createPickerImage(sketch.createGraphics(Math.max(800, sketch.width - 2 * xBorder), Math.max(540, sketch.height - 2 * yBorder), "processing.awt.PGraphicsJava2D"));
    }

    public void draw() {
        if (!this.isActive) {
            return;
        }
        this.sketch.pushStyle();
        this.sketch.image(this.img, (float)this.xBorder, (float)this.yBorder, (float)(this.sketch.width - 2 * this.xBorder), (float)(this.sketch.height - 2 * this.yBorder));
        this.sketch.noFill();
        this.sketch.strokeWeight(0.5f);
        this.sketch.stroke(120, 50.0f);
        this.sketch.rect((float)this.xBorder, (float)this.yBorder, (float)(this.sketch.width - 2 * this.xBorder), (float)(this.sketch.height - 2 * this.yBorder));
        this.drawSelected();
        this.sketch.popStyle();
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.sketch.registerMethod("mouseEvent", (Object)this);
        } else {
            this.sketch.unregisterMethod("mouseEvent", (Object)this);
        }
    }

    public int getLastColour() {
        return this.lastColour;
    }

    public ColourTable getLastColourTable() {
        return this.lastColourTable;
    }

    public void addPickerListener(PickerListener pickerListener) {
        this.pickerListeners.add(pickerListener);
    }

    public boolean removePickerListener(PickerListener pickerListener) {
        return this.pickerListeners.remove(pickerListener);
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getAction() == 3) {
            if (this.isActive) {
                float xScale = (float)(this.sketch.width - 2 * this.xBorder) / (float)this.imgWidth;
                float yScale = (float)(this.sketch.height - 2 * this.yBorder) / (float)this.imgHeight;
                float xClick = (float)(e.getX() - this.xBorder) / xScale;
                float yClick = (float)(e.getY() - this.yBorder) / yScale;
                for (Rectangle2D.Float rect : this.swatches.keySet()) {
                    if (!rect.contains(xClick, yClick)) continue;
                    this.lastColourTable = this.swatches.get(rect);
                    float pos = (float)(((double)xClick - rect.getX()) / rect.getWidth());
                    float range = this.lastColourTable.getMaxIndex() - this.lastColourTable.getMinIndex();
                    if (this.lastColourTable.getIsDiscrete()) {
                        if (range == 1.0f) {
                            pos = (float)((int)(pos * 9.0f)) / 9.0f + 0.055555f;
                        } else {
                            float numColours = range + 1.0f;
                            pos = pos * numColours + 0.5f;
                        }
                    }
                    this.lastColour = this.lastColourTable.findColour(pos);
                    this.fireColourSelectionEvent();
                    return;
                }
                this.lastColourTable = null;
                this.lastColour = Integer.MAX_VALUE;
                this.fireColourSelectionEvent();
            }
        } else if (e.getAction() == 2) {
            if (this.isActive && this.isDragged) {
                this.isDragged = false;
                if (this.lastColourTable != null) {
                    this.fireColourSelectionEvent();
                }
            }
        } else if (e.getAction() == 4 && this.isActive) {
            this.isDragged = true;
            float xScale = (float)(this.sketch.width - 2 * this.xBorder) / (float)this.imgWidth;
            float yScale = (float)(this.sketch.height - 2 * this.yBorder) / (float)this.imgHeight;
            float xClick = (float)(e.getX() - this.xBorder) / xScale;
            float yClick = (float)(e.getY() - this.yBorder) / yScale;
            for (Rectangle2D.Float rect : this.swatches.keySet()) {
                if (!rect.contains(xClick, yClick)) continue;
                this.lastColourTable = this.swatches.get(rect);
                float pos = (float)(((double)xClick - rect.getX()) / rect.getWidth());
                float range = this.lastColourTable.getMaxIndex() - this.lastColourTable.getMinIndex();
                if (this.lastColourTable.getIsDiscrete()) {
                    if (range == 1.0f) {
                        pos = (float)((int)(pos * 9.0f)) / 9.0f + 0.055555f;
                    } else {
                        float numColours = range + 1.0f;
                        pos = pos * numColours + 0.5f;
                    }
                }
                this.lastColour = this.lastColourTable.findColour(pos);
                return;
            }
        }
    }

    private void fireColourSelectionEvent() {
        for (PickerListener listener : this.pickerListeners) {
            listener.colourChosen();
        }
    }

    private void createPickerImage(PGraphics buffer) {
        ColourTable discreteCTable;
        float inc;
        int border;
        String cn;
        this.swatches = new HashMap();
        PFont largeFont = null;
        PFont smallFont = null;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream stream = cl.getResourceAsStream("data/BonvenoCF-Light-18.vlw");
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            try {
                largeFont = new PFont(stream);
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((stream = cl.getResourceAsStream("data/BonvenoCF-Light-10.vlw")) != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            try {
                smallFont = new PFont(stream);
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (largeFont == null) {
            largeFont = this.sketch.createFont("sans serif", 18.0f);
        }
        if (smallFont == null) {
            smallFont = this.sketch.createFont("sans serif", 10.0f);
        }
        buffer.beginDraw();
        buffer.smooth();
        buffer.background(255, 220.0f);
        buffer.textAlign(3, 101);
        buffer.strokeWeight(0.5f);
        buffer.stroke(180);
        this.imgWidth = buffer.width;
        this.imgHeight = buffer.height;
        int colOffset = border = 8;
        int textSpace = 46;
        this.barWidth = (this.imgWidth - (border * 6 + textSpace * 2)) / 4;
        int rowOffset = 24 + border;
        buffer.fill(120);
        buffer.textFont(largeFont);
        buffer.text("Sequential", (float)border + this.barWidth + (float)(textSpace / 2), (float)border);
        buffer.text("Diverging", (float)(2 * border) + 3.0f * ((float)border + this.barWidth) + 1.5f * (float)textSpace, (float)border);
        buffer.text("Categorical", (float)(2 * border) + 2.7f * ((float)border + this.barWidth) + 1.5f * (float)textSpace, (float)(border + (this.coloursDiv.length + 1) * 25));
        buffer.textFont(smallFont);
        int bar = 0;
        while (bar < this.coloursCont.length) {
            inc = 0.01f;
            colOffset = border;
            float i = 0.0f;
            while (i < 1.0f - inc) {
                buffer.fill(this.coloursCont[bar].findColour(i));
                buffer.stroke(this.coloursCont[bar].findColour(i));
                buffer.rect((float)colOffset + this.barWidth * i, (float)(rowOffset + bar * 25), this.barWidth * inc + 1.0f, 20.0f);
                i += inc;
            }
            buffer.stroke(0, 100.0f);
            buffer.noFill();
            buffer.rect((float)colOffset, (float)(rowOffset + bar * 25), this.barWidth, 20.0f);
            this.swatches.put(new Rectangle2D.Float(colOffset, rowOffset + bar * 25, this.barWidth, 20.0f), this.coloursCont[bar]);
            buffer.fill(80);
            buffer.textAlign(3, 101);
            buffer.text(this.coloursCont[bar].getName(), (float)colOffset + this.barWidth + (float)((border + textSpace) / 2), (float)(rowOffset + bar * 25 + 5));
            colOffset = (int)((float)colOffset + (this.barWidth + (float)border + (float)textSpace));
            buffer.stroke(0, 100.0f);
            inc = 0.11111111f;
            i = 0.0f;
            while (i < 1.0f) {
                buffer.fill(this.coloursCont[bar].findColour(i + 0.5f * inc));
                buffer.rect((float)colOffset + this.barWidth * i, (float)(rowOffset + bar * 25), this.barWidth * inc, 20.0f);
                i += inc;
            }
            discreteCTable = new ColourTable(this.coloursCont[bar]);
            discreteCTable.setIsDiscrete(true);
            this.swatches.put(new Rectangle2D.Float(colOffset, rowOffset + bar * 25, this.barWidth, 20.0f), discreteCTable);
            ++bar;
        }
        bar = 0;
        while (bar < this.coloursDiv.length) {
            inc = 0.01f;
            colOffset = (int)(this.barWidth + (float)(border * 2)) * 2 + textSpace;
            float i = 0.0f;
            while (i < 1.0f - inc) {
                buffer.fill(this.coloursDiv[bar].findColour(i));
                buffer.stroke(this.coloursDiv[bar].findColour(i));
                buffer.rect((float)colOffset + this.barWidth * i, (float)(rowOffset + bar * 25), this.barWidth * inc + 1.0f, 20.0f);
                i += inc;
            }
            buffer.stroke(0, 100.0f);
            buffer.noFill();
            buffer.rect((float)colOffset, (float)(rowOffset + bar * 25), this.barWidth, 20.0f);
            this.swatches.put(new Rectangle2D.Float(colOffset, rowOffset + bar * 25, this.barWidth, 20.0f), this.coloursDiv[bar]);
            buffer.fill(80);
            buffer.textAlign(3, 101);
            buffer.text(this.coloursDiv[bar].getName(), (float)colOffset + this.barWidth + (float)((border + textSpace) / 2), (float)(rowOffset + bar * 25 + 5));
            colOffset = (int)((float)colOffset + (this.barWidth + (float)border + (float)textSpace));
            buffer.stroke(0, 100.0f);
            inc = 0.11111111f;
            i = 0.0f;
            while (i < 1.0f) {
                buffer.fill(this.coloursDiv[bar].findColour(i + 0.5f * inc));
                buffer.rect((float)colOffset + this.barWidth * i, (float)(rowOffset + bar * 25), this.barWidth * inc, 20.0f);
                i += inc;
            }
            discreteCTable = new ColourTable(this.coloursDiv[bar]);
            discreteCTable.setIsDiscrete(true);
            this.swatches.put(new Rectangle2D.Float(colOffset, rowOffset + bar * 25, this.barWidth, 20.0f), discreteCTable);
            ++bar;
        }
        colOffset = (int)((double)(this.barWidth + (float)(border * 2)) * 2.2 + (double)textSpace * 1.5);
        bar = 0;
        while (bar < this.coloursCat.length) {
            this.coloursCat[bar].setIsDiscrete(true);
            rowOffset = 24 + border + (this.coloursDiv.length + 1) * 25;
            buffer.stroke(0, 100.0f);
            int numColours = this.coloursCat[bar].getColourRules().size() - 1;
            float i = 0.0f;
            while (i < (float)numColours) {
                buffer.fill(this.coloursCat[bar].findColour(i + 1.0f));
                buffer.rect((float)colOffset + this.barWidth * i / (float)numColours, (float)(rowOffset + bar * 25), this.barWidth / (float)numColours, 20.0f);
                i += 1.0f;
            }
            buffer.textAlign(39, 101);
            buffer.fill(80);
            buffer.text(this.coloursCat[bar].getName(), (float)(colOffset - border), (float)(rowOffset + bar * 25 + 5));
            this.swatches.put(new Rectangle2D.Float(colOffset, rowOffset + bar * 25, this.barWidth, 20.0f), this.coloursCat[bar]);
            this.bottom = rowOffset + bar * 25 + 20;
            ++bar;
        }
        buffer.endDraw();
        this.img = buffer.get(0, 0, this.imgWidth, this.imgHeight);
    }

    private void drawSelected() {
        float xScale = (float)(this.sketch.width - 2 * this.xBorder) / (float)this.imgWidth;
        float yScale = (float)(this.sketch.height - 2 * this.yBorder) / (float)this.imgHeight;
        float selectedBarWidth = 20.0f * xScale;
        float selectedBarHeight = 1.3f * this.barWidth * yScale;
        float x = (float)(this.sketch.width - this.xBorder) - 3.9f * selectedBarWidth;
        float y = (float)this.yBorder + this.bottom * yScale - selectedBarHeight;
        if (this.lastColour == Integer.MAX_VALUE) {
            this.sketch.rect(x, y + selectedBarHeight / 4.0f, selectedBarWidth * 3.0f, selectedBarHeight / 2.0f);
            x = (float)(this.sketch.width - this.xBorder) - 5.4f * selectedBarWidth;
            this.sketch.rect(x, y, selectedBarWidth, selectedBarHeight);
            return;
        }
        this.sketch.fill(this.lastColour);
        this.sketch.rect(x, y + selectedBarHeight / 4.0f, selectedBarWidth * 3.0f, selectedBarHeight / 2.0f);
        x = (float)(this.sketch.width - this.xBorder) - 5.4f * selectedBarWidth;
        if (this.lastColourTable.getIsDiscrete()) {
            float maxIndex = this.lastColourTable.getMaxIndex();
            float range = this.lastColourTable.getMaxIndex() - this.lastColourTable.getMinIndex();
            if (range == 1.0f) {
                float inc = 0.11111111f;
                float i = 0.0f;
                while (i < 1.0f) {
                    this.sketch.fill(this.lastColourTable.findColour(maxIndex - (i * range + 0.5f * inc)));
                    this.sketch.rect(x, y + selectedBarHeight * i, selectedBarWidth, selectedBarHeight * inc + 1.0f);
                    i += inc;
                }
            } else {
                int numColours = this.lastColourTable.getColourRules().size() - 1;
                float i = 0.0f;
                while (i < (float)numColours) {
                    this.sketch.fill(this.lastColourTable.findColour((float)numColours - i));
                    this.sketch.rect(x, y + selectedBarHeight * i / (float)numColours, selectedBarWidth, selectedBarHeight / (float)numColours);
                    i += 1.0f;
                }
            }
        } else {
            float inc = 0.01f;
            float maxIndex = this.lastColourTable.getMaxIndex();
            float range = this.lastColourTable.getMaxIndex() - this.lastColourTable.getMinIndex();
            float i = 0.0f;
            while (i < 1.0f - inc) {
                this.sketch.fill(this.lastColourTable.findColour(maxIndex - i * range));
                this.sketch.stroke(this.lastColourTable.findColour(maxIndex - i * range));
                this.sketch.rect(x, y + selectedBarHeight * i, selectedBarWidth, selectedBarHeight * inc + 1.0f);
                i += inc;
            }
            this.sketch.stroke(200);
            this.sketch.strokeWeight(Math.min(0.5f, xScale));
            this.sketch.noFill();
            this.sketch.rect(x, y, selectedBarWidth, selectedBarHeight);
        }
    }
}

