/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.io.Serializable;

public class ColourRule
implements Serializable {
    static final long serialVersionUID = -4430404671758693062L;
    public static final int CONTINUOUS = 1;
    public static final int DISCRETE = 2;
    private int lColour;
    private int uColour;
    private float lIndex;
    private float uIndex;
    private int type;
    private static final int ALF = -16777216;
    private static final int RED = 0xFF0000;
    private static final int GRN = 65280;
    private static final int BLU = 255;

    public ColourRule(float i, int r, int g, int b) {
        this(i, 0xFF000000 | r << 16 | g << 8 | b);
    }

    public ColourRule(float i, int r, int g, int b, int a) {
        this(i, a << 24 | r << 16 | g << 8 | b);
    }

    public ColourRule(float i, int c) {
        this.lIndex = i;
        this.lColour = c;
        this.uIndex = i;
        this.uColour = c;
        this.type = 2;
    }

    public ColourRule(float i1, int r1, int g1, int b1, float i2, int r2, int g2, int b2) {
        this(i1, 0xFF000000 | r1 << 16 | g1 << 8 | b1, i2, 0xFF000000 | r2 << 16 | g2 << 8 | b2);
    }

    public ColourRule(float i1, int r1, int g1, int b1, int a1, float i2, int r2, int g2, int b2, int a2) {
        this(i1, a1 << 24 | r1 << 16 | g1 << 8 | b1, i2, a2 << 24 | r2 << 16 | g2 << 8 | b2);
    }

    public ColourRule(float i1, int c1, float i2, int c2) {
        this.lIndex = i1;
        this.lColour = c1;
        this.uIndex = i2;
        this.uColour = c2;
        this.type = 1;
    }

    public int getColour(float index) {
        if (index <= this.lIndex) {
            return this.lColour;
        }
        if (index >= this.uIndex) {
            return this.uColour;
        }
        float position = (index - this.lIndex) / (this.uIndex - this.lIndex);
        int lalf = (this.lColour & 0xFF000000) >> 24;
        int ualf = (this.uColour & 0xFF000000) >> 24;
        if (lalf < 0) {
            lalf += 256;
        }
        if (ualf < 0) {
            ualf += 256;
        }
        int lred = (this.lColour & 0xFF0000) >> 16;
        int ured = (this.uColour & 0xFF0000) >> 16;
        int lgrn = (this.lColour & 0xFF00) >> 8;
        int ugrn = (this.uColour & 0xFF00) >> 8;
        int lblu = this.lColour & 0xFF;
        int ublu = this.uColour & 0xFF;
        int alpha = (int)(position * (float)(ualf - lalf) + (float)lalf);
        int red = (int)(position * (float)(ured - lred) + (float)lred);
        int green = (int)(position * (float)(ugrn - lgrn) + (float)lgrn);
        int blue = (int)(position * (float)(ublu - lblu) + (float)lblu);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public float getlIndex() {
        return this.lIndex;
    }

    public void setlIndex(float lIndex) {
        this.lIndex = lIndex;
    }

    public float getuIndex() {
        return this.uIndex;
    }

    public void setuIndex(float uIndex) {
        this.uIndex = uIndex;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getlColour() {
        return this.lColour;
    }

    public void setlColour(int lColour) {
        this.lColour = lColour;
    }

    public void setuColour(int uColour) {
        this.uColour = uColour;
    }

    public int getuColour() {
        return this.uColour;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(String.valueOf(this.lIndex) + ": " + ColourRule.toString(this.lColour) + " -> ");
        output.append(String.valueOf(this.uIndex) + ": " + ColourRule.toString(this.uColour));
        if (this.type == 2) {
            output.append(" (D)\n");
        } else {
            output.append("\n");
        }
        return output.toString();
    }

    public static String toString(int intColour) {
        int alpha = (intColour & 0xFF000000) >> 24;
        int red = (intColour & 0xFF0000) >> 16;
        int green = (intColour & 0xFF00) >> 8;
        int blue = intColour & 0xFF;
        if (alpha < 0) {
            alpha += 256;
        }
        return new String(String.valueOf(red) + "," + green + "," + blue + "," + alpha);
    }
}

