/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.gicentre.utils.colour.ColourRule;
import org.gicentre.utils.io.DOMProcessor;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColourTable
implements Serializable {
    public static final float NO_VALUE = Float.MIN_VALUE;
    public static final int UNDEFINED = 0;
    public static final int PIT = 1;
    public static final int CHANNEL = 2;
    public static final int PASS = 3;
    public static final int RIDGE = 4;
    public static final int PEAK = 5;
    public static final int PLANAR = 6;
    public static final int UPIT = 11;
    public static final int UPEAK = 15;
    public static final int COLOUR_RULES = 1;
    public static final int COLOUR_RAW = 2;
    public static final int COLOUR_ATTRIB = 3;
    public static final int DEFAULT = 100;
    public static final int FEATURES = 101;
    public static final int MSN_FEATURES = 102;
    public static final int SLOPE = 103;
    public static final int ASPECT = 104;
    public static final int DIVERGING_BLURED = 111;
    public static final int DIVERGING_GRNYEL = 112;
    public static final int DIVERGING_BLUYELRED = 113;
    public static final int GREYSCALE = 121;
    public static final int INV_GREYSCALE = 122;
    public static final int IMHOF_L1 = 131;
    public static final int IMHOF_L2 = 132;
    public static final int IMHOF_L3 = 133;
    public static final int IMHOF_L4 = 134;
    public static final int IMHOF_S1 = 135;
    public static final int IMHOF_S2 = 136;
    public static final int IMHOF_SL = 137;
    public static final int EXP_ORRED = 141;
    public static final int RANDOM = 151;
    public static final int YL_GN = 201;
    public static final int YL_GN_BU = 202;
    public static final int GN_BU = 203;
    public static final int BU_GN = 204;
    public static final int PU_BU_GN = 205;
    public static final int PU_BU = 206;
    public static final int BU_PU = 207;
    public static final int RD_PU = 208;
    public static final int PU_RD = 209;
    public static final int OR_RD = 210;
    public static final int YL_OR_RD = 211;
    public static final int YL_OR_BR = 212;
    public static final int PURPLES = 213;
    public static final int BLUES = 214;
    public static final int GREENS = 215;
    public static final int ORANGES = 216;
    public static final int REDS = 217;
    public static final int GREYS = 218;
    public static final int PU_OR = 219;
    public static final int BR_B_G = 220;
    public static final int P_R_GN = 221;
    public static final int PI_Y_G = 222;
    public static final int RD_BU = 223;
    public static final int RD_GY = 224;
    public static final int RD_YL_BU = 225;
    public static final int SPECTRAL = 226;
    public static final int RD_YL_GN = 227;
    public static final int SET1_3 = 230;
    public static final int SET1_4 = 231;
    public static final int SET1_5 = 232;
    public static final int SET1_6 = 233;
    public static final int SET1_7 = 234;
    public static final int SET1_8 = 235;
    public static final int SET1_9 = 236;
    public static final int SET2_3 = 237;
    public static final int SET2_4 = 238;
    public static final int SET2_5 = 239;
    public static final int SET2_6 = 240;
    public static final int SET2_7 = 241;
    public static final int SET2_8 = 242;
    public static final int SET3_3 = 243;
    public static final int SET3_4 = 244;
    public static final int SET3_5 = 245;
    public static final int SET3_6 = 246;
    public static final int SET3_7 = 247;
    public static final int SET3_8 = 248;
    public static final int SET3_9 = 249;
    public static final int SET3_10 = 250;
    public static final int SET3_11 = 251;
    public static final int SET3_12 = 252;
    public static final int PASTEL1_3 = 253;
    public static final int PASTEL1_4 = 254;
    public static final int PASTEL1_5 = 255;
    public static final int PASTEL1_6 = 256;
    public static final int PASTEL1_7 = 257;
    public static final int PASTEL1_8 = 258;
    public static final int PASTEL1_9 = 259;
    public static final int PASTEL2_3 = 260;
    public static final int PASTEL2_4 = 261;
    public static final int PASTEL2_5 = 262;
    public static final int PASTEL2_6 = 263;
    public static final int PASTEL2_7 = 264;
    public static final int PASTEL2_8 = 265;
    public static final int DARK2_3 = 266;
    public static final int DARK2_4 = 267;
    public static final int DARK2_5 = 268;
    public static final int DARK2_6 = 269;
    public static final int DARK2_7 = 270;
    public static final int DARK2_8 = 271;
    public static final int PAIRED_3 = 272;
    public static final int PAIRED_4 = 273;
    public static final int PAIRED_5 = 274;
    public static final int PAIRED_6 = 275;
    public static final int PAIRED_7 = 276;
    public static final int PAIRED_8 = 277;
    public static final int PAIRED_9 = 278;
    public static final int PAIRED_10 = 279;
    public static final int PAIRED_11 = 280;
    public static final int PAIRED_12 = 281;
    public static final int ACCENT_3 = 282;
    public static final int ACCENT_4 = 283;
    public static final int ACCENT_5 = 284;
    public static final int ACCENT_6 = 285;
    public static final int ACCENT_7 = 286;
    public static final int ACCENT_8 = 287;
    public static final int BLACK = 999;
    static final long serialVersionUID = 969046130790808050L;
    private Vector<ColourRule> cTable;
    private int cTableType;
    private String name;
    private boolean isDiscrete;
    private static final int ALF = -16777216;
    private static final int RED = 0xFF0000;
    private static final int GRN = 65280;
    private static final int BLU = 255;

    public ColourTable() {
        this.cTable = new Vector();
        this.cTableType = 1;
        this.name = "User";
        this.isDiscrete = false;
        this.cTable.add(new ColourRule(-3.4028235E38f, 255, 255, 255, 0));
    }

    public ColourTable(ColourTable oldColourTable) {
        this.cTableType = oldColourTable.getColourTableType();
        this.name = oldColourTable.name;
        this.isDiscrete = oldColourTable.isDiscrete;
        this.cTable = new Vector();
        this.cTable.add(new ColourRule(-3.4028235E38f, 255, 255, 255, 0));
        if (this.cTableType == 2 || this.cTableType == 3) {
            return;
        }
        ColourRule rule = null;
        int i = 1;
        while (i < oldColourTable.getColourRules().size()) {
            rule = oldColourTable.getColourRules().get(i);
            if (rule.getType() == 2) {
                this.addDiscreteColourRule(rule.getlIndex(), rule.getColour(rule.getlIndex()));
            } else {
                this.addContinuousColourRule(rule.getlIndex(), rule.getColour(rule.getlIndex()));
            }
            ++i;
        }
        if (rule != null && rule.getlIndex() != rule.getuIndex()) {
            this.addContinuousColourRule(rule.getuIndex(), rule.getColour(rule.getuIndex()));
        }
    }

    public void addDiscreteColourRule(float index, int r, int g, int b) {
        this.addDiscreteColourRule(index, 0xFF000000 | r << 16 | g << 8 | b);
    }

    public void addDiscreteColourRule(float index, int r, int g, int b, int a) {
        this.addDiscreteColourRule(index, a << 24 | r << 16 | g << 8 | b);
    }

    public void addDiscreteColourRule(float index, int colour) {
        int i = 1;
        while (i < this.cTable.size()) {
            ColourRule rule = this.cTable.get(i);
            if (rule.getlIndex() >= index) break;
            ++i;
        }
        this.cTable.add(i, new ColourRule(index, colour));
    }

    public void addContinuousColourRule(float index, int r, int g, int b) {
        this.addContinuousColourRule(index, 0xFF000000 | r << 16 | g << 8 | b);
    }

    public void addContinuousColourRule(float index, int r, int g, int b, int a) {
        this.addContinuousColourRule(index, a << 24 | r << 16 | g << 8 | b);
    }

    public void addContinuousColourRule(float index, int colour) {
        ColourRule prevContinuousRule = null;
        ColourRule nextRule = null;
        int i = 1;
        while (i < this.cTable.size()) {
            nextRule = this.cTable.get(i);
            if (nextRule.getlIndex() == index) {
                ColourRule rule = nextRule;
                rule.setlColour(colour);
                rule.setType(1);
                int j = i + 1;
                while (j < this.cTable.size()) {
                    nextRule = this.cTable.get(j);
                    if (nextRule.getType() == 1) {
                        rule.setuColour(nextRule.getlColour());
                        rule.setuIndex(nextRule.getlIndex());
                        break;
                    }
                    ++j;
                }
                if (prevContinuousRule != null) {
                    prevContinuousRule.setuColour(colour);
                }
                return;
            }
            if (nextRule.getlIndex() > index) {
                boolean foundRule = false;
                int j = i;
                while (j < this.cTable.size()) {
                    nextRule = this.cTable.get(j);
                    if (nextRule.getType() == 1) {
                        this.cTable.add(i, new ColourRule(index, colour, nextRule.getlIndex(), nextRule.getlColour()));
                        foundRule = true;
                        break;
                    }
                    ++j;
                }
                if (!foundRule) {
                    this.cTable.add(i, new ColourRule(index, colour, index, colour));
                }
                if (prevContinuousRule != null) {
                    prevContinuousRule.setuIndex(index);
                    prevContinuousRule.setuColour(colour);
                }
                return;
            }
            if (nextRule.getType() == 1) {
                prevContinuousRule = nextRule;
            }
            ++i;
        }
        this.cTable.add(new ColourRule(index, colour, index, colour));
        if (prevContinuousRule != null) {
            prevContinuousRule.setuIndex(index);
            prevContinuousRule.setuColour(colour);
        }
    }

    public boolean removeColourRule(float index) {
        ColourRule prevContinuousRule = null;
        ColourRule ruleToRemove = null;
        ColourRule nextContinuousRule = null;
        ColourRule rule = null;
        int i = 1;
        while (i < this.cTable.size()) {
            rule = this.cTable.get(i);
            if (rule.getlIndex() == index) {
                ruleToRemove = rule;
            } else {
                if (ruleToRemove == null && rule.getType() == 1) {
                    prevContinuousRule = rule;
                }
                if (ruleToRemove != null && rule.getType() == 1) {
                    nextContinuousRule = rule;
                    break;
                }
            }
            ++i;
        }
        if (ruleToRemove == null) {
            return false;
        }
        if (prevContinuousRule != null) {
            if (nextContinuousRule != null) {
                prevContinuousRule.setuColour(nextContinuousRule.getlColour());
                prevContinuousRule.setuIndex(nextContinuousRule.getlIndex());
            } else {
                prevContinuousRule.setuColour(prevContinuousRule.getlColour());
                prevContinuousRule.setuIndex(prevContinuousRule.getlIndex());
            }
        }
        return this.cTable.remove(ruleToRemove);
    }

    public boolean modifyColourRule(float existingIndex, float newIndex, int newColour, int newType) {
        ColourRule prevContinuousRule = null;
        ColourRule nextRule = null;
        int i = 1;
        while (i < this.cTable.size()) {
            nextRule = this.cTable.get(i);
            if (nextRule.getlIndex() == existingIndex) {
                int j;
                ColourRule rule = nextRule;
                rule.setlColour(newColour);
                rule.setlIndex(newIndex);
                rule.setType(newType);
                if (newType == 2) {
                    rule.setuColour(newColour);
                    rule.setuIndex(newIndex);
                } else {
                    j = i + 1;
                    while (j < this.cTable.size()) {
                        nextRule = this.cTable.get(j);
                        if (nextRule.getType() == 1) {
                            rule.setuColour(nextRule.getlColour());
                            rule.setuIndex(nextRule.getlIndex());
                            break;
                        }
                        ++j;
                    }
                }
                if (prevContinuousRule != null) {
                    if (newType == 2) {
                        j = i + 1;
                        while (j < this.cTable.size()) {
                            nextRule = this.cTable.get(j);
                            if (nextRule.getType() == 1) {
                                prevContinuousRule.setuColour(nextRule.getlColour());
                                prevContinuousRule.setuIndex(nextRule.getlIndex());
                                break;
                            }
                            ++j;
                        }
                    } else {
                        prevContinuousRule.setuColour(newColour);
                        prevContinuousRule.setuIndex(newIndex);
                    }
                }
                return true;
            }
            if (nextRule.getType() == 1) {
                prevContinuousRule = nextRule;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int findColour(float index) {
        i = 1;
        nearest = 0;
        minDistance = 3.4028235E38f;
        if (this.cTableType == 2) {
            return (int)index;
        }
        if (this.cTableType == 3) {
            return Float.floatToRawIntBits(index);
        }
        if (index == 1.4E-45f) {
            return 0;
        }
        if (this.cTable.size() == 1) {
            rule = this.cTable.firstElement();
            return rule.getlColour();
        }
        rule = this.cTable.get(1);
        if (!(index <= rule.getlIndex())) ** GOTO lbl20
        return rule.getlColour();
lbl-1000:
        // 1 sources

        {
            rule = this.cTable.get(i);
            if (rule.getType() == 2 && index == rule.getlIndex()) {
                return rule.getlColour();
            }
            ++i;
lbl20:
            // 2 sources

            ** while (i < this.cTable.size())
        }
lbl21:
        // 1 sources

        i = 1;
        while (i < this.cTable.size()) {
            rule = this.cTable.get(i);
            if (index >= rule.getlIndex() && index <= rule.getuIndex()) {
                return rule.getColour(index);
            }
            if (Math.abs(index - rule.getlIndex()) < minDistance) {
                nearest = rule.getColour(rule.getlIndex());
                minDistance = Math.abs(index - rule.getlIndex());
            }
            ++i;
        }
        if (index >= rule.getuIndex()) {
            nearest = rule.getuColour();
        }
        return nearest;
    }

    public float getMinIndex() {
        if (this.cTable.size() <= 1) {
            return 0.0f;
        }
        ColourRule rule = this.cTable.elementAt(1);
        return rule.getlIndex();
    }

    public float getMaxIndex() {
        if (this.cTable.size() <= 1) {
            return 0.0f;
        }
        ColourRule rule = this.cTable.lastElement();
        return rule.getuIndex();
    }

    public boolean getIsDiscrete() {
        return this.isDiscrete;
    }

    public void setIsDiscrete(boolean isDiscrete) {
        this.isDiscrete = isDiscrete;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        ColourRule rule = null;
        if (this.cTableType == 2) {
            return "Raw colour table";
        }
        if (this.cTable.size() <= 1) {
            return "Empty colour table";
        }
        StringBuffer output = new StringBuffer();
        Iterator<ColourRule> i = this.cTable.iterator();
        i.next();
        while (i.hasNext()) {
            rule = i.next();
            output.append(rule.toString());
        }
        if (rule == null) {
            return "Empty colour table";
        }
        if (rule.getlIndex() != rule.getuIndex()) {
            int alpha = (rule.getColour(rule.getuIndex()) & 0xFF000000) >> 24;
            int red = (rule.getColour(rule.getuIndex()) & 0xFF0000) >> 16;
            int green = (rule.getColour(rule.getuIndex()) & 0xFF00) >> 8;
            int blue = rule.getColour(rule.getuIndex()) & 0xFF;
            if (alpha < 0) {
                alpha += 256;
            }
            output.append(String.valueOf(rule.getlIndex()) + ": " + red + "," + green + "," + blue + "," + alpha + "\n");
        }
        return output.toString();
    }

    public String[] toStringArray() {
        String[] output = null;
        ColourRule rule = null;
        if (this.cTable.size() <= 1) {
            output = new String[]{new String("Empty colour table")};
            return output;
        }
        output = new String[this.cTable.size() - 1];
        int i = 1;
        while (i < this.cTable.size()) {
            rule = this.cTable.get(i);
            output[i - 1] = new String(rule.toString());
            ++i;
        }
        return output;
    }

    public ListModel toListModel() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        if (this.cTable.size() <= 1) {
            listModel.addElement(new String("Empty colour table"));
        } else {
            int i = 1;
            while (i < this.cTable.size()) {
                ColourRule rule = this.cTable.get(i);
                listModel.addElement(rule);
                ++i;
            }
        }
        return listModel;
    }

    public int getColourTableType() {
        return this.cTableType;
    }

    public void setColourTableType(int cTableType) {
        if (cTableType == this.cTableType) {
            return;
        }
        this.cTableType = cTableType;
        if (cTableType == 2) {
            this.name = "raw";
        } else if (cTableType == 3) {
            this.name = "attrib";
        } else if (cTableType == 1) {
            this.name = "user";
        }
    }

    public Vector<ColourRule> getColourRules() {
        return this.cTable;
    }

    public static int rgbaToArgb(int rgba) {
        int alpha = rgba << 24;
        return rgba >> 8 | alpha;
    }

    public static int argbToRgba(int argb) {
        int alpha = argb >> 24;
        return argb << 8 | alpha;
    }

    public static String getHexString(int colour) {
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        int alf = (colour & 0xFF000000) >> 24;
        if (alf < 0) {
            alf += 256;
        }
        if (alf < 255) {
            return new String("#" + ColourTable.paddedHex(red) + ColourTable.paddedHex(green) + ColourTable.paddedHex(blue) + ColourTable.paddedHex(alf));
        }
        return new String("#" + ColourTable.paddedHex(red) + ColourTable.paddedHex(green) + ColourTable.paddedHex(blue));
    }

    public static String getHexStringABGR(int colour) {
        int alf = (colour & 0xFF000000) >> 24;
        if (alf < 0) {
            alf += 256;
        }
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        return new String(String.valueOf(ColourTable.paddedHex(alf)) + ColourTable.paddedHex(blue) + ColourTable.paddedHex(green) + ColourTable.paddedHex(red));
    }

    public static int getAlpha(int colour) {
        int alf = (colour & 0xFF000000) >> 24;
        if (alf < 0) {
            alf += 256;
        }
        return alf;
    }

    private static String paddedHex(int i) {
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static ColourTable getPresetColourTable(int type) {
        return ColourTable.getPresetColourTable(type, Float.NaN, Float.NaN);
    }

    private static float getDefaultMin(int type) {
        switch (type) {
            case 111: 
            case 112: 
            case 113: 
            case 137: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                return -1.0f;
            }
            case 151: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    private static float getDefaultMax(int type, float min) {
        float validMin = min;
        if (Float.isNaN(validMin)) {
            validMin = ColourTable.getDefaultMin(type);
        }
        switch (type) {
            case 151: {
                return validMin - 1.0f + 10.0f;
            }
            case 101: {
                return 15.0f;
            }
            case 230: 
            case 237: 
            case 243: 
            case 253: 
            case 260: 
            case 266: 
            case 272: 
            case 282: {
                return validMin - 1.0f + 3.0f;
            }
            case 231: 
            case 238: 
            case 244: 
            case 254: 
            case 261: 
            case 267: 
            case 273: 
            case 283: {
                return validMin - 1.0f + 4.0f;
            }
            case 232: 
            case 239: 
            case 245: 
            case 255: 
            case 262: 
            case 268: 
            case 274: 
            case 284: {
                return validMin - 1.0f + 5.0f;
            }
            case 233: 
            case 240: 
            case 246: 
            case 256: 
            case 263: 
            case 269: 
            case 275: 
            case 285: {
                return validMin - 1.0f + 6.0f;
            }
            case 234: 
            case 241: 
            case 247: 
            case 257: 
            case 264: 
            case 270: 
            case 276: 
            case 286: {
                return validMin - 1.0f + 7.0f;
            }
            case 235: 
            case 242: 
            case 248: 
            case 258: 
            case 265: 
            case 271: 
            case 277: 
            case 287: {
                return validMin - 1.0f + 8.0f;
            }
            case 236: 
            case 249: 
            case 259: 
            case 278: {
                return validMin - 1.0f + 9.0f;
            }
            case 250: 
            case 279: {
                return validMin - 1.0f + 10.0f;
            }
            case 251: 
            case 280: {
                return validMin - 1.0f + 11.0f;
            }
            case 252: 
            case 281: {
                return validMin - 1.0f + 12.0f;
            }
        }
        return 1.0f;
    }

    public static ColourTable getPresetColourTable(int type, float min, float max) {
        float validMin = min;
        float validMax = max;
        if (Float.isNaN(validMin)) {
            validMin = ColourTable.getDefaultMin(type);
        }
        if (Float.isNaN(validMax)) {
            validMax = ColourTable.getDefaultMax(type, validMin);
        }
        float range = validMax - validMin;
        ColourTable colours = new ColourTable();
        if (range <= 0.0f) {
            colours.addContinuousColourRule(validMax, 0, 0, 0);
            colours.addContinuousColourRule(validMin, 0, 0, 0);
            return colours;
        }
        switch (type) {
            case 103: {
                colours.name = "slope";
                colours.addContinuousColourRule(0.0f, 255, 255, 255);
                colours.addContinuousColourRule(10.0f, 255, 255, 0);
                colours.addContinuousColourRule(30.0f, 255, 0, 0);
                colours.addContinuousColourRule(90.0f, 0, 0, 0);
                break;
            }
            case 104: {
                colours.name = "aspect";
                colours.addContinuousColourRule(0.0f, 255, 127, 127);
                colours.addContinuousColourRule(45.0f, 255, 0, 0);
                colours.addContinuousColourRule(135.0f, 0, 0, 0);
                colours.addContinuousColourRule(225.0f, 0, 0, 255);
                colours.addContinuousColourRule(315.0f, 255, 255, 255);
                colours.addContinuousColourRule(360.0f, 255, 127, 127);
                break;
            }
            case 101: {
                colours.name = "features";
                colours.addDiscreteColourRule(0.0f, 50, 50, 50, 0);
                colours.addDiscreteColourRule(1.0f, 0, 0, 0);
                colours.addDiscreteColourRule(2.0f, 0, 0, 200);
                colours.addDiscreteColourRule(3.0f, 0, 150, 0);
                colours.addDiscreteColourRule(4.0f, 250, 250, 0);
                colours.addDiscreteColourRule(5.0f, 200, 0, 0);
                colours.addDiscreteColourRule(6.0f, 200, 200, 200);
                colours.addDiscreteColourRule(8.0f, 50, 50, 50, 0);
                colours.addDiscreteColourRule(11.0f, 100, 100, 100);
                colours.addDiscreteColourRule(15.0f, 150, 100, 100);
                colours.setIsDiscrete(true);
                break;
            }
            case 111: {
                colours.name = "diverging2";
                if (validMin > 0.0f) {
                    colours.addContinuousColourRule(validMin, 0, 0, 0);
                    colours.addContinuousColourRule(validMin + range / 3.0f, 0, 0, 255);
                    colours.addContinuousColourRule((validMax + validMin) / 2.0f, 255, 255, 255);
                    colours.addContinuousColourRule(validMax - range / 3.0f, 255, 0, 0);
                    colours.addContinuousColourRule(validMax, 0, 0, 0);
                    break;
                }
                float lowerInterval = 2.0f * (0.0f - validMin) / 3.0f;
                float upperInterval = 2.0f * validMax / 3.0f;
                colours.addContinuousColourRule(validMin, 0, 0, 0);
                colours.addContinuousColourRule(validMin + lowerInterval, 0, 0, 255);
                colours.addContinuousColourRule(0.0f, 255, 255, 255);
                colours.addContinuousColourRule(validMax - upperInterval, 255, 0, 0);
                colours.addContinuousColourRule(validMax, 0, 0, 0);
                break;
            }
            case 112: {
                colours.name = "diverging3";
                if (validMin > 0.0f) {
                    colours.addContinuousColourRule(validMin, 0, 0, 0);
                    colours.addContinuousColourRule(validMin + range / 3.0f, 0, 255, 0);
                    colours.addContinuousColourRule((validMax + validMin) / 2.0f, 255, 255, 255);
                    colours.addContinuousColourRule(validMax - range / 3.0f, 255, 255, 0);
                    colours.addContinuousColourRule(validMax, 0, 0, 0);
                    break;
                }
                float lowerInterval = 2.0f * (0.0f - validMin) / 3.0f;
                float upperInterval = 2.0f * validMax / 3.0f;
                colours.addContinuousColourRule(validMin, 0, 0, 0);
                colours.addContinuousColourRule(validMin + lowerInterval, 0, 255, 0);
                colours.addContinuousColourRule(0.0f, 255, 255, 255);
                colours.addContinuousColourRule(validMax - upperInterval, 255, 255, 0);
                colours.addContinuousColourRule(validMax, 0, 0, 0);
                break;
            }
            case 113: {
                colours.name = "diverging1";
                if (validMin > 0.0f) {
                    float interval = range / 12.0f;
                    colours.addContinuousColourRule(validMin, 49, 54, 149);
                    colours.addContinuousColourRule(validMin + interval, 49, 54, 149);
                    colours.addContinuousColourRule(validMin + 2.0f * interval, 69, 117, 180);
                    colours.addContinuousColourRule(validMin + 3.0f * interval, 116, 173, 209);
                    colours.addContinuousColourRule(validMin + 4.0f * interval, 171, 217, 233);
                    colours.addContinuousColourRule(validMin + 5.0f * interval, 224, 243, 248);
                    colours.addContinuousColourRule(validMin + 6.0f * interval, 255, 255, 191);
                    colours.addContinuousColourRule(validMin + 7.0f * interval, 254, 224, 144);
                    colours.addContinuousColourRule(validMin + 8.0f * interval, 253, 174, 97);
                    colours.addContinuousColourRule(validMin + 9.0f * interval, 244, 109, 67);
                    colours.addContinuousColourRule(validMin + 10.0f * interval, 215, 48, 39);
                    colours.addContinuousColourRule(validMin + 11.0f * interval, 165, 0, 38);
                    colours.addContinuousColourRule(validMax, 165, 0, 38);
                    break;
                }
                float lowerInterval = (0.0f - validMin) / 6.0f;
                float upperInterval = validMax / 6.0f;
                colours.addContinuousColourRule(validMin, 49, 54, 149);
                colours.addContinuousColourRule(validMin + lowerInterval, 49, 54, 149);
                colours.addContinuousColourRule(validMin + 2.0f * lowerInterval, 69, 117, 180);
                colours.addContinuousColourRule(validMin + 3.0f * lowerInterval, 116, 173, 209);
                colours.addContinuousColourRule(validMin + 4.0f * lowerInterval, 171, 217, 233);
                colours.addContinuousColourRule(validMin + 5.0f * lowerInterval, 224, 243, 248);
                colours.addContinuousColourRule(0.0f, 255, 255, 191);
                colours.addContinuousColourRule(upperInterval, 254, 224, 144);
                colours.addContinuousColourRule(2.0f * upperInterval, 253, 174, 97);
                colours.addContinuousColourRule(3.0f * upperInterval, 244, 109, 67);
                colours.addContinuousColourRule(4.0f * upperInterval, 215, 48, 39);
                colours.addContinuousColourRule(5.0f * upperInterval, 165, 0, 38);
                colours.addContinuousColourRule(validMax, 165, 0, 38);
                break;
            }
            case 121: {
                colours.name = "grey1";
                colours.addContinuousColourRule(validMin, 0, 0, 0);
                colours.addContinuousColourRule(validMax, 255, 255, 255);
                break;
            }
            case 122: {
                colours.name = "grey2";
                colours.addContinuousColourRule(validMin, 255, 255, 255);
                colours.addContinuousColourRule(validMax, 0, 0, 0);
                break;
            }
            case 131: {
                colours.name = "land1";
                float interval = range / 6.5f;
                colours.addContinuousColourRule(validMin, 98, 123, 92);
                colours.addContinuousColourRule(validMin + interval, 130, 152, 117);
                colours.addContinuousColourRule(validMin + 2.0f * interval, 155, 180, 139);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 196, 197, 160);
                colours.addContinuousColourRule(validMin + 4.0f * interval, 229, 216, 175);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 244, 232, 195);
                colours.addContinuousColourRule(validMin + 6.0f * interval, 249, 242, 230);
                colours.addContinuousColourRule(validMax, 249, 242, 230);
                break;
            }
            case 132: {
                colours.name = "land2";
                float interval = range / 6.5f;
                colours.addContinuousColourRule(validMin, 161, 212, 179);
                colours.addContinuousColourRule(validMin + interval, 199, 221, 182);
                colours.addContinuousColourRule(validMin + 2.0f * interval, 231, 234, 195);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 248, 231, 190);
                colours.addContinuousColourRule(validMin + 4.0f * interval, 235, 213, 174);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 224, 195, 158);
                colours.addContinuousColourRule(validMin + 6.0f * interval, 216, 172, 136);
                colours.addContinuousColourRule(validMax, 216, 172, 136);
                break;
            }
            case 133: {
                colours.name = "land3";
                float interval = range / 6.5f;
                colours.addContinuousColourRule(validMin, 141, 166, 141);
                colours.addContinuousColourRule(validMin + interval, 172, 194, 155);
                colours.addContinuousColourRule(validMin + 2.0f * interval, 221, 219, 167);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 254, 235, 181);
                colours.addContinuousColourRule(validMin + 4.0f * interval, 248, 212, 153);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 241, 170, 109);
                colours.addContinuousColourRule(validMin + 6.0f * interval, 227, 112, 72);
                colours.addContinuousColourRule(validMax, 227, 112, 72);
                break;
            }
            case 134: {
                colours.name = "land4";
                float interval = range / 7.0f;
                colours.addContinuousColourRule(validMin, 153, 201, 171);
                colours.addContinuousColourRule(validMin + interval, 202, 224, 190);
                colours.addContinuousColourRule(validMin + 2.0f * interval, 252, 239, 201);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 252, 222, 197);
                colours.addContinuousColourRule(validMin + 4.0f * interval, 254, 207, 177);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 217, 199, 210);
                colours.addContinuousColourRule(validMin + 6.0f * interval, 242, 228, 227);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 255, 255, 255);
                colours.addContinuousColourRule(validMax, 255, 255, 255);
                break;
            }
            case 135: {
                colours.name = "sea1";
                float interval = range / 7.8f;
                colours.addContinuousColourRule(validMin, 112, 193, 189);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 153, 210, 198);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 182, 222, 211);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 224, 232, 223);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 255, 255, 255);
                colours.addContinuousColourRule(validMax, 255, 255, 255);
                break;
            }
            case 136: {
                colours.name = "sea2";
                float interval = range / 8.0f;
                colours.addContinuousColourRule(validMin, 69, 171, 178);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 121, 200, 191);
                colours.addContinuousColourRule(validMin + 5.0f * interval, 154, 211, 204);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 195, 227, 212);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 224, 232, 230);
                colours.addContinuousColourRule(validMin + 7.9f * interval, 255, 255, 255);
                colours.addContinuousColourRule(validMax, 255, 255, 255);
                break;
            }
            case 137: {
                colours.name = "seaLand";
                float interval = (0.0f - validMin) / 6.0f;
                float minPos = 0.001f;
                if (interval >= 0.0f) {
                    colours.addContinuousColourRule(validMin, 40, 153, 162);
                    colours.addContinuousColourRule(validMin + interval, 92, 181, 176);
                    colours.addContinuousColourRule(validMin + 2.0f * interval, 120, 190, 188);
                    colours.addContinuousColourRule(validMin + 3.0f * interval, 169, 208, 203);
                    colours.addContinuousColourRule(validMin + 4.0f * interval, 207, 220, 210);
                    colours.addContinuousColourRule(validMin + 5.0f * interval, 234, 228, 218);
                    colours.addContinuousColourRule(0.0f, 234, 228, 218);
                }
                if (!((interval = (validMax - minPos) / 6.5f) > 0.0f)) break;
                colours.addContinuousColourRule(minPos, 134, 189, 155);
                colours.addContinuousColourRule(minPos + interval, 179, 205, 174);
                colours.addContinuousColourRule(minPos + 2.0f * interval, 229, 216, 184);
                colours.addContinuousColourRule(minPos + 3.0f * interval, 228, 216, 181);
                colours.addContinuousColourRule(minPos + 4.0f * interval, 217, 198, 166);
                colours.addContinuousColourRule(minPos + 5.0f * interval, 201, 179, 149);
                colours.addContinuousColourRule(minPos + 6.0f * interval, 189, 152, 123);
                colours.addContinuousColourRule(validMax, 189, 152, 123);
                break;
            }
            case 141: {
                colours.name = "exp1";
                colours.addContinuousColourRule(validMin, 255, 247, 236);
                colours.addContinuousColourRule(validMin + range / 500.0f, 254, 232, 200);
                colours.addContinuousColourRule(validMin + range / 200.0f, 253, 212, 158);
                colours.addContinuousColourRule(validMin + range / 100.0f, 253, 187, 132);
                colours.addContinuousColourRule(validMin + range / 50.0f, 252, 141, 89);
                colours.addContinuousColourRule(validMin + range / 20.0f, 239, 101, 72);
                colours.addContinuousColourRule(validMin + range / 10.0f, 215, 48, 31);
                colours.addContinuousColourRule(validMin + range / 5.0f, 179, 0, 0);
                colours.addContinuousColourRule(validMin + range / 2.0f, 127, 0, 0);
                colours.addContinuousColourRule(validMax, 64, 0, 0);
                break;
            }
            case 151: {
                colours.name = "random";
                float interval = validMax - validMin > 2.0f ? 1.0f : (validMax - validMin) / 100.0f;
                int prevRed = -999;
                int prevGrn = -999;
                int prevBlu = -999;
                int diff = 0;
                float i = validMin;
                while (i < validMax + interval) {
                    int blu;
                    int grn;
                    int red;
                    do {
                        red = (int)(Math.random() * 150.0);
                        grn = (int)(Math.random() * 150.0);
                        blu = (int)(Math.random() * 150.0);
                    } while ((diff = Math.abs(red - prevRed) + Math.abs(grn - prevGrn) + Math.abs(blu - prevBlu)) < 50);
                    colours.addDiscreteColourRule(i, red + 100, grn + 100, blu + 100);
                    prevRed = red;
                    prevGrn = grn;
                    prevBlu = blu;
                    i += interval;
                }
                colours.setIsDiscrete(true);
                break;
            }
            case 999: {
                colours.name = "black";
                colours.addContinuousColourRule(validMin, 0, 0, 0);
                colours.addContinuousColourRule(validMax, 0, 0, 0);
                break;
            }
            case 201: {
                colours.name = "YlGn";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 255, 229);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 255, 229);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 247, 252, 185);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 217, 240, 163);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 173, 221, 142);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 120, 198, 121);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 65, 171, 93);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 35, 132, 67);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 0, 104, 55);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 0, 69, 41);
                colours.addContinuousColourRule(validMax, 0, 69, 41);
                break;
            }
            case 202: {
                colours.name = "YlGnBu";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 255, 217);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 255, 217);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 237, 248, 177);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 199, 233, 180);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 127, 205, 187);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 65, 182, 196);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 29, 145, 192);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 34, 94, 168);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 37, 52, 148);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 8, 29, 88);
                colours.addContinuousColourRule(validMax, 8, 29, 88);
                break;
            }
            case 203: {
                colours.name = "GnBu";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 252, 240);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 252, 240);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 224, 243, 219);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 204, 235, 197);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 168, 221, 181);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 123, 204, 196);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 78, 179, 211);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 43, 140, 190);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 8, 104, 172);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 8, 64, 129);
                colours.addContinuousColourRule(validMax, 8, 64, 129);
                break;
            }
            case 204: {
                colours.name = "BuGn";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 252, 253);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 252, 253);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 229, 245, 249);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 204, 236, 230);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 153, 216, 201);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 102, 194, 164);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 65, 174, 118);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 35, 139, 69);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 0, 109, 44);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 0, 68, 27);
                colours.addContinuousColourRule(validMax, 0, 68, 27);
                break;
            }
            case 205: {
                colours.name = "PuBuGn";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 247, 251);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 247, 251);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 236, 226, 240);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 208, 209, 230);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 166, 189, 219);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 103, 169, 207);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 54, 144, 192);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 2, 129, 138);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 1, 108, 89);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 1, 70, 54);
                colours.addContinuousColourRule(validMax, 1, 70, 54);
                break;
            }
            case 206: {
                colours.name = "PuBu";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 247, 251);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 247, 251);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 236, 231, 242);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 208, 209, 230);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 166, 189, 219);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 116, 169, 207);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 54, 144, 192);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 5, 112, 176);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 4, 90, 141);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 2, 56, 88);
                colours.addContinuousColourRule(validMax, 2, 56, 88);
                break;
            }
            case 207: {
                colours.name = "BuPu";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 252, 253);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 252, 253);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 224, 236, 244);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 191, 211, 230);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 158, 188, 218);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 140, 150, 198);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 140, 107, 177);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 136, 65, 157);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 129, 15, 124);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 77, 0, 75);
                colours.addContinuousColourRule(validMax, 77, 0, 75);
                break;
            }
            case 208: {
                colours.name = "RdPu";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 247, 243);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 247, 243);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 253, 224, 221);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 252, 197, 192);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 250, 159, 181);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 247, 104, 161);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 221, 52, 151);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 174, 1, 126);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 122, 1, 119);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 73, 0, 106);
                colours.addContinuousColourRule(validMax, 73, 0, 106);
                break;
            }
            case 209: {
                colours.name = "PuRd";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 244, 249);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 244, 249);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 231, 225, 239);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 212, 185, 218);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 201, 148, 199);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 223, 101, 176);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 231, 41, 138);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 206, 18, 86);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 152, 0, 67);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 103, 0, 31);
                colours.addContinuousColourRule(validMax, 103, 0, 31);
                break;
            }
            case 210: {
                colours.name = "OrRd";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 247, 236);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 247, 236);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 254, 232, 200);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 253, 212, 158);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 187, 132);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 252, 141, 89);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 239, 101, 72);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 215, 48, 31);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 179, 0, 0);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 127, 0, 0);
                colours.addContinuousColourRule(validMax, 127, 0, 0);
                break;
            }
            case 211: {
                colours.name = "YlOrRd";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 255, 204);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 255, 204);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 255, 237, 160);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 254, 217, 118);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 254, 178, 76);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 253, 141, 60);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 252, 78, 42);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 227, 26, 28);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 189, 0, 38);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 128, 0, 38);
                colours.addContinuousColourRule(validMax, 128, 0, 38);
                break;
            }
            case 212: {
                colours.name = "YlOrBr";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 255, 229);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 255, 229);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 255, 247, 188);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 254, 227, 145);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 254, 196, 79);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 254, 153, 41);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 236, 112, 20);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 204, 76, 2);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 153, 52, 4);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 102, 37, 6);
                colours.addContinuousColourRule(validMax, 102, 37, 6);
                break;
            }
            case 213: {
                colours.name = "purples";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 252, 251, 253);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 252, 251, 253);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 239, 237, 245);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 218, 218, 235);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 188, 189, 220);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 158, 154, 200);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 128, 125, 186);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 106, 81, 163);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 84, 39, 143);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 63, 0, 125);
                colours.addContinuousColourRule(validMax, 63, 0, 125);
                break;
            }
            case 214: {
                colours.name = "blues";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 251, 255);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 251, 255);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 222, 235, 247);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 198, 219, 239);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 158, 202, 225);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 107, 174, 214);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 66, 146, 198);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 33, 113, 181);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 8, 81, 156);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 8, 48, 107);
                colours.addContinuousColourRule(validMax, 8, 48, 107);
                break;
            }
            case 215: {
                colours.name = "greens";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 247, 252, 245);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 247, 252, 245);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 229, 245, 224);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 199, 233, 192);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 161, 217, 155);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 116, 196, 118);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 65, 171, 93);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 35, 139, 69);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 0, 109, 44);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 0, 68, 27);
                colours.addContinuousColourRule(validMax, 0, 68, 27);
                break;
            }
            case 216: {
                colours.name = "oranges";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 245, 235);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 245, 235);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 254, 230, 206);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 253, 208, 162);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 174, 107);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 253, 141, 60);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 241, 105, 19);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 217, 72, 1);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 166, 54, 3);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 127, 39, 4);
                colours.addContinuousColourRule(validMax, 127, 39, 4);
                break;
            }
            case 217: {
                colours.name = "reds";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 245, 240);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 245, 240);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 254, 224, 210);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 252, 187, 161);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 252, 146, 114);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 251, 106, 74);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 239, 59, 44);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 203, 24, 29);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 165, 15, 21);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 103, 0, 13);
                colours.addContinuousColourRule(validMax, 103, 0, 13);
                break;
            }
            case 218: {
                colours.name = "greys";
                float interval = range / 9.0f;
                colours.addContinuousColourRule(validMin, 255, 255, 255);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 255, 255, 255);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 240, 240, 240);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 217, 217, 217);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 189, 189, 189);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 150, 150, 150);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 115, 115, 115);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 82, 82, 82);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 37, 37, 37);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 0, 0, 0);
                colours.addContinuousColourRule(validMax, 0, 0, 0);
                break;
            }
            case 219: {
                colours.name = "PuOr";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 127, 59, 8);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 127, 59, 8);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 179, 88, 6);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 224, 130, 20);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 184, 99);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 254, 224, 182);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 247, 247, 247);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 216, 218, 235);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 178, 171, 210);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 128, 115, 172);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 84, 39, 136);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 45, 0, 75);
                colours.addContinuousColourRule(validMax, 45, 0, 75);
                break;
            }
            case 220: {
                colours.name = "BrBG";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 84, 48, 5);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 84, 48, 5);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 140, 81, 10);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 191, 129, 45);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 223, 194, 125);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 246, 232, 195);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 245, 245, 245);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 199, 234, 229);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 128, 205, 193);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 53, 151, 143);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 1, 102, 94);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 0, 60, 48);
                colours.addContinuousColourRule(validMax, 0, 60, 48);
                break;
            }
            case 221: {
                colours.name = "PRGn";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 64, 0, 75);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 64, 0, 75);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 118, 42, 131);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 153, 112, 171);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 194, 165, 207);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 231, 212, 232);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 247, 247, 247);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 217, 240, 211);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 166, 219, 160);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 90, 174, 97);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 27, 120, 55);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 0, 68, 27);
                colours.addContinuousColourRule(validMax, 0, 68, 27);
                break;
            }
            case 222: {
                colours.name = "PiYG";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 142, 1, 82);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 142, 1, 82);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 197, 27, 125);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 222, 119, 174);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 241, 182, 218);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 253, 224, 239);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 247, 247, 247);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 230, 245, 208);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 184, 225, 134);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 127, 188, 65);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 77, 146, 33);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 39, 100, 25);
                colours.addContinuousColourRule(validMax, 39, 100, 25);
                break;
            }
            case 223: {
                colours.name = "RdBu";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 103, 0, 31);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 103, 0, 31);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 178, 24, 43);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 214, 96, 77);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 244, 165, 130);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 253, 219, 199);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 247, 247, 247);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 209, 229, 240);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 146, 197, 222);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 67, 147, 195);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 33, 102, 172);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 5, 48, 97);
                colours.addContinuousColourRule(validMax, 5, 48, 97);
                break;
            }
            case 224: {
                colours.name = "RdGy";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 103, 0, 31);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 103, 0, 31);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 178, 24, 43);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 214, 96, 77);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 244, 165, 130);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 253, 219, 199);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 255, 255, 255);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 224, 224, 224);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 186, 186, 186);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 135, 135, 135);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 77, 77, 77);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 26, 26, 26);
                colours.addContinuousColourRule(validMax, 26, 26, 26);
                break;
            }
            case 225: {
                colours.name = "RdYlBu";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 165, 0, 38);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 165, 0, 38);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 215, 48, 39);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 244, 109, 67);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 174, 97);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 254, 224, 144);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 255, 255, 191);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 224, 243, 248);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 171, 217, 233);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 116, 173, 209);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 69, 117, 180);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 49, 54, 149);
                colours.addContinuousColourRule(validMax, 49, 54, 149);
                break;
            }
            case 226: {
                colours.name = "spectral";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 158, 1, 66);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 158, 1, 66);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 213, 62, 79);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 244, 109, 67);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 174, 97);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 254, 224, 139);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 255, 255, 191);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 230, 245, 152);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 171, 221, 164);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 102, 194, 165);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 50, 136, 189);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 94, 79, 162);
                colours.addContinuousColourRule(validMax, 94, 79, 162);
                break;
            }
            case 227: {
                colours.name = "RdYlGn";
                float interval = range / 11.0f;
                colours.addContinuousColourRule(validMin, 165, 0, 38);
                colours.addContinuousColourRule(validMin + 0.5f * interval, 165, 0, 38);
                colours.addContinuousColourRule(validMin + 1.5f * interval, 215, 48, 39);
                colours.addContinuousColourRule(validMin + 2.5f * interval, 244, 109, 67);
                colours.addContinuousColourRule(validMin + 3.5f * interval, 253, 174, 97);
                colours.addContinuousColourRule(validMin + 4.5f * interval, 254, 224, 139);
                colours.addContinuousColourRule(validMin + 5.5f * interval, 255, 255, 191);
                colours.addContinuousColourRule(validMin + 6.5f * interval, 217, 239, 139);
                colours.addContinuousColourRule(validMin + 7.5f * interval, 166, 217, 106);
                colours.addContinuousColourRule(validMin + 8.5f * interval, 102, 189, 99);
                colours.addContinuousColourRule(validMin + 9.5f * interval, 26, 152, 80);
                colours.addContinuousColourRule(validMin + 10.5f * interval, 0, 104, 55);
                colours.addContinuousColourRule(validMax, 0, 104, 55);
                break;
            }
            case 230: {
                colours.name = "Set1_3";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.setIsDiscrete(true);
                break;
            }
            case 231: {
                colours.name = "Set1_4";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.setIsDiscrete(true);
                break;
            }
            case 232: {
                colours.name = "Set1_5";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 127, 0);
                colours.setIsDiscrete(true);
                break;
            }
            case 233: {
                colours.name = "Set1_6";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 51);
                colours.setIsDiscrete(true);
                break;
            }
            case 234: {
                colours.name = "Set1_7";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 51);
                colours.addDiscreteColourRule(validMin + 6.0f, 166, 86, 40);
                colours.setIsDiscrete(true);
                break;
            }
            case 235: {
                colours.name = "Set1_8";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 51);
                colours.addDiscreteColourRule(validMin + 6.0f, 166, 86, 40);
                colours.addDiscreteColourRule(validMin + 7.0f, 247, 129, 191);
                colours.setIsDiscrete(true);
                break;
            }
            case 236: {
                colours.name = "Set1_9";
                colours.addDiscreteColourRule(validMin, 228, 26, 28);
                colours.addDiscreteColourRule(validMin + 1.0f, 55, 126, 184);
                colours.addDiscreteColourRule(validMin + 2.0f, 77, 175, 74);
                colours.addDiscreteColourRule(validMin + 3.0f, 152, 78, 163);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 51);
                colours.addDiscreteColourRule(validMin + 6.0f, 166, 86, 40);
                colours.addDiscreteColourRule(validMin + 7.0f, 247, 129, 191);
                colours.addDiscreteColourRule(validMin + 8.0f, 153, 153, 153);
                colours.setIsDiscrete(true);
                break;
            }
            case 237: {
                colours.name = "Set2_3";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.setIsDiscrete(true);
                break;
            }
            case 238: {
                colours.name = "Set2_4";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 138, 195);
                colours.setIsDiscrete(true);
                break;
            }
            case 239: {
                colours.name = "Set2_5";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 138, 195);
                colours.addDiscreteColourRule(validMin + 4.0f, 166, 216, 84);
                colours.setIsDiscrete(true);
                break;
            }
            case 240: {
                colours.name = "Set2_6";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 138, 195);
                colours.addDiscreteColourRule(validMin + 4.0f, 166, 216, 84);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 217, 47);
                colours.setIsDiscrete(true);
                break;
            }
            case 241: {
                colours.name = "Set2_7";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 138, 195);
                colours.addDiscreteColourRule(validMin + 4.0f, 166, 216, 84);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 217, 47);
                colours.addDiscreteColourRule(validMin + 6.0f, 229, 196, 148);
                colours.setIsDiscrete(true);
                break;
            }
            case 242: {
                colours.name = "Set2_8";
                colours.addDiscreteColourRule(validMin, 102, 194, 165);
                colours.addDiscreteColourRule(validMin + 1.0f, 252, 141, 98);
                colours.addDiscreteColourRule(validMin + 2.0f, 141, 160, 203);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 138, 195);
                colours.addDiscreteColourRule(validMin + 4.0f, 166, 216, 84);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 217, 47);
                colours.addDiscreteColourRule(validMin + 6.0f, 229, 196, 148);
                colours.addDiscreteColourRule(validMin + 7.0f, 179, 179, 179);
                colours.setIsDiscrete(true);
                break;
            }
            case 243: {
                colours.name = "Set3_3";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.setIsDiscrete(true);
                break;
            }
            case 244: {
                colours.name = "Set3_4";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.setIsDiscrete(true);
                break;
            }
            case 245: {
                colours.name = "Set3_5";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.setIsDiscrete(true);
                break;
            }
            case 246: {
                colours.name = "Set3_6";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.setIsDiscrete(true);
                break;
            }
            case 247: {
                colours.name = "Set3_7";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.setIsDiscrete(true);
                break;
            }
            case 248: {
                colours.name = "Set3_8";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.addDiscreteColourRule(validMin + 7.0f, 252, 205, 229);
                colours.setIsDiscrete(true);
                break;
            }
            case 249: {
                colours.name = "Set3_9";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.addDiscreteColourRule(validMin + 7.0f, 252, 205, 229);
                colours.addDiscreteColourRule(validMin + 8.0f, 217, 217, 217);
                colours.setIsDiscrete(true);
                break;
            }
            case 250: {
                colours.name = "Set3_10";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.addDiscreteColourRule(validMin + 7.0f, 252, 205, 229);
                colours.addDiscreteColourRule(validMin + 8.0f, 217, 217, 217);
                colours.addDiscreteColourRule(validMin + 9.0f, 188, 128, 189);
                colours.setIsDiscrete(true);
                break;
            }
            case 251: {
                colours.name = "Set3_11";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.addDiscreteColourRule(validMin + 7.0f, 252, 205, 229);
                colours.addDiscreteColourRule(validMin + 8.0f, 217, 217, 217);
                colours.addDiscreteColourRule(validMin + 9.0f, 188, 128, 189);
                colours.addDiscreteColourRule(validMin + 10.0f, 204, 235, 197);
                colours.setIsDiscrete(true);
                break;
            }
            case 252: {
                colours.name = "Set3_12";
                colours.addDiscreteColourRule(validMin, 141, 211, 199);
                colours.addDiscreteColourRule(validMin + 1.0f, 255, 255, 179);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 186, 218);
                colours.addDiscreteColourRule(validMin + 3.0f, 251, 128, 114);
                colours.addDiscreteColourRule(validMin + 4.0f, 128, 177, 211);
                colours.addDiscreteColourRule(validMin + 5.0f, 253, 180, 98);
                colours.addDiscreteColourRule(validMin + 6.0f, 179, 222, 105);
                colours.addDiscreteColourRule(validMin + 7.0f, 252, 205, 229);
                colours.addDiscreteColourRule(validMin + 8.0f, 217, 217, 217);
                colours.addDiscreteColourRule(validMin + 9.0f, 188, 128, 189);
                colours.addDiscreteColourRule(validMin + 10.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 11.0f, 255, 237, 111);
                colours.setIsDiscrete(true);
                break;
            }
            case 253: {
                colours.name = "Pastel1_3";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.setIsDiscrete(true);
                break;
            }
            case 254: {
                colours.name = "Pastel1_4";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.setIsDiscrete(true);
                break;
            }
            case 255: {
                colours.name = "Pastel1_5";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 254, 217, 166);
                colours.setIsDiscrete(true);
                break;
            }
            case 256: {
                colours.name = "Pastel1_6";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 254, 217, 166);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 204);
                colours.setIsDiscrete(true);
                break;
            }
            case 257: {
                colours.name = "Pastel1_7";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 254, 217, 166);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 204);
                colours.addDiscreteColourRule(validMin + 6.0f, 229, 216, 189);
                colours.setIsDiscrete(true);
                break;
            }
            case 258: {
                colours.name = "Pastel1_8";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 254, 217, 166);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 204);
                colours.addDiscreteColourRule(validMin + 6.0f, 229, 216, 189);
                colours.addDiscreteColourRule(validMin + 7.0f, 253, 218, 236);
                colours.setIsDiscrete(true);
                break;
            }
            case 259: {
                colours.name = "Pastel1_9";
                colours.addDiscreteColourRule(validMin, 251, 180, 174);
                colours.addDiscreteColourRule(validMin + 1.0f, 179, 205, 227);
                colours.addDiscreteColourRule(validMin + 2.0f, 204, 235, 197);
                colours.addDiscreteColourRule(validMin + 3.0f, 222, 203, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 254, 217, 166);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 255, 204);
                colours.addDiscreteColourRule(validMin + 6.0f, 229, 216, 189);
                colours.addDiscreteColourRule(validMin + 7.0f, 253, 218, 236);
                colours.addDiscreteColourRule(validMin + 8.0f, 242, 242, 242);
                colours.setIsDiscrete(true);
                break;
            }
            case 260: {
                colours.name = "Pastel2_3";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.setIsDiscrete(true);
                break;
            }
            case 261: {
                colours.name = "Pastel2_4";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.addDiscreteColourRule(validMin + 3.0f, 244, 202, 228);
                colours.setIsDiscrete(true);
                break;
            }
            case 262: {
                colours.name = "Pastel2_5";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.addDiscreteColourRule(validMin + 3.0f, 244, 202, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 230, 245, 201);
                colours.setIsDiscrete(true);
                break;
            }
            case 263: {
                colours.name = "Pastel2_6";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.addDiscreteColourRule(validMin + 3.0f, 244, 202, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 230, 245, 201);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 242, 174);
                colours.setIsDiscrete(true);
                break;
            }
            case 264: {
                colours.name = "Pastel2_7";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.addDiscreteColourRule(validMin + 3.0f, 244, 202, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 230, 245, 201);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 242, 174);
                colours.addDiscreteColourRule(validMin + 6.0f, 241, 226, 204);
                colours.setIsDiscrete(true);
                break;
            }
            case 265: {
                colours.name = "Pastel2_8";
                colours.addDiscreteColourRule(validMin, 179, 226, 205);
                colours.addDiscreteColourRule(validMin + 1.0f, 253, 205, 172);
                colours.addDiscreteColourRule(validMin + 2.0f, 203, 213, 232);
                colours.addDiscreteColourRule(validMin + 3.0f, 244, 202, 228);
                colours.addDiscreteColourRule(validMin + 4.0f, 230, 245, 201);
                colours.addDiscreteColourRule(validMin + 5.0f, 255, 242, 174);
                colours.addDiscreteColourRule(validMin + 6.0f, 241, 226, 204);
                colours.addDiscreteColourRule(validMin + 7.0f, 204, 204, 204);
                colours.setIsDiscrete(true);
                break;
            }
            case 266: {
                colours.name = "Dark2_3";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.setIsDiscrete(true);
                break;
            }
            case 267: {
                colours.name = "Dark2_4";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 41, 138);
                colours.setIsDiscrete(true);
                break;
            }
            case 268: {
                colours.name = "Dark2_5";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 41, 138);
                colours.addDiscreteColourRule(validMin + 4.0f, 102, 166, 30);
                colours.setIsDiscrete(true);
                break;
            }
            case 269: {
                colours.name = "Dark2_6";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 41, 138);
                colours.addDiscreteColourRule(validMin + 4.0f, 102, 166, 30);
                colours.addDiscreteColourRule(validMin + 5.0f, 230, 171, 2);
                colours.setIsDiscrete(true);
                break;
            }
            case 270: {
                colours.name = "Dark2_7";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 41, 138);
                colours.addDiscreteColourRule(validMin + 4.0f, 102, 166, 30);
                colours.addDiscreteColourRule(validMin + 5.0f, 230, 171, 2);
                colours.addDiscreteColourRule(validMin + 6.0f, 166, 118, 29);
                colours.setIsDiscrete(true);
                break;
            }
            case 271: {
                colours.name = "Dark2_8";
                colours.addDiscreteColourRule(validMin, 27, 158, 119);
                colours.addDiscreteColourRule(validMin + 1.0f, 217, 95, 2);
                colours.addDiscreteColourRule(validMin + 2.0f, 117, 112, 179);
                colours.addDiscreteColourRule(validMin + 3.0f, 231, 41, 138);
                colours.addDiscreteColourRule(validMin + 4.0f, 102, 166, 30);
                colours.addDiscreteColourRule(validMin + 5.0f, 230, 171, 2);
                colours.addDiscreteColourRule(validMin + 6.0f, 166, 118, 29);
                colours.addDiscreteColourRule(validMin + 7.0f, 102, 102, 102);
                colours.setIsDiscrete(true);
                break;
            }
            case 272: {
                colours.name = "Paired_3";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.setIsDiscrete(true);
                break;
            }
            case 273: {
                colours.name = "Paired_4";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.setIsDiscrete(true);
                break;
            }
            case 274: {
                colours.name = "Paired_5";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.setIsDiscrete(true);
                break;
            }
            case 275: {
                colours.name = "Paired_6";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.setIsDiscrete(true);
                break;
            }
            case 276: {
                colours.name = "Paired_7";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.setIsDiscrete(true);
                break;
            }
            case 277: {
                colours.name = "Paired_8";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.addDiscreteColourRule(validMin + 7.0f, 255, 127, 0);
                colours.setIsDiscrete(true);
                break;
            }
            case 278: {
                colours.name = "Paired_9";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.addDiscreteColourRule(validMin + 7.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 8.0f, 202, 178, 214);
                colours.setIsDiscrete(true);
                break;
            }
            case 279: {
                colours.name = "Paired_10";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.addDiscreteColourRule(validMin + 7.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 8.0f, 202, 178, 214);
                colours.addDiscreteColourRule(validMin + 9.0f, 106, 61, 154);
                colours.setIsDiscrete(true);
                break;
            }
            case 280: {
                colours.name = "Paired_11";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.addDiscreteColourRule(validMin + 7.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 8.0f, 202, 178, 214);
                colours.addDiscreteColourRule(validMin + 9.0f, 106, 61, 154);
                colours.addDiscreteColourRule(validMin + 10.0f, 255, 255, 153);
                colours.setIsDiscrete(true);
                break;
            }
            case 281: {
                colours.name = "Paired_12";
                colours.addDiscreteColourRule(validMin, 166, 206, 227);
                colours.addDiscreteColourRule(validMin + 1.0f, 31, 120, 180);
                colours.addDiscreteColourRule(validMin + 2.0f, 178, 223, 138);
                colours.addDiscreteColourRule(validMin + 3.0f, 51, 160, 44);
                colours.addDiscreteColourRule(validMin + 4.0f, 251, 154, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 227, 26, 28);
                colours.addDiscreteColourRule(validMin + 6.0f, 253, 191, 111);
                colours.addDiscreteColourRule(validMin + 7.0f, 255, 127, 0);
                colours.addDiscreteColourRule(validMin + 8.0f, 202, 178, 214);
                colours.addDiscreteColourRule(validMin + 9.0f, 106, 61, 154);
                colours.addDiscreteColourRule(validMin + 10.0f, 255, 255, 153);
                colours.addDiscreteColourRule(validMin + 11.0f, 177, 89, 40);
                colours.setIsDiscrete(true);
                break;
            }
            case 282: {
                colours.name = "Accent_3";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 1.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 2.0f, 253, 192, 134);
                colours.setIsDiscrete(true);
                break;
            }
            case 283: {
                colours.name = "Accent_4";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 1.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 2.0f, 253, 192, 134);
                colours.addDiscreteColourRule(validMin + 3.0f, 255, 255, 153);
                colours.setIsDiscrete(true);
                break;
            }
            case 284: {
                colours.name = "Accent_5";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 1.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 2.0f, 253, 192, 134);
                colours.addDiscreteColourRule(validMin + 3.0f, 255, 255, 153);
                colours.addDiscreteColourRule(validMin + 4.0f, 56, 108, 176);
                colours.setIsDiscrete(true);
                break;
            }
            case 285: {
                colours.name = "Accent_6";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 2.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 3.0f, 253, 192, 134);
                colours.addDiscreteColourRule(validMin + 4.0f, 255, 255, 153);
                colours.addDiscreteColourRule(validMin + 5.0f, 56, 108, 176);
                colours.addDiscreteColourRule(validMin + 6.0f, 240, 2, 127);
                colours.setIsDiscrete(true);
                break;
            }
            case 286: {
                colours.name = "Accent_7";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 1.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 2.0f, 253, 192, 134);
                colours.addDiscreteColourRule(validMin + 3.0f, 255, 255, 153);
                colours.addDiscreteColourRule(validMin + 4.0f, 56, 108, 176);
                colours.addDiscreteColourRule(validMin + 5.0f, 240, 2, 127);
                colours.addDiscreteColourRule(validMin + 6.0f, 191, 91, 23);
                colours.setIsDiscrete(true);
                break;
            }
            case 287: {
                colours.name = "Accent_8";
                colours.addDiscreteColourRule(validMin, 127, 201, 127);
                colours.addDiscreteColourRule(validMin + 1.0f, 190, 174, 212);
                colours.addDiscreteColourRule(validMin + 2.0f, 253, 192, 134);
                colours.addDiscreteColourRule(validMin + 3.0f, 255, 255, 153);
                colours.addDiscreteColourRule(validMin + 4.0f, 56, 108, 176);
                colours.addDiscreteColourRule(validMin + 5.0f, 240, 2, 127);
                colours.addDiscreteColourRule(validMin + 6.0f, 191, 91, 23);
                colours.addDiscreteColourRule(validMin + 7.0f, 102, 102, 102);
                colours.setIsDiscrete(true);
                break;
            }
            default: {
                colours.name = "default";
                float interval = range / 4.0f;
                colours.addContinuousColourRule(validMin, 0, 50, 0);
                colours.addContinuousColourRule(validMin + interval, 0, 150, 0);
                colours.addContinuousColourRule(validMin + 2.0f * interval, 150, 150, 0);
                colours.addContinuousColourRule(validMin + 3.0f * interval, 150, 0, 160);
                colours.addContinuousColourRule(validMax, 255, 255, 255);
            }
        }
        return colours;
    }

    public static ColourTable readFile(String fileName) {
        DOMProcessor dom = new DOMProcessor(fileName);
        if (dom.isEmpty()) {
            System.err.println("Could not extract XML colourtable data from '" + fileName + "'.");
            return null;
        }
        return ColourTable.processDom(dom);
    }

    public static ColourTable readFile(InputStream inStream) {
        DOMProcessor dom = new DOMProcessor(inStream);
        if (dom.isEmpty()) {
            System.err.println("Could not extract XML colourtable data from input stream.");
            return null;
        }
        return ColourTable.processDom(dom);
    }

    public static boolean writeFile(ColourTable colourTable, String fileName) {
        if (colourTable == null) {
            System.err.println("No colour table provided to write to file.");
            return false;
        }
        DOMProcessor dom = new DOMProcessor();
        Node root = dom.addElement("colourTable");
        dom.addComment("Colour table rules");
        dom.addComment("Each rule associates a colour with a value. Discrete rules apply to that value only, continuous rules are interpolated between values.");
        dom.addComment("Generated by the org.gicentre.processing.utils colour package.");
        dom.addElement("name", colourTable.name, root);
        if (colourTable.cTableType == 2) {
            DOMProcessor.addAttribute("raw", "true", root);
        } else {
            Vector<ColourRule> rules = colourTable.getColourRules();
            int i = 1;
            while (i < rules.size()) {
                ColourRule colRule = rules.get(i);
                Node rule = dom.addElement("rule", ColourRule.toString(colRule.getlColour()), root);
                DOMProcessor.addAttribute("value", Float.toString(colRule.getlIndex()), rule);
                if (colRule.getType() == 2) {
                    DOMProcessor.addAttribute("type", "discrete", rule);
                }
                ++i;
            }
        }
        return dom.writeXML(fileName);
    }

    public static boolean writeFile(ColourTable colourTable, OutputStream outStream) {
        if (colourTable == null) {
            System.err.println("No colour table provided to write to file.");
            return false;
        }
        DOMProcessor dom = new DOMProcessor();
        Node root = dom.addElement("colourTable");
        dom.addComment("Colour table rules");
        dom.addComment("Each rule assoociates a colour with a value. Discrete rules apply to that value only, continuous rules are interpolated between values.");
        dom.addComment("Generated by the org.gicentre.processing.utils colour package.");
        dom.addElement("name", colourTable.name, root);
        if (colourTable.cTableType == 2) {
            DOMProcessor.addAttribute("raw", "true", root);
        } else {
            Vector<ColourRule> rules = colourTable.getColourRules();
            int i = 1;
            while (i < rules.size()) {
                ColourRule colRule = rules.get(i);
                Node rule = dom.addElement("rule", ColourRule.toString(colRule.getlColour()), root);
                DOMProcessor.addAttribute("value", Float.toString(colRule.getlIndex()), rule);
                if (colRule.getType() == 2) {
                    DOMProcessor.addAttribute("type", "discrete", rule);
                }
                ++i;
            }
        }
        return dom.writeXML(outStream);
    }

    private static ColourTable processDom(DOMProcessor dom) {
        String[] names;
        String[] atts;
        Node[] cTables = dom.getElements("colourTable");
        if (cTables.length > 0 && (atts = dom.getAttributes("raw", cTables[0])) != null) {
            int i = 0;
            while (i < atts.length) {
                if (atts[i].equalsIgnoreCase("true")) {
                    ColourTable cTable = new ColourTable();
                    cTable.setColourTableType(2);
                    return cTable;
                }
                ++i;
            }
        }
        ColourTable colourTable = new ColourTable();
        Node[] nodes = dom.getElements("name");
        if (nodes.length >= 1 && (names = dom.getText("name", nodes[0]))[0] != null && names[0].trim().length() > 0) {
            colourTable.name = names[0].trim();
        }
        if ((nodes = dom.getElements("rule")).length < 1) {
            System.err.println("No colour rules found in colourtable file.");
            return null;
        }
        StringTokenizer sToken = null;
        int i = 0;
        while (i < nodes.length) {
            block11: {
                String[] colours = dom.getText("rule", nodes[i]);
                String[] values = dom.getAttributes("value", nodes[i]);
                String[] dRules = dom.getAttributes("type", nodes[i]);
                sToken = new StringTokenizer(colours[0], " \t\n\r\f,");
                if (sToken.countTokens() >= 3 && values.length >= 1) {
                    float lVal;
                    int alf;
                    int blu;
                    int grn;
                    int red;
                    try {
                        red = Integer.parseInt(sToken.nextToken());
                        grn = Integer.parseInt(sToken.nextToken());
                        blu = Integer.parseInt(sToken.nextToken());
                        alf = sToken.hasMoreTokens() ? Integer.parseInt(sToken.nextToken()) : 255;
                        lVal = Float.parseFloat(values[0]);
                    }
                    catch (NumberFormatException e) {
                        break block11;
                    }
                    if (dRules.length > 0 && dRules[0].equalsIgnoreCase("discrete")) {
                        colourTable.addDiscreteColourRule(lVal, red, grn, blu, alf);
                    } else {
                        colourTable.addContinuousColourRule(lVal, red, grn, blu, alf);
                    }
                }
            }
            ++i;
        }
        return colourTable;
    }
}

