/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvexHull {
    private Collection<PVector> points;
    private ArrayList<PVector> hull;
    private boolean needsNewCalculation;

    public ConvexHull(Collection<PVector> points) {
        this.points = points;
        this.hull = ConvexHull.calcHull(points);
        this.needsNewCalculation = false;
    }

    public static ArrayList<PVector> getHull(Collection<PVector> points) {
        return ConvexHull.calcHull(points);
    }

    public ArrayList<PVector> getHull() {
        if (this.needsNewCalculation) {
            this.hull = ConvexHull.calcHull(this.points);
            this.needsNewCalculation = false;
        }
        return this.hull;
    }

    public void addPoint(PVector point) {
        this.points.add(point);
        this.needsNewCalculation = true;
    }

    public boolean removePoint(PVector point) {
        boolean success = this.points.remove(point);
        if (success) {
            this.needsNewCalculation = true;
        }
        return success;
    }

    private static ArrayList<PVector> calcHull(Collection<PVector> points) {
        ArrayList<PVector> sortedPoints = new ArrayList<PVector>(points);
        Collections.sort(sortedPoints, new XSort());
        if (sortedPoints.size() < 4) {
            ArrayList<PVector> hullPoints = new ArrayList<PVector>();
            for (PVector point : sortedPoints) {
                hullPoints.add(point);
            }
            return hullPoints;
        }
        PVector left = sortedPoints.remove(0);
        PVector right = sortedPoints.remove(sortedPoints.size() - 1);
        ArrayList<PVector> upperPoints = new ArrayList<PVector>();
        ArrayList<PVector> lowerPoints = new ArrayList<PVector>();
        ArrayList<PVector> upperHull = new ArrayList<PVector>();
        ArrayList<PVector> lowerHull = new ArrayList<PVector>();
        for (PVector p : sortedPoints) {
            if (ConvexHull.findDirection(left, right, p) < 0) {
                upperPoints.add(p);
                continue;
            }
            lowerPoints.add(p);
        }
        lowerPoints.add(right);
        lowerHull.add(left);
        block2: while (lowerPoints.size() > 0) {
            lowerHull.add((PVector)lowerPoints.remove(0));
            while (lowerHull.size() >= 3) {
                int end = lowerHull.size() - 1;
                if (ConvexHull.findDirection((PVector)lowerHull.get(end - 2), (PVector)lowerHull.get(end), (PVector)lowerHull.get(end - 1)) > 0) continue block2;
                lowerHull.remove(end - 1);
            }
        }
        upperPoints.add(right);
        upperHull.add(left);
        block4: while (upperPoints.size() > 0) {
            upperHull.add((PVector)upperPoints.remove(0));
            while (upperHull.size() >= 3) {
                int end = upperHull.size() - 1;
                if (ConvexHull.findDirection((PVector)upperHull.get(end - 2), (PVector)upperHull.get(end), (PVector)upperHull.get(end - 1)) < 0) continue block4;
                upperHull.remove(end - 1);
            }
        }
        ArrayList<PVector> hullPoints = new ArrayList<PVector>(lowerHull);
        int i = upperHull.size() - 2;
        while (i > 0) {
            hullPoints.add((PVector)upperHull.get(i));
            --i;
        }
        return hullPoints;
    }

    private static int findDirection(PVector p1, PVector p2, PVector p3) {
        float crossProduct = (p1.x - p2.x) * (p3.y - p2.y) - (p3.x - p2.x) * (p1.y - p2.y);
        if (crossProduct < 0.0f) {
            return -1;
        }
        if (crossProduct > 0.0f) {
            return 1;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XSort
    implements Comparator<PVector> {
        @Override
        public int compare(PVector p1, PVector p2) {
            int order = Float.compare(p1.x, p2.x);
            if (order != 0) {
                return order;
            }
            order = Float.compare(p1.y, p2.y);
            if (order != 0) {
                return order;
            }
            order = Float.compare(p1.z, p2.z);
            if (order != 0) {
                return order;
            }
            return Float.compare(p1.hashCode(), p2.hashCode());
        }
    }
}

